/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.TrackerFactories;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.MemoryTracker;

public class IdMappers {
    private IdMappers() {
    }

    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(NumberArrayFactory cacheFactory, ReadableGroups groups, boolean strictNodeCheck, MemoryTracker memoryTracker, long estimatedNumberOfNodes) {
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), strictNodeCheck, Radix.STRING, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new StringCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    public static IdMapper longs(NumberArrayFactory cacheFactory, ReadableGroups groups, MemoryTracker memoryTracker, long estimatedNumberOfNodes) {
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), false, Radix.LONG, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new LongCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    private static int goodChunkSize(long estimatedNumberOfNodes) {
        return (int)MathUtil.clamp((long)(estimatedNumberOfNodes / 100L), (long)1000000L, (long)(ByteUnit.gibiBytes((long)1L) / 8L));
    }

    private static class ActualIdMapper
    implements IdMapper,
    IdMapper.Getter {
        private ActualIdMapper() {
        }

        @Override
        public void put(Object inputId, long actualId, Group group) {
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(PropertyValueLookup inputIdLookup, Collector collector, ProgressMonitorFactory progressMonitorFactory) {
        }

        @Override
        public long get(Object inputId, Group group) {
            return (Long)inputId;
        }

        @Override
        public IdMapper.Getter newGetter() {
            return this;
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void close() {
        }

        @Override
        public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
            return MemoryStatsVisitor.NONE;
        }

        @Override
        public LongIterator leftOverDuplicateNodesIds() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
    }
}

