/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.Inputs;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.input.csv.CsvGroupInputIterator;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;

public class CsvInput
implements Input {
    private static final long ESTIMATE_SAMPLE_SIZE = ByteUnit.mebiBytes((long)1L);
    private final Iterable<DataFactory> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final Configuration config;
    private final Monitor monitor;
    private final Groups groups;
    private final boolean autoSkipHeaders;
    private final MemoryTracker memoryTracker;
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void duplicateSourceFile(String sourceFile) {
        }

        @Override
        public void noNodeLabelsSpecified(String sourceFile) {
        }

        @Override
        public void noRelationshipTypeSpecified(String sourceFile) {
        }

        @Override
        public void typeNormalized(String sourceDescription, String header, String fromType, String toType) {
        }
    };

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, boolean autoSkipHeaders, Monitor monitor, MemoryTracker memoryTracker) {
        this(nodeDataFactory, nodeHeaderFactory, relationshipDataFactory, relationshipHeaderFactory, idType, config, autoSkipHeaders, monitor, new Groups(), memoryTracker);
    }

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, boolean autoSkipHeaders, Monitor monitor, Groups groups, MemoryTracker memoryTracker) {
        this.autoSkipHeaders = autoSkipHeaders;
        this.memoryTracker = memoryTracker;
        CsvInput.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.config = config;
        this.monitor = monitor;
        this.groups = groups;
        this.verifyHeaders();
        this.warnAboutDuplicateSourceFiles();
    }

    private void verifyHeaders() {
        try {
            Header header;
            CharSeeker dataStream;
            Data data;
            for (DataFactory dataFactory : this.nodeDataFactory) {
                data = dataFactory.create(this.config);
                dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(data.stream()), (Configuration)this.config, (boolean)true);
                try {
                    long numIdColumnsGroups;
                    long numIdColumns;
                    header = this.nodeHeaderFactory.create(dataStream, this.config, this.idType, this.groups, NO_MONITOR);
                    if (Arrays.stream(header.entries()).noneMatch(entry -> entry.type() == Type.LABEL) && data.decorator() == InputEntityDecorators.NO_DECORATOR) {
                        this.monitor.noNodeLabelsSpecified(dataStream.sourceDescription());
                    }
                    if ((numIdColumns = Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).count()) > 1L) {
                        Preconditions.checkState((this.idType == IdType.STRING ? 1 : 0) != 0, (String)("Having multiple :ID columns requires idType:" + IdType.STRING));
                    }
                    Preconditions.checkState(((numIdColumnsGroups = Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).map(Header.Entry::group).distinct().count()) <= 1L ? 1 : 0) != 0, (String)"There are multiple :ID columns, but they are referring different groups");
                    long numNamedIdColumns = Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).filter(e -> e.name() != null).count();
                    long numDistinctlyNamedIdColumns = Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).map(Header.Entry::name).filter(Objects::nonNull).distinct().count();
                    Preconditions.checkState((numNamedIdColumns == numDistinctlyNamedIdColumns ? 1 : 0) != 0, (String)"Cannot store composite IDs as properties, only individual parts");
                }
                finally {
                    if (dataStream == null) continue;
                    dataStream.close();
                }
            }
            for (DataFactory dataFactory : this.relationshipDataFactory) {
                data = dataFactory.create(this.config);
                dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(data.stream()), (Configuration)this.config, (boolean)true);
                try {
                    header = this.relationshipHeaderFactory.create(dataStream, this.config, this.idType, this.groups, NO_MONITOR);
                    if (!Arrays.stream(header.entries()).noneMatch(entry -> entry.type() == Type.TYPE) || data.decorator() != InputEntityDecorators.NO_DECORATOR) continue;
                    this.monitor.noRelationshipTypeSpecified(dataStream.sourceDescription());
                }
                finally {
                    if (dataStream == null) continue;
                    dataStream.close();
                }
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void warnAboutDuplicateSourceFiles() {
        try {
            HashSet<String> seenSourceFiles = new HashSet<String>();
            this.warnAboutDuplicateSourceFiles(seenSourceFiles, this.nodeDataFactory);
            this.warnAboutDuplicateSourceFiles(seenSourceFiles, this.relationshipDataFactory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void warnAboutDuplicateSourceFiles(Set<String> seenSourceFiles, Iterable<DataFactory> dataFactories) throws IOException {
        for (DataFactory dataFactory : dataFactories) {
            RawIterator<CharReadable, IOException> stream = dataFactory.create(this.config).stream();
            while (stream.hasNext()) {
                CharReadable source = (CharReadable)stream.next();
                try {
                    this.warnAboutDuplicateSourceFiles(seenSourceFiles, source);
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
        }
    }

    private void warnAboutDuplicateSourceFiles(Set<String> seenSourceFiles, CharReadable source) {
        String sourceDescription = source.sourceDescription();
        if (!seenSourceFiles.add(sourceDescription)) {
            this.monitor.duplicateSourceFile(sourceDescription);
        }
    }

    private static void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private static void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> this.stream(this.nodeDataFactory, this.nodeHeaderFactory, badCollector);
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> this.stream(this.relationshipDataFactory, this.relationshipHeaderFactory, badCollector);
    }

    private InputIterator stream(Iterable<DataFactory> data, Header.Factory headerFactory, Collector badCollector) {
        return new CsvGroupInputIterator(data.iterator(), headerFactory, this.idType, this.config, badCollector, this.groups, this.autoSkipHeaders, NO_MONITOR);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public Input.Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) throws IOException {
        long[] nodeSample = this.sample(this.nodeDataFactory, this.nodeHeaderFactory, valueSizeCalculator, node -> node.labels().length);
        long[] relationshipSample = this.sample(this.relationshipDataFactory, this.relationshipHeaderFactory, valueSizeCalculator, entity -> 0);
        long propPreAllocAdditional = CsvInput.propertyPreAllocateRounding(nodeSample[2] + relationshipSample[2]) / 2L;
        return Input.knownEstimates((long)nodeSample[0], (long)relationshipSample[0], (long)nodeSample[1], (long)relationshipSample[1], (long)(nodeSample[2] + propPreAllocAdditional), (long)(relationshipSample[2] + propPreAllocAdditional), (long)nodeSample[3]);
    }

    private long[] sample(Iterable<DataFactory> dataFactories, Header.Factory headerFactory, PropertySizeCalculator valueSizeCalculator, ToIntFunction<InputEntity> additionalCalculator) throws IOException {
        long[] estimates = new long[4];
        try (CsvInputChunkProxy chunk = new CsvInputChunkProxy();){
            int groupId = 0;
            for (DataFactory dataFactory : dataFactories) {
                ++groupId;
                Header header = null;
                Data data = dataFactory.create(this.config);
                RawIterator<CharReadable, IOException> sources = data.stream();
                while (sources.hasNext()) {
                    CharReadable source = (CharReadable)sources.next();
                    try {
                        if (header == null) {
                            header = CsvInputIterator.extractHeader(source, headerFactory, this.idType, this.config, this.groups, this.monitor);
                        }
                        try (CsvInputIterator iterator = new CsvInputIterator(source, data.decorator(), header, this.config, this.idType, Collector.EMPTY, CsvGroupInputIterator.extractors(this.config), groupId, this.autoSkipHeaders);
                             InputEntity entity = new InputEntity();){
                            int entities = 0;
                            int properties = 0;
                            int propertySize = 0;
                            int additional = 0;
                            while (iterator.position() < ESTIMATE_SAMPLE_SIZE && iterator.next(chunk)) {
                                while (chunk.next(entity)) {
                                    properties += entity.propertyCount();
                                    propertySize += Inputs.calculatePropertySize(entity, valueSizeCalculator, CursorContext.NULL_CONTEXT, this.memoryTracker);
                                    additional += additionalCalculator.applyAsInt(entity);
                                    ++entities;
                                }
                            }
                            if (entities <= 0) continue;
                            long position = iterator.position();
                            double compressionRatio = iterator.compressionRatio();
                            double actualFileSize = (double)source.length() / compressionRatio;
                            long entityCountInSource = (long)(actualFileSize / (double)position * (double)entities);
                            estimates[0] = estimates[0] + entityCountInSource;
                            estimates[1] = (long)((double)estimates[1] + (double)properties / (double)entities * (double)entityCountInSource);
                            estimates[2] = (long)((double)estimates[2] + (double)propertySize / (double)entities * (double)entityCountInSource);
                            estimates[3] = (long)((double)estimates[3] + (double)additional / (double)entities * (double)entityCountInSource);
                        }
                    }
                    finally {
                        if (source == null) continue;
                        source.close();
                    }
                }
            }
        }
        return estimates;
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        try {
            HashMap<String, SchemaDescriptor> result = new HashMap<String, SchemaDescriptor>();
            for (DataFactory dataFactory : this.nodeDataFactory) {
                Data data = dataFactory.create(this.config);
                CharSeeker dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(data.stream()), (Configuration)this.config, (boolean)true);
                try {
                    Header header = DataFactories.defaultFormatNodeFileHeader().create(dataStream, this.config, this.idType, this.groups);
                    CsvInput.collectReferencedNodeSchemaFromHeader(header, tokenHolders, result);
                }
                finally {
                    if (dataStream == null) continue;
                    dataStream.close();
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void collectReferencedNodeSchemaFromHeader(Header header, TokenHolders tokenHolders, Map<String, SchemaDescriptor> result) {
        Arrays.stream(header.entries()).filter(e -> e.type() == Type.ID).findAny().ifPresent(entry -> {
            Map<String, String> options = entry.rawOptions();
            String labelName = options.get("label");
            Preconditions.checkState((labelName != null ? 1 : 0) != 0, (String)"No label was specified for the node index in '%s'", (Object[])new Object[]{entry});
            String keyName = entry.name();
            Preconditions.checkState((keyName != null ? 1 : 0) != 0, (String)"No property key was specified for node index in '%s'", (Object[])new Object[]{entry});
            int label = tokenHolders.labelTokens().getIdByName(labelName);
            int key = tokenHolders.propertyKeyTokens().getIdByName(keyName);
            Preconditions.checkState((label != -1 ? 1 : 0) != 0, (String)"Label '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{labelName, entry});
            Preconditions.checkState((key != -1 ? 1 : 0) != 0, (String)"Property key '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{keyName, entry});
            SchemaDescriptor prev = (SchemaDescriptor)result.put(entry.group().name(), (SchemaDescriptor)SchemaDescriptors.forLabel((int)label, (int[])new int[]{key}));
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)("Multiple indexes for group " + entry.group()));
        });
    }

    private static long propertyPreAllocateRounding(long initialEstimatedPropertyStoreSize) {
        if (!SystemUtils.IS_OS_LINUX) {
            return 0L;
        }
        long preAllocSize = ByteUnit.mebiBytes((long)32L);
        if (initialEstimatedPropertyStoreSize < preAllocSize) {
            return 0L;
        }
        long chunks = 1L + initialEstimatedPropertyStoreSize / preAllocSize;
        long estimatedFinalPropertyStoreSize = chunks * preAllocSize;
        return estimatedFinalPropertyStoreSize - initialEstimatedPropertyStoreSize;
    }

    public static Extractor<?> idExtractor(IdType idType, Extractors extractors) {
        return switch (idType) {
            default -> throw new IncompatibleClassChangeError();
            case IdType.STRING -> extractors.string();
            case IdType.INTEGER, IdType.ACTUAL -> extractors.long_();
        };
    }

    public static interface Monitor
    extends Header.Monitor {
        public void duplicateSourceFile(String var1);

        public void noNodeLabelsSpecified(String var1);

        public void noRelationshipTypeSpecified(String var1);
    }

    public static class PrintingMonitor
    extends Header.PrintingMonitor
    implements Monitor {
        private final PrintStream out;

        public PrintingMonitor(PrintStream out) {
            super(out);
            this.out = out;
        }

        @Override
        public void duplicateSourceFile(String sourceFile) {
            this.out.printf("WARN: source file %s has been specified multiple times, this may result in unwanted duplicates%n", sourceFile);
        }

        @Override
        public void noNodeLabelsSpecified(String sourceFile) {
            this.out.printf("WARN: file group with header file %s specifies no node labels, which could be a mistake%n", sourceFile);
        }

        @Override
        public void noRelationshipTypeSpecified(String sourceFile) {
            this.out.printf("WARN: file group with header file %s specifies no relationship type, which could be a mistake%n", sourceFile);
        }
    }
}

