/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;

class PointerChecking {
    static final String WRITER_TRAVERSE_OLD_STATE_MESSAGE = "Writer traversed to a tree node that has a valid successor, This is most likely due to failure to checkpoint the tree before shutdown and/or tree state being out of date.";

    private PointerChecking() {
    }

    static void checkPointer(long result, boolean allowNoNode) {
        PointerChecking.checkPointer(result, allowNoNode, -1L, "unknown", 0L, 1L);
    }

    static void checkPointer(long result, boolean allowNoNode, long nodeId, String pointerType, long stableGeneration, long unstableGeneration, PageCursor cursor, int offset) {
        GenerationSafePointerPair.assertSuccess(result, nodeId, pointerType, stableGeneration, unstableGeneration, cursor, offset);
        PointerChecking.assertIdSpace(allowNoNode, result);
    }

    static void checkPointer(long result, boolean allowNoNode, long nodeId, String pointerType, long stableGeneration, long unstableGeneration) {
        GenerationSafePointerPair.assertSuccess(result, nodeId, pointerType, stableGeneration, unstableGeneration);
        PointerChecking.assertIdSpace(allowNoNode, result);
    }

    private static void assertIdSpace(boolean allowNoNode, long result) {
        if (allowNoNode && !TreeNodeUtil.isNode(result)) {
            return;
        }
        if (result < 3L) {
            throw new TreeInconsistencyException("Pointer to id " + result + " not allowed. Minimum node id allowed is 3", new Object[0]);
        }
    }

    static boolean assertNoSuccessor(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        long successor = TreeNodeUtil.successor(cursor, stableGeneration, unstableGeneration).pointer();
        if (TreeNodeUtil.isNode(successor)) {
            throw new TreeInconsistencyException(WRITER_TRAVERSE_OLD_STATE_MESSAGE, new Object[0]);
        }
        return true;
    }

    static void checkOutOfBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new TreeInconsistencyException("Some internal problem causing out of bounds: pageId:" + cursor.getCurrentPageId(), new Object[0]);
        }
    }
}

