/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.FreelistEntry;
import org.neo4j.index.internal.gbptree.FreelistNode;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.PointerWithGeneration;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;

class FreeListIdProvider
implements IdProvider {
    private static final int CACHE_SIZE = 30;
    static final Monitor NO_MONITOR = new Monitor(){};
    private final FreelistNode freelistNode;
    private volatile ListHeadMetaData readMetaData;
    private volatile ListHeadMetaData writeMetaData;
    private final AtomicLong lastId = new AtomicLong();
    private final Monitor monitor;
    private final ConcurrentLinkedDeque<FreelistEntry> acquireCache = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Long> releaseCache = new ConcurrentLinkedDeque();
    private volatile boolean mayBeMoreToReadIntoCache;

    FreeListIdProvider(int payloadSize) {
        this(payloadSize, NO_MONITOR);
    }

    FreeListIdProvider(int payloadSize, Monitor monitor) {
        this.monitor = monitor;
        this.freelistNode = new FreelistNode(payloadSize);
    }

    void initialize(long lastId, long writePageId, long readPageId, int writePos, int readPos) {
        this.lastId.set(lastId);
        this.writeMetaData = new ListHeadMetaData(writePageId, writePos);
        this.readMetaData = new ListHeadMetaData(readPageId, readPos);
        this.mayBeMoreToReadIntoCache = true;
    }

    void initializeAfterCreation(CursorCreator cursorCreator, long lastId) throws IOException {
        this.lastId.set(lastId);
        this.writeMetaData = new ListHeadMetaData(lastId, 0);
        long pageId = this.writeMetaData.pageId;
        this.readMetaData = new ListHeadMetaData(pageId, 0);
        this.mayBeMoreToReadIntoCache = false;
        try (PageCursor cursor = cursorCreator.create();){
            PageCursorUtil.goTo((PageCursor)cursor, (String)"free-list", (long)pageId);
            FreelistNode.initialize(cursor);
            PointerChecking.checkOutOfBounds(cursor);
        }
    }

    @Override
    public long acquireNewId(long stableGeneration, long unstableGeneration, CursorCreator cursorCreator) throws IOException {
        try (PageCursor cursor = cursorCreator.create();){
            long acquiredId = this.acquireNewIdFromFreelistOrEnd(stableGeneration, cursor);
            FreeListIdProvider.zapPage(acquiredId, cursor);
            long l = acquiredId;
            return l;
        }
    }

    private static void zapPage(long acquiredId, PageCursor cursor) throws IOException {
        PageCursorUtil.goTo((PageCursor)cursor, (String)"newly allocated free-list page", (long)acquiredId);
        cursor.zapPage();
    }

    private synchronized void fillAcquireCache(long stableGeneration, PageCursor cursor) throws IOException {
        if (!this.mayBeMoreToReadIntoCache) {
            return;
        }
        boolean moreAfterThis = false;
        ListHeadMetaData writeMetaDataSnapshot = this.writeMetaData;
        long readPageId = this.readMetaData.pageId;
        int readPos = this.readMetaData.pos;
        while (readPageId != writeMetaDataSnapshot.pageId || readPos < writeMetaDataSnapshot.pos) {
            PageCursorUtil.goTo((PageCursor)cursor, (String)"Free-list read page ", (long)readPageId);
            PointerWithGeneration resultPageId = this.freelistNode.read(cursor, stableGeneration, readPos);
            if (resultPageId.pointer() == 0L) break;
            FreelistEntry entry = new FreelistEntry(readPageId, readPos, resultPageId.pointer(), resultPageId.generation());
            if (++readPos >= this.freelistNode.maxEntries()) {
                readPos = 0;
                readPageId = FreelistNode.next(cursor);
            }
            this.acquireCache.addLast(entry);
            if (this.acquireCache.size() < 30) continue;
            moreAfterThis = true;
            break;
        }
        this.readMetaData = new ListHeadMetaData(readPageId, readPos);
        this.mayBeMoreToReadIntoCache = moreAfterThis;
    }

    private long acquireNewIdFromFreelistOrEnd(long stableGeneration, PageCursor cursor) throws IOException {
        do {
            FreelistEntry entry;
            if ((entry = this.acquireCache.poll()) != null) {
                if (entry.pos == this.freelistNode.maxEntries() - 1) {
                    this.queueReleasedId(entry.freelistPageId);
                }
                return entry.id;
            }
            this.fillAcquireCache(stableGeneration, cursor);
        } while (this.mayBeMoreToReadIntoCache || !this.acquireCache.isEmpty());
        return this.nextLastId();
    }

    private long nextLastId() {
        return this.lastId.incrementAndGet();
    }

    @Override
    public void releaseId(long stableGeneration, long unstableGeneration, long id, CursorCreator cursorCreator) throws IOException {
        this.queueReleasedId(id);
        if (this.releaseCache.size() >= 30) {
            this.flushReleaseCache(stableGeneration, unstableGeneration, cursorCreator);
        }
    }

    private void queueReleasedId(long id) {
        this.releaseCache.addLast(id);
        this.monitor.releasedFreelistPageId(id);
    }

    private synchronized void flushReleaseCache(long stableGeneration, long unstableGeneration, CursorCreator cursorCreator) throws IOException {
        if (this.releaseCache.isEmpty()) {
            return;
        }
        long writePageId = this.writeMetaData.pageId;
        int writePos = this.writeMetaData.pos;
        try (PageCursor cursor = cursorCreator.create();){
            Long id;
            while ((id = this.releaseCache.poll()) != null) {
                PageCursorUtil.goTo((PageCursor)cursor, (String)"free-list write page", (long)writePageId);
                this.freelistNode.write(cursor, unstableGeneration, id, writePos);
                if (++writePos < this.freelistNode.maxEntries()) continue;
                long nextFreelistPage = this.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
                PageCursorUtil.goTo((PageCursor)cursor, (String)"free-list write page", (long)writePageId);
                FreelistNode.initialize(cursor);
                FreelistNode.setNext(cursor, nextFreelistPage);
                writePageId = nextFreelistPage;
                writePos = 0;
                this.monitor.acquiredFreelistPageId(nextFreelistPage);
            }
        }
        this.writeMetaData = new ListHeadMetaData(writePageId, writePos);
        this.mayBeMoreToReadIntoCache = true;
    }

    void flush(long stableGeneration, long unstableGeneration, CursorCreator cursorCreator) throws IOException {
        this.flushReleaseCache(stableGeneration, unstableGeneration, cursorCreator);
    }

    @Override
    public void visitFreelist(IdProvider.IdProviderVisitor visitor, CursorCreator cursorCreator) throws IOException {
        ListHeadMetaData readMetaData = this.readMetaData;
        long pageId = readMetaData.pageId;
        int pos = readMetaData.pos;
        FreelistEntry cachedEntry = this.acquireCache.peek();
        if (cachedEntry != null) {
            pageId = cachedEntry.freelistPageId;
            pos = cachedEntry.pos;
        }
        if (pageId == 0L) {
            return;
        }
        try (PageCursor cursor = cursorCreator.create();){
            ListHeadMetaData writeMetaDataSnapshot;
            long prevPage;
            do {
                int targetPos;
                PageCursorUtil.goTo((PageCursor)cursor, (String)"free-list", (long)pageId);
                visitor.beginFreelistPage(pageId);
                writeMetaDataSnapshot = this.writeMetaData;
                int n = targetPos = pageId == writeMetaDataSnapshot.pageId ? writeMetaDataSnapshot.pos : this.freelistNode.maxEntries();
                while (pos < targetPos) {
                    PointerWithGeneration unacquiredId;
                    do {
                        unacquiredId = this.freelistNode.read(cursor, Long.MAX_VALUE, pos);
                    } while (cursor.shouldRetry());
                    visitor.freelistEntry(unacquiredId.pointer(), unacquiredId.generation(), pos);
                    ++pos;
                }
                visitor.endFreelistPage(pageId);
                prevPage = pageId;
                pos = 0;
                do {
                    pageId = FreelistNode.next(cursor);
                } while (cursor.shouldRetry());
            } while (prevPage != writeMetaDataSnapshot.pageId);
        }
        this.releaseCache.forEach(visitor::freelistEntryFromReleaseCache);
    }

    @Override
    public long lastId() {
        return this.lastId.get();
    }

    FreelistMetaData metaData() {
        long lastId = this.lastId.get();
        long writePageId = this.writeMetaData.pageId;
        long readPageId = this.readMetaData.pageId;
        int writePos = this.writeMetaData.pos;
        int readPos = this.readMetaData.pos;
        FreelistEntry acquireCacheEntry = this.acquireCache.peek();
        if (acquireCacheEntry != null) {
            readPageId = acquireCacheEntry.freelistPageId;
            readPos = acquireCacheEntry.pos;
        }
        return new FreelistMetaData(lastId, writePageId, readPageId, writePos, readPos);
    }

    int entriesPerPage() {
        return this.freelistNode.maxEntries();
    }

    static interface Monitor {
        default public void acquiredFreelistPageId(long freelistPageId) {
        }

        default public void releasedFreelistPageId(long freelistPageId) {
        }
    }

    private record ListHeadMetaData(long pageId, int pos) {
    }

    record FreelistMetaData(long lastId, long writePageId, long readPageId, int writePos, int readPos) {
    }
}

