/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.io.pagecache.PageCursor;

class TreeStatePair {
    TreeStatePair() {
    }

    static void initializeStatePages(PageCursor cursor) throws IOException {
        PageCursorUtil.goTo(cursor, "State page A", 1L);
        PageCursorUtil.goTo(cursor, "State page B", 2L);
    }

    static Pair<TreeState, TreeState> readStatePages(PageCursor cursor, long pageIdA, long pageIdB) throws IOException {
        TreeState stateA = TreeStatePair.readStatePage(cursor, pageIdA);
        TreeState stateB = TreeStatePair.readStatePage(cursor, pageIdB);
        return Pair.of((Object)stateA, (Object)stateB);
    }

    private static TreeState readStatePage(PageCursor cursor, long pageIdA) throws IOException {
        TreeState state;
        PageCursorUtil.goTo(cursor, "state page", pageIdA);
        do {
            state = TreeState.read(cursor);
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return state;
    }

    static TreeState selectNewestValidState(Pair<TreeState, TreeState> states) {
        return TreeStatePair.selectNewestValidStateOptionally(states).orElseThrow(() -> new TreeInconsistencyException("Unexpected combination of state.%n  STATE_A[%s]%n  STATE_B[%s]", states.getLeft(), states.getRight()));
    }

    static TreeState selectOldestOrInvalid(Pair<TreeState, TreeState> states) {
        TreeState newestValidState = TreeStatePair.selectNewestValidStateOptionally(states).orElse((TreeState)states.getRight());
        return newestValidState == states.getLeft() ? (TreeState)states.getRight() : (TreeState)states.getLeft();
    }

    private static Optional<TreeState> selectNewestValidStateOptionally(Pair<TreeState, TreeState> states) {
        TreeState stateA = (TreeState)states.getLeft();
        TreeState stateB = (TreeState)states.getRight();
        if (stateA.isValid() != stateB.isValid()) {
            return stateA.isValid() ? Optional.of(stateA) : Optional.of(stateB);
        }
        if (stateA.isValid() && stateB.isValid()) {
            if (stateA.stableGeneration() == stateB.stableGeneration() && stateA.unstableGeneration() == stateB.unstableGeneration() && stateA.isClean() != stateB.isClean()) {
                return Optional.of(stateA.isClean() ? stateA : stateB);
            }
            if (stateA.stableGeneration() >= stateB.stableGeneration() && stateA.unstableGeneration() > stateB.unstableGeneration()) {
                return Optional.of(stateA);
            }
            if (stateA.stableGeneration() <= stateB.stableGeneration() && stateA.unstableGeneration() < stateB.unstableGeneration()) {
                return Optional.of(stateB);
            }
        }
        return Optional.empty();
    }
}

