/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;

class TreeNode<KEY, VALUE> {
    static final int BYTE_POS_NODE_TYPE = 0;
    static final byte NODE_TYPE_TREE_NODE = 1;
    static final byte NODE_TYPE_FREE_LIST_NODE = 2;
    static final int SIZE_PAGE_REFERENCE = 24;
    static final int BYTE_POS_TYPE = 1;
    static final int BYTE_POS_GENERATION = 2;
    static final int BYTE_POS_KEYCOUNT = 6;
    static final int BYTE_POS_RIGHTSIBLING = 10;
    static final int BYTE_POS_LEFTSIBLING = 34;
    static final int BYTE_POS_SUCCESSOR = 58;
    static final int HEADER_LENGTH = 82;
    private static final byte LEAF_FLAG = 1;
    static final byte INTERNAL_FLAG = 0;
    static final long NO_NODE_FLAG = 0L;
    private final int pageSize;
    private final int internalMaxKeyCount;
    private final int leafMaxKeyCount;
    private final Layout<KEY, VALUE> layout;
    private final int keySize;
    private final int valueSize;

    TreeNode(int pageSize, Layout<KEY, VALUE> layout) {
        this.pageSize = pageSize;
        this.layout = layout;
        this.keySize = layout.keySize();
        this.valueSize = layout.valueSize();
        this.internalMaxKeyCount = Math.floorDiv(pageSize - 106, this.keySize + 24);
        this.leafMaxKeyCount = Math.floorDiv(pageSize - 82, this.keySize + this.valueSize);
        if (this.internalMaxKeyCount < 2) {
            throw new MetadataMismatchException("For layout " + layout + " a page size of " + pageSize + " would only fit " + this.internalMaxKeyCount + " internal keys, minimum is 2");
        }
        if (this.leafMaxKeyCount < 2) {
            throw new MetadataMismatchException("A page size of " + pageSize + " would only fit " + this.leafMaxKeyCount + " leaf keys, minimum is 2");
        }
    }

    static byte nodeType(PageCursor cursor) {
        return cursor.getByte(0);
    }

    private static void initialize(PageCursor cursor, byte type, long stableGeneration, long unstableGeneration) {
        cursor.putByte(0, (byte)1);
        cursor.putByte(1, type);
        TreeNode.setGeneration(cursor, unstableGeneration);
        TreeNode.setKeyCount(cursor, 0);
        TreeNode.setRightSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNode.setLeftSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNode.setSuccessor(cursor, 0L, stableGeneration, unstableGeneration);
    }

    static void initializeLeaf(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        TreeNode.initialize(cursor, (byte)1, stableGeneration, unstableGeneration);
    }

    static void initializeInternal(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        TreeNode.initialize(cursor, (byte)0, stableGeneration, unstableGeneration);
    }

    static boolean isLeaf(PageCursor cursor) {
        return cursor.getByte(1) == 1;
    }

    static boolean isInternal(PageCursor cursor) {
        return cursor.getByte(1) == 0;
    }

    static long generation(PageCursor cursor) {
        return (long)cursor.getInt(2) & 0xFFFFFFFFL;
    }

    static int keyCount(PageCursor cursor) {
        return cursor.getInt(6);
    }

    static long rightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(10);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, -1);
    }

    static long leftSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(34);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, -1);
    }

    static long successor(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(58);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, -1);
    }

    static void setGeneration(PageCursor cursor, long generation) {
        GenerationSafePointer.assertGenerationOnWrite(generation);
        cursor.putInt(2, (int)generation);
    }

    static void setKeyCount(PageCursor cursor, int count) {
        cursor.putInt(6, count);
    }

    static void setRightSibling(PageCursor cursor, long rightSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(10);
        long result = GenerationSafePointerPair.write(cursor, rightSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    static void setLeftSibling(PageCursor cursor, long leftSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(34);
        long result = GenerationSafePointerPair.write(cursor, leftSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    static void setSuccessor(PageCursor cursor, long successorId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(58);
        long result = GenerationSafePointerPair.write(cursor, successorId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    long pointerGeneration(PageCursor cursor, long readResult) {
        if (!GenerationSafePointerPair.isRead(readResult)) {
            throw new IllegalArgumentException("Expected read result, but got " + readResult);
        }
        int offset = GenerationSafePointerPair.generationOffset(readResult);
        int gsppOffset = GenerationSafePointerPair.isLogicalPos(readResult) ? this.childOffset(offset) : offset;
        int gspOffset = GenerationSafePointerPair.resultIsFromSlotA(readResult) ? gsppOffset : gsppOffset + 12;
        cursor.setOffset(gspOffset);
        return GenerationSafePointer.readGeneration(cursor);
    }

    KEY keyAt(PageCursor cursor, KEY into, int pos) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.readKey(cursor, into);
        return into;
    }

    void insertKeyAt(PageCursor cursor, KEY key, int pos, int keyCount) {
        this.insertKeySlotsAt(cursor, pos, 1, keyCount);
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    void removeKeyAt(PageCursor cursor, int pos, int keyCount) {
        TreeNode.removeSlotAt(cursor, pos, keyCount, this.keyOffset(0), this.keySize);
    }

    private static void removeSlotAt(PageCursor cursor, int pos, int itemCount, int baseOffset, int itemSize) {
        int posToMoveLeft = pos + 1;
        int offset = baseOffset + posToMoveLeft * itemSize;
        while (posToMoveLeft < itemCount) {
            cursor.copyTo(offset, cursor, offset - itemSize, itemSize);
            ++posToMoveLeft;
            offset += itemSize;
        }
    }

    void setKeyAt(PageCursor cursor, KEY key, int pos) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    VALUE valueAt(PageCursor cursor, VALUE value, int pos) {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.readValue(cursor, value);
        return value;
    }

    void insertValueAt(PageCursor cursor, VALUE value, int pos, int keyCount) {
        this.insertValueSlotsAt(cursor, pos, 1, keyCount);
        this.setValueAt(cursor, value, pos);
    }

    void removeValueAt(PageCursor cursor, int pos, int keyCount) {
        TreeNode.removeSlotAt(cursor, pos, keyCount, this.valueOffset(0), this.valueSize);
    }

    void setValueAt(PageCursor cursor, VALUE value, int pos) {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.writeValue(cursor, value);
    }

    long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, pos);
    }

    void insertChildAt(PageCursor cursor, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        this.insertChildSlotsAt(cursor, pos, 1, keyCount);
        this.setChildAt(cursor, child, pos, stableGeneration, unstableGeneration);
    }

    void removeChildAt(PageCursor cursor, int pos, int keyCount) {
        TreeNode.removeSlotAt(cursor, pos, keyCount + 1, this.childOffset(0), TreeNode.childSize());
    }

    void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        TreeNode.writeChild(cursor, child, stableGeneration, unstableGeneration);
    }

    static void writeChild(PageCursor cursor, long child, long stableGeneration, long unstableGeneration) {
        GenerationSafePointerPair.write(cursor, child, stableGeneration, unstableGeneration);
    }

    private static void insertSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int itemCount, int baseOffset, int itemSize) {
        int posToMoveRight = itemCount - 1;
        int offset = baseOffset + posToMoveRight * itemSize;
        while (posToMoveRight >= pos) {
            cursor.copyTo(offset, cursor, offset + itemSize * numberOfSlots, itemSize);
            --posToMoveRight;
            offset -= itemSize;
        }
    }

    void insertKeySlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNode.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.keyOffset(0), this.keySize);
    }

    void insertValueSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNode.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.valueOffset(0), this.valueSize);
    }

    void insertChildSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNode.insertSlotsAt(cursor, pos, numberOfSlots, keyCount + 1, this.childOffset(0), TreeNode.childSize());
    }

    int internalMaxKeyCount() {
        return this.internalMaxKeyCount;
    }

    int leafMaxKeyCount() {
        return this.leafMaxKeyCount;
    }

    int keyOffset(int pos) {
        return 82 + pos * this.keySize;
    }

    int valueOffset(int pos) {
        return 82 + this.leafMaxKeyCount * this.keySize + pos * this.valueSize;
    }

    int childOffset(int pos) {
        return 82 + this.internalMaxKeyCount * this.keySize + pos * 24;
    }

    static boolean isNode(long node) {
        return GenerationSafePointerPair.pointer(node) != 0L;
    }

    int keySize() {
        return this.keySize;
    }

    int valueSize() {
        return this.valueSize;
    }

    static int childSize() {
        return 24;
    }

    Comparator<KEY> keyComparator() {
        return this.layout;
    }

    static void goTo(PageCursor cursor, String messageOnError, long nodeId) throws IOException {
        PageCursorUtil.goTo(cursor, messageOnError, GenerationSafePointerPair.pointer(nodeId));
    }

    public String toString() {
        return "TreeNode[pageSize:" + this.pageSize + ", internalMax:" + this.internalMaxKeyCount + ", leafMax:" + this.leafMaxKeyCount + ", keySize:" + this.keySize + ", valueSize:" + this.valueSize + "]";
    }
}

