/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;

class DynamicSizeUtil {
    static final int SIZE_OFFSET = 2;
    static final int SIZE_KEY_SIZE = 2;
    static final int SIZE_VALUE_SIZE = 2;
    static final int SIZE_TOTAL_OVERHEAD = 6;
    private static final int FLAG_FIRST_BYTE_TOMBSTONE = 128;
    private static final long FLAG_READ_TOMBSTONE = Long.MIN_VALUE;
    static final int MASK_ONE_BYTE_KEY_SIZE = 31;
    static final int MAX_TWO_BYTE_KEY_SIZE = 4095;
    static final int MASK_ONE_BYTE_VALUE_SIZE = 127;
    private static final int MAX_TWO_BYTE_VALUE_SIZE = Short.MAX_VALUE;
    private static final int FLAG_HAS_VALUE_SIZE = 32;
    private static final int FLAG_ADDITIONAL_KEY_SIZE = 64;
    private static final int FLAG_ADDITIONAL_VALUE_SIZE = 128;
    private static final int SHIFT_LSB_KEY_SIZE = 5;
    private static final int SHIFT_LSB_VALUE_SIZE = 7;

    DynamicSizeUtil() {
    }

    static void putKeyOffset(PageCursor cursor, int keyOffset) {
        PageCursorUtil.putUnsignedShort(cursor, keyOffset);
    }

    static int readKeyOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor);
    }

    static void putKeySize(PageCursor cursor, int keySize) {
        DynamicSizeUtil.putKeyValueSize(cursor, keySize, 0);
    }

    static void putKeyValueSize(PageCursor cursor, int keySize, int valueSize) {
        boolean hasAdditionalKeySize = keySize > 31;
        boolean hasValueSize = valueSize > 0;
        byte firstByte = (byte)(keySize & 0x1F);
        if (hasAdditionalKeySize) {
            firstByte = (byte)(firstByte | 0x40);
            if (keySize > 4095) {
                throw new IllegalArgumentException(String.format("Max supported key size is %d, but tried to store key of size %d", 4095, keySize));
            }
        }
        if (hasValueSize) {
            firstByte = (byte)(firstByte | 0x20);
        }
        cursor.putByte(firstByte);
        if (hasAdditionalKeySize) {
            cursor.putByte((byte)(keySize >> 5));
        }
        if (hasValueSize) {
            boolean needsAdditionalValueSize = valueSize > 127;
            byte firstByte2 = (byte)(valueSize & 0x7F);
            if (needsAdditionalValueSize) {
                if (valueSize > Short.MAX_VALUE) {
                    throw new IllegalArgumentException(String.format("Max supported value size is %d, but tried to store value of size %d", Short.MAX_VALUE, valueSize));
                }
                firstByte2 = (byte)(firstByte2 | 0x80);
            }
            cursor.putByte(firstByte2);
            if (needsAdditionalValueSize) {
                cursor.putByte((byte)(valueSize >> 7));
            }
        }
    }

    static long readKeyValueSize(PageCursor cursor) {
        long valueSize;
        long keySize;
        byte firstByte = cursor.getByte();
        boolean hasTombstone = DynamicSizeUtil.hasTombstone(firstByte);
        boolean hasAdditionalKeySize = (firstByte & 0x40) != 0;
        boolean hasValueSize = (firstByte & 0x20) != 0;
        int keySizeLsb = firstByte & 0x1F;
        if (hasAdditionalKeySize) {
            int keySizeMsb = cursor.getByte() & 0xFF;
            keySize = keySizeMsb << 5 | keySizeLsb;
        } else {
            keySize = keySizeLsb;
        }
        if (hasValueSize) {
            boolean hasAdditionalValueSize;
            byte firstValueByte = cursor.getByte();
            int valueSizeLsb = firstValueByte & 0x7F;
            boolean bl = hasAdditionalValueSize = (firstValueByte & 0x80) != 0;
            if (hasAdditionalValueSize) {
                int valueSizeMsb = cursor.getByte() & 0xFF;
                valueSize = valueSizeMsb << 7 | valueSizeLsb;
            } else {
                valueSize = valueSizeLsb;
            }
        } else {
            valueSize = 0L;
        }
        return (hasTombstone ? Long.MIN_VALUE : 0L) | keySize << 32 | valueSize;
    }

    static int extractValueSize(long keyValueSize) {
        return (int)keyValueSize;
    }

    static int extractKeySize(long keyValueSize) {
        return (int)((keyValueSize & Long.MAX_VALUE) >>> 32);
    }

    static int getOverhead(int keySize, int valueSize) {
        return 1 + (keySize > 31 ? 1 : 0) + (valueSize > 0 ? 1 : 0) + (valueSize > 127 ? 1 : 0);
    }

    static boolean extractTombstone(long keyValueSize) {
        return (keyValueSize & Long.MIN_VALUE) != 0L;
    }

    static void putTombstone(PageCursor cursor) {
        int offset = cursor.getOffset();
        byte firstByte = cursor.getByte();
        firstByte = DynamicSizeUtil.withTombstoneFlag(firstByte);
        cursor.setOffset(offset);
        cursor.putByte(firstByte);
    }

    private static boolean hasTombstone(byte firstKeySizeByte) {
        return (firstKeySizeByte & 0x80) != 0;
    }

    private static byte withTombstoneFlag(byte firstByte) {
        assert ((firstByte & 0x80) == 0) : "First key size byte " + firstByte + " is too large to fit tombstone.";
        return (byte)(firstByte | 0x80);
    }
}

