/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;

class TreeNodeFixedSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    static final byte FORMAT_IDENTIFIER = 2;
    static final byte FORMAT_VERSION = 0;
    private final int internalMaxKeyCount;
    private final int leafMaxKeyCount;
    private final int keySize;
    private final int valueSize;

    TreeNodeFixedSize(int pageSize, Layout<KEY, VALUE> layout) {
        super(pageSize, layout);
        this.keySize = layout.keySize(null);
        this.valueSize = layout.valueSize(null);
        this.internalMaxKeyCount = Math.floorDiv(pageSize - 106, this.keySize + 24);
        this.leafMaxKeyCount = Math.floorDiv(pageSize - 82, this.keySize + this.valueSize);
        if (this.internalMaxKeyCount < 2) {
            throw new MetadataMismatchException("For layout %s a page size of %d would only fit %d internal keys, minimum is 2", layout, pageSize, this.internalMaxKeyCount);
        }
        if (this.leafMaxKeyCount < 2) {
            throw new MetadataMismatchException("A page size of %d would only fit leaf keys, minimum is 2", pageSize, this.leafMaxKeyCount);
        }
    }

    @Override
    void writeAdditionalHeader(PageCursor cursor) {
    }

    private static int childSize() {
        return 24;
    }

    @Override
    KEY keyAt(PageCursor cursor, KEY into, int pos, TreeNode.Type type) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.readKey(cursor, into, -1);
        return into;
    }

    @Override
    void keyValueAt(PageCursor cursor, KEY intoKey, VALUE intoValue, int pos) {
        this.keyAt(cursor, intoKey, pos, TreeNode.Type.LEAF);
        this.valueAt(cursor, intoValue, pos);
    }

    @Override
    void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertChildAt(cursor, child, pos + 1, keyCount, stableGeneration, unstableGeneration);
    }

    @Override
    void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount) {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertValueAt(cursor, value, pos, keyCount);
    }

    @Override
    void removeKeyValueAt(PageCursor cursor, int pos, int keyCount) {
        this.removeKeyAt(cursor, pos, keyCount);
        this.removeValueAt(cursor, pos, keyCount);
    }

    @Override
    void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos, keyCount);
    }

    @Override
    void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos + 1, keyCount);
    }

    @Override
    boolean setKeyAtInternal(PageCursor cursor, KEY key, int pos) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
        return true;
    }

    @Override
    VALUE valueAt(PageCursor cursor, VALUE value, int pos) {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.readValue(cursor, value, -1);
        return value;
    }

    @Override
    boolean setValueAt(PageCursor cursor, VALUE value, int pos) {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.writeValue(cursor, value);
        return true;
    }

    @Override
    long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, pos);
    }

    @Override
    void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        TreeNodeFixedSize.writeChild(cursor, child, stableGeneration, unstableGeneration);
    }

    @Override
    int keyValueSizeCap() {
        return -1;
    }

    @Override
    void validateKeyValueSize(KEY key, VALUE value) {
    }

    @Override
    boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= Math.max(this.internalMaxKeyCount(), this.leafMaxKeyCount());
    }

    @Override
    boolean reasonableChildCount(int childCount) {
        return childCount >= 0 && childCount <= this.internalMaxKeyCount();
    }

    @Override
    int childOffset(int pos) {
        return 82 + this.internalMaxKeyCount * this.keySize + pos * 24;
    }

    private int internalMaxKeyCount() {
        return this.internalMaxKeyCount;
    }

    private void insertKeyAt(PageCursor cursor, KEY key, int pos, int keyCount) {
        this.insertKeySlotsAt(cursor, pos, 1, keyCount);
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    private int leafMaxKeyCount() {
        return this.leafMaxKeyCount;
    }

    private void removeKeyAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertChildAt(PageCursor cursor, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        this.insertChildSlot(cursor, pos, keyCount);
        this.setChildAt(cursor, child, pos, stableGeneration, unstableGeneration);
    }

    private void removeChildAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount + 1, this.childOffset(0), TreeNodeFixedSize.childSize());
    }

    private void insertKeyValueSlots(PageCursor cursor, int numberOfSlots, int keyCount) {
        this.insertKeySlotsAt(cursor, 0, numberOfSlots, keyCount);
        this.insertValueSlotsAt(cursor, 0, numberOfSlots, keyCount);
    }

    private void insertValueAt(PageCursor cursor, VALUE value, int pos, int keyCount) {
        this.insertValueSlotsAt(cursor, pos, 1, keyCount);
        this.setValueAt(cursor, value, pos);
    }

    private void removeValueAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount, this.valueOffset(0), this.valueSize);
    }

    private void insertKeySlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertValueSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.valueOffset(0), this.valueSize);
    }

    private void insertChildSlot(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, 1, keyCount + 1, this.childOffset(0), TreeNodeFixedSize.childSize());
    }

    private int keyOffset(int pos) {
        return 82 + pos * this.keySize;
    }

    private int valueOffset(int pos) {
        return 82 + this.leafMaxKeyCount * this.keySize + pos * this.valueSize;
    }

    private int keySize() {
        return this.keySize;
    }

    private int valueSize() {
        return this.valueSize;
    }

    @Override
    TreeNode.Overflow internalOverflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        return currentKeyCount + 1 > this.internalMaxKeyCount() ? TreeNode.Overflow.YES : TreeNode.Overflow.NO;
    }

    @Override
    TreeNode.Overflow leafOverflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        return currentKeyCount + 1 > this.leafMaxKeyCount() ? TreeNode.Overflow.YES : TreeNode.Overflow.NO;
    }

    @Override
    void defragmentLeaf(PageCursor cursor) {
    }

    @Override
    void defragmentInternal(PageCursor cursor) {
    }

    @Override
    boolean leafUnderflow(PageCursor cursor, int keyCount) {
        return keyCount < (this.leafMaxKeyCount() + 1) / 2;
    }

    @Override
    int canRebalanceLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        if (leftKeyCount + rightKeyCount >= this.leafMaxKeyCount()) {
            int totalKeyCount = rightKeyCount + leftKeyCount;
            int moveFromPosition = totalKeyCount / 2;
            return leftKeyCount - moveFromPosition;
        }
        return -1;
    }

    @Override
    boolean canMergeLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        return leftKeyCount + rightKeyCount <= this.leafMaxKeyCount();
    }

    @Override
    void doSplitLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter) {
        int keyCountAfterInsert = leftKeyCount + 1;
        int middlePos = TreeNodeFixedSize.middle(keyCountAfterInsert);
        if (middlePos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < middlePos ? middlePos - 1 : middlePos, TreeNode.Type.LEAF);
        }
        int rightKeyCount = keyCountAfterInsert - middlePos;
        if (insertPos < middlePos) {
            this.copyKeysAndValues(leftCursor, middlePos - 1, rightCursor, 0, rightKeyCount);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, middlePos - 1);
        } else {
            int countBeforePos = insertPos - middlePos;
            if (countBeforePos > 0) {
                this.copyKeysAndValues(leftCursor, middlePos, rightCursor, 0, countBeforePos);
            }
            this.insertKeyValueAt(rightCursor, newKey, newValue, countBeforePos, countBeforePos);
            int countAfterPos = leftKeyCount - insertPos;
            if (countAfterPos > 0) {
                this.copyKeysAndValues(leftCursor, insertPos, rightCursor, countBeforePos + 1, countAfterPos);
            }
        }
        TreeNode.setKeyCount(leftCursor, middlePos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    private static int middle(int keyCountAfterInsert) {
        return keyCountAfterInsert / 2;
    }

    @Override
    void doSplitInternal(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter) {
        int keyCountAfterInsert = leftKeyCount + 1;
        int middlePos = TreeNodeFixedSize.middle(keyCountAfterInsert);
        if (middlePos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < middlePos ? middlePos - 1 : middlePos, TreeNode.Type.INTERNAL);
        }
        int rightKeyCount = keyCountAfterInsert - middlePos - 1;
        if (insertPos < middlePos) {
            leftCursor.copyTo(this.keyOffset(middlePos), rightCursor, this.keyOffset(0), rightKeyCount * this.keySize());
            leftCursor.copyTo(this.childOffset(middlePos), rightCursor, this.childOffset(0), (rightKeyCount + 1) * TreeNodeFixedSize.childSize());
            this.insertKeyAt(leftCursor, newKey, insertPos, middlePos - 1);
            this.insertChildAt(leftCursor, newRightChild, insertPos + 1, middlePos - 1, stableGeneration, unstableGeneration);
        } else {
            int countAfterPos;
            int countBeforePos = insertPos - (middlePos + 1);
            if (countBeforePos > 0) {
                leftCursor.copyTo(this.keyOffset(middlePos + 1), rightCursor, this.keyOffset(0), countBeforePos * this.keySize());
            }
            if (countBeforePos >= 0) {
                this.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
            }
            if ((countAfterPos = leftKeyCount - insertPos) > 0) {
                leftCursor.copyTo(this.keyOffset(insertPos), rightCursor, this.keyOffset(countBeforePos + 1), countAfterPos * this.keySize());
            }
            if ((countBeforePos = insertPos - middlePos) > 0) {
                leftCursor.copyTo(this.childOffset(middlePos + 1), rightCursor, this.childOffset(0), countBeforePos * TreeNodeFixedSize.childSize());
            }
            this.insertChildAt(rightCursor, newRightChild, countBeforePos, countBeforePos, stableGeneration, unstableGeneration);
            if (countAfterPos > 0) {
                leftCursor.copyTo(this.childOffset(insertPos + 1), rightCursor, this.childOffset(countBeforePos + 1), countAfterPos * TreeNodeFixedSize.childSize());
            }
        }
        TreeNode.setKeyCount(leftCursor, middlePos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        this.insertKeyValueSlots(rightCursor, numberOfKeysToMove, rightKeyCount);
        this.copyKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeFixedSize.setKeyCount(leftCursor, leftKeyCount - numberOfKeysToMove);
        TreeNodeFixedSize.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    @Override
    void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.insertKeyValueSlots(rightCursor, leftKeyCount, rightKeyCount);
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeFixedSize.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        fromCursor.copyTo(this.keyOffset(fromPos), toCursor, this.keyOffset(toPos), count * this.keySize());
        fromCursor.copyTo(this.valueOffset(fromPos), toCursor, this.valueOffset(toPos), count * this.valueSize());
    }

    public String toString() {
        return "TreeNodeFixedSize[pageSize:" + this.pageSize + ", internalMax:" + this.internalMaxKeyCount() + ", leafMax:" + this.leafMaxKeyCount() + ", keySize:" + this.keySize() + ", valueSize:" + this.valueSize + "]";
    }
}

