/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.neo4j.index.internal.gbptree.FreelistNode;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

class FreeListIdProvider
implements IdProvider {
    static final Monitor NO_MONITOR = new Monitor(){};
    private final PagedFile pagedFile;
    private final FreelistNode freelistNode;
    private volatile long writePageId;
    private volatile long readPageId;
    private volatile int writePos;
    private volatile int readPos;
    private volatile long lastId;
    private final Monitor monitor;

    FreeListIdProvider(PagedFile pagedFile, int pageSize, long lastId, Monitor monitor) {
        this.pagedFile = pagedFile;
        this.monitor = monitor;
        this.freelistNode = new FreelistNode(pageSize);
        this.lastId = lastId;
    }

    void initialize(long lastId, long writePageId, long readPageId, int writePos, int readPos) {
        this.lastId = lastId;
        this.writePageId = writePageId;
        this.readPageId = readPageId;
        this.writePos = writePos;
        this.readPos = readPos;
    }

    void initializeAfterCreation() throws IOException {
        this.readPageId = this.writePageId = this.nextLastId();
        try (PageCursor cursor = this.pagedFile.io(this.writePageId, 2);){
            PageCursorUtil.goTo(cursor, "free-list", this.writePageId);
            FreelistNode.initialize(cursor);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
    }

    @Override
    public long acquireNewId(long stableGeneration, long unstableGeneration) throws IOException {
        return this.acquireNewId(stableGeneration, unstableGeneration, true);
    }

    private long acquireNewId(long stableGeneration, long unstableGeneration, boolean allowTakeLastFromPage) throws IOException {
        long acquiredId = this.acquireNewIdFromFreelistOrEnd(stableGeneration, unstableGeneration, allowTakeLastFromPage);
        try (PageCursor cursor = this.pagedFile.io(acquiredId, 2);){
            PageCursorUtil.goTo(cursor, "newly allocated free-list page", acquiredId);
            cursor.zapPage();
        }
        return acquiredId;
    }

    private long acquireNewIdFromFreelistOrEnd(long stableGeneration, long unstableGeneration, boolean allowTakeLastFromPage) throws IOException {
        if (!(this.readPageId == this.writePageId && this.readPos >= this.writePos || !allowTakeLastFromPage && this.readPos >= this.freelistNode.maxEntries() - 1)) {
            try (PageCursor cursor = this.pagedFile.io(this.readPageId, 1);){
                long resultPageId;
                if (!cursor.next()) {
                    throw new IOException("Couldn't go to free-list read page " + this.readPageId);
                }
                do {
                    resultPageId = this.freelistNode.read(cursor, stableGeneration, this.readPos);
                } while (cursor.shouldRetry());
                if (resultPageId != 0L) {
                    ++this.readPos;
                    if (this.readPos >= this.freelistNode.maxEntries()) {
                        this.readPos = 0;
                        do {
                            this.readPageId = FreelistNode.next(cursor);
                        } while (cursor.shouldRetry());
                        long exhaustedFreelistPageId = cursor.getCurrentPageId();
                        this.releaseId(stableGeneration, unstableGeneration, exhaustedFreelistPageId);
                        this.monitor.releasedFreelistPageId(exhaustedFreelistPageId);
                    }
                    long l = resultPageId;
                    return l;
                }
            }
        }
        return this.nextLastId();
    }

    private long nextLastId() {
        return ++this.lastId;
    }

    @Override
    public void releaseId(long stableGeneration, long unstableGeneration, long id) throws IOException {
        try (PageCursor cursor = this.pagedFile.io(this.writePageId, 2);){
            PageCursorUtil.goTo(cursor, "free-list write page", this.writePageId);
            this.freelistNode.write(cursor, unstableGeneration, id, this.writePos);
            ++this.writePos;
        }
        if (this.writePos >= this.freelistNode.maxEntries()) {
            long nextFreelistPage = this.acquireNewId(stableGeneration, unstableGeneration, false);
            try (PageCursor cursor = this.pagedFile.io(this.writePageId, 2);){
                PageCursorUtil.goTo(cursor, "free-list write page", this.writePageId);
                FreelistNode.initialize(cursor);
                FreelistNode.setNext(cursor, nextFreelistPage);
            }
            this.writePageId = nextFreelistPage;
            this.writePos = 0;
            this.monitor.acquiredFreelistPageId(nextFreelistPage);
        }
    }

    void visitFreelistPageIds(LongConsumer visitor) throws IOException {
        if (this.readPageId == 0L) {
            return;
        }
        long pageId = this.readPageId;
        visitor.accept(pageId);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            while (pageId != this.writePageId) {
                long nextFreelistPageId;
                PageCursorUtil.goTo(cursor, "free-list", pageId);
                do {
                    nextFreelistPageId = FreelistNode.next(cursor);
                } while (cursor.shouldRetry());
                visitor.accept(nextFreelistPageId);
                pageId = nextFreelistPageId;
            }
        }
    }

    void visitUnacquiredIds(LongConsumer visitor, long stableGeneration) throws IOException {
        if (this.readPageId == 0L) {
            return;
        }
        long pageId = this.readPageId;
        int pos = this.readPos;
        try (PageCursor cursor = this.pagedFile.io(pageId, 1);){
            while (pageId != this.writePageId || pos < this.writePos) {
                long nextFreelistPageId;
                long unacquiredId;
                PageCursorUtil.goTo(cursor, "free-list", pageId);
                do {
                    unacquiredId = this.freelistNode.read(cursor, stableGeneration, pos);
                    nextFreelistPageId = FreelistNode.next(cursor);
                } while (cursor.shouldRetry());
                visitor.accept(unacquiredId);
                if (++pos != this.freelistNode.maxEntries()) continue;
                pos = 0;
                pageId = nextFreelistPageId;
            }
        }
    }

    long lastId() {
        return this.lastId;
    }

    long writePageId() {
        return this.writePageId;
    }

    long readPageId() {
        return this.readPageId;
    }

    int writePos() {
        return this.writePos;
    }

    int readPos() {
        return this.readPos;
    }

    int entriesPerPage() {
        return this.freelistNode.maxEntries();
    }

    static interface Monitor {
        default public void acquiredFreelistPageId(long freelistPageId) {
        }

        default public void releasedFreelistPageId(long freelistPageId) {
        }
    }
}

