/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.scheduler.JobScheduler;

public class GBPTreeBootstrapper {
    private final PageCache pageCache;
    private final LayoutBootstrapper layoutBootstrapper;
    private final boolean readOnly;

    public GBPTreeBootstrapper(PageCache pageCache, LayoutBootstrapper layoutBootstrapper, boolean readOnly) {
        this.pageCache = pageCache;
        this.layoutBootstrapper = layoutBootstrapper;
        this.readOnly = readOnly;
    }

    public Bootstrap bootstrapTree(File file, String targetLayout) {
        try {
            MetaVisitor metaVisitor = new MetaVisitor();
            GBPTreeStructure.visitHeader(this.pageCache, file, metaVisitor);
            Meta meta = metaVisitor.meta;
            Pair statePair = metaVisitor.statePair;
            TreeState state = TreeStatePair.selectNewestValidState((Pair<TreeState, TreeState>)statePair);
            Layout<?, ?> layout = this.layoutBootstrapper.create(file, this.pageCache, meta, targetLayout);
            TreeNodeSelector.Factory factory = TreeNodeSelector.selectByFormat(meta.getFormatIdentifier(), meta.getFormatVersion());
            TreeNode<?, ?> treeNode = factory.create(meta.getPageSize(), layout);
            GBPTree tree = new GBPTree(this.pageCache, file, layout, meta.getPageSize(), GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.ignore(), this.readOnly);
            return new SuccessfulBootstrap(tree, layout, treeNode, state, meta);
        }
        catch (Exception e) {
            return new FailedBootstrap();
        }
    }

    static PageCache pageCache(JobScheduler jobScheduler) {
        SingleFilePageSwapperFactory swapper = new SingleFilePageSwapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        swapper.open((FileSystemAbstraction)fs, Configuration.EMPTY);
        PageCursorTracerSupplier cursorTracerSupplier = PageCursorTracerSupplier.NULL;
        return new MuninnPageCache((PageSwapperFactory)swapper, 100, PageCacheTracer.NULL, cursorTracerSupplier, EmptyVersionContextSupplier.EMPTY, jobScheduler);
    }

    private static class MetaVisitor<KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
        private Meta meta;
        private Pair<TreeState, TreeState> statePair;

        private MetaVisitor() {
        }

        @Override
        public void meta(Meta meta) {
            this.meta = meta;
        }

        @Override
        public void treeState(Pair<TreeState, TreeState> statePair) {
            this.statePair = statePair;
        }
    }

    private static class SuccessfulBootstrap
    implements Bootstrap {
        private final GBPTree<?, ?> tree;
        private final Layout<?, ?> layout;
        private final TreeNode<?, ?> treeNode;
        private final TreeState state;
        private final Meta meta;

        SuccessfulBootstrap(GBPTree<?, ?> tree, Layout<?, ?> layout, TreeNode<?, ?> treeNode, TreeState state, Meta meta) {
            this.tree = tree;
            this.layout = layout;
            this.treeNode = treeNode;
            this.state = state;
            this.meta = meta;
        }

        @Override
        public boolean isTree() {
            return true;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            return this.tree;
        }

        @Override
        public Layout<?, ?> getLayout() {
            return this.layout;
        }

        @Override
        public TreeNode<?, ?> getTreeNode() {
            return this.treeNode;
        }

        @Override
        public TreeState getState() {
            return this.state;
        }

        @Override
        public Meta getMeta() {
            return this.meta;
        }
    }

    private static class FailedBootstrap
    implements Bootstrap {
        private FailedBootstrap() {
        }

        @Override
        public boolean isTree() {
            return false;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            throw new IllegalStateException("Bootstrap failed");
        }

        @Override
        public Layout<?, ?> getLayout() {
            throw new IllegalStateException("Bootstrap failed");
        }

        @Override
        public TreeNode<?, ?> getTreeNode() {
            throw new IllegalStateException("Bootstrap failed");
        }

        @Override
        public TreeState getState() {
            throw new IllegalStateException("Bootstrap failed");
        }

        @Override
        public Meta getMeta() {
            throw new IllegalStateException("Bootstrap failed");
        }
    }

    public static interface Bootstrap {
        public boolean isTree();

        public GBPTree<?, ?> getTree();

        public Layout<?, ?> getLayout();

        public TreeNode<?, ?> getTreeNode();

        public TreeState getState();

        public Meta getMeta();
    }
}

