/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.concurrent.Futures;

class CrashGenerationCleaner {
    private static final String NUMBER_OF_WORKERS_NAME = "number_of_workers";
    private static final int NUMBER_OF_WORKERS_DEFAULT = Math.min(8, Runtime.getRuntime().availableProcessors());
    private static final int NUMBER_OF_WORKERS = FeatureToggles.getInteger(CrashGenerationCleaner.class, (String)"number_of_workers", (int)NUMBER_OF_WORKERS_DEFAULT);
    private static final long MIN_BATCH_SIZE = 10L;
    static final long MAX_BATCH_SIZE = 100L;
    private final PagedFile pagedFile;
    private final TreeNode<?, ?> treeNode;
    private final long lowTreeNodeId;
    private final long highTreeNodeId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final GBPTree.Monitor monitor;

    CrashGenerationCleaner(PagedFile pagedFile, TreeNode<?, ?> treeNode, long lowTreeNodeId, long highTreeNodeId, long stableGeneration, long unstableGeneration, GBPTree.Monitor monitor) {
        this.pagedFile = pagedFile;
        this.treeNode = treeNode;
        this.lowTreeNodeId = lowTreeNodeId;
        this.highTreeNodeId = highTreeNodeId;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.monitor = monitor;
    }

    private static long batchSize(long pagesToClean, int threads) {
        return Math.min(100L, Math.max(10L, pagesToClean / (100L * (long)threads)));
    }

    public void clean(ExecutorService executor) {
        this.monitor.cleanupStarted();
        assert (this.unstableGeneration > this.stableGeneration) : this.unexpectedGenerations();
        assert (this.unstableGeneration - this.stableGeneration > 1L) : this.unexpectedGenerations();
        long startTime = System.currentTimeMillis();
        long pagesToClean = this.highTreeNodeId - this.lowTreeNodeId;
        int threads = NUMBER_OF_WORKERS;
        long batchSize = CrashGenerationCleaner.batchSize(pagesToClean, threads);
        AtomicLong nextId = new AtomicLong(this.lowTreeNodeId);
        AtomicBoolean stopFlag = new AtomicBoolean();
        AtomicInteger cleanedPointers = new AtomicInteger();
        ArrayList cleanerFutures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            cleanerFutures.add(executor.submit(this.cleaner(nextId, batchSize, cleanedPointers, stopFlag)));
        }
        try {
            Futures.getAll(cleanerFutures);
        }
        catch (Throwable e) {
            Exceptions.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        long endTime = System.currentTimeMillis();
        this.monitor.cleanupFinished(pagesToClean, cleanedPointers.get(), endTime - startTime);
    }

    private Callable<?> cleaner(AtomicLong nextId, long batchSize, AtomicInteger cleanedPointers, AtomicBoolean stopFlag) {
        return () -> {
            try (PageCursor cursor = this.pagedFile.io(0L, 1);
                 PageCursor writeCursor = this.pagedFile.io(0L, 2);){
                long localNextId;
                while ((localNextId = nextId.getAndAdd(batchSize)) < this.highTreeNodeId) {
                    int i = 0;
                    while ((long)i < batchSize && localNextId < this.highTreeNodeId) {
                        PageCursorUtil.goTo(cursor, "clean", localNextId);
                        if (this.hasCrashedGSPP(this.treeNode, cursor)) {
                            writeCursor.next(cursor.getCurrentPageId());
                            this.cleanTreeNode(this.treeNode, writeCursor, cleanedPointers);
                        }
                        ++i;
                        ++localNextId;
                    }
                    if (!stopFlag.get()) continue;
                    break;
                }
            }
            catch (Throwable e) {
                stopFlag.set(true);
                throw e;
            }
            return null;
        };
    }

    private boolean hasCrashedGSPP(TreeNode<?, ?> treeNode, PageCursor cursor) throws IOException {
        boolean hasCrashed;
        int keyCount;
        boolean isTreeNode;
        do {
            isTreeNode = TreeNode.nodeType(cursor) == 1;
            keyCount = TreeNode.keyCount(cursor);
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        if (!isTreeNode) {
            return false;
        }
        do {
            boolean bl = hasCrashed = this.hasCrashedGSPP(cursor, 58) || this.hasCrashedGSPP(cursor, 34) || this.hasCrashedGSPP(cursor, 10);
            if (hasCrashed || !TreeNode.isInternal(cursor)) continue;
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i) && !hasCrashed; ++i) {
                hasCrashed = this.hasCrashedGSPP(cursor, treeNode.childOffset(i));
            }
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return hasCrashed;
    }

    private boolean hasCrashedGSPP(PageCursor cursor, int gsppOffset) {
        return this.hasCrashedGSP(cursor, gsppOffset) || this.hasCrashedGSP(cursor, gsppOffset + 12);
    }

    private boolean hasCrashedGSP(PageCursor cursor, int offset) {
        cursor.setOffset(offset);
        long generation = GenerationSafePointer.readGeneration(cursor);
        return generation > this.stableGeneration && generation < this.unstableGeneration;
    }

    private void cleanTreeNode(TreeNode<?, ?> treeNode, PageCursor cursor, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSPP(cursor, 58, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 34, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 10, cleanedPointers);
        if (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i); ++i) {
                this.cleanCrashedGSPP(cursor, treeNode.childOffset(i), cleanedPointers);
            }
        }
    }

    private void cleanCrashedGSPP(PageCursor cursor, int gsppOffset, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSP(cursor, gsppOffset, cleanedPointers);
        this.cleanCrashedGSP(cursor, gsppOffset + 12, cleanedPointers);
    }

    private void cleanCrashedGSP(PageCursor cursor, int gspOffset, AtomicInteger cleanedPointers) {
        if (this.hasCrashedGSP(cursor, gspOffset)) {
            cursor.setOffset(gspOffset);
            GenerationSafePointer.clean(cursor);
            cleanedPointers.incrementAndGet();
        }
    }

    private String unexpectedGenerations() {
        return "Unexpected generations, stableGeneration=" + this.stableGeneration + ", unstableGeneration=" + this.unstableGeneration;
    }
}

