/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.CleanTrackingConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreeCleanupJob;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeLock;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.InternalTreeLogic;
import org.neo4j.index.internal.gbptree.KeyPartitioning;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.OffloadIdValidator;
import org.neo4j.index.internal.gbptree.OffloadPageCursorFactory;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SizeEstimationMonitor;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.ThrowingConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.index.internal.gbptree.TripCountingRootCatchup;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class GBPTree<KEY, VALUE>
implements Closeable,
Seeker.Factory<KEY, VALUE> {
    public static final Monitor NO_MONITOR = new Monitor.Adaptor();
    public static final Header.Reader NO_HEADER_READER = headerData -> {};
    public static final Consumer<PageCursor> NO_HEADER_WRITER = pc -> {};
    private final PagedFile pagedFile;
    private final File indexFile;
    private final Layout<KEY, VALUE> layout;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final FreeListIdProvider freeList;
    private final SingleWriter writer;
    private volatile boolean changesSinceLastCheckpoint;
    private final GBPTreeLock lock = new GBPTreeLock();
    private int pageSize;
    private boolean created;
    private volatile long generation;
    private volatile Root root;
    private final Supplier<RootCatchup> rootCatchupSupplier = () -> new TripCountingRootCatchup(() -> this.root);
    private final LongSupplier generationSupplier = () -> this.generation;
    private final Monitor monitor;
    private final boolean readOnly;
    private final OpenOption[] openOptions;
    private boolean closed = true;
    private boolean clean;
    private boolean dirtyOnStartup;
    private final CleanupJob cleaning;
    private final Consumer<Throwable> exceptionDecorator = this::appendTreeInformation;

    public GBPTree(PageCache pageCache, File indexFile, Layout<KEY, VALUE> layout, int tentativePageSize, Monitor monitor, Header.Reader headerReader, Consumer<PageCursor> headerWriter, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, OpenOption ... openOptions) throws MetadataMismatchException {
        this.indexFile = indexFile;
        this.monitor = monitor;
        this.readOnly = readOnly;
        this.openOptions = openOptions;
        this.generation = Generation.generation(1L, 2L);
        long rootId = 3L;
        this.setRoot(rootId, Generation.unstableGeneration(this.generation));
        this.layout = layout;
        try {
            TreeNodeSelector.Factory format;
            this.pagedFile = this.openOrCreate(pageCache, indexFile, tentativePageSize, openOptions);
            this.pageSize = this.pagedFile.pageSize();
            this.closed = false;
            if (this.created) {
                format = TreeNodeSelector.selectByLayout(layout);
                this.writeMeta(layout, format, this.pagedFile);
            } else {
                Meta meta = GBPTree.readMeta(layout, this.pagedFile);
                meta.verify(layout);
                format = TreeNodeSelector.selectByFormat(meta.getFormatIdentifier(), meta.getFormatVersion());
            }
            this.freeList = new FreeListIdProvider(this.pagedFile, this.pageSize, rootId, FreeListIdProvider.NO_MONITOR);
            OffloadStoreImpl<KEY, VALUE> offloadStore = GBPTree.buildOffload(layout, this.freeList, this.pagedFile, this.pageSize);
            this.bTreeNode = format.create(this.pageSize, layout, offloadStore);
            this.writer = new SingleWriter(new InternalTreeLogic<KEY, VALUE>(this.freeList, this.bTreeNode, layout, monitor));
            if (this.created) {
                this.initializeAfterCreation(headerWriter);
            } else {
                this.loadState(this.pagedFile, headerReader);
            }
            this.monitor.startupState(this.clean);
            this.dirtyOnStartup = !this.clean;
            this.clean = false;
            this.bumpUnstableGeneration();
            if (!readOnly) {
                this.forceState();
                this.cleaning = this.createCleanupJob(recoveryCleanupWorkCollector, this.dirtyOnStartup);
            } else {
                this.cleaning = CleanupJob.CLEAN;
            }
        }
        catch (IOException e) {
            throw this.exitConstructor(new UncheckedIOException(e));
        }
        catch (Throwable e) {
            throw this.exitConstructor(e);
        }
    }

    private RuntimeException exitConstructor(Throwable throwable) {
        try {
            this.close();
        }
        catch (IOException e) {
            throwable = Exceptions.chain((Throwable)new UncheckedIOException(e), (Throwable)throwable);
        }
        this.appendTreeInformation(throwable);
        Exceptions.throwIfUnchecked((Throwable)throwable);
        return new RuntimeException(throwable);
    }

    private void initializeAfterCreation(Consumer<PageCursor> headerWriter) throws IOException {
        try (PageCursor cursor = this.pagedFile.io(0L, 2);){
            TreeStatePair.initializeStatePages(cursor);
        }
        cursor = this.openRootCursor(2);
        try {
            long stableGeneration = Generation.stableGeneration(this.generation);
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            this.bTreeNode.initializeLeaf(cursor, stableGeneration, unstableGeneration);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.freeList.initializeAfterCreation();
        this.changesSinceLastCheckpoint = true;
        this.checkpoint(IOLimiter.UNLIMITED, headerWriter);
        this.clean = true;
    }

    private PagedFile openOrCreate(PageCache pageCache, File indexFile, int pageSizeForCreation, OpenOption ... openOptions) throws IOException, MetadataMismatchException {
        try {
            return GBPTree.openExistingIndexFile(pageCache, indexFile, openOptions);
        }
        catch (NoSuchFileException e) {
            if (!this.readOnly) {
                return this.createNewIndexFile(pageCache, indexFile, pageSizeForCreation);
            }
            throw new TreeFileNotFoundException("Can not create new tree file in read only mode.", e);
        }
    }

    private static PagedFile openExistingIndexFile(PageCache pageCache, File indexFile, OpenOption ... openOptions) throws IOException, MetadataMismatchException {
        PagedFile pagedFile = pageCache.map(indexFile, pageCache.pageSize(), openOptions);
        MutableBoolean pagedFileOpen = new MutableBoolean(true);
        boolean success = false;
        try {
            Meta meta = GBPTree.readMeta(null, pagedFile);
            pagedFile = GBPTree.mapWithCorrectPageSize(pageCache, indexFile, pagedFile, meta.getPageSize(), pagedFileOpen, openOptions);
            success = true;
            PagedFile pagedFile2 = pagedFile;
            return pagedFile2;
        }
        catch (IllegalStateException e) {
            throw new MetadataMismatchException("Index is not fully initialized since it's missing the meta page", e);
        }
        finally {
            if (!success && pagedFileOpen.booleanValue()) {
                pagedFile.close();
            }
        }
    }

    private PagedFile createNewIndexFile(PageCache pageCache, File indexFile, int pageSizeForCreation) throws IOException {
        int pageSize;
        this.monitor.noStoreFile();
        int n = pageSize = pageSizeForCreation == 0 ? pageCache.pageSize() : pageSizeForCreation;
        if (pageSize > pageCache.pageSize()) {
            throw new MetadataMismatchException(String.format("Tried to create tree with page size %d, but page cache used to create it has a smaller page size %d so cannot be created", pageSize, pageCache.pageSize()));
        }
        PagedFile pagedFile = pageCache.map(indexFile, pageSize, (OpenOption[])ArrayUtil.concat((Object)StandardOpenOption.CREATE, (Object[])this.openOptions));
        this.created = true;
        return pagedFile;
    }

    private void loadState(PagedFile pagedFile, Header.Reader headerReader) throws IOException {
        Pair<TreeState, TreeState> states = GBPTree.loadStatePages(pagedFile);
        TreeState state = TreeStatePair.selectNewestValidState(states);
        try (PageCursor cursor = pagedFile.io(state.pageId(), 1);){
            PageCursorUtil.goTo(cursor, "header data", state.pageId());
            GBPTree.doReadHeader(headerReader, cursor);
        }
        this.generation = Generation.generation(state.stableGeneration(), state.unstableGeneration());
        this.setRoot(state.rootId(), state.rootGeneration());
        long lastId = state.lastId();
        long freeListWritePageId = state.freeListWritePageId();
        long freeListReadPageId = state.freeListReadPageId();
        int freeListWritePos = state.freeListWritePos();
        int freeListReadPos = state.freeListReadPos();
        this.freeList.initialize(lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos);
        this.clean = state.isClean();
    }

    public static void readHeader(PageCache pageCache, File indexFile, Header.Reader headerReader) throws IOException, MetadataMismatchException {
        try (PagedFile pagedFile = GBPTree.openExistingIndexFile(pageCache, indexFile, new OpenOption[0]);){
            Pair<TreeState, TreeState> states = GBPTree.loadStatePages(pagedFile);
            TreeState state = TreeStatePair.selectNewestValidState(states);
            try (PageCursor cursor = pagedFile.io(state.pageId(), 1);){
                PageCursorUtil.goTo(cursor, "header data", state.pageId());
                GBPTree.doReadHeader(headerReader, cursor);
            }
        }
        catch (Throwable t) {
            Exceptions.withMessage((Throwable)t, (String)(t.getMessage() + " | " + String.format("GBPTree[file:%s]", indexFile)));
            throw t;
        }
    }

    private static void doReadHeader(Header.Reader headerReader, PageCursor cursor) throws IOException {
        int headerDataLength;
        do {
            TreeState.read(cursor);
            headerDataLength = cursor.getInt();
        } while (cursor.shouldRetry());
        int headerDataOffset = cursor.getOffset();
        byte[] headerDataBytes = new byte[headerDataLength];
        do {
            cursor.setOffset(headerDataOffset);
            cursor.getBytes(headerDataBytes);
        } while (cursor.shouldRetry());
        headerReader.read(ByteBuffer.wrap(headerDataBytes));
    }

    private void writeState(PagedFile pagedFile, Header.Writer headerWriter) throws IOException {
        Pair<TreeState, TreeState> states = GBPTree.readStatePages(pagedFile);
        TreeState oldestState = TreeStatePair.selectOldestOrInvalid(states);
        long pageToOverwrite = oldestState.pageId();
        Root root = this.root;
        try (PageCursor cursor = pagedFile.io(pageToOverwrite, 2);){
            PageCursorUtil.goTo(cursor, "state page", pageToOverwrite);
            TreeState.write(cursor, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation), root.id(), root.generation(), this.freeList.lastId(), this.freeList.writePageId(), this.freeList.readPageId(), this.freeList.writePos(), this.freeList.readPos(), this.clean);
            GBPTree.writerHeader(pagedFile, headerWriter, GBPTree.other(states, oldestState), cursor);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
    }

    private static void writerHeader(PagedFile pagedFile, Header.Writer headerWriter, TreeState otherState, PageCursor cursor) throws IOException {
        int headerOffset = cursor.getOffset();
        int headerDataOffset = GBPTree.getHeaderDataOffset(headerOffset);
        if (otherState.isValid() || headerWriter != Header.CARRY_OVER_PREVIOUS_HEADER) {
            PageCursor previousCursor = pagedFile.io(otherState.pageId(), 1);
            PageCursorUtil.goTo(previousCursor, "previous state page", otherState.pageId());
            PageCursorUtil.checkOutOfBounds(cursor);
            do {
                cursor.checkAndClearBoundsFlag();
                TreeState.read(previousCursor);
                int previousLength = previousCursor.getInt();
                cursor.setOffset(headerDataOffset);
                headerWriter.write(previousCursor, previousLength, cursor);
            } while (previousCursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(previousCursor);
            PageCursorUtil.checkOutOfBounds(cursor);
            int length = cursor.getOffset() - headerDataOffset;
            cursor.putInt(headerOffset, length);
        }
    }

    @VisibleForTesting
    public static void overwriteHeader(PageCache pageCache, File indexFile, Consumer<PageCursor> headerWriter) throws IOException {
        Header.Writer writer = Header.replace(headerWriter);
        try (PagedFile pagedFile = GBPTree.openExistingIndexFile(pageCache, indexFile, new OpenOption[0]);){
            Pair<TreeState, TreeState> states = GBPTree.readStatePages(pagedFile);
            TreeState newestValidState = TreeStatePair.selectNewestValidState(states);
            long pageToOverwrite = newestValidState.pageId();
            try (PageCursor cursor = pagedFile.io(pageToOverwrite, 2);){
                PageCursorUtil.goTo(cursor, "state page", pageToOverwrite);
                TreeState.read(cursor);
                int headerOffset = cursor.getOffset();
                int headerDataOffset = GBPTree.getHeaderDataOffset(headerOffset);
                cursor.setOffset(headerDataOffset);
                writer.write(null, 0, cursor);
                int length = cursor.getOffset() - headerDataOffset;
                cursor.putInt(headerOffset, length);
                PageCursorUtil.checkOutOfBounds(cursor);
            }
        }
    }

    private static int getHeaderDataOffset(int headerOffset) {
        return headerOffset + 4;
    }

    private static TreeState other(Pair<TreeState, TreeState> states, TreeState state) {
        return states.getLeft() == state ? (TreeState)states.getRight() : (TreeState)states.getLeft();
    }

    private static Pair<TreeState, TreeState> loadStatePages(PagedFile pagedFile) throws MetadataMismatchException, IOException {
        try {
            Pair<TreeState, TreeState> states = GBPTree.readStatePages(pagedFile);
            if (((TreeState)states.getLeft()).isEmpty() && ((TreeState)states.getRight()).isEmpty()) {
                throw new MetadataMismatchException("Index is not fully initialized since its state pages are empty");
            }
            return states;
        }
        catch (IllegalStateException e) {
            throw new MetadataMismatchException("Index is not fully initialized since it's missing state pages", e);
        }
    }

    private static Pair<TreeState, TreeState> readStatePages(PagedFile pagedFile) throws IOException {
        Pair<TreeState, TreeState> states;
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            states = TreeStatePair.readStatePages(cursor, 1L, 2L);
        }
        return states;
    }

    private static PageCursor openMetaPageCursor(PagedFile pagedFile, int pfFlags) throws IOException {
        PageCursor metaCursor = pagedFile.io(0L, pfFlags);
        PageCursorUtil.goTo(metaCursor, "meta page", 0L);
        return metaCursor;
    }

    private static <KEY, VALUE> Meta readMeta(Layout<KEY, VALUE> layout, PagedFile pagedFile) throws IOException {
        try (PageCursor metaCursor = GBPTree.openMetaPageCursor(pagedFile, 1);){
            Meta meta = Meta.read(metaCursor, layout);
            return meta;
        }
    }

    private void writeMeta(Layout<KEY, VALUE> layout, TreeNodeSelector.Factory format, PagedFile pagedFile) throws IOException {
        Meta meta = new Meta(format.formatIdentifier(), format.formatVersion(), this.pageSize, layout);
        try (PageCursor metaCursor = GBPTree.openMetaPageCursor(pagedFile, 2);){
            meta.write(metaCursor, layout);
        }
    }

    private static PagedFile mapWithCorrectPageSize(PageCache pageCache, File indexFile, PagedFile pagedFile, int pageSize, MutableBoolean pagedFileOpen, OpenOption ... openOptions) throws IOException {
        if (pageSize != pageCache.pageSize()) {
            if (pageSize > pageCache.pageSize() || pageSize < 0) {
                throw new MetadataMismatchException(String.format("Tried to create tree with page size %d, but page cache used to open it this time has a smaller page size %d so cannot be opened", pageSize, pageCache.pageSize()));
            }
            pagedFile.close();
            pagedFileOpen.setFalse();
            PagedFile remappedFile = pageCache.map(indexFile, pageSize, openOptions);
            pagedFileOpen.setTrue();
            return remappedFile;
        }
        return pagedFile;
    }

    private PageCursor openRootCursor(int pfFlags) throws IOException {
        PageCursor cursor = this.pagedFile.io(0L, pfFlags);
        this.root.goTo(cursor);
        return cursor;
    }

    @Override
    public Seeker<KEY, VALUE> seek(KEY fromInclusive, KEY toExclusive) throws IOException {
        return this.seekInternal(fromInclusive, toExclusive, 20, SeekCursor.NO_MONITOR);
    }

    private Seeker<KEY, VALUE> seekInternal(KEY fromInclusive, KEY toExclusive, int readAheadLength, SeekCursor.Monitor monitor) throws IOException {
        long generation = this.generation;
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        PageCursor cursor = this.pagedFile.io(0L, 1);
        long rootGeneration = this.root.goTo(cursor);
        return new SeekCursor<KEY, VALUE>(cursor, this.bTreeNode, fromInclusive, toExclusive, this.layout, stableGeneration, unstableGeneration, this.generationSupplier, this.rootCatchupSupplier.get(), rootGeneration, this.exceptionDecorator, readAheadLength, monitor);
    }

    public Collection<Seeker<KEY, VALUE>> partitionedSeek(KEY fromInclusive, KEY toExclusive, int numberOfPartitions) throws IOException {
        return this.partitionedSeekInternal(fromInclusive, toExclusive, numberOfPartitions, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Seeker<KEY, VALUE>> partitionedSeekInternal(KEY fromInclusive, KEY toExclusive, int numberOfPartitions, Seeker.Factory<KEY, VALUE> seekerFactory) throws IOException {
        ArrayList<KEY> rootKeys;
        Preconditions.checkArgument((this.layout.compare(fromInclusive, toExclusive) <= 0 ? 1 : 0) != 0, (String)"Partitioned seek only supports forward seeking for the time being");
        try (PageCursor cursor = this.pagedFile.io(0L, 1);){
            boolean goodRead;
            RootCatchup rootCatchup = this.rootCatchupSupplier.get();
            Root root = this.root;
            boolean didRetry = true;
            do {
                goodRead = false;
                if (!didRetry) {
                    root = rootCatchup.catchupFrom(root.id());
                }
                rootKeys = new ArrayList<KEY>();
                root.goTo(cursor);
                byte nodeType = TreeNode.nodeType(cursor);
                boolean isLeaf = TreeNode.isLeaf(cursor);
                boolean isInternal = TreeNode.isInternal(cursor);
                int keyCount = TreeNode.keyCount(cursor);
                if (nodeType != 1 || !isLeaf && !isInternal || !this.bTreeNode.reasonableKeyCount(keyCount)) continue;
                if (isLeaf) {
                    break;
                }
                for (int pos = 0; pos < keyCount; ++pos) {
                    rootKeys.add(this.bTreeNode.keyAt(cursor, this.layout.newKey(), pos, TreeNode.Type.INTERNAL));
                }
                goodRead = true;
            } while ((didRetry = cursor.shouldRetry()) || !goodRead);
        }
        KeyPartitioning<KEY> partitioning = new KeyPartitioning<KEY>(this.layout);
        ArrayList<Seeker<KEY, VALUE>> seekers = new ArrayList<Seeker<KEY, VALUE>>();
        boolean success = false;
        try {
            for (Pair<KEY, KEY> partition : partitioning.partition(rootKeys, fromInclusive, toExclusive, numberOfPartitions)) {
                seekers.add(seekerFactory.seek(partition.getLeft(), partition.getRight()));
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeAll(seekers);
            }
        }
        return seekers;
    }

    public long estimateNumberOfEntriesInTree() throws IOException {
        KEY low = this.layout.newKey();
        this.layout.initializeAsLowest(low);
        KEY high = this.layout.newKey();
        this.layout.initializeAsHighest(high);
        int sampleSize = 100;
        SizeEstimationMonitor monitor = new SizeEstimationMonitor();
        do {
            monitor.clear();
            Seeker.Factory monitoredSeeks = (fromInclusive, toExclusive) -> this.seekInternal(fromInclusive, toExclusive, 1, monitor);
            for (Seeker partition : this.partitionedSeekInternal(low, high, sampleSize, monitoredSeeks)) {
                partition.next();
            }
        } while (!monitor.isConsistent());
        return monitor.estimateNumberOfKeys();
    }

    public void checkpoint(IOLimiter ioLimiter, Consumer<PageCursor> headerWriter) {
        try {
            this.checkpoint(ioLimiter, Header.replace(headerWriter));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void checkpoint(IOLimiter ioLimiter) {
        try {
            this.checkpoint(ioLimiter, Header.CARRY_OVER_PREVIOUS_HEADER);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint(IOLimiter ioLimiter, Header.Writer headerWriter) throws IOException {
        if (this.readOnly) {
            return;
        }
        this.pagedFile.flushAndForce(ioLimiter);
        this.lock.writerAndCleanerLock();
        try {
            this.assertRecoveryCleanSuccessful();
            this.pagedFile.flushAndForce();
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            this.generation = Generation.generation(unstableGeneration, unstableGeneration + 1L);
            this.writeState(this.pagedFile, headerWriter);
            this.pagedFile.flushAndForce();
            this.monitor.checkpointCompleted();
            this.changesSinceLastCheckpoint = false;
        }
        finally {
            this.lock.writerAndCleanerUnlock();
        }
    }

    private void assertRecoveryCleanSuccessful() throws IOException {
        if (this.cleaning != null && this.cleaning.hasFailed()) {
            throw new IOException("Pointer cleaning during recovery failed", this.cleaning.getCause());
        }
    }

    private void assertNotReadOnly(String operationDescription) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("GBPTree was opened in read only mode and can not finish operation: " + operationDescription);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.readOnly) {
            this.doClose();
            return;
        }
        this.lock.writerLock();
        try {
            if (this.closed) {
                return;
            }
            this.maybeForceCleanState();
            this.doClose();
        }
        catch (IOException ioe) {
            try {
                if (!this.pagedFile.isDeleteOnClose()) {
                    this.pagedFile.flushAndForce();
                }
                this.maybeForceCleanState();
                this.doClose();
            }
            catch (IOException e) {
                ioe.addSuppressed(e);
                throw ioe;
            }
        }
        finally {
            this.lock.writerUnlock();
        }
    }

    private void maybeForceCleanState() throws IOException {
        if (this.cleaning != null && !this.changesSinceLastCheckpoint && !this.cleaning.needed()) {
            this.clean = true;
            if (!this.pagedFile.isDeleteOnClose()) {
                this.forceState();
            }
        }
    }

    private void doClose() throws IOException {
        if (this.pagedFile != null) {
            this.pagedFile.close();
        }
        this.closed = true;
    }

    public Writer<KEY, VALUE> writer() throws IOException {
        return this.writer(0.5);
    }

    public Writer<KEY, VALUE> writer(double ratioToKeepInLeftOnSplit) throws IOException {
        this.assertNotReadOnly("Open tree writer.");
        this.writer.initialize(ratioToKeepInLeftOnSplit);
        this.changesSinceLastCheckpoint = true;
        return this.writer;
    }

    private void setRoot(long rootId, long rootGeneration) {
        this.root = new Root(rootId, rootGeneration);
    }

    private void bumpUnstableGeneration() {
        this.generation = Generation.generation(Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation) + 1L);
    }

    private void forceState() throws IOException {
        this.assertNotReadOnly("Force tree state.");
        if (this.changesSinceLastCheckpoint) {
            throw new IllegalStateException("It seems that this method has been called in the wrong state. It's expected that this is called after opening this tree, but before any changes have been made");
        }
        this.writeState(this.pagedFile, Header.CARRY_OVER_PREVIOUS_HEADER);
        this.pagedFile.flushAndForce();
    }

    private CleanupJob createCleanupJob(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean needsCleaning) {
        if (!needsCleaning) {
            return CleanupJob.CLEAN;
        }
        this.lock.cleanerLock();
        this.monitor.cleanupRegistered();
        long generation = this.generation;
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        long highTreeNodeId = this.freeList.lastId() + 1L;
        CrashGenerationCleaner crashGenerationCleaner = new CrashGenerationCleaner(this.pagedFile, this.bTreeNode, 3L, highTreeNodeId, stableGeneration, unstableGeneration, this.monitor);
        GBPTreeCleanupJob cleanupJob = new GBPTreeCleanupJob(crashGenerationCleaner, this.lock, this.monitor, this.indexFile);
        recoveryCleanupWorkCollector.add(cleanupJob);
        return cleanupJob;
    }

    @VisibleForTesting
    public <VISITOR extends GBPTreeVisitor<KEY, VALUE>> VISITOR visit(VISITOR visitor) throws IOException {
        try (PageCursor cursor = this.openRootCursor(1);){
            new GBPTreeStructure<KEY, VALUE>(this.bTreeNode, this.layout, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation)).visitTree(cursor, this.writer.cursor, visitor);
            this.freeList.visitFreelist(visitor);
        }
        return visitor;
    }

    public void printTree() throws IOException {
        this.printTree(false, false, false, false, false);
    }

    void printTree(boolean printValues, boolean printPosition, boolean printState, boolean printHeader, boolean printFreelist) throws IOException {
        PrintingGBPTreeVisitor printingVisitor = new PrintingGBPTreeVisitor(System.out, printValues, printPosition, printState, printHeader, printFreelist);
        this.visit(printingVisitor);
    }

    public void printState() throws IOException {
        try (PageCursor cursor = this.openRootCursor(1);){
            PrintingGBPTreeVisitor printingVisitor = new PrintingGBPTreeVisitor(System.out, false, false, true, false, false);
            GBPTreeStructure.visitTreeState(cursor, printingVisitor);
        }
    }

    void printNode(long id) throws IOException {
        if (id < this.freeList.lastId()) {
            try (PageCursor cursor = this.pagedFile.io(id, 2);){
                cursor.next();
                byte nodeType = TreeNode.nodeType(cursor);
                if (nodeType == 1) {
                    this.bTreeNode.printNode(cursor, false, true, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation));
                }
            }
        }
    }

    public boolean consistencyCheck() throws IOException {
        return this.consistencyCheck(true);
    }

    public boolean consistencyCheck(boolean reportCrashPointers) throws IOException {
        ThrowingConsistencyCheckVisitor reporter = new ThrowingConsistencyCheckVisitor();
        return this.consistencyCheck(reporter, reportCrashPointers);
    }

    public boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor) throws IOException {
        return this.consistencyCheck(visitor, true);
    }

    public boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<KEY> visitor, boolean reportCrashPointers) throws IOException {
        CleanTrackingConsistencyCheckVisitor<KEY> cleanTrackingVisitor = new CleanTrackingConsistencyCheckVisitor<KEY>(visitor);
        try (PageCursor cursor = this.pagedFile.io(0L, 1);){
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            GBPTreeConsistencyChecker<KEY> consistencyChecker = new GBPTreeConsistencyChecker<KEY>(this.bTreeNode, this.layout, this.freeList, Generation.stableGeneration(this.generation), unstableGeneration, reportCrashPointers);
            consistencyChecker.check(this.indexFile, cursor, this.root, cleanTrackingVisitor);
        }
        catch (MetadataMismatchException | TreeInconsistencyException | CursorException e) {
            cleanTrackingVisitor.exception((Exception)e);
        }
        return cleanTrackingVisitor.clean();
    }

    @VisibleForTesting
    public void unsafe(GBPTreeUnsafe<KEY, VALUE> unsafe) throws IOException {
        TreeState state;
        try (PageCursor cursor = this.pagedFile.io(0L, 2);){
            Pair<TreeState, TreeState> states = TreeStatePair.readStatePages(cursor, 1L, 2L);
            state = TreeStatePair.selectNewestValidState(states);
        }
        unsafe.access(this.pagedFile, this.layout, this.bTreeNode, state);
    }

    public String toString() {
        long generation = this.generation;
        return String.format("GB+Tree[file:%s, layout:%s, generation:%d/%d]", this.indexFile.getAbsolutePath(), this.layout, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
    }

    private <E extends Throwable> void appendTreeInformation(E e) {
        Exceptions.withMessage(e, (String)(e.getMessage() + " | " + this.toString()));
    }

    public boolean wasDirtyOnStartup() {
        return this.dirtyOnStartup;
    }

    public int keyValueSizeCap() {
        return this.bTreeNode.keyValueSizeCap();
    }

    int inlineKeyValueSizeCap() {
        return this.bTreeNode.inlineKeyValueSizeCap();
    }

    private static <KEY, VALUE> OffloadStoreImpl<KEY, VALUE> buildOffload(Layout<KEY, VALUE> layout, IdProvider idProvider, PagedFile pagedFile, int pageSize) {
        OffloadPageCursorFactory pcFactory = (arg_0, arg_1) -> ((PagedFile)pagedFile).io(arg_0, arg_1);
        OffloadIdValidator idValidator = id -> id >= 3L && id <= pagedFile.getLastPageId();
        return new OffloadStoreImpl<KEY, VALUE>(layout, idProvider, pcFactory, idValidator, pageSize);
    }

    private class SingleWriter
    implements Writer<KEY, VALUE> {
        private final AtomicBoolean writerTaken = new AtomicBoolean();
        private final InternalTreeLogic<KEY, VALUE> treeLogic;
        private final StructurePropagation<KEY> structurePropagation;
        private PageCursor cursor;
        private long stableGeneration;
        private long unstableGeneration;
        private double ratioToKeepInLeftOnSplit;

        SingleWriter(InternalTreeLogic<KEY, VALUE> treeLogic) {
            this.structurePropagation = new StructurePropagation(GBPTree.this.layout.newKey(), GBPTree.this.layout.newKey(), GBPTree.this.layout.newKey());
            this.treeLogic = treeLogic;
        }

        void initialize(double ratioToKeepInLeftOnSplit) throws IOException {
            if (!this.writerTaken.compareAndSet(false, true)) {
                throw new IllegalStateException("Writer in " + this + " is already acquired by someone else. Only a single writer is allowed. The writer will become available as soon as acquired writer is closed");
            }
            boolean success = false;
            try {
                GBPTree.this.lock.writerAndCleanerLock();
                GBPTree.this.assertRecoveryCleanSuccessful();
                this.cursor = GBPTree.this.openRootCursor(2);
                this.stableGeneration = Generation.stableGeneration(GBPTree.this.generation);
                this.unstableGeneration = Generation.unstableGeneration(GBPTree.this.generation);
                this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
                assert (PointerChecking.assertNoSuccessor(this.cursor, this.stableGeneration, this.unstableGeneration));
                this.treeLogic.initialize(this.cursor, ratioToKeepInLeftOnSplit);
                success = true;
            }
            catch (Throwable e) {
                GBPTree.this.appendTreeInformation(e);
                throw e;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        public void put(KEY key, VALUE value) {
            this.merge(key, value, ValueMergers.overwrite());
        }

        @Override
        public void merge(KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger) {
            this.internalMerge(key, value, valueMerger, true);
        }

        @Override
        public void mergeIfExists(KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger) {
            this.internalMerge(key, value, valueMerger, false);
        }

        private void internalMerge(KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists) {
            try {
                this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, createIfNotExists, this.stableGeneration, this.unstableGeneration);
                this.handleStructureChanges();
            }
            catch (IOException e) {
                GBPTree.this.appendTreeInformation(e);
                throw new UncheckedIOException(e);
            }
            catch (Throwable t) {
                GBPTree.this.appendTreeInformation(t);
                throw t;
            }
            PageCursorUtil.checkOutOfBounds(this.cursor);
        }

        private void setRoot(long rootPointer) {
            long rootId = GenerationSafePointerPair.pointer(rootPointer);
            GBPTree.this.setRoot(rootId, this.unstableGeneration);
            this.treeLogic.initialize(this.cursor, this.ratioToKeepInLeftOnSplit);
        }

        @Override
        public VALUE remove(KEY key) {
            Object result;
            try {
                result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, GBPTree.this.layout.newValue(), this.stableGeneration, this.unstableGeneration);
                this.handleStructureChanges();
            }
            catch (IOException e) {
                GBPTree.this.appendTreeInformation(e);
                throw new UncheckedIOException(e);
            }
            catch (Throwable e) {
                GBPTree.this.appendTreeInformation(e);
                throw e;
            }
            PageCursorUtil.checkOutOfBounds(this.cursor);
            return result;
        }

        private void handleStructureChanges() throws IOException {
            if (this.structurePropagation.hasRightKeyInsert) {
                long newRootId = GBPTree.this.freeList.acquireNewId(this.stableGeneration, this.unstableGeneration);
                PageCursorUtil.goTo(this.cursor, "new root", newRootId);
                GBPTree.this.bTreeNode.initializeInternal(this.cursor, this.stableGeneration, this.unstableGeneration);
                GBPTree.this.bTreeNode.setChildAt(this.cursor, this.structurePropagation.midChild, 0, this.stableGeneration, this.unstableGeneration);
                GBPTree.this.bTreeNode.insertKeyAndRightChildAt(this.cursor, this.structurePropagation.rightKey, this.structurePropagation.rightChild, 0, 0, this.stableGeneration, this.unstableGeneration);
                TreeNode.setKeyCount(this.cursor, 1);
                this.setRoot(newRootId);
                GBPTree.this.monitor.treeGrowth();
            } else if (this.structurePropagation.hasMidChildUpdate) {
                this.setRoot(this.structurePropagation.midChild);
            }
            this.structurePropagation.clear();
        }

        @Override
        public void close() {
            if (!this.writerTaken.compareAndSet(true, false)) {
                throw new IllegalStateException("Tried to close writer of " + GBPTree.this + ", but writer is already closed.");
            }
            this.closeCursor();
            GBPTree.this.lock.writerAndCleanerUnlock();
        }

        private void closeCursor() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }

    public static interface Monitor {
        public void checkpointCompleted();

        public void noStoreFile();

        public void cleanupRegistered();

        public void cleanupStarted();

        public void cleanupFinished(long var1, long var3, long var5, long var7);

        public void cleanupClosed();

        public void cleanupFailed(Throwable var1);

        public void startupState(boolean var1);

        public void treeGrowth();

        public void treeShrink();

        public static class Adaptor
        implements Monitor {
            @Override
            public void checkpointCompleted() {
            }

            @Override
            public void noStoreFile() {
            }

            @Override
            public void cleanupRegistered() {
            }

            @Override
            public void cleanupStarted() {
            }

            @Override
            public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void cleanupClosed() {
            }

            @Override
            public void cleanupFailed(Throwable throwable) {
            }

            @Override
            public void startupState(boolean clean) {
            }

            @Override
            public void treeGrowth() {
            }

            @Override
            public void treeShrink() {
            }
        }
    }
}

