/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.io.pagecache.PageCursor;

class InternalTreeLogic<KEY, VALUE> {
    static final double DEFAULT_SPLIT_RATIO = 0.5;
    private final IdProvider idProvider;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final Layout<KEY, VALUE> layout;
    private final KEY newKeyPlaceHolder;
    private final KEY readKey;
    private final VALUE readValue;
    private final GBPTree.Monitor monitor;
    private Level<KEY>[] levels = new Level[0];
    private int currentLevel = -1;
    private double ratioToKeepInLeftOnSplit;

    InternalTreeLogic(IdProvider idProvider, TreeNode<KEY, VALUE> bTreeNode, Layout<KEY, VALUE> layout, GBPTree.Monitor monitor) {
        this.idProvider = idProvider;
        this.bTreeNode = bTreeNode;
        this.layout = layout;
        this.newKeyPlaceHolder = layout.newKey();
        this.readKey = layout.newKey();
        this.readValue = layout.newValue();
        this.monitor = monitor;
        this.ensureStackCapacity(10);
    }

    private void ensureStackCapacity(int depth) {
        if (depth > this.levels.length) {
            int oldStackLength = this.levels.length;
            this.levels = Arrays.copyOf(this.levels, depth);
            for (int i = oldStackLength; i < depth; ++i) {
                this.levels[i] = new Level<KEY>(this.layout);
            }
        }
    }

    protected void initialize(PageCursor cursorAtRoot) {
        this.initialize(cursorAtRoot, 0.5);
    }

    protected void initialize(PageCursor cursorAtRoot, double ratioToKeepInLeftOnSplit) {
        this.currentLevel = 0;
        Level<KEY> level = this.levels[this.currentLevel];
        level.treeNodeId = cursorAtRoot.getCurrentPageId();
        level.lowerIsOpenEnded = true;
        level.upperIsOpenEnded = true;
        this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
    }

    private boolean popLevel(PageCursor cursor) throws IOException {
        --this.currentLevel;
        if (this.currentLevel >= 0) {
            Level<KEY> level = this.levels[this.currentLevel];
            TreeNode.goTo(cursor, "parent", level.treeNodeId);
            return true;
        }
        return false;
    }

    private void moveToCorrectLeaf(PageCursor cursor, KEY key, long stableGeneration, long unstableGeneration) throws IOException {
        int previousLevel = this.currentLevel;
        while (!this.levels[this.currentLevel].covers(key)) {
            --this.currentLevel;
        }
        if (this.currentLevel != previousLevel) {
            TreeNode.goTo(cursor, "parent", this.levels[this.currentLevel].treeNodeId);
        }
        while (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            int searchResult = this.search(cursor, TreeNode.Type.INTERNAL, key, this.readKey, keyCount);
            int childPos = KeySearch.positionOf(searchResult);
            if (KeySearch.isHit(searchResult)) {
                // empty if block
            }
            Level<KEY> parentLevel = this.levels[this.currentLevel];
            ++this.currentLevel;
            this.ensureStackCapacity(this.currentLevel + 1);
            Level<KEY> level = this.levels[this.currentLevel];
            level.childPos = ++childPos;
            boolean bl = level.lowerIsOpenEnded = childPos == 0 && !TreeNode.isNode(TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.lowerIsOpenEnded) {
                if (childPos == 0) {
                    this.layout.copyKey(parentLevel.lower, level.lower);
                    level.lowerIsOpenEnded = parentLevel.lowerIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, level.lower, childPos - 1, TreeNode.Type.INTERNAL);
                }
            }
            boolean bl2 = level.upperIsOpenEnded = childPos >= keyCount && !TreeNode.isNode(TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.upperIsOpenEnded) {
                if (childPos == keyCount) {
                    this.layout.copyKey(parentLevel.upper, level.upper);
                    level.upperIsOpenEnded = parentLevel.upperIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, level.upper, childPos, TreeNode.Type.INTERNAL);
                }
            }
            long childId = this.bTreeNode.childAt(cursor, childPos, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(childId, false);
            TreeNode.goTo(cursor, "child", childId);
            level.treeNodeId = cursor.getCurrentPageId();
            assert (PointerChecking.assertNoSuccessor(cursor, stableGeneration, unstableGeneration));
        }
        assert (TreeNode.isLeaf(cursor)) : "Ended up on a tree node which isn't a leaf after moving cursor towards " + key + ", cursor is at " + cursor.getCurrentPageId();
    }

    void insert(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.bTreeNode.validateKeyValueSize(key, value);
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        this.insertInLeaf(cursor, structurePropagation, key, value, valueMerger, createIfNotExists, stableGeneration, unstableGeneration);
        this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration);
    }

    private int search(PageCursor cursor, TreeNode.Type type, KEY key, KEY readKey, int keyCount) {
        int searchResult = KeySearch.search(cursor, this.bTreeNode, type, key, readKey, keyCount);
        KeySearch.assertSuccess(searchResult);
        return searchResult;
    }

    private boolean cursorIsAtExpectedLocation(PageCursor cursor) {
        assert (this.currentLevel >= 0) : "Uninitialized tree logic, currentLevel:" + this.currentLevel;
        long currentPageId = cursor.getCurrentPageId();
        long expectedPageId = this.levels[this.currentLevel].treeNodeId;
        assert (currentPageId == expectedPageId) : "Expected cursor to be at page:" + expectedPageId + " at level:" + this.currentLevel + ", but was at page:" + currentPageId;
        return true;
    }

    private void insertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        this.doInsertInInternal(cursor, structurePropagation, keyCount, primKey, rightChild, stableGeneration, unstableGeneration);
    }

    private void doInsertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration) throws IOException {
        TreeNode.Overflow overflow = this.bTreeNode.internalOverflow(cursor, keyCount, primKey);
        if (overflow == TreeNode.Overflow.YES) {
            this.layout.copyKey(primKey, this.newKeyPlaceHolder);
            this.splitInternal(cursor, structurePropagation, this.newKeyPlaceHolder, rightChild, keyCount, stableGeneration, unstableGeneration);
            return;
        }
        if (overflow == TreeNode.Overflow.NO_NEED_DEFRAG) {
            this.bTreeNode.defragmentInternal(cursor);
        }
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.INTERNAL, primKey, this.readKey, keyCount));
        this.bTreeNode.insertKeyAndRightChildAt(cursor, primKey, rightChild, pos, keyCount, stableGeneration, unstableGeneration);
        TreeNode.setKeyCount(cursor, keyCount + 1);
    }

    private void splitInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, long newRightChild, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.INTERNAL, newKey, this.readKey, keyCount));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeInternal(rightCursor, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.bTreeNode.doSplitInternal(cursor, keyCount, rightCursor, pos, newKey, newRightChild, stableGeneration, unstableGeneration, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit);
        }
        if (TreeNode.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private void insertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, TreeNode.Type.LEAF, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        if (KeySearch.isHit(search)) {
            this.mergeValue(cursor, structurePropagation, key, value, valueMerger, pos, keyCount, stableGeneration, unstableGeneration);
            return;
        }
        if (createIfNotExists) {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.doInsertInLeaf(cursor, structurePropagation, key, value, pos, keyCount, stableGeneration, unstableGeneration);
        }
    }

    private void mergeValue(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, int pos, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.valueAt(cursor, this.readValue, pos);
        ValueMerger.MergeResult mergeResult = valueMerger.merge(this.readKey, key, this.readValue, value);
        if (mergeResult == ValueMerger.MergeResult.UNCHANGED) {
            return;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        if (mergeResult == ValueMerger.MergeResult.REPLACED || mergeResult == ValueMerger.MergeResult.MERGED) {
            VALUE mergedValue = mergeResult == ValueMerger.MergeResult.REPLACED ? value : this.readValue;
            boolean couldOverwrite = this.bTreeNode.setValueAt(cursor, mergedValue, pos);
            if (!couldOverwrite) {
                this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration);
                TreeNode.setKeyCount(cursor, keyCount - 1);
                boolean didSplit = this.doInsertInLeaf(cursor, structurePropagation, key, mergedValue, pos, keyCount - 1, stableGeneration, unstableGeneration);
                if (!didSplit && this.bTreeNode.leafUnderflow(cursor, keyCount)) {
                    this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
                }
            }
        } else if (mergeResult == ValueMerger.MergeResult.REMOVED) {
            this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration);
            int newKeyCount = keyCount - 1;
            TreeNode.setKeyCount(cursor, newKeyCount);
            if (this.bTreeNode.leafUnderflow(cursor, newKeyCount)) {
                this.underflowInLeaf(cursor, structurePropagation, newKeyCount, stableGeneration, unstableGeneration);
            }
        } else {
            throw new UnsupportedOperationException("Unexpected merge result " + mergeResult);
        }
    }

    private boolean doInsertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        TreeNode.Overflow overflow = this.bTreeNode.leafOverflow(cursor, keyCount, key, value);
        if (overflow == TreeNode.Overflow.YES) {
            this.splitLeaf(cursor, structurePropagation, key, value, keyCount, stableGeneration, unstableGeneration);
            return true;
        }
        if (overflow == TreeNode.Overflow.NO_NEED_DEFRAG) {
            this.bTreeNode.defragmentLeaf(cursor);
        }
        this.bTreeNode.insertKeyValueAt(cursor, key, value, pos, keyCount, stableGeneration, unstableGeneration);
        TreeNode.setKeyCount(cursor, keyCount + 1);
        return false;
    }

    private void splitLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, VALUE newValue, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.LEAF, newKey, this.readKey, keyCount));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeLeaf(rightCursor, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.bTreeNode.doSplitLeaf(cursor, keyCount, rightCursor, pos, newKey, newValue, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    VALUE remove(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        if (!this.removeFromLeaf(cursor, structurePropagation, key, into, stableGeneration, unstableGeneration)) {
            return null;
        }
        this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration);
        if (this.currentLevel <= 0) {
            this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
        }
        return into;
    }

    private void handleStructureChanges(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        block8: while (structurePropagation.hasLeftChildUpdate || structurePropagation.hasMidChildUpdate || structurePropagation.hasRightChildUpdate || structurePropagation.hasLeftKeyReplace || structurePropagation.hasRightKeyReplace || structurePropagation.hasRightKeyInsert) {
            int pos = this.levels[this.currentLevel].childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasLeftChildUpdate) {
                structurePropagation.hasLeftChildUpdate = false;
                if (pos == 0) {
                    this.updateRightmostChildInLeftSibling(cursor, structurePropagation.leftChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.leftChild, pos - 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
            }
            if (structurePropagation.hasRightChildUpdate) {
                structurePropagation.hasRightChildUpdate = false;
                int keyCount = TreeNode.keyCount(cursor);
                if (pos == keyCount) {
                    this.updateLeftmostChildInRightSibling(cursor, structurePropagation.rightChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.rightChild, pos + 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasRightKeyInsert) {
                structurePropagation.hasRightKeyInsert = false;
                this.insertInInternal(cursor, structurePropagation, TreeNode.keyCount(cursor), structurePropagation.rightKey, structurePropagation.rightChild, stableGeneration, unstableGeneration);
            }
            if (structurePropagation.hasLeftKeyReplace && this.levels[this.currentLevel].covers(structurePropagation.leftKey)) {
                structurePropagation.hasLeftKeyReplace = false;
                switch (structurePropagation.keyReplaceStrategy) {
                    case REPLACE: {
                        this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.leftKey, pos - 1, stableGeneration, unstableGeneration);
                        break;
                    }
                    case BUBBLE: {
                        this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos - 1, stableGeneration, unstableGeneration);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown KeyReplaceStrategy " + structurePropagation.keyReplaceStrategy);
                    }
                }
            }
            if (!structurePropagation.hasRightKeyReplace || !this.levels[this.currentLevel].covers(structurePropagation.rightKey)) continue;
            structurePropagation.hasRightKeyReplace = false;
            switch (structurePropagation.keyReplaceStrategy) {
                case REPLACE: {
                    this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.rightKey, pos, stableGeneration, unstableGeneration);
                    continue block8;
                }
                case BUBBLE: {
                    this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown KeyReplaceStrategy " + structurePropagation.keyReplaceStrategy);
        }
    }

    private void overwriteKeyInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, int pos, long stableGeneration, long unstableGeneration) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        int keyCount = TreeNode.keyCount(cursor);
        boolean couldOverwrite = this.bTreeNode.setKeyAtInternal(cursor, newKey, pos);
        if (!couldOverwrite) {
            long rightChild = this.bTreeNode.childAt(cursor, pos + 1, stableGeneration, unstableGeneration);
            this.bTreeNode.removeKeyAndRightChildAt(cursor, pos, keyCount, stableGeneration, unstableGeneration);
            TreeNode.setKeyCount(cursor, keyCount - 1);
            this.doInsertInInternal(cursor, structurePropagation, keyCount - 1, newKey, rightChild, stableGeneration, unstableGeneration);
        }
    }

    private void tryShrinkTree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        int rootKeyCount = TreeNode.keyCount(cursor);
        while (rootKeyCount == 0 && TreeNode.isInternal(cursor)) {
            long oldRoot = cursor.getCurrentPageId();
            long onlyChildOfRoot = this.bTreeNode.childAt(cursor, 0, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(onlyChildOfRoot, false);
            structurePropagation.hasMidChildUpdate = true;
            structurePropagation.midChild = onlyChildOfRoot;
            this.idProvider.releaseId(stableGeneration, unstableGeneration, oldRoot);
            TreeNode.goTo(cursor, "child", onlyChildOfRoot);
            rootKeyCount = TreeNode.keyCount(cursor);
            this.monitor.treeShrink();
        }
    }

    private void updateMidChild(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int childPos, long stableGeneration, long unstableGeneration) {
        structurePropagation.hasMidChildUpdate = false;
        this.bTreeNode.setChildAt(cursor, structurePropagation.midChild, childPos, stableGeneration, unstableGeneration);
    }

    private void replaceKeyByBubbleRightmostFromSubtree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int subtreePosition, long stableGeneration, long unstableGeneration) throws IOException {
        long currentPageId = cursor.getCurrentPageId();
        long subtree = this.bTreeNode.childAt(cursor, subtreePosition, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(subtree, false);
        TreeNode.goTo(cursor, "child", subtree);
        boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration);
        if (structurePropagation.hasMidChildUpdate) {
            this.updateMidChild(cursor, structurePropagation, subtreePosition, stableGeneration, unstableGeneration);
        }
        if (foundKeyBelow) {
            this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.bubbleKey, subtreePosition, stableGeneration, unstableGeneration);
        } else {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            int keyCount = TreeNode.keyCount(cursor);
            this.simplyRemoveFromInternal(cursor, keyCount, subtreePosition, true, stableGeneration, unstableGeneration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bubbleRightmostKeyRecursive(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long previousNode, long stableGeneration, long unstableGeneration) throws IOException {
        try {
            if (TreeNode.isLeaf(cursor)) {
                boolean bl = false;
                return bl;
            }
            long currentPageId = cursor.getCurrentPageId();
            int keyCount = TreeNode.keyCount(cursor);
            long rightmostSubtree = this.bTreeNode.childAt(cursor, keyCount, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(rightmostSubtree, false);
            TreeNode.goTo(cursor, "child", rightmostSubtree);
            boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration);
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
            }
            if (foundKeyBelow) {
                boolean bl = true;
                return bl;
            }
            if (keyCount == 0) {
                this.connectLeftAndRightSibling(cursor, stableGeneration, unstableGeneration);
                this.idProvider.releaseId(stableGeneration, unstableGeneration, currentPageId);
                boolean bl = false;
                return bl;
            }
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.bTreeNode.keyAt(cursor, structurePropagation.bubbleKey, keyCount - 1, TreeNode.Type.INTERNAL);
            this.simplyRemoveFromInternal(cursor, keyCount, keyCount - 1, false, stableGeneration, unstableGeneration);
            boolean bl = true;
            return bl;
        }
        finally {
            TreeNode.goTo(cursor, "back to previous node", previousNode);
        }
    }

    private void simplyRemoveFromInternal(PageCursor cursor, int keyCount, int keyPos, boolean leftChild, long stableGeneration, long unstableGeneration) throws IOException {
        if (leftChild) {
            this.bTreeNode.removeKeyAndLeftChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration);
        } else {
            this.bTreeNode.removeKeyAndRightChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration);
        }
        TreeNode.setKeyCount(cursor, keyCount - 1);
    }

    private void updateRightmostChildInLeftSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, false);
        try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(leftSibling);){
            TreeNode.goTo(leftSiblingCursor, "left sibling", leftSibling);
            int keyCount = TreeNode.keyCount(leftSiblingCursor);
            this.bTreeNode.setChildAt(leftSiblingCursor, childPointer, keyCount, stableGeneration, unstableGeneration);
        }
    }

    private void updateLeftmostChildInRightSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, false);
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(rightSibling);){
            TreeNode.goTo(rightSiblingCursor, "right sibling", rightSibling);
            this.bTreeNode.setChildAt(rightSiblingCursor, childPointer, 0, stableGeneration, unstableGeneration);
        }
    }

    private boolean removeFromLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, TreeNode.Type.LEAF, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        boolean hit = KeySearch.isHit(search);
        if (!hit) {
            return false;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        keyCount = this.simplyRemoveFromLeaf(cursor, into, keyCount, pos, stableGeneration, unstableGeneration);
        if (this.bTreeNode.leafUnderflow(cursor, keyCount)) {
            this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void underflowInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(leftSibling));){
                leftSiblingCursor.next();
                int leftSiblingKeyCount = TreeNode.keyCount(leftSiblingCursor);
                int keysToRebalance = this.bTreeNode.canRebalanceLeaves(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount);
                if (keysToRebalance > 0) {
                    this.createSuccessorIfNeeded(leftSiblingCursor, structurePropagation, StructurePropagation.UPDATE_LEFT_CHILD, stableGeneration, unstableGeneration);
                    this.rebalanceLeaf(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, keysToRebalance, structurePropagation);
                    return;
                }
                if (keysToRebalance != -1) return;
                this.mergeFromLeftSiblingLeaf(cursor, leftSiblingCursor, structurePropagation, keyCount, leftSiblingKeyCount, stableGeneration, unstableGeneration);
                return;
            }
        }
        if (!TreeNode.isNode(rightSibling)) return;
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(rightSibling));){
            rightSiblingCursor.next();
            int rightSiblingKeyCount = TreeNode.keyCount(rightSiblingCursor);
            if (!this.bTreeNode.canMergeLeaves(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount)) return;
            this.createSuccessorIfNeeded(rightSiblingCursor, structurePropagation, StructurePropagation.UPDATE_RIGHT_CHILD, stableGeneration, unstableGeneration);
            this.mergeToRightSiblingLeaf(cursor, rightSiblingCursor, structurePropagation, keyCount, rightSiblingKeyCount, stableGeneration, unstableGeneration);
            return;
        }
    }

    private void connectLeftAndRightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) throws IOException {
        long currentId = cursor.getCurrentPageId();
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling", leftSibling);
            TreeNode.setRightSibling(cursor, rightSibling, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling", rightSibling);
            TreeNode.setLeftSibling(cursor, leftSibling, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "back to origin after repointing siblings", currentId);
    }

    private void mergeToRightSiblingLeaf(PageCursor cursor, PageCursor rightSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.keyAt(rightSiblingCursor, structurePropagation.rightKey, rightSiblingKeyCount - 1, TreeNode.Type.LEAF);
        this.merge(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount, stableGeneration, unstableGeneration);
        structurePropagation.hasMidChildUpdate = true;
        structurePropagation.midChild = rightSiblingCursor.getCurrentPageId();
        structurePropagation.hasRightKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void mergeFromLeftSiblingLeaf(PageCursor cursor, PageCursor leftSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int leftSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.keyAt(leftSiblingCursor, structurePropagation.leftKey, 0, TreeNode.Type.LEAF);
        this.merge(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, stableGeneration, unstableGeneration);
        structurePropagation.hasLeftChildUpdate = true;
        structurePropagation.leftChild = cursor.getCurrentPageId();
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void merge(PageCursor leftSiblingCursor, int leftSiblingKeyCount, PageCursor rightSiblingCursor, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.copyKeyValuesFromLeftToRight(leftSiblingCursor, leftSiblingKeyCount, rightSiblingCursor, rightSiblingKeyCount);
        TreeNode.setSuccessor(leftSiblingCursor, rightSiblingCursor.getCurrentPageId(), stableGeneration, unstableGeneration);
        this.connectLeftAndRightSibling(leftSiblingCursor, stableGeneration, unstableGeneration);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, leftSiblingCursor.getCurrentPageId());
    }

    private void rebalanceLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int numberOfKeysToMove, StructurePropagation<KEY> structurePropagation) {
        this.bTreeNode.moveKeyValuesFromLeftToRight(leftCursor, leftKeyCount, rightCursor, rightKeyCount, leftKeyCount - numberOfKeysToMove);
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.REPLACE;
        this.bTreeNode.keyAt(rightCursor, structurePropagation.leftKey, 0, TreeNode.Type.LEAF);
    }

    private int simplyRemoveFromLeaf(PageCursor cursor, VALUE into, int keyCount, int pos, long stableGeneration, long unstableGeneration) throws IOException {
        this.bTreeNode.valueAt(cursor, into, pos);
        this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration);
        int newKeyCount = keyCount - 1;
        TreeNode.setKeyCount(cursor, newKeyCount);
        return newKeyCount;
    }

    private void createSuccessorIfNeeded(PageCursor cursor, StructurePropagation<KEY> structurePropagation, StructurePropagation.StructureUpdate structureUpdate, long stableGeneration, long unstableGeneration) throws IOException {
        long oldId = cursor.getCurrentPageId();
        long nodeGeneration = TreeNode.generation(cursor);
        if (nodeGeneration == unstableGeneration) {
            return;
        }
        long successorId = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        try (PageCursor successorCursor = cursor.openLinkedCursor(successorId);){
            TreeNode.goTo(successorCursor, "successor", successorId);
            cursor.copyTo(0, successorCursor, 0, cursor.getCurrentPageSize());
            TreeNode.setGeneration(successorCursor, unstableGeneration);
            TreeNode.setSuccessor(successorCursor, 0L, stableGeneration, unstableGeneration);
        }
        TreeNode.setSuccessor(cursor, successorId, stableGeneration, unstableGeneration);
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling in split", leftSibling);
            TreeNode.setRightSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling in split", rightSibling);
            TreeNode.setLeftSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "successor", successorId);
        structureUpdate.update(structurePropagation, successorId);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, oldId);
    }

    private static class Level<KEY> {
        private final Comparator<KEY> layout;
        private long treeNodeId;
        private int childPos;
        private final KEY lower;
        private boolean lowerIsOpenEnded;
        private final KEY upper;
        private boolean upperIsOpenEnded;

        Level(Layout<KEY, ?> layout) {
            this.layout = layout;
            this.lower = layout.newKey();
            this.upper = layout.newKey();
        }

        boolean covers(KEY key) {
            boolean insideLower = this.lowerIsOpenEnded || this.layout.compare(key, this.lower) >= 0;
            boolean insideHigher = this.upperIsOpenEnded || this.layout.compare(key, this.upper) < 0;
            return insideLower && insideHigher;
        }
    }
}

