/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadIdValidator;
import org.neo4j.index.internal.gbptree.OffloadPageCursorFactory;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.util.VisibleForTesting;

public class OffloadStoreImpl<KEY, VALUE>
implements OffloadStore<KEY, VALUE> {
    private static final int SIZE_HEADER = 9;
    private static final int SIZE_KEY_SIZE = 4;
    private static final int SIZE_VALUE_SIZE = 4;
    private final Layout<KEY, VALUE> layout;
    private final IdProvider idProvider;
    private final OffloadPageCursorFactory pcFactory;
    private final OffloadIdValidator offloadIdValidator;
    private final int maxEntrySize;

    OffloadStoreImpl(Layout<KEY, VALUE> layout, IdProvider idProvider, OffloadPageCursorFactory pcFactory, OffloadIdValidator offloadIdValidator, int pageSize) {
        this.layout = layout;
        this.idProvider = idProvider;
        this.pcFactory = pcFactory;
        this.offloadIdValidator = offloadIdValidator;
        this.maxEntrySize = OffloadStoreImpl.keyValueSizeCapFromPageSize(pageSize);
    }

    @Override
    public int maxEntrySize() {
        return this.maxEntrySize;
    }

    @Override
    public void readKey(long offloadId, KEY into) throws IOException {
        this.validateOffloadId(offloadId);
        try (PageCursor cursor = this.pcFactory.create(offloadId, 1);){
            do {
                OffloadStoreImpl.placeCursorAtOffloadId(cursor, offloadId);
                if (!this.readHeader(cursor)) continue;
                cursor.setOffset(9);
                int keySize = cursor.getInt();
                int valueSize = cursor.getInt();
                if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0 || valueSize < 0) {
                    OffloadStoreImpl.readUnreliableKeyValueSize(cursor, keySize, valueSize);
                    continue;
                }
                this.layout.readKey(cursor, into, keySize);
            } while (cursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(cursor);
            cursor.checkAndClearCursorException();
        }
    }

    @Override
    public void readKeyValue(long offloadId, KEY key, VALUE value) throws IOException {
        this.validateOffloadId(offloadId);
        try (PageCursor cursor = this.pcFactory.create(offloadId, 1);){
            do {
                OffloadStoreImpl.placeCursorAtOffloadId(cursor, offloadId);
                if (!this.readHeader(cursor)) continue;
                cursor.setOffset(9);
                int keySize = cursor.getInt();
                int valueSize = cursor.getInt();
                if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0) {
                    OffloadStoreImpl.readUnreliableKeyValueSize(cursor, keySize, valueSize);
                    continue;
                }
                this.layout.readKey(cursor, key, keySize);
                this.layout.readValue(cursor, value, valueSize);
            } while (cursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(cursor);
            cursor.checkAndClearCursorException();
        }
    }

    @Override
    public void readValue(long offloadId, VALUE into) throws IOException {
        this.validateOffloadId(offloadId);
        try (PageCursor cursor = this.pcFactory.create(offloadId, 1);){
            do {
                OffloadStoreImpl.placeCursorAtOffloadId(cursor, offloadId);
                if (!this.readHeader(cursor)) continue;
                cursor.setOffset(9);
                int keySize = cursor.getInt();
                int valueSize = cursor.getInt();
                if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0) {
                    OffloadStoreImpl.readUnreliableKeyValueSize(cursor, keySize, valueSize);
                    continue;
                }
                cursor.setOffset(cursor.getOffset() + keySize);
                this.layout.readValue(cursor, into, valueSize);
            } while (cursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(cursor);
            cursor.checkAndClearCursorException();
        }
    }

    @Override
    public long writeKey(KEY key, long stableGeneration, long unstableGeneration) throws IOException {
        int keySize = this.layout.keySize(key);
        long newId = this.acquireNewId(stableGeneration, unstableGeneration);
        try (PageCursor cursor = this.pcFactory.create(newId, 2);){
            OffloadStoreImpl.placeCursorAtOffloadId(cursor, newId);
            OffloadStoreImpl.writeHeader(cursor);
            cursor.setOffset(9);
            OffloadStoreImpl.putKeyValueSize(cursor, keySize, 0);
            this.layout.writeKey(cursor, key);
            long l = newId;
            return l;
        }
    }

    @Override
    public long writeKeyValue(KEY key, VALUE value, long stableGeneration, long unstableGeneration) throws IOException {
        int keySize = this.layout.keySize(key);
        int valueSize = this.layout.valueSize(value);
        long newId = this.acquireNewId(stableGeneration, unstableGeneration);
        try (PageCursor cursor = this.pcFactory.create(newId, 2);){
            OffloadStoreImpl.placeCursorAtOffloadId(cursor, newId);
            OffloadStoreImpl.writeHeader(cursor);
            cursor.setOffset(9);
            OffloadStoreImpl.putKeyValueSize(cursor, keySize, valueSize);
            this.layout.writeKey(cursor, key);
            this.layout.writeValue(cursor, value);
            long l = newId;
            return l;
        }
    }

    @Override
    public void free(long offloadId, long stableGeneration, long unstableGeneration) throws IOException {
        this.idProvider.releaseId(stableGeneration, unstableGeneration, offloadId);
    }

    @VisibleForTesting
    static int keyValueSizeCapFromPageSize(int pageSize) {
        return pageSize - 9 - 4 - 4;
    }

    static void writeHeader(PageCursor cursor) {
        cursor.putByte(0, (byte)3);
    }

    private boolean readHeader(PageCursor cursor) {
        byte type = TreeNode.nodeType(cursor);
        if (type != 3) {
            cursor.setCursorException(String.format("Tried to read from offload store but page is not an offload page. Expected %d but was %d", (byte)3, type));
            return false;
        }
        return true;
    }

    private static void putKeyValueSize(PageCursor cursor, int keySize, int valueSize) {
        cursor.putInt(keySize);
        cursor.putInt(valueSize);
    }

    private long acquireNewId(long stableGeneration, long unstableGeneration) throws IOException {
        return this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
    }

    private static void placeCursorAtOffloadId(PageCursor cursor, long offloadId) throws IOException {
        PageCursorUtil.goTo(cursor, "offload page", offloadId);
    }

    private boolean keyValueSizeTooLarge(int keySize, int valueSize) {
        return keySize > this.maxEntrySize || valueSize > this.maxEntrySize || keySize + valueSize > this.maxEntrySize;
    }

    private static void readUnreliableKeyValueSize(PageCursor cursor, int keySize, int valueSize) {
        cursor.setCursorException(String.format("Read unreliable key, id=%d, keySize=%d, valueSize=%d", cursor.getCurrentPageId(), keySize, valueSize));
    }

    private void validateOffloadId(long offloadId) throws IOException {
        if (!this.offloadIdValidator.valid(offloadId)) {
            throw new IOException(String.format("Offload id %d is outside of valid range, ", offloadId));
        }
    }
}

