/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.KeyRange;

class CleanTrackingConsistencyCheckVisitor<KEY>
implements GBPTreeConsistencyCheckVisitor<KEY> {
    private final MutableBoolean isConsistent = new MutableBoolean(true);
    private final GBPTreeConsistencyCheckVisitor<KEY> delegate;

    CleanTrackingConsistencyCheckVisitor(GBPTreeConsistencyCheckVisitor<KEY> delegate) {
        this.delegate = delegate;
    }

    boolean isConsistent() {
        return this.isConsistent.booleanValue();
    }

    @Override
    public void notATreeNode(long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.notATreeNode(pageId, file);
    }

    @Override
    public void unknownTreeNodeType(long pageId, byte treeNodeType, File file) {
        this.isConsistent.setFalse();
        this.delegate.unknownTreeNodeType(pageId, treeNodeType, file);
    }

    @Override
    public void siblingsDontPointToEachOther(long leftNode, long leftNodeGeneration, long leftRightSiblingPointerGeneration, long leftRightSiblingPointer, long rightLeftSiblingPointer, long rightLeftSiblingPointerGeneration, long rightNode, long rightNodeGeneration, File file) {
        this.isConsistent.setFalse();
        this.delegate.siblingsDontPointToEachOther(leftNode, leftNodeGeneration, leftRightSiblingPointerGeneration, leftRightSiblingPointer, rightLeftSiblingPointer, rightLeftSiblingPointerGeneration, rightNode, rightNodeGeneration, file);
    }

    @Override
    public void rightmostNodeHasRightSibling(long rightSiblingPointer, long rightmostNode, File file) {
        this.isConsistent.setFalse();
        this.delegate.rightmostNodeHasRightSibling(rightSiblingPointer, rightmostNode, file);
    }

    @Override
    public void pointerToOldVersionOfTreeNode(long pageId, long successorPointer, File file) {
        this.isConsistent.setFalse();
        this.delegate.pointerToOldVersionOfTreeNode(pageId, successorPointer, file);
    }

    @Override
    public void pointerHasLowerGenerationThanNode(GBPTreePointerType pointerType, long sourceNode, long pointerGeneration, long pointer, long targetNodeGeneration, File file) {
        this.isConsistent.setFalse();
        this.delegate.pointerHasLowerGenerationThanNode(pointerType, sourceNode, pointerGeneration, pointer, targetNodeGeneration, file);
    }

    @Override
    public void keysOutOfOrderInNode(long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.keysOutOfOrderInNode(pageId, file);
    }

    @Override
    public void keysLocatedInWrongNode(KeyRange<KEY> range, KEY key, int pos, int keyCount, long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.keysLocatedInWrongNode(range, key, pos, keyCount, pageId, file);
    }

    @Override
    public void unusedPage(long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.unusedPage(pageId, file);
    }

    @Override
    public void pageIdExceedLastId(long lastId, long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.pageIdExceedLastId(lastId, pageId, file);
    }

    @Override
    public void nodeMetaInconsistency(long pageId, String message, File file) {
        this.isConsistent.setFalse();
        this.delegate.nodeMetaInconsistency(pageId, message, file);
    }

    @Override
    public void pageIdSeenMultipleTimes(long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.pageIdSeenMultipleTimes(pageId, file);
    }

    @Override
    public void crashedPointer(long pageId, GBPTreePointerType pointerType, long generationA, long readPointerA, long pointerA, byte stateA, long generationB, long readPointerB, long pointerB, byte stateB, File file) {
        this.isConsistent.setFalse();
        this.delegate.crashedPointer(pageId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
    }

    @Override
    public void brokenPointer(long pageId, GBPTreePointerType pointerType, long generationA, long readPointerA, long pointerA, byte stateA, long generationB, long readPointerB, long pointerB, byte stateB, File file) {
        this.isConsistent.setFalse();
        this.delegate.brokenPointer(pageId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
    }

    @Override
    public void unreasonableKeyCount(long pageId, int keyCount, File file) {
        this.isConsistent.setFalse();
        this.delegate.unreasonableKeyCount(pageId, keyCount, file);
    }

    @Override
    public void childNodeFoundAmongParentNodes(KeyRange<KEY> superRange, int level, long pageId, File file) {
        this.isConsistent.setFalse();
        this.delegate.childNodeFoundAmongParentNodes(superRange, level, pageId, file);
    }

    @Override
    public void exception(Exception e) {
        this.isConsistent.setFalse();
        this.delegate.exception(e);
    }

    @Override
    public void dirtyOnStartup(File file) {
        this.delegate.dirtyOnStartup(file);
    }
}

