/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.concurrent.Futures;

class CrashGenerationCleaner {
    private static final String INDEX_CLEANER_TAG = "indexCleaner";
    private static final String NUMBER_OF_WORKERS_NAME = "number_of_workers";
    private static final int NUMBER_OF_WORKERS_DEFAULT = Math.min(8, Runtime.getRuntime().availableProcessors());
    private static final int NUMBER_OF_WORKERS = FeatureToggles.getInteger(CrashGenerationCleaner.class, (String)"number_of_workers", (int)NUMBER_OF_WORKERS_DEFAULT);
    private static final long MIN_BATCH_SIZE = 10L;
    static final long MAX_BATCH_SIZE = 100L;
    private final PagedFile pagedFile;
    private final TreeNode<?, ?> treeNode;
    private final long lowTreeNodeId;
    private final long highTreeNodeId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final GBPTree.Monitor monitor;
    private final PageCacheTracer pageCacheTracer;

    CrashGenerationCleaner(PagedFile pagedFile, TreeNode<?, ?> treeNode, long lowTreeNodeId, long highTreeNodeId, long stableGeneration, long unstableGeneration, GBPTree.Monitor monitor, PageCacheTracer pageCacheTracer) {
        this.pagedFile = pagedFile;
        this.treeNode = treeNode;
        this.lowTreeNodeId = lowTreeNodeId;
        this.highTreeNodeId = highTreeNodeId;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.monitor = monitor;
        this.pageCacheTracer = pageCacheTracer;
    }

    private static long batchSize(long pagesToClean, int threads) {
        return Math.min(100L, Math.max(10L, pagesToClean / (100L * (long)threads)));
    }

    public void clean(CallableExecutor executor) {
        this.monitor.cleanupStarted();
        assert (this.unstableGeneration > this.stableGeneration) : this.unexpectedGenerations();
        assert (this.unstableGeneration - this.stableGeneration > 1L) : this.unexpectedGenerations();
        Stopwatch startTime = Stopwatch.start();
        long pagesToClean = this.highTreeNodeId - this.lowTreeNodeId;
        int threads = NUMBER_OF_WORKERS;
        long batchSize = CrashGenerationCleaner.batchSize(pagesToClean, threads);
        AtomicLong nextId = new AtomicLong(this.lowTreeNodeId);
        AtomicBoolean stopFlag = new AtomicBoolean();
        LongAdder cleanedPointers = new LongAdder();
        LongAdder numberOfTreeNodes = new LongAdder();
        ArrayList<Future> cleanerFutures = new ArrayList<Future>();
        for (int i = 0; i < threads; ++i) {
            Callable<?> cleanerTask = this.cleaner(nextId, batchSize, numberOfTreeNodes, cleanedPointers, stopFlag, this.pageCacheTracer);
            Future future = executor.submit(cleanerTask);
            cleanerFutures.add(future);
        }
        try {
            Futures.getAll(cleanerFutures);
        }
        catch (Throwable e) {
            Exceptions.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.monitor.cleanupFinished(pagesToClean, numberOfTreeNodes.sum(), cleanedPointers.sum(), startTime.elapsed(TimeUnit.MILLISECONDS));
    }

    private Callable<?> cleaner(AtomicLong nextId, long batchSize, LongAdder numberOfTreeNodes, LongAdder cleanedPointers, AtomicBoolean stopFlag, PageCacheTracer pageCacheTracer) {
        return () -> {
            try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(INDEX_CLEANER_TAG);
                 PageCursor cursor = this.pagedFile.io(0L, 1, cursorTracer);
                 PageCursor writeCursor = this.pagedFile.io(0L, 2, cursorTracer);){
                long localNextId;
                while ((localNextId = nextId.getAndAdd(batchSize)) < this.highTreeNodeId) {
                    int localNumberOfTreeNodes = 0;
                    int i = 0;
                    while ((long)i < batchSize && localNextId < this.highTreeNodeId) {
                        PageCursorUtil.goTo(cursor, "clean", localNextId);
                        boolean isTreeNode = this.isTreeNode(cursor);
                        if (isTreeNode) {
                            ++localNumberOfTreeNodes;
                            if (this.hasCrashedGSPP(this.treeNode, cursor)) {
                                writeCursor.next(cursor.getCurrentPageId());
                                this.cleanTreeNode(this.treeNode, writeCursor, cleanedPointers);
                            }
                        }
                        ++i;
                        ++localNextId;
                    }
                    numberOfTreeNodes.add(localNumberOfTreeNodes);
                    if (!stopFlag.get()) continue;
                    break;
                }
            }
            catch (Throwable e) {
                stopFlag.set(true);
                throw e;
            }
            return null;
        };
    }

    private boolean isTreeNode(PageCursor cursor) throws IOException {
        boolean isTreeNode;
        do {
            boolean bl = isTreeNode = TreeNode.nodeType(cursor) == 1;
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return isTreeNode;
    }

    private boolean hasCrashedGSPP(TreeNode<?, ?> treeNode, PageCursor cursor) throws IOException {
        boolean hasCrashed;
        int keyCount;
        do {
            keyCount = TreeNode.keyCount(cursor);
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        do {
            boolean bl = hasCrashed = this.hasCrashedGSPP(cursor, 58) || this.hasCrashedGSPP(cursor, 34) || this.hasCrashedGSPP(cursor, 10);
            if (hasCrashed || !TreeNode.isInternal(cursor)) continue;
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i) && !hasCrashed; ++i) {
                hasCrashed = this.hasCrashedGSPP(cursor, treeNode.childOffset(i));
            }
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return hasCrashed;
    }

    private boolean hasCrashedGSPP(PageCursor cursor, int gsppOffset) {
        return this.hasCrashedGSP(cursor, gsppOffset) || this.hasCrashedGSP(cursor, gsppOffset + 12);
    }

    private boolean hasCrashedGSP(PageCursor cursor, int offset) {
        cursor.setOffset(offset);
        long generation = GenerationSafePointer.readGeneration(cursor);
        return generation > this.stableGeneration && generation < this.unstableGeneration;
    }

    private void cleanTreeNode(TreeNode<?, ?> treeNode, PageCursor cursor, LongAdder cleanedPointers) {
        this.cleanCrashedGSPP(cursor, 58, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 34, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 10, cleanedPointers);
        if (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i); ++i) {
                this.cleanCrashedGSPP(cursor, treeNode.childOffset(i), cleanedPointers);
            }
        }
    }

    private void cleanCrashedGSPP(PageCursor cursor, int gsppOffset, LongAdder cleanedPointers) {
        this.cleanCrashedGSP(cursor, gsppOffset, cleanedPointers);
        this.cleanCrashedGSP(cursor, gsppOffset + 12, cleanedPointers);
    }

    private void cleanCrashedGSP(PageCursor cursor, int gspOffset, LongAdder cleanedPointers) {
        if (this.hasCrashedGSP(cursor, gspOffset)) {
            cursor.setOffset(gspOffset);
            GenerationSafePointer.clean(cursor);
            cleanedPointers.increment();
        }
    }

    private String unexpectedGenerations() {
        return "Unexpected generations, stableGeneration=" + this.stableGeneration + ", unstableGeneration=" + this.unstableGeneration;
    }
}

