/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.io.pagecache.PageCursor;

public interface Layout<KEY, VALUE>
extends Comparator<KEY> {
    public static final int FIXED_SIZE_KEY = -1;
    public static final int FIXED_SIZE_VALUE = -1;

    public KEY newKey();

    public KEY copyKey(KEY var1, KEY var2);

    public VALUE newValue();

    public int keySize(KEY var1);

    public int valueSize(VALUE var1);

    public void writeKey(PageCursor var1, KEY var2);

    public void writeValue(PageCursor var1, VALUE var2);

    public void readKey(PageCursor var1, KEY var2, int var3);

    public void readValue(PageCursor var1, VALUE var2, int var3);

    public boolean fixedSize();

    default public void minimalSplitter(KEY left, KEY right, KEY into) {
        this.copyKey(right, into);
    }

    public long identifier();

    public int majorVersion();

    public int minorVersion();

    default public void writeMetaData(PageCursor cursor) {
    }

    default public void readMetaData(PageCursor cursor) {
    }

    public static long namedIdentifier(String name, int identifier) {
        char[] chars = name.toCharArray();
        if (chars.length > 4) {
            throw new IllegalArgumentException("Maximum 4 character name, was '" + name + "'");
        }
        long upperInt = 0L;
        for (char aChar : chars) {
            byte byteValue = (byte)((byte)aChar ^ (byte)(aChar >> 8));
            upperInt <<= 8;
            upperInt |= (long)(byteValue & 0xFF);
        }
        return upperInt << 32 | (long)identifier;
    }

    public boolean compatibleWith(long var1, int var3, int var4);

    public void initializeAsLowest(KEY var1);

    public void initializeAsHighest(KEY var1);

    public static abstract class Adapter<KEY, VALUE>
    implements Layout<KEY, VALUE> {
        private final boolean fixedSize;
        private final long identifier;
        private final int majorVersion;
        private final int minorVersion;

        protected Adapter(boolean fixedSize, long identifier, int majorVersion, int minorVersion) {
            this.fixedSize = fixedSize;
            this.identifier = identifier;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        @Override
        public boolean fixedSize() {
            return this.fixedSize;
        }

        @Override
        public long identifier() {
            return this.identifier;
        }

        @Override
        public int majorVersion() {
            return this.majorVersion;
        }

        @Override
        public int minorVersion() {
            return this.minorVersion;
        }

        public String toString() {
            return String.format("%s[version:%d.%d, identifier:%d, fixedSize:%b]", this.getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier(), this.fixedSize());
        }

        @Override
        public boolean compatibleWith(long layoutIdentifier, int majorVersion, int minorVersion) {
            return layoutIdentifier == this.identifier() && majorVersion == this.majorVersion() && minorVersion == this.minorVersion();
        }
    }
}

