/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.FreelistNode;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

class FreeListIdProvider
implements IdProvider {
    static final Monitor NO_MONITOR = new Monitor(){};
    private final PagedFile pagedFile;
    private final FreelistNode freelistNode;
    private volatile long writePageId;
    private volatile long readPageId;
    private volatile int writePos;
    private volatile int readPos;
    private volatile long lastId;
    private final Monitor monitor;

    FreeListIdProvider(PagedFile pagedFile, long lastId) {
        this(pagedFile, lastId, NO_MONITOR);
    }

    FreeListIdProvider(PagedFile pagedFile, long lastId, Monitor monitor) {
        this.pagedFile = pagedFile;
        this.monitor = monitor;
        this.freelistNode = new FreelistNode(pagedFile.pageSize());
        this.lastId = lastId;
    }

    void initialize(long lastId, long writePageId, long readPageId, int writePos, int readPos) {
        this.lastId = lastId;
        this.writePageId = writePageId;
        this.readPageId = readPageId;
        this.writePos = writePos;
        this.readPos = readPos;
    }

    void initializeAfterCreation(CursorContext cursorContext) throws IOException {
        this.readPageId = this.writePageId = this.nextLastId();
        try (PageCursor cursor = this.pagedFile.io(this.writePageId, 2, cursorContext);){
            PageCursorUtil.goTo(cursor, "free-list", this.writePageId);
            FreelistNode.initialize(cursor);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
    }

    @Override
    public long acquireNewId(long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.pagedFile.io(0L, 2, cursorContext);){
            long l = this.acquireNewId(cursor, stableGeneration, unstableGeneration, true, cursorContext);
            return l;
        }
    }

    private long acquireNewId(PageCursor cursor, long stableGeneration, long unstableGeneration, boolean allowTakeLastFromPage, CursorContext cursorContext) throws IOException {
        long acquiredId = this.acquireNewIdFromFreelistOrEnd(cursor, stableGeneration, unstableGeneration, allowTakeLastFromPage, cursorContext);
        PageCursorUtil.goTo(cursor, "newly allocated free-list page", acquiredId);
        cursor.zapPage();
        return acquiredId;
    }

    private long acquireNewIdFromFreelistOrEnd(PageCursor cursor, long stableGeneration, long unstableGeneration, boolean allowTakeLastFromPage, CursorContext cursorContext) throws IOException {
        if (!(this.readPageId == this.writePageId && this.readPos >= this.writePos || !allowTakeLastFromPage && this.readPos >= this.freelistNode.maxEntries() - 1)) {
            PageCursorUtil.goTo(cursor, "Free-list read page ", this.readPageId);
            long resultPageId = this.freelistNode.read(cursor, stableGeneration, this.readPos);
            if (resultPageId != 0L) {
                ++this.readPos;
                if (this.readPos >= this.freelistNode.maxEntries()) {
                    this.readPos = 0;
                    this.readPageId = FreelistNode.next(cursor);
                    long exhaustedFreelistPageId = cursor.getCurrentPageId();
                    this.releaseId(stableGeneration, unstableGeneration, exhaustedFreelistPageId, cursorContext);
                    this.monitor.releasedFreelistPageId(exhaustedFreelistPageId);
                }
                return resultPageId;
            }
        }
        return this.nextLastId();
    }

    private long nextLastId() {
        return ++this.lastId;
    }

    @Override
    public void releaseId(long stableGeneration, long unstableGeneration, long id, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.pagedFile.io(this.writePageId, 2, cursorContext);){
            PageCursorUtil.goTo(cursor, "free-list write page", this.writePageId);
            this.freelistNode.write(cursor, unstableGeneration, id, this.writePos);
            ++this.writePos;
            if (this.writePos >= this.freelistNode.maxEntries()) {
                long nextFreelistPage = this.acquireNewId(cursor, stableGeneration, unstableGeneration, false, cursorContext);
                PageCursorUtil.goTo(cursor, "free-list write page", this.writePageId);
                FreelistNode.initialize(cursor);
                FreelistNode.setNext(cursor, nextFreelistPage);
                this.writePageId = nextFreelistPage;
                this.writePos = 0;
                this.monitor.acquiredFreelistPageId(nextFreelistPage);
            }
        }
    }

    @Override
    public void visitFreelist(IdProvider.IdProviderVisitor visitor, CursorContext cursorContext) throws IOException {
        if (this.readPageId == 0L) {
            return;
        }
        try (PageCursor cursor = this.pagedFile.io(0L, 1, cursorContext);){
            long prevPage;
            GenerationKeeper generation = new GenerationKeeper();
            long pageId = this.readPageId;
            int pos = this.readPos;
            do {
                int targetPos;
                PageCursorUtil.goTo(cursor, "free-list", pageId);
                visitor.beginFreelistPage(pageId);
                int n = targetPos = pageId == this.writePageId ? this.writePos : this.freelistNode.maxEntries();
                while (pos < targetPos) {
                    long unacquiredId;
                    do {
                        unacquiredId = this.freelistNode.read(cursor, Long.MAX_VALUE, pos, generation);
                    } while (cursor.shouldRetry());
                    visitor.freelistEntry(unacquiredId, generation.generation, pos);
                    ++pos;
                }
                visitor.endFreelistPage(pageId);
                prevPage = pageId;
                pos = 0;
                do {
                    pageId = FreelistNode.next(cursor);
                } while (cursor.shouldRetry());
            } while (prevPage != this.writePageId);
        }
    }

    @Override
    public long lastId() {
        return this.lastId;
    }

    long writePageId() {
        return this.writePageId;
    }

    long readPageId() {
        return this.readPageId;
    }

    int writePos() {
        return this.writePos;
    }

    int readPos() {
        return this.readPos;
    }

    int entriesPerPage() {
        return this.freelistNode.maxEntries();
    }

    static interface Monitor {
        default public void acquiredFreelistPageId(long freelistPageId) {
        }

        default public void releasedFreelistPageId(long freelistPageId) {
        }
    }
}

