/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class SeekCursor<KEY, VALUE>
implements Seeker<KEY, VALUE> {
    static final Monitor NO_MONITOR = new MonitorAdaptor();
    static final int DEFAULT_MAX_READ_AHEAD = 20;
    static final int LEAF_LEVEL = Integer.MAX_VALUE;
    private final PageCursor cursor;
    private final CursorContext cursorContext;
    private final KEY[] mutableKeys;
    private final VALUE[] mutableValues;
    private int cachedIndex;
    private int cachedLength;
    private boolean resultOnTrack;
    private final KEY fromInclusive;
    private final KEY toExclusive;
    private final boolean exactMatch;
    private final Layout<KEY, VALUE> layout;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final KEY prevKey;
    private final LongSupplier generationSupplier;
    private final RootCatchup rootCatchup;
    private final int searchLevel;
    private boolean first = true;
    private long stableGeneration;
    private long unstableGeneration;
    private int pos;
    private int keyCount;
    private boolean concurrentWriteHappened;
    private long currentNodeGeneration;
    private long lastFollowedPointerGeneration;
    private long expectedCurrentNodeGeneration;
    private final boolean seekForward;
    private final int stride;
    private byte nodeType;
    private long successor;
    private long successorGeneration;
    private boolean isInternal;
    private long pointerId;
    private long pointerGeneration;
    private int searchResult;
    private long prevSiblingId;
    private long prevSiblingGeneration;
    private final KEY expectedFirstAfterGoToNext;
    private final KEY firstKeyInNode;
    private boolean verifyExpectedFirstAfterGoToNext;
    private boolean closed;
    private final Consumer<Throwable> exceptionDecorator;
    private final Monitor monitor;
    private boolean forceReadHeader;
    private final GenerationKeeper generationKeeper = new GenerationKeeper();

    SeekCursor(PageCursor cursor, TreeNode<KEY, VALUE> bTreeNode, KEY fromInclusive, KEY toExclusive, Layout<KEY, VALUE> layout, long stableGeneration, long unstableGeneration, LongSupplier generationSupplier, RootCatchup rootCatchup, long lastFollowedPointerGeneration, Consumer<Throwable> exceptionDecorator, int maxReadAhead, int searchLevel, Monitor monitor, CursorContext cursorContext) throws IOException {
        this.cursor = cursor;
        this.cursorContext = cursorContext;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.layout = layout;
        this.exceptionDecorator = exceptionDecorator;
        this.monitor = monitor;
        this.exactMatch = layout.compare(fromInclusive, toExclusive) == 0;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.generationSupplier = generationSupplier;
        this.bTreeNode = bTreeNode;
        this.rootCatchup = rootCatchup;
        this.lastFollowedPointerGeneration = lastFollowedPointerGeneration;
        int batchSize = this.exactMatch ? 1 : maxReadAhead;
        this.mutableKeys = new Object[batchSize];
        this.mutableValues = new Object[batchSize];
        this.mutableKeys[0] = layout.newKey();
        this.mutableValues[0] = layout.newValue();
        this.prevKey = layout.newKey();
        this.seekForward = layout.compare(fromInclusive, toExclusive) <= 0;
        this.stride = this.seekForward ? 1 : -1;
        this.expectedFirstAfterGoToNext = layout.newKey();
        this.firstKeyInNode = layout.newKey();
        this.searchLevel = searchLevel;
        try {
            this.traverseDownToCorrectLevel();
        }
        catch (Throwable e) {
            exceptionDecorator.accept(e);
            throw e;
        }
    }

    private void traverseDownToCorrectLevel() throws IOException {
        int currentReadLevel = 0;
        int completedReadLevel = -1;
        do {
            boolean lookingForChild = true;
            do {
                if (!this.readHeader()) continue;
                this.searchResult = this.searchKey(this.fromInclusive, this.isInternal ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF);
                if (!KeySearch.isSuccess(this.searchResult)) continue;
                lookingForChild = this.isInternal && currentReadLevel < this.searchLevel;
                this.pos = SeekCursor.positionOf(this.searchResult, lookingForChild);
                if (!lookingForChild) continue;
                this.pointerId = this.bTreeNode.childAt(this.cursor, this.pos, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
                this.pointerGeneration = this.generationKeeper.generation;
            } while (this.cursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(this.cursor);
            this.cursor.checkAndClearCursorException();
            if (!this.endedUpOnExpectedNode()) {
                this.prepareToStartFromRoot();
                this.isInternal = true;
                currentReadLevel = 0;
                completedReadLevel = -1;
                continue;
            }
            if (!this.saneRead()) {
                throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGeneration:%d%n  successor:%d%n  successorGeneration:%d%n  isInternal:%b%n  keyCount:%d%n  searchResult:%d%n  pos:%d%n  childId:%d%n  childIdGeneration:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGeneration, this.successor, this.successorGeneration, this.isInternal, this.keyCount, this.searchResult, this.pos, this.pointerId, this.pointerGeneration);
            }
            if (this.goToSuccessor()) continue;
            completedReadLevel = currentReadLevel++;
            if (!lookingForChild) continue;
            this.monitor.internalNode(completedReadLevel, this.keyCount);
            this.goTo(this.pointerId, this.pointerGeneration, "child", false);
        } while (completedReadLevel < currentReadLevel && completedReadLevel < this.searchLevel);
        if (this.isInternal) {
            this.monitor.internalNode(completedReadLevel, this.keyCount);
        } else {
            this.monitor.leafNode(completedReadLevel, this.keyCount);
        }
        this.pos -= this.stride;
        if (!this.seekForward) {
            this.concurrentWriteHappened = true;
        }
        this.cachedLength = 0;
    }

    @Override
    public boolean next() throws IOException {
        if (this.closed) {
            return false;
        }
        try {
            block11: {
                while (true) {
                    this.pos += this.stride;
                    if (this.cachedIndex + 1 < this.cachedLength && !this.closed && !(this.concurrentWriteHappened = this.cursor.shouldRetry())) {
                        ++this.cachedIndex;
                        if (0 <= this.pos && this.pos < this.keyCount) {
                            if (!this.resultOnTrack && !this.isResultKey()) continue;
                            this.resultOnTrack = true;
                            return true;
                        }
                        break block11;
                    }
                    if (this.resultOnTrack) {
                        this.layout.copyKey(this.mutableKeys[this.cachedIndex], this.prevKey);
                    }
                    if (!this.readAndValidateNextKeyValueBatch()) {
                        this.cachedLength = 0;
                        continue;
                    }
                    if (!this.seekForward && this.pos >= this.keyCount) {
                        this.goTo(this.prevSiblingId, this.prevSiblingGeneration, "prev sibling", true);
                        continue;
                    }
                    if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0 && !this.insidePrevKey(this.cachedIndex)) {
                        if (this.goToNextSibling()) {
                            continue;
                        }
                        break block11;
                    }
                    if (0 > this.pos || this.pos >= this.keyCount || !this.insideEndRange(this.exactMatch, 0)) break block11;
                    if (this.isResultKey()) break;
                }
                this.resultOnTrack = true;
                return true;
            }
            this.close();
            return false;
        }
        catch (Throwable e) {
            this.exceptionDecorator.accept(e);
            throw e;
        }
    }

    private boolean readAndValidateNextKeyValueBatch() throws IOException {
        block0: do {
            this.cachedIndex = 0;
            this.cachedLength = 0;
            this.resultOnTrack = false;
            if ((this.concurrentWriteHappened || this.forceReadHeader || !this.seekForward) && (!this.readHeader() || this.isInternal && this.searchLevel == Integer.MAX_VALUE)) continue;
            if (this.verifyExpectedFirstAfterGoToNext) {
                this.pos = this.seekForward ? 0 : this.keyCount - 1;
                this.bTreeNode.keyAt(this.cursor, this.firstKeyInNode, this.pos, this.isInternal ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF, this.cursorContext);
            }
            if (this.concurrentWriteHappened) {
                this.searchResult = this.searchKey(this.first ? this.fromInclusive : this.prevKey, this.isInternal ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF);
                if (!KeySearch.isSuccess(this.searchResult)) continue;
                this.pos = SeekCursor.positionOf(this.searchResult, false);
                if (!this.seekForward && this.pos >= this.keyCount) {
                    this.prevSiblingId = this.readPrevSibling();
                    this.prevSiblingGeneration = this.generationKeeper.generation;
                }
            }
            if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0) {
                this.pointerId = this.readNextSibling();
                this.pointerGeneration = this.generationKeeper.generation;
            }
            for (int readPos = this.pos; this.cachedLength < this.mutableKeys.length && 0 <= readPos && readPos < this.keyCount; readPos += this.stride) {
                if (this.mutableKeys[this.cachedLength] == null) {
                    this.mutableKeys[this.cachedLength] = this.layout.newKey();
                    this.mutableValues[this.cachedLength] = this.layout.newValue();
                }
                if (!this.isInternal) {
                    this.bTreeNode.keyValueAt(this.cursor, this.mutableKeys[this.cachedLength], this.mutableValues[this.cachedLength], readPos, this.cursorContext);
                } else {
                    this.bTreeNode.keyAt(this.cursor, this.mutableKeys[this.cachedLength], readPos, TreeNode.Type.INTERNAL, this.cursorContext);
                }
                if (!this.insideEndRange(this.exactMatch, this.cachedLength)) continue block0;
                if (this.cachedLength <= 0 && !this.insidePrevKey(this.cachedLength)) continue;
                ++this.cachedLength;
            }
        } while (this.concurrentWriteHappened = this.cursor.shouldRetry());
        this.checkOutOfBoundsAndClosed();
        this.cursor.checkAndClearCursorException();
        if (!this.endedUpOnExpectedNode() || this.isInternal && this.searchLevel == Integer.MAX_VALUE) {
            this.prepareToStartFromRoot();
            this.traverseDownToCorrectLevel();
            return false;
        }
        if (!this.saneRead()) {
            throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGeneration:%d%n  successor:%d%n  successorGeneration:%d%n  keyCount:%d%n  searchResult:%d%n  pos:%d%n  rightSibling:%d%n  rightSiblingGeneration:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGeneration, this.successor, this.successorGeneration, this.keyCount, this.searchResult, this.pos, this.pointerId, this.pointerGeneration);
        }
        if (!this.verifyFirstKeyInNodeIsExpectedAfterGoTo()) {
            return false;
        }
        return !this.goToSuccessor();
    }

    private void checkOutOfBoundsAndClosed() {
        try {
            PageCursorUtil.checkOutOfBounds(this.cursor);
        }
        catch (TreeInconsistencyException e) {
            if (this.closed) {
                throw new IllegalStateException("Tried to use seeker after it was closed");
            }
            throw e;
        }
    }

    private boolean insideEndRange(boolean exactMatch, int cachedIndex) {
        if (exactMatch) {
            return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) <= 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) >= 0;
        }
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) < 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) > 0;
    }

    private boolean insideStartRange(int cachedIndex) {
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.fromInclusive) >= 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.fromInclusive) <= 0;
    }

    private boolean insidePrevKey(int cachedIndex) {
        if (this.first) {
            return this.insideStartRange(cachedIndex);
        }
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.prevKey) > 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.prevKey) < 0;
    }

    private boolean goTo(long pointerId, long pointerGeneration, String type, boolean allowNoNode) throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(pointerId, allowNoNode)) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (!allowNoNode || TreeNode.isNode(pointerId)) {
            TreeNode.goTo(this.cursor, type, pointerId);
            this.lastFollowedPointerGeneration = pointerGeneration;
            this.concurrentWriteHappened = true;
            return true;
        }
        return false;
    }

    private boolean goToSuccessor() throws IOException {
        return this.goTo(this.successor, this.successorGeneration, "successor", true);
    }

    private boolean verifyFirstKeyInNodeIsExpectedAfterGoTo() {
        boolean result = true;
        if (this.verifyExpectedFirstAfterGoToNext && this.layout.compare(this.firstKeyInNode, this.expectedFirstAfterGoToNext) != 0) {
            this.concurrentWriteHappened = true;
            result = false;
        }
        this.verifyExpectedFirstAfterGoToNext = false;
        return result;
    }

    private long readPrevSibling() {
        return this.seekForward ? TreeNode.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper) : TreeNode.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
    }

    private long readNextSibling() {
        return this.seekForward ? TreeNode.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper) : TreeNode.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
    }

    private int searchKey(KEY key, TreeNode.Type type) {
        return KeySearch.search(this.cursor, this.bTreeNode, type, key, this.mutableKeys[0], this.keyCount, this.cursorContext);
    }

    private static int positionOf(int searchResult, boolean lookingForChildPosition) {
        if (lookingForChildPosition) {
            return KeySearch.childPositionOf(searchResult);
        }
        return KeySearch.positionOf(searchResult);
    }

    private boolean readHeader() {
        this.nodeType = TreeNode.nodeType(this.cursor);
        if (this.nodeType != 1) {
            return false;
        }
        this.currentNodeGeneration = TreeNode.generation(this.cursor);
        this.successor = TreeNode.successor(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
        this.successorGeneration = this.generationKeeper.generation;
        this.isInternal = TreeNode.isInternal(this.cursor);
        this.keyCount = TreeNode.keyCount(this.cursor);
        this.forceReadHeader = false;
        return this.keyCountIsSane(this.keyCount);
    }

    private boolean endedUpOnExpectedNode() {
        return this.nodeType == 1 && this.verifyNodeGenerationInvariants();
    }

    private boolean goToNextSibling() throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(this.pointerId, true)) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (TreeNode.isNode(this.pointerId)) {
            if (this.seekForward) {
                TreeNode.goTo(this.cursor, "sibling", this.pointerId);
                this.lastFollowedPointerGeneration = this.pointerGeneration;
                if (this.first) {
                    this.concurrentWriteHappened = true;
                } else {
                    this.forceReadHeader = true;
                    this.pos = -1;
                }
                return true;
            }
            if (this.scoutNextSibling()) {
                TreeNode.goTo(this.cursor, "sibling", this.pointerId);
                this.verifyExpectedFirstAfterGoToNext = true;
                this.lastFollowedPointerGeneration = this.pointerGeneration;
            } else {
                this.concurrentWriteHappened = true;
            }
            return true;
        }
        return false;
    }

    private boolean scoutNextSibling() throws IOException {
        byte nodeType;
        int keyCount = -1;
        try (PageCursor scout = this.cursor.openLinkedCursor(GenerationSafePointerPair.pointer(this.pointerId));){
            scout.next();
            nodeType = TreeNode.nodeType(scout);
            if (nodeType == 1 && this.keyCountIsSane(keyCount = TreeNode.keyCount(scout))) {
                int firstPos = this.seekForward ? 0 : keyCount - 1;
                this.bTreeNode.keyAt(scout, this.expectedFirstAfterGoToNext, firstPos, TreeNode.Type.LEAF, this.cursorContext);
            }
            if (this.cursor.shouldRetry()) {
                boolean bl = false;
                return bl;
            }
            PageCursorUtil.checkOutOfBounds(this.cursor);
        }
        return nodeType == 1 && this.keyCountIsSane(keyCount);
    }

    private boolean isResultKey() {
        if (!this.insideStartRange(this.cachedIndex)) {
            this.concurrentWriteHappened = true;
            return false;
        }
        if (!this.first && !this.insidePrevKey(this.cachedIndex)) {
            return false;
        }
        if (this.first) {
            this.first = false;
        }
        return true;
    }

    private boolean keyCountIsSane(int keyCount) {
        return this.bTreeNode.reasonableKeyCount(keyCount);
    }

    private boolean saneRead() {
        return this.keyCountIsSane(this.keyCount) && KeySearch.isSuccess(this.searchResult);
    }

    private void prepareToStartFromRoot() throws IOException {
        this.generationCatchup();
        Root root = this.rootCatchup.catchupFrom(this.cursor.getCurrentPageId());
        this.lastFollowedPointerGeneration = root.goTo(this.cursor);
        if (!this.first) {
            this.layout.copyKey(this.prevKey, this.fromInclusive);
        }
        this.cachedIndex = 0;
        this.cachedLength = 0;
        this.resultOnTrack = false;
        this.pos = 0;
        this.keyCount = 0;
        this.concurrentWriteHappened = false;
        this.verifyExpectedFirstAfterGoToNext = false;
        this.currentNodeGeneration = 0L;
        this.expectedCurrentNodeGeneration = 0L;
        this.nodeType = 0;
        this.successor = 0L;
        this.successorGeneration = 0L;
        this.isInternal = false;
        this.pointerId = 0L;
        this.pointerGeneration = 0L;
        this.searchResult = 0;
        this.prevSiblingId = 0L;
        this.prevSiblingGeneration = 0L;
        this.forceReadHeader = false;
    }

    private boolean verifyNodeGenerationInvariants() {
        if (this.lastFollowedPointerGeneration != 0L) {
            if (this.currentNodeGeneration > this.lastFollowedPointerGeneration) {
                return false;
            }
            this.lastFollowedPointerGeneration = 0L;
            this.expectedCurrentNodeGeneration = this.currentNodeGeneration;
        } else if (this.currentNodeGeneration != this.expectedCurrentNodeGeneration) {
            return false;
        }
        return true;
    }

    private boolean pointerCheckingWithGenerationCatchup(long pointer, boolean allowNoNode) {
        if (!GenerationSafePointerPair.isSuccess(pointer)) {
            if (this.generationCatchup()) {
                return true;
            }
            PointerChecking.checkPointer(pointer, allowNoNode);
        }
        return false;
    }

    private boolean generationCatchup() {
        long newGeneration = this.generationSupplier.getAsLong();
        long newStableGeneration = Generation.stableGeneration(newGeneration);
        long newUnstableGeneration = Generation.unstableGeneration(newGeneration);
        if (newStableGeneration != this.stableGeneration || newUnstableGeneration != this.unstableGeneration) {
            this.stableGeneration = newStableGeneration;
            this.unstableGeneration = newUnstableGeneration;
            return true;
        }
        return false;
    }

    @Override
    public KEY key() {
        this.assertHasResult();
        return this.mutableKeys[this.cachedIndex];
    }

    @Override
    public VALUE value() {
        this.assertHasResult();
        return this.mutableValues[this.cachedIndex];
    }

    @Override
    public void close() {
        this.cursor.close();
        this.closed = true;
    }

    private void assertHasResult() {
        if (this.first) {
            throw new IllegalStateException("There has been no successful call to next() yet");
        }
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
    }

    static class MonitorAdaptor
    implements Monitor {
        MonitorAdaptor() {
        }

        @Override
        public void internalNode(int depth, int keyCount) {
        }

        @Override
        public void leafNode(int depth, int keyCount) {
        }
    }

    static interface Monitor {
        public void internalNode(int var1, int var2);

        public void leafNode(int var1, int var2);
    }
}

