/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class GBPTree<KEY, VALUE>
extends MultiRootGBPTree<SingleRoot, KEY, VALUE>
implements DataTree<KEY, VALUE> {
    private final DataTree<KEY, VALUE> access;

    public GBPTree(PageCache pageCache, FileSystemAbstraction fileSystem, Path indexFile, Layout<KEY, VALUE> layout, MultiRootGBPTree.Monitor monitor, Header.Reader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, ImmutableSet<OpenOption> openOptions, String databaseName, String name, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) throws MetadataMismatchException {
        this(pageCache, fileSystem, indexFile, layout, monitor, headerReader, recoveryCleanupWorkCollector, readOnly, openOptions, databaseName, name, contextFactory, pageCacheTracer, EmptyDependencyResolver.EMPTY_RESOLVER, TreeNodeLayoutFactory.getInstance());
    }

    public GBPTree(PageCache pageCache, FileSystemAbstraction fileSystem, Path indexFile, Layout<KEY, VALUE> layout, MultiRootGBPTree.Monitor monitor, Header.Reader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, ImmutableSet<OpenOption> openOptions, String databaseName, String name, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver) throws MetadataMismatchException {
        this(pageCache, fileSystem, indexFile, layout, monitor, headerReader, recoveryCleanupWorkCollector, readOnly, openOptions, databaseName, name, contextFactory, pageCacheTracer, dependencyResolver, TreeNodeLayoutFactory.getInstance());
    }

    public GBPTree(PageCache pageCache, FileSystemAbstraction fileSystem, Path indexFile, Layout<KEY, VALUE> layout, MultiRootGBPTree.Monitor monitor, Header.Reader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, ImmutableSet<OpenOption> openOptions, String databaseName, String name, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver, TreeNodeLayoutFactory treeNodeLayoutFactory) throws MetadataMismatchException {
        super(pageCache, fileSystem, indexFile, layout, monitor, headerReader, recoveryCleanupWorkCollector, readOnly, openOptions, databaseName, name, contextFactory, RootLayerConfiguration.singleRoot(), pageCacheTracer, dependencyResolver, treeNodeLayoutFactory);
        this.access = this.rootLayer.access(SingleRoot.SINGLE_ROOT);
    }

    @Override
    public Seeker<KEY, VALUE> allocateSeeker(CursorContext cursorContext) throws IOException {
        return this.access.allocateSeeker(cursorContext);
    }

    @Override
    public Seeker<KEY, VALUE> seek(Seeker<KEY, VALUE> seeker, KEY fromInclusive, KEY toExclusive) throws IOException {
        return this.access.seek(seeker, fromInclusive, toExclusive);
    }

    @Override
    public List<KEY> partitionedSeek(KEY fromInclusive, KEY toExclusive, int desiredNumberOfPartitions, CursorContext cursorContext) throws IOException {
        return this.access.partitionedSeek(fromInclusive, toExclusive, desiredNumberOfPartitions, cursorContext);
    }

    @Override
    public Writer<KEY, VALUE> writer(int flags, CursorContext cursorContext) throws IOException {
        return this.access.writer(flags, cursorContext);
    }

    @Override
    public long estimateNumberOfEntriesInTree(CursorContext cursorContext) throws IOException {
        return this.access.estimateNumberOfEntriesInTree(cursorContext);
    }
}

