/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.InternalNodeFixedSize;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeFixedSize;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class TreeNodeFixedSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    static final byte FORMAT_IDENTIFIER = 2;
    static final byte FORMAT_VERSION = 0;

    TreeNodeFixedSize(int pageSize, Layout<KEY, VALUE> layout) {
        super(layout, new LeafNodeFixedSize<KEY, VALUE>(pageSize, layout), new InternalNodeFixedSize<KEY>(pageSize, layout));
    }

    @Override
    void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        try {
            boolean isDataNode;
            boolean bl = isDataNode = TreeNodeUtil.layerType(cursor) == 0;
            if (isDataNode) {
                new GBPTreeStructure(null, null, this, this.layout, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            } else {
                new GBPTreeStructure(this, this.layout, null, null, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return "TreeNodeFixedSize[internal:" + this.internal + ", leaf:" + this.leaf + "]";
    }
}

