/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;

final class TreeStatePair {
    private static final int MISSING_INT = -1;
    private static final long MISSING_LONG = -1L;
    static final TreeState FIRST_TREE_STATE = new TreeState(-1L, 1L, 3L, -1L, -1L, -1L, -1L, -1L, -1, -1, false, true);

    private TreeStatePair() {
    }

    static Pair<TreeState, TreeState> readStatePages(PageCursor cursor, long pageIdA, long pageIdB) throws IOException {
        TreeState stateA = TreeStatePair.readStatePage(cursor, pageIdA);
        TreeState stateB = TreeStatePair.readStatePage(cursor, pageIdB);
        return Pair.of((Object)stateA, (Object)stateB);
    }

    private static TreeState readStatePage(PageCursor cursor, long pageIdA) throws IOException {
        TreeState state;
        PageCursorUtil.goTo((PageCursor)cursor, (String)"state page", (long)pageIdA);
        do {
            state = TreeState.read(cursor);
        } while (cursor.shouldRetry());
        PointerChecking.checkOutOfBounds(cursor);
        return state;
    }

    static TreeState selectNewestValidOrFirst(Pair<TreeState, TreeState> states) {
        if (TreeStatePair.neverCheckpointed(states)) {
            return FIRST_TREE_STATE;
        }
        return TreeStatePair.selectNewestValidState(states);
    }

    static TreeState selectNewestValidState(Pair<TreeState, TreeState> states) {
        return TreeStatePair.selectNewestValidStateOptionally(states).orElseThrow(() -> new TreeInconsistencyException("Unexpected combination of state.%n  STATE_A[%s]%n  STATE_B[%s]", states.getLeft(), states.getRight()));
    }

    static TreeState selectOldestOrInvalid(Pair<TreeState, TreeState> states) {
        TreeState newestValidState = TreeStatePair.selectNewestValidStateOptionally(states).orElse((TreeState)states.getRight());
        return newestValidState == states.getLeft() ? (TreeState)states.getRight() : (TreeState)states.getLeft();
    }

    private static Optional<TreeState> selectNewestValidStateOptionally(Pair<TreeState, TreeState> states) {
        TreeState stateA = (TreeState)states.getLeft();
        TreeState stateB = (TreeState)states.getRight();
        if (stateA.isValid() != stateB.isValid()) {
            return stateA.isValid() ? Optional.of(stateA) : Optional.of(stateB);
        }
        if (stateA.isValid() && stateB.isValid()) {
            if (stateA.stableGeneration() == stateB.stableGeneration() && stateA.unstableGeneration() == stateB.unstableGeneration() && stateA.isClean() != stateB.isClean()) {
                return Optional.of(stateA.isClean() ? stateA : stateB);
            }
            if (stateA.stableGeneration() >= stateB.stableGeneration() && stateA.unstableGeneration() > stateB.unstableGeneration()) {
                return Optional.of(stateA);
            }
            if (stateA.stableGeneration() <= stateB.stableGeneration() && stateA.unstableGeneration() < stateB.unstableGeneration()) {
                return Optional.of(stateB);
            }
        }
        return Optional.empty();
    }

    private static boolean neverCheckpointed(Pair<TreeState, TreeState> states) {
        return ((TreeState)states.getLeft()).isEmpty() && ((TreeState)states.getRight()).isEmpty();
    }
}

