/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.index.internal.gbptree.SharedNodeBehaviour;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class KeySearch {
    private KeySearch() {
    }

    static <KEY> int search(PageCursor cursor, SharedNodeBehaviour<KEY> node, KEY key, KEY readKey, int keyCount, CursorContext cursorContext) {
        int pos;
        if (keyCount == 0) {
            return -1;
        }
        Comparator<KEY> comparator = node.keyComparator();
        if (comparator.compare(key, node.keyAt(cursor, readKey, keyCount - 1, cursorContext)) > 0) {
            return -keyCount - 1;
        }
        int comparison = comparator.compare(key, node.keyAt(cursor, readKey, 0, cursorContext));
        if (comparison <= 0) {
            if (comparison == 0) {
                return 0;
            }
            return -1;
        }
        int lower = 0;
        int higher = keyCount - 1;
        while (lower < higher) {
            pos = (lower + higher) / 2;
            int comparison2 = comparator.compare(key, node.keyAt(cursor, readKey, pos, cursorContext));
            if (comparison2 <= 0) {
                higher = pos;
                continue;
            }
            lower = pos + 1;
        }
        pos = lower;
        if (comparator.compare(key, node.keyAt(cursor, readKey, pos, cursorContext)) == 0) {
            return pos;
        }
        return -(pos + 1);
    }

    static int positionOf(int searchResult) {
        if (searchResult >= 0) {
            return searchResult;
        }
        return -searchResult - 1;
    }

    static int childPositionOf(int searchResult) {
        if (searchResult >= 0) {
            return searchResult + 1;
        }
        return -searchResult - 1;
    }

    static boolean isHit(int searchResult) {
        return searchResult >= 0;
    }
}

