/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public class GBPTreeBootstrapper
implements Closeable {
    private static final int MAX_PAGE_PAYLOAD = (int)ByteUnit.mebiBytes((long)4L);
    private final FileSystemAbstraction fs;
    private final JobScheduler jobScheduler;
    private final LayoutBootstrapper layoutBootstrapper;
    private final boolean readOnly;
    private final CursorContextFactory contextFactory;
    private final PageCacheTracer pageCacheTracer;
    private PageCache pageCache;

    public GBPTreeBootstrapper(FileSystemAbstraction fs, JobScheduler jobScheduler, LayoutBootstrapper layoutBootstrapper, boolean readOnly, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        this.fs = fs;
        this.jobScheduler = jobScheduler;
        this.layoutBootstrapper = layoutBootstrapper;
        this.readOnly = readOnly;
        this.contextFactory = contextFactory;
        this.pageCacheTracer = pageCacheTracer;
    }

    public Bootstrap bootstrapTree(Path file, OpenOption ... additionalOptions) {
        try {
            this.instantiatePageCache(this.fs, this.jobScheduler, 8192);
            ImmutableSet openOptions = Sets.immutable.of((Object[])additionalOptions);
            MetaVisitor<?, ?, ?> metaVisitor = this.visitMeta(file, (ImmutableSet<OpenOption>)openOptions);
            Meta meta = metaVisitor.meta;
            if (!GBPTreeBootstrapper.isReasonablePageSize(meta.getPayloadSize())) {
                throw new MetadataMismatchException("Unexpected page size " + meta.getPayloadSize());
            }
            if (meta.getPayloadSize() != this.expectedPayload(this.pageCache, (ImmutableSet<OpenOption>)openOptions)) {
                this.instantiatePageCache(this.fs, this.jobScheduler, this.pageCachePageForPayload(meta.getPayloadSize(), (ImmutableSet<OpenOption>)openOptions));
                metaVisitor = this.visitMeta(file, (ImmutableSet<OpenOption>)openOptions);
                meta = metaVisitor.meta;
            }
            StateVisitor<?, ?, ?> stateVisitor = this.visitState(file, (ImmutableSet<OpenOption>)openOptions);
            Pair<TreeState, TreeState> statePair = stateVisitor.statePair;
            TreeState state = TreeStatePair.selectNewestValidState(statePair);
            LayoutBootstrapper.Layouts layouts = this.layoutBootstrapper.bootstrap(meta);
            MultiRootGBPTree tree = new MultiRootGBPTree(this.pageCache, this.fs, file, layouts.dataLayout(), GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, RecoveryCleanupWorkCollector.ignore(), this.readOnly, (ImmutableSet<OpenOption>)openOptions, "neo4j", file.getFileName().toString(), this.contextFactory, layouts.rootLayerConfiguration(), this.pageCacheTracer, EmptyDependencyResolver.EMPTY_RESOLVER, TreeNodeLayoutFactory.getInstance(), StructureWriteLog.EMPTY);
            return new SuccessfulBootstrap(tree, layouts, state, meta);
        }
        catch (Exception e) {
            return new FailedBootstrap(e);
        }
    }

    private int pageCachePageForPayload(int payload, ImmutableSet<OpenOption> openOptions) {
        int reservedBytes = this.pageCache.pageReservedBytes(openOptions);
        return payload + reservedBytes;
    }

    private int expectedPayload(PageCache pageCache, ImmutableSet<OpenOption> openOptions) {
        int reservedBytes = pageCache.pageReservedBytes(openOptions);
        return pageCache.pageSize() - reservedBytes;
    }

    @Override
    public void close() throws IOException {
        this.closePageCache();
    }

    private MetaVisitor<?, ?, ?> visitMeta(Path file, ImmutableSet<OpenOption> openOptions) throws IOException {
        MetaVisitor metaVisitor = new MetaVisitor();
        try (CursorContext cursorContext = this.contextFactory.create("TreeBootstrap");){
            GBPTreeStructure.visitMeta(this.pageCache, file, metaVisitor, file.getFileName().toString(), cursorContext, openOptions);
        }
        return metaVisitor;
    }

    private StateVisitor<?, ?, ?> visitState(Path file, ImmutableSet<OpenOption> openOptions) throws IOException {
        StateVisitor stateVisitor = new StateVisitor();
        try (CursorContext cursorContext = this.contextFactory.create("TreeBootstrap");){
            GBPTreeStructure.visitState(this.pageCache, file, stateVisitor, file.getFileName().toString(), cursorContext, openOptions);
        }
        return stateVisitor;
    }

    private void instantiatePageCache(FileSystemAbstraction fs, JobScheduler jobScheduler, int pageSize) {
        if (this.pageCache != null && this.pageCache.pageSize() == pageSize) {
            return;
        }
        this.closePageCache();
        SingleFilePageSwapperFactory swapper = new SingleFilePageSwapperFactory(fs, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long expectedMemory = Math.max(MuninnPageCache.memoryRequiredForPages((long)100L), 3L * (long)pageSize);
        this.pageCache = new MuninnPageCache((PageSwapperFactory)swapper, jobScheduler, MuninnPageCache.config((MemoryAllocator)MemoryAllocator.createAllocator((long)expectedMemory, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).pageSize(pageSize));
    }

    private void closePageCache() {
        if (this.pageCache != null) {
            this.pageCache.close();
            this.pageCache = null;
        }
    }

    private static boolean isReasonablePageSize(int number) {
        return GBPTreeBootstrapper.isReasonableSize(number);
    }

    private static boolean isReasonableSize(int payloadSize) {
        return payloadSize <= MAX_PAGE_PAYLOAD;
    }

    private static class MetaVisitor<ROOT_KEY, KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<ROOT_KEY, KEY, VALUE> {
        private Meta meta;

        private MetaVisitor() {
        }

        @Override
        public void meta(Meta meta) {
            this.meta = meta;
        }
    }

    private static class StateVisitor<ROOT_KEY, KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<ROOT_KEY, KEY, VALUE> {
        private Pair<TreeState, TreeState> statePair;

        private StateVisitor() {
        }

        @Override
        public void treeState(Pair<TreeState, TreeState> statePair) {
            this.statePair = statePair;
        }
    }

    private record SuccessfulBootstrap(MultiRootGBPTree<?, ?, ?> tree, LayoutBootstrapper.Layouts layouts, TreeState state, Meta meta) implements Bootstrap
    {
        @Override
        public boolean isTree() {
            return true;
        }
    }

    private static class FailedBootstrap
    implements Bootstrap {
        private final Throwable cause;

        FailedBootstrap(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public boolean isTree() {
            return false;
        }

        @Override
        public MultiRootGBPTree<?, ?, ?> tree() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public LayoutBootstrapper.Layouts layouts() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public TreeState state() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public Meta meta() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }
    }

    public static interface Bootstrap {
        public boolean isTree();

        public MultiRootGBPTree<?, ?, ?> tree();

        public LayoutBootstrapper.Layouts layouts();

        public TreeState state();

        public Meta meta();
    }
}

