/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.index.internal.gbptree.LoggingStructureWriteLog;
import org.neo4j.io.fs.FileSystemAbstraction;

public interface StructureWriteLog
extends AutoCloseable {
    public static final Empty EMPTY = new Empty();

    public Session newSession();

    public void checkpoint(long var1, long var3, long var5);

    @Override
    public void close();

    public static StructureWriteLog structureWriteLog(FileSystemAbstraction fs, Path gbpTreeFile, Config config) {
        if (((Boolean)config.get(GraphDatabaseInternalSettings.gbptree_structure_log_enabled)).booleanValue()) {
            return LoggingStructureWriteLog.forGBPTree(fs, gbpTreeFile);
        }
        return EMPTY;
    }

    public static class Empty
    implements StructureWriteLog,
    Session {
        @Override
        public Session newSession() {
            return this;
        }

        @Override
        public void split(long generation, long parentId, long childId, long createdChildId) {
        }

        @Override
        public void merge(long generation, long parentId, long childId, long deletedChildId) {
        }

        @Override
        public void createSuccessor(long generation, long parentId, long oldId, long newId) {
        }

        @Override
        public void addToFreelist(long generation, long id) {
        }

        @Override
        public void growTree(long generation, long createdRootId) {
        }

        @Override
        public void shrinkTree(long generation, long deletedRootId) {
        }

        @Override
        public void checkpoint(long previousStableGeneration, long newStableGeneration, long newUnstableGeneration) {
        }

        @Override
        public void close() {
        }
    }

    public static interface Session {
        public void split(long var1, long var3, long var5, long var7);

        public void merge(long var1, long var3, long var5, long var7);

        public void createSuccessor(long var1, long var3, long var5, long var7);

        public void addToFreelist(long var1, long var3);

        public void growTree(long var1, long var3);

        public void shrinkTree(long var1, long var3);
    }
}

