/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;

class FreelistNode {
    private static final int PAGE_ID_SIZE = 6;
    private static final int BYTE_POS_NEXT = 1;
    private static final int HEADER_LENGTH = 7;
    private static final int ENTRY_SIZE = 10;
    static final long NO_PAGE_ID = 0L;
    private final int maxEntries;

    FreelistNode(int payloadSize) {
        this.maxEntries = (payloadSize - 7) / 10;
    }

    static void initialize(PageCursor cursor) {
        cursor.putByte(0, (byte)2);
    }

    void write(PageCursor cursor, long unstableGeneration, long pageId, int pos) {
        if (pageId == 0L) {
            throw new IllegalArgumentException("Tried to write pageId " + pageId + " which means null");
        }
        this.assertPos(pos);
        GenerationSafePointer.assertGenerationOnWrite(unstableGeneration);
        cursor.setOffset(FreelistNode.entryOffset(pos));
        cursor.putInt((int)unstableGeneration);
        PageCursorUtil.put6BLong((PageCursor)cursor, (long)pageId);
    }

    private void assertPos(int pos) {
        if (pos >= this.maxEntries) {
            throw new IllegalArgumentException("Pos " + pos + " too big, max entries " + this.maxEntries);
        }
        if (pos < 0) {
            throw new IllegalArgumentException("Negative pos " + pos);
        }
    }

    long read(PageCursor cursor, long stableGeneration, int pos) {
        return this.read(cursor, stableGeneration, pos, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    long read(PageCursor cursor, long stableGeneration, int pos, GBPTreeGenerationTarget target) {
        this.assertPos(pos);
        cursor.setOffset(FreelistNode.entryOffset(pos));
        long generation = PageCursorUtil.getUnsignedInt((PageCursor)cursor);
        target.accept(generation);
        return generation <= stableGeneration ? PageCursorUtil.get6BLong((PageCursor)cursor) : 0L;
    }

    private static int entryOffset(int pos) {
        return 7 + pos * 10;
    }

    int maxEntries() {
        return this.maxEntries;
    }

    static void setNext(PageCursor cursor, long nextFreelistPage) {
        cursor.setOffset(1);
        PageCursorUtil.put6BLong((PageCursor)cursor, (long)nextFreelistPage);
    }

    static long next(PageCursor cursor) {
        cursor.setOffset(1);
        return PageCursorUtil.get6BLong((PageCursor)cursor);
    }
}

