/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.OptionalInt;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.InternalTreeLogic;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.ValueAggregator;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

class GBPTreeWriter<K, V>
implements Writer<K, V> {
    private final InternalTreeLogic<K, V> treeLogic;
    private final ReadWriteLock checkpointLock;
    private final ReadWriteLock writerLock;
    private final FreeListIdProvider freeList;
    private final MultiRootGBPTree.Monitor monitor;
    private final Consumer<Throwable> exceptionMessageAppender;
    private final LongSupplier generationSupplier;
    private final BooleanSupplier mustEagerlyFlushSupplier;
    private final StructureWriteLog.Session structureWriteLog;
    private final StructurePropagation<K> structurePropagation;
    private final PagedFile pagedFile;
    private final TreeWriterCoordination coordination;
    private final LeafNodeBehaviour<K, V> leafNode;
    private final InternalNodeBehaviour<K> internalNode;
    private final boolean parallel;
    private final TreeRootExchange rootExchange;
    private final Layout<K, V> layout;
    private boolean writerLockAcquired;
    private PageCursor cursor;
    private CursorContext cursorContext;
    private double ratioToKeepInLeftOnSplit;
    private Root root;
    private long stableGeneration;
    private long unstableGeneration;

    GBPTreeWriter(Layout<K, V> layout, PagedFile pagedFile, TreeWriterCoordination coordination, InternalTreeLogic<K, V> treeLogic, LeafNodeBehaviour<K, V> leafNode, InternalNodeBehaviour<K> internalNode, boolean parallel, TreeRootExchange rootExchange, ReadWriteLock checkpointLock, ReadWriteLock writerLock, FreeListIdProvider freeList, MultiRootGBPTree.Monitor monitor, Consumer<Throwable> exceptionMessageAppender, LongSupplier generationSupplier, BooleanSupplier mustEagerlyFlushSupplier, StructureWriteLog.Session structureWriteLog) {
        this.layout = layout;
        this.pagedFile = pagedFile;
        this.coordination = coordination;
        this.leafNode = leafNode;
        this.internalNode = internalNode;
        this.parallel = parallel;
        this.rootExchange = rootExchange;
        this.structurePropagation = new StructurePropagation(layout.newKey(), layout.newKey(), layout.newKey());
        this.treeLogic = treeLogic;
        this.checkpointLock = checkpointLock;
        this.writerLock = writerLock;
        this.freeList = freeList;
        this.monitor = monitor;
        this.exceptionMessageAppender = exceptionMessageAppender;
        this.generationSupplier = generationSupplier;
        this.mustEagerlyFlushSupplier = mustEagerlyFlushSupplier;
        this.structureWriteLog = structureWriteLog;
    }

    void initialize(double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        if (this.writerLockAcquired) {
            throw this.appendTreeInformation(new IllegalStateException(String.format("This writer has already been initialized %s", this)));
        }
        this.acquireLockForWriter();
        boolean success = false;
        try {
            this.writerLockAcquired = true;
            this.cursor = this.pagedFile.io(0L, this.writeCursorFlags(), cursorContext);
            this.coordination.initialize(this.cursor);
            this.cursorContext = cursorContext;
            long generation = this.generationSupplier.getAsLong();
            this.stableGeneration = Generation.stableGeneration(generation);
            this.unstableGeneration = Generation.unstableGeneration(generation);
            this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
            this.root = this.rootExchange.getRoot(cursorContext);
            success = true;
        }
        catch (Throwable e) {
            this.exceptionMessageAppender.accept(e);
            throw e;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private int writeCursorFlags() {
        int flags = 2;
        if (this.mustEagerlyFlushSupplier.getAsBoolean()) {
            flags |= 0x40;
        }
        return flags;
    }

    private void acquireLockForWriter() {
        this.checkpointLock.readLock().lock();
        try {
            if (this.parallel) {
                if (!this.writerLock.readLock().tryLock()) {
                    throw this.appendTreeInformation(new IllegalStateException("Single writer from GBPTree#writer() is active and cannot co-exist with parallel writers"));
                }
            } else if (!this.writerLock.writeLock().tryLock()) {
                throw this.appendTreeInformation(new IllegalStateException("Single writer from GBPTree#writer() is already acquired by someone else or one or more parallel writers are active"));
            }
        }
        catch (Throwable t) {
            this.checkpointLock.readLock().unlock();
            throw t;
        }
    }

    private <T extends Exception> T appendTreeInformation(T exception) {
        this.exceptionMessageAppender.accept(exception);
        return exception;
    }

    @Override
    public void put(K key, V value) {
        this.merge(key, value, ValueMergers.overwrite());
    }

    @Override
    public void merge(K key, V value, ValueMerger<K, V> valueMerger) {
        this.internalMerge(key, value, valueMerger, true);
    }

    @Override
    public void mergeIfExists(K key, V value, ValueMerger<K, V> valueMerger) {
        this.internalMerge(key, value, valueMerger, false);
    }

    private void internalMerge(K key, V value, ValueMerger<K, V> valueMerger, boolean createIfNotExists) {
        try {
            this.coordination.beginOperation();
            if (!this.goToRoot() || !this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, createIfNotExists, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                this.coordination.flipToPessimisticMode();
                valueMerger.reset();
                assert (this.structurePropagation.isEmpty());
                this.treeLogic.reset();
                if (!this.goToRoot() || !this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, createIfNotExists, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to insert key:%s value:%s in pessimistic mode", key, value));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            this.exceptionMessageAppender.accept(t);
            throw t;
        }
        finally {
            this.checkForceReset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
    }

    private boolean goToRoot() throws IOException {
        if (this.treeLogic.depth() >= 0) {
            return true;
        }
        while (true) {
            this.coordination.beforeTraversingToChild(this.root.id(), 0);
            Root rootAfterLock = this.rootExchange.getRoot(this.cursorContext);
            if (rootAfterLock.equals(this.root)) break;
            this.coordination.reset();
            this.root = rootAfterLock;
        }
        TreeNodeUtil.goTo(this.cursor, "Root", this.root.id());
        assert (PointerChecking.assertNoSuccessor(this.cursor, this.stableGeneration, this.unstableGeneration));
        this.treeLogic.initialize(this.cursor, this.ratioToKeepInLeftOnSplit, this.structureWriteLog);
        int keyCount = TreeNodeUtil.keyCount(this.cursor);
        boolean isInternal = TreeNodeUtil.isInternal(this.cursor);
        return this.coordination.arrivedAtChild(isInternal, (isInternal ? this.internalNode : this.leafNode).availableSpace(this.cursor, keyCount), TreeNodeUtil.generation(this.cursor) != this.unstableGeneration, keyCount);
    }

    private void setRoot(long rootPointer) throws IOException {
        long rootId = GenerationSafePointerPair.pointer(rootPointer);
        this.rootExchange.setRoot(new Root(rootId, this.unstableGeneration), this.cursorContext);
    }

    @Override
    public V remove(K key) {
        InternalTreeLogic.RemoveResult result;
        ValueHolder<V> removedValue = new ValueHolder<V>(this.layout.newValue());
        try {
            this.coordination.beginOperation();
            if (!this.goToRoot() || (result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, removedValue, this.stableGeneration, this.unstableGeneration, this.cursorContext)) == InternalTreeLogic.RemoveResult.FAIL) {
                this.coordination.flipToPessimisticMode();
                assert (this.structurePropagation.isEmpty());
                this.treeLogic.reset();
                if (!this.goToRoot() || (result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, removedValue, this.stableGeneration, this.unstableGeneration, this.cursorContext)) == InternalTreeLogic.RemoveResult.FAIL) {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to remove key:%s in pessimistic mode", key));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable e) {
            this.exceptionMessageAppender.accept(e);
            throw e;
        }
        finally {
            this.checkForceReset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
        return result == InternalTreeLogic.RemoveResult.REMOVED && removedValue.defined ? (V)removedValue.value : null;
    }

    @Override
    public int aggregate(K fromInclusive, K toExclusive, ValueAggregator<V> aggregator) {
        OptionalInt result;
        try {
            this.coordination.beginOperation();
            if (!this.goToRoot() || (result = this.treeLogic.aggregate(this.cursor, this.structurePropagation, fromInclusive, toExclusive, aggregator, this.stableGeneration, this.unstableGeneration, this.cursorContext)).isEmpty()) {
                this.coordination.flipToPessimisticMode();
                assert (this.structurePropagation.isEmpty());
                this.treeLogic.reset();
                if (!this.goToRoot() || (result = this.treeLogic.aggregate(this.cursor, this.structurePropagation, fromInclusive, toExclusive, aggregator, this.stableGeneration, this.unstableGeneration, this.cursorContext)).isEmpty()) {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to aggregate keys from:%s to:%s in pessimistic mode", fromInclusive, toExclusive));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            this.exceptionMessageAppender.accept(t);
            throw t;
        }
        finally {
            this.checkForceReset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
        return result.orElse(0);
    }

    @Override
    public void updateCeilingValue(K searchKey, K upperBound, Function<V, V> updateFunction) {
        try {
            this.coordination.beginOperation();
            if (!this.goToRoot() || !this.treeLogic.updateCeilingValue(this.cursor, this.structurePropagation, searchKey, upperBound, updateFunction, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                this.coordination.flipToPessimisticMode();
                assert (this.structurePropagation.isEmpty());
                this.treeLogic.reset();
                if (!this.goToRoot() || !this.treeLogic.updateCeilingValue(this.cursor, this.structurePropagation, searchKey, upperBound, updateFunction, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to bla blah key:%s value:%s in pessimistic mode", searchKey, upperBound));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            this.exceptionMessageAppender.accept(t);
            throw t;
        }
        finally {
            this.checkForceReset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
    }

    private void checkForceReset() {
        if (this.coordination.checkForceReset()) {
            this.treeLogic.reset();
            this.coordination.reset();
        }
    }

    private void handleStructureChanges(CursorContext cursorContext) throws IOException {
        boolean didRootStructureChange = false;
        if (this.structurePropagation.hasRightKeyInsert) {
            long newRootId = this.freeList.acquireNewId(this.stableGeneration, this.unstableGeneration, CursorCreator.bind(this.cursor));
            PageCursorUtil.goTo((PageCursor)this.cursor, (String)"new root", (long)newRootId);
            this.structureWriteLog.growTree(this.unstableGeneration, newRootId);
            this.internalNode.initialize(this.cursor, this.treeLogic.layerType, this.stableGeneration, this.unstableGeneration);
            this.internalNode.setChildAt(this.cursor, this.structurePropagation.midChild, 0, this.stableGeneration, this.unstableGeneration);
            this.internalNode.insertKeyAndRightChildAt(this.cursor, this.structurePropagation.rightKey, this.structurePropagation.rightChild, 0, 0, this.stableGeneration, this.unstableGeneration, cursorContext);
            TreeNodeUtil.setKeyCount(this.cursor, 1);
            this.setRoot(newRootId);
            this.monitor.treeGrowth();
            didRootStructureChange = true;
        } else if (this.structurePropagation.hasMidChildUpdate) {
            this.setRoot(this.structurePropagation.midChild);
            didRootStructureChange = true;
        }
        this.structurePropagation.clear();
        if (didRootStructureChange) {
            this.coordination.reset();
            this.treeLogic.reset();
        }
    }

    @Override
    public void close() {
        if (!this.writerLockAcquired) {
            throw this.appendTreeInformation(new IllegalStateException(String.format("Tried to close writer, but writer is already closed. %s", this)));
        }
        this.closeCursor();
        this.coordination.close();
        this.treeLogic.reset();
        if (this.parallel) {
            this.writerLock.readLock().unlock();
        } else {
            this.writerLock.writeLock().unlock();
        }
        this.checkpointLock.readLock().unlock();
        this.writerLockAcquired = false;
    }

    private void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public String toString() {
        return this.coordination.toString();
    }
}

