/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.OptionalInt;
import java.util.function.Function;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.Overflow;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.ValueAggregator;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class InternalTreeLogic<KEY, VALUE> {
    static final double DEFAULT_SPLIT_RATIO = 0.5;
    private final IdProvider idProvider;
    private final LeafNodeBehaviour<KEY, VALUE> leafNode;
    private final InternalNodeBehaviour<KEY> internalNode;
    private final Layout<KEY, VALUE> layout;
    private final KEY newKeyPlaceHolder;
    private final KEY readKey;
    private final ValueHolder<VALUE> readValue;
    private final MultiRootGBPTree.Monitor monitor;
    private final TreeWriterCoordination coordination;
    final byte layerType;
    private StructureWriteLog.Session structureWriteLog;
    private Level<KEY>[] levels;
    private int currentLevel = -1;
    private double ratioToKeepInLeftOnSplit;

    InternalTreeLogic(IdProvider idProvider, LeafNodeBehaviour<KEY, VALUE> leafNode, InternalNodeBehaviour<KEY> internalNode, Layout<KEY, VALUE> layout, MultiRootGBPTree.Monitor monitor, TreeWriterCoordination coordination, byte layerType) {
        this.idProvider = idProvider;
        this.leafNode = leafNode;
        this.internalNode = internalNode;
        this.layout = layout;
        this.newKeyPlaceHolder = layout.newKey();
        this.readKey = layout.newKey();
        this.readValue = new ValueHolder<VALUE>(layout.newValue());
        this.monitor = monitor;
        this.coordination = coordination;
        this.layerType = layerType;
        this.levels = new Level[10];
        this.levels[0] = new Level<KEY>(layout);
    }

    protected void initialize(PageCursor cursorAtRoot, double ratioToKeepInLeftOnSplit, StructureWriteLog.Session structureWriteLog) {
        this.currentLevel = 0;
        Level<KEY> level = this.levels[this.currentLevel];
        level.treeNodeId = cursorAtRoot.getCurrentPageId();
        level.lowerIsOpenEnded = true;
        level.upperIsOpenEnded = true;
        this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
        this.structureWriteLog = structureWriteLog;
    }

    void reset() {
        this.currentLevel = -1;
    }

    int depth() {
        return this.currentLevel;
    }

    private Level<KEY> descendToLevel(int currentLevel) {
        Level<KEY> level;
        if (currentLevel >= this.levels.length) {
            this.levels = Arrays.copyOf(this.levels, currentLevel + 1);
        }
        if ((level = this.levels[currentLevel]) == null) {
            level = this.levels[currentLevel] = new Level<KEY>(this.layout);
        }
        return level;
    }

    private boolean popLevel(PageCursor cursor) throws IOException {
        --this.currentLevel;
        if (this.currentLevel >= 0) {
            this.coordination.up();
            Level<KEY> level = this.levels[this.currentLevel];
            TreeNodeUtil.goTo(cursor, "parent", level.treeNodeId);
            return true;
        }
        return false;
    }

    private boolean moveToCorrectLeaf(PageCursor cursor, KEY key, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int previousLevel = this.currentLevel;
        while (!this.levels[this.currentLevel].covers(key)) {
            --this.currentLevel;
            this.coordination.up();
        }
        if (this.currentLevel != previousLevel) {
            TreeNodeUtil.goTo(cursor, "parent", this.levels[this.currentLevel].treeNodeId);
        }
        boolean isInternal = TreeNodeUtil.isInternal(cursor);
        while (isInternal) {
            this.ensureNodeIsTreeNode(cursor, key);
            int keyCount = TreeNodeUtil.keyCount(cursor);
            int searchResult = KeySearch.search(cursor, this.internalNode, key, this.readKey, keyCount, cursorContext);
            int childPos = KeySearch.childPositionOf(searchResult);
            Level<KEY> parentLevel = this.levels[this.currentLevel];
            ++this.currentLevel;
            Level<KEY> level = this.descendToLevel(this.currentLevel);
            level.childPos = childPos;
            boolean bl = level.lowerIsOpenEnded = childPos == 0 && !TreeNodeUtil.isNode(TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.lowerIsOpenEnded) {
                if (childPos == 0) {
                    this.layout.copyKey(parentLevel.lower, level.lower);
                    level.lowerIsOpenEnded = parentLevel.lowerIsOpenEnded;
                } else {
                    this.internalNode.keyAt(cursor, level.lower, childPos - 1, cursorContext);
                }
            }
            boolean bl2 = level.upperIsOpenEnded = childPos >= keyCount && !TreeNodeUtil.isNode(TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.upperIsOpenEnded) {
                if (childPos == keyCount) {
                    this.layout.copyKey(parentLevel.upper, level.upper);
                    level.upperIsOpenEnded = parentLevel.upperIsOpenEnded;
                } else {
                    this.internalNode.keyAt(cursor, level.upper, childPos, cursorContext);
                }
            }
            long childId = this.internalNode.childAt(cursor, childPos, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(childId, cursor, childPos, this.internalNode, stableGeneration, unstableGeneration);
            this.coordination.beforeTraversingToChild(GenerationSafePointerPair.pointer(childId), childPos);
            TreeNodeUtil.goTo(cursor, "child", childId);
            level.treeNodeId = cursor.getCurrentPageId();
            int childKeyCount = TreeNodeUtil.keyCount(cursor);
            isInternal = TreeNodeUtil.isInternal(cursor);
            if (!this.coordination.arrivedAtChild(isInternal, (isInternal ? this.internalNode : this.leafNode).availableSpace(cursor, childKeyCount), TreeNodeUtil.generation(cursor) != unstableGeneration, childKeyCount)) {
                return false;
            }
            assert (PointerChecking.assertNoSuccessor(cursor, stableGeneration, unstableGeneration));
        }
        this.ensureNodeIsTreeNode(cursor, key);
        this.ensureTreeNodeIsLeaf(cursor, key);
        return true;
    }

    private void ensureNodeIsTreeNode(PageCursor cursor, KEY key) {
        if (TreeNodeUtil.nodeType(cursor) != 1) {
            throw new TreeInconsistencyException("Index update aborted due to finding tree node that doesn't have correct type (pageId: %d, type: %d), when moving cursor towards " + key + ". This is most likely caused by an inconsistency in the index. ", cursor.getCurrentPageId(), TreeNodeUtil.nodeType(cursor));
        }
    }

    private void ensureTreeNodeIsLeaf(PageCursor cursor, KEY key) {
        if (!TreeNodeUtil.isLeaf(cursor)) {
            throw new TreeInconsistencyException("Index update aborted due to ending up on a tree node which isn't a leaf after moving cursor towards " + key + ", cursor is at pageId " + cursor.getCurrentPageId() + ". This is most likely caused by an inconsistency in the index.", new Object[0]);
        }
    }

    boolean insert(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.leafNode.validateKeyValueSize(key, value);
        if (!this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration, cursorContext)) {
            return false;
        }
        boolean insertSuccess = this.insertInLeaf(cursor, structurePropagation, key, value, valueMerger, createIfNotExists, stableGeneration, unstableGeneration, cursorContext);
        this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
        return insertSuccess;
    }

    private boolean cursorIsAtExpectedLocation(PageCursor cursor) {
        assert (this.currentLevel >= 0) : "Uninitialized tree logic, currentLevel:" + this.currentLevel;
        long currentPageId = cursor.getCurrentPageId();
        long expectedPageId = this.levels[this.currentLevel].treeNodeId;
        assert (currentPageId == expectedPageId) : "Expected cursor to be at page:" + expectedPageId + " at level:" + this.currentLevel + ", but was at page:" + currentPageId;
        return true;
    }

    private void insertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        this.doInsertInInternal(cursor, structurePropagation, keyCount, primKey, rightChild, stableGeneration, unstableGeneration, cursorContext);
    }

    private void doInsertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        Overflow overflow = this.internalNode.overflow(cursor, keyCount, primKey);
        if (overflow == Overflow.YES) {
            this.layout.copyKey(primKey, this.newKeyPlaceHolder);
            this.splitInternal(cursor, structurePropagation, this.newKeyPlaceHolder, rightChild, keyCount, stableGeneration, unstableGeneration, cursorContext);
            return;
        }
        if (overflow == Overflow.NO_NEED_DEFRAG) {
            this.internalNode.defragment(cursor, keyCount);
        }
        int pos = KeySearch.positionOf(KeySearch.search(cursor, this.internalNode, primKey, this.readKey, keyCount, cursorContext));
        this.internalNode.insertKeyAndRightChildAt(cursor, primKey, rightChild, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNodeUtil.setKeyCount(cursor, keyCount + 1);
    }

    private void splitInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, long newRightChild, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        long current = cursor.getCurrentPageId();
        this.coordination.beforeSplitInternal(current);
        long oldRight = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(oldRight, true, cursor, stableGeneration, unstableGeneration);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        int pos = KeySearch.positionOf(KeySearch.search(cursor, this.internalNode, newKey, this.readKey, keyCount, cursorContext));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        this.structureWriteLog.split(unstableGeneration, this.currentLevel > 0 ? this.levels[this.currentLevel - 1].treeNodeId : -1L, cursor.getCurrentPageId(), newRight);
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNodeUtil.goTo(rightCursor, "new right sibling in split", newRight);
            this.internalNode.initialize(rightCursor, this.layerType, stableGeneration, unstableGeneration);
            TreeNodeUtil.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNodeUtil.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.internalNode.doSplit(cursor, keyCount, rightCursor, pos, newKey, newRightChild, stableGeneration, unstableGeneration, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit, cursorContext);
        }
        if (TreeNodeUtil.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNodeUtil.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNodeUtil.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNodeUtil.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private boolean insertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int search = KeySearch.search(cursor, this.leafNode, key, this.readKey, keyCount, cursorContext);
        int pos = KeySearch.positionOf(search);
        if (KeySearch.isHit(search)) {
            return this.mergeValue(cursor, structurePropagation, key, value, valueMerger, pos, keyCount, stableGeneration, unstableGeneration, cursorContext, createIfNotExists);
        }
        if (createIfNotExists) {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            return this.doInsertInLeaf(cursor, structurePropagation, key, value, pos, keyCount, stableGeneration, unstableGeneration, cursorContext) != InsertResult.SPLIT_FAIL;
        }
        return true;
    }

    private boolean mergeValue(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext, boolean createIfNotExists) throws IOException {
        this.leafNode.valueAt(cursor, this.readValue, pos, cursorContext);
        int totalSpaceBefore = this.leafNode.totalSpaceOfKeyValue(key, this.readValue.value);
        ValueMerger.MergeResult mergeResult = ValueMerger.MergeResult.REPLACED;
        if (this.readValue.defined ? (mergeResult = valueMerger.merge(this.readKey, key, this.readValue.value, value)) == ValueMerger.MergeResult.UNCHANGED : !createIfNotExists) {
            return true;
        }
        int totalSpaceAfter = switch (mergeResult) {
            case ValueMerger.MergeResult.MERGED -> this.leafNode.totalSpaceOfKeyValue(key, this.readValue.value);
            case ValueMerger.MergeResult.REPLACED -> this.leafNode.totalSpaceOfKeyValue(key, value);
            default -> 0;
        };
        int valueShrinkSize = totalSpaceBefore - totalSpaceAfter;
        if (!this.coordination.beforeRemovalFromLeaf(valueShrinkSize)) {
            return false;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        if (mergeResult == ValueMerger.MergeResult.REPLACED || mergeResult == ValueMerger.MergeResult.MERGED) {
            VALUE mergedValue = mergeResult == ValueMerger.MergeResult.REPLACED ? value : this.readValue.value;
            return this.setValueAtWithFallback(cursor, pos, key, mergedValue, keyCount, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
        }
        if (mergeResult == ValueMerger.MergeResult.REMOVED) {
            int newKeyCount = this.leafNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
            TreeNodeUtil.setKeyCount(cursor, newKeyCount);
            this.coordination.updateChildInformation(this.leafNode.availableSpace(cursor, newKeyCount), newKeyCount);
            if (this.leafNode.underflow(cursor, newKeyCount)) {
                this.underflowInLeaf(cursor, structurePropagation, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
            }
        } else {
            throw new UnsupportedOperationException("Unexpected merge result " + mergeResult);
        }
        return true;
    }

    private boolean setValueAtWithFallback(PageCursor cursor, int pos, KEY key, VALUE value, int keyCount, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        if (this.leafNode.setValueAt(cursor, value, pos, cursorContext, stableGeneration, unstableGeneration)) {
            return true;
        }
        int newKeyCount = this.leafNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNodeUtil.setKeyCount(cursor, newKeyCount);
        InsertResult result = this.doInsertInLeaf(cursor, structurePropagation, key, value, pos, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
        if (result == InsertResult.SPLIT_FAIL) {
            return false;
        }
        if (result == InsertResult.NO_SPLIT && this.leafNode.underflow(cursor, newKeyCount + 1)) {
            this.underflowInLeaf(cursor, structurePropagation, newKeyCount + 1, stableGeneration, unstableGeneration, cursorContext);
        }
        return true;
    }

    private InsertResult doInsertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCountAfterDeframent;
        Overflow overflow = this.leafNode.overflow(cursor, keyCount, key, value, cursorContext);
        if (overflow == Overflow.YES) {
            if (!this.splitLeaf(cursor, structurePropagation, key, value, keyCount, stableGeneration, unstableGeneration, cursorContext)) {
                return InsertResult.SPLIT_FAIL;
            }
            return InsertResult.SPLIT;
        }
        if (overflow == Overflow.NO_NEED_DEFRAG && (keyCountAfterDeframent = this.leafNode.defragment(cursor, keyCount, cursorContext)) != keyCount) {
            keyCount = keyCountAfterDeframent;
            pos = KeySearch.positionOf(KeySearch.search(cursor, this.leafNode, key, this.readKey, keyCount, cursorContext));
        }
        this.leafNode.insertKeyValueAt(cursor, key, value, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        int newKeyCount = keyCount + 1;
        TreeNodeUtil.setKeyCount(cursor, newKeyCount);
        this.coordination.updateChildInformation(this.leafNode.availableSpace(cursor, newKeyCount), newKeyCount);
        return InsertResult.NO_SPLIT;
    }

    private boolean splitLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, VALUE newValue, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int pos = KeySearch.positionOf(KeySearch.search(cursor, this.leafNode, newKey, this.readKey, keyCount, cursorContext));
        int middlePos = this.leafNode.findSplitter(cursor, keyCount, newKey, newValue, pos, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit, cursorContext);
        if (!this.coordination.beforeSplittingLeaf(this.internalNode.totalSpaceOfKeyChild(structurePropagation.rightKey))) {
            return false;
        }
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(oldRight, true, cursor, stableGeneration, unstableGeneration);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        this.structureWriteLog.split(unstableGeneration, this.currentLevel > 0 ? this.levels[this.currentLevel - 1].treeNodeId : -1L, cursor.getCurrentPageId(), newRight);
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNodeUtil.goTo(rightCursor, "new right sibling in split", newRight);
            this.leafNode.initialize(rightCursor, this.layerType, stableGeneration, unstableGeneration);
            TreeNodeUtil.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNodeUtil.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.leafNode.doSplit(cursor, keyCount, rightCursor, pos, newKey, newValue, structurePropagation.rightKey, middlePos, this.ratioToKeepInLeftOnSplit, stableGeneration, unstableGeneration, cursorContext);
        }
        if (TreeNodeUtil.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNodeUtil.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNodeUtil.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNodeUtil.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
        return true;
    }

    RemoveResult remove(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, ValueHolder<VALUE> into, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        if (!this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration, cursorContext)) {
            return RemoveResult.FAIL;
        }
        RemoveResult result = this.removeFromLeaf(cursor, structurePropagation, key, into, stableGeneration, unstableGeneration, cursorContext);
        if (result == RemoveResult.REMOVED) {
            this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
            if (this.currentLevel <= 0) {
                this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
            }
        }
        return result;
    }

    private void handleStructureChanges(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        while (structurePropagation.hasLeftChildUpdate || structurePropagation.hasMidChildUpdate || structurePropagation.hasRightChildUpdate || structurePropagation.hasLeftKeyReplace || structurePropagation.hasRightKeyReplace || structurePropagation.hasRightKeyInsert) {
            int pos = this.levels[this.currentLevel].childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasLeftChildUpdate) {
                structurePropagation.hasLeftChildUpdate = false;
                if (pos == 0) {
                    this.updateRightmostChildInLeftSibling(cursor, structurePropagation.leftChild, stableGeneration, unstableGeneration);
                } else {
                    this.internalNode.setChildAt(cursor, structurePropagation.leftChild, pos - 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
            }
            if (structurePropagation.hasRightChildUpdate) {
                structurePropagation.hasRightChildUpdate = false;
                int keyCount = TreeNodeUtil.keyCount(cursor);
                if (pos == keyCount) {
                    this.updateLeftmostChildInRightSibling(cursor, structurePropagation.rightChild, stableGeneration, unstableGeneration);
                } else {
                    this.internalNode.setChildAt(cursor, structurePropagation.rightChild, pos + 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasRightKeyInsert) {
                structurePropagation.hasRightKeyInsert = false;
                this.insertInInternal(cursor, structurePropagation, TreeNodeUtil.keyCount(cursor), structurePropagation.rightKey, structurePropagation.rightChild, stableGeneration, unstableGeneration, cursorContext);
            }
            if (structurePropagation.hasLeftKeyReplace && this.levels[this.currentLevel].covers(structurePropagation.leftKey)) {
                assert (pos > 0) : "attempt to replace key left to the leftmost key";
                structurePropagation.hasLeftKeyReplace = false;
                switch (structurePropagation.keyReplaceStrategy) {
                    case REPLACE: {
                        this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.leftKey, pos - 1, stableGeneration, unstableGeneration, cursorContext);
                        break;
                    }
                    case BUBBLE: {
                        this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos - 1, stableGeneration, unstableGeneration, cursorContext);
                    }
                }
            }
            if (structurePropagation.hasRightKeyReplace && this.levels[this.currentLevel].covers(structurePropagation.rightKey)) {
                structurePropagation.hasRightKeyReplace = false;
                switch (structurePropagation.keyReplaceStrategy) {
                    case REPLACE: {
                        this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.rightKey, pos, stableGeneration, unstableGeneration, cursorContext);
                        break;
                    }
                    case BUBBLE: {
                        this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos, stableGeneration, unstableGeneration, cursorContext);
                    }
                }
            }
            int keyCountAfterUpdate = TreeNodeUtil.keyCount(cursor);
            this.coordination.updateChildInformation(this.internalNode.availableSpace(cursor, keyCountAfterUpdate), keyCountAfterUpdate);
        }
    }

    private void overwriteKeyInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, int pos, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        int keyCount = TreeNodeUtil.keyCount(cursor);
        boolean couldOverwrite = this.internalNode.setKeyAt(cursor, newKey, pos);
        if (!couldOverwrite) {
            long rightChild = this.internalNode.childAt(cursor, pos + 1, stableGeneration, unstableGeneration);
            this.internalNode.removeKeyAndRightChildAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
            TreeNodeUtil.setKeyCount(cursor, keyCount - 1);
            this.doInsertInInternal(cursor, structurePropagation, keyCount - 1, newKey, rightChild, stableGeneration, unstableGeneration, cursorContext);
        }
    }

    private void tryShrinkTree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        int rootKeyCount = TreeNodeUtil.keyCount(cursor);
        while (rootKeyCount == 0 && TreeNodeUtil.isInternal(cursor)) {
            long oldRoot = cursor.getCurrentPageId();
            long onlyChildOfRoot = this.internalNode.childAt(cursor, 0, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(onlyChildOfRoot, cursor, 0, this.internalNode, stableGeneration, unstableGeneration);
            structurePropagation.hasMidChildUpdate = true;
            structurePropagation.midChild = onlyChildOfRoot;
            this.structureWriteLog.shrinkTree(unstableGeneration, oldRoot);
            this.structureWriteLog.addToFreelist(unstableGeneration, oldRoot);
            this.idProvider.releaseId(stableGeneration, unstableGeneration, oldRoot, CursorCreator.bind(cursor));
            TreeNodeUtil.goTo(cursor, "child", onlyChildOfRoot);
            rootKeyCount = TreeNodeUtil.keyCount(cursor);
            this.monitor.treeShrink();
        }
    }

    private void updateMidChild(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int childPos, long stableGeneration, long unstableGeneration) {
        structurePropagation.hasMidChildUpdate = false;
        this.internalNode.setChildAt(cursor, structurePropagation.midChild, childPos, stableGeneration, unstableGeneration);
    }

    private void replaceKeyByBubbleRightmostFromSubtree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int subtreePosition, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        long currentPageId = cursor.getCurrentPageId();
        long subtree = this.internalNode.childAt(cursor, subtreePosition, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkChildPointer(subtree, cursor, subtreePosition, this.internalNode, stableGeneration, unstableGeneration);
        TreeNodeUtil.goTo(cursor, "child", subtree);
        boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration, cursorContext);
        if (structurePropagation.hasMidChildUpdate) {
            this.updateMidChild(cursor, structurePropagation, subtreePosition, stableGeneration, unstableGeneration);
        }
        if (foundKeyBelow) {
            this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.bubbleKey, subtreePosition, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            int keyCount = TreeNodeUtil.keyCount(cursor);
            this.simplyRemoveFromInternal(cursor, keyCount, subtreePosition, true, stableGeneration, unstableGeneration, cursorContext);
            if (this.currentLevel <= 0) {
                this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bubbleRightmostKeyRecursive(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long previousNode, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        try {
            if (TreeNodeUtil.isLeaf(cursor)) {
                boolean bl = false;
                return bl;
            }
            long currentPageId = cursor.getCurrentPageId();
            int keyCount = TreeNodeUtil.keyCount(cursor);
            long rightmostSubtree = this.internalNode.childAt(cursor, keyCount, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(rightmostSubtree, cursor, keyCount, this.internalNode, stableGeneration, unstableGeneration);
            TreeNodeUtil.goTo(cursor, "child", rightmostSubtree);
            boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration, cursorContext);
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
            }
            if (foundKeyBelow) {
                boolean bl = true;
                return bl;
            }
            if (keyCount == 0) {
                InternalTreeLogic.connectLeftAndRightSibling(cursor, stableGeneration, unstableGeneration);
                this.structureWriteLog.addToFreelist(unstableGeneration, currentPageId);
                this.idProvider.releaseId(stableGeneration, unstableGeneration, currentPageId, CursorCreator.bind(cursor));
                boolean bl = false;
                return bl;
            }
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.internalNode.keyAt(cursor, structurePropagation.bubbleKey, keyCount - 1, cursorContext);
            this.simplyRemoveFromInternal(cursor, keyCount, keyCount - 1, false, stableGeneration, unstableGeneration, cursorContext);
            boolean bl = true;
            return bl;
        }
        finally {
            TreeNodeUtil.goTo(cursor, "back to previous node", previousNode);
        }
    }

    private void simplyRemoveFromInternal(PageCursor cursor, int keyCount, int keyPos, boolean leftChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        if (leftChild) {
            this.internalNode.removeKeyAndLeftChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.internalNode.removeKeyAndRightChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNodeUtil.setKeyCount(cursor, keyCount - 1);
    }

    private void updateRightmostChildInLeftSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, false, cursor, stableGeneration, unstableGeneration);
        try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(leftSibling);){
            TreeNodeUtil.goTo(leftSiblingCursor, "left sibling", leftSibling);
            int keyCount = TreeNodeUtil.keyCount(leftSiblingCursor);
            this.internalNode.setChildAt(leftSiblingCursor, childPointer, keyCount, stableGeneration, unstableGeneration);
        }
    }

    private void updateLeftmostChildInRightSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, false, cursor, stableGeneration, unstableGeneration);
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(rightSibling);){
            TreeNodeUtil.goTo(rightSiblingCursor, "right sibling", rightSibling);
            this.internalNode.setChildAt(rightSiblingCursor, childPointer, 0, stableGeneration, unstableGeneration);
        }
    }

    private RemoveResult removeFromLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, ValueHolder<VALUE> into, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int search = KeySearch.search(cursor, this.leafNode, key, this.readKey, keyCount, cursorContext);
        int pos = KeySearch.positionOf(search);
        boolean hit = KeySearch.isHit(search);
        if (!hit) {
            return RemoveResult.NOT_FOUND;
        }
        this.leafNode.valueAt(cursor, into, pos, cursorContext);
        if (!this.coordination.beforeRemovalFromLeaf(this.leafNode.totalSpaceOfKeyValue(key, into.value))) {
            return RemoveResult.FAIL;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        keyCount = this.simplyRemoveFromLeaf(cursor, keyCount, pos, stableGeneration, unstableGeneration, cursorContext);
        if (this.leafNode.underflow(cursor, keyCount)) {
            this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.coordination.updateChildInformation(this.leafNode.availableSpace(cursor, keyCount), keyCount);
        }
        return RemoveResult.REMOVED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void underflowInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.coordination.beforeUnderflowInLeaf(cursor.getCurrentPageId());
        long leftSibling = TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNodeUtil.isNode(leftSibling)) {
            try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(leftSibling));){
                leftSiblingCursor.next();
                int leftSiblingKeyCount = TreeNodeUtil.keyCount(leftSiblingCursor);
                int keysToRebalance = this.leafNode.canRebalance(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount);
                if (keysToRebalance > 0) {
                    this.createSuccessorIfNeeded(leftSiblingCursor, structurePropagation, StructurePropagation.UPDATE_LEFT_CHILD, stableGeneration, unstableGeneration);
                    this.rebalanceLeaf(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, keysToRebalance, structurePropagation, cursorContext);
                    return;
                }
                if (keysToRebalance != -1) return;
                this.mergeFromLeftSiblingLeaf(cursor, leftSiblingCursor, structurePropagation, keyCount, leftSiblingKeyCount, stableGeneration, unstableGeneration, cursorContext, CursorCreator.bind(leftSiblingCursor));
                return;
            }
        }
        if (!TreeNodeUtil.isNode(rightSibling)) return;
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(rightSibling));){
            rightSiblingCursor.next();
            int rightSiblingKeyCount = TreeNodeUtil.keyCount(rightSiblingCursor);
            if (!this.leafNode.canMerge(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount)) return;
            this.createSuccessorIfNeeded(rightSiblingCursor, structurePropagation, StructurePropagation.UPDATE_RIGHT_CHILD, stableGeneration, unstableGeneration);
            this.mergeToRightSiblingLeaf(cursor, rightSiblingCursor, structurePropagation, keyCount, rightSiblingKeyCount, stableGeneration, unstableGeneration, cursorContext, CursorCreator.bind(rightSiblingCursor));
            return;
        }
    }

    private static void connectLeftAndRightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) throws IOException {
        long currentId = cursor.getCurrentPageId();
        long leftSibling = TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNodeUtil.isNode(leftSibling)) {
            TreeNodeUtil.goTo(cursor, "left sibling", leftSibling);
            TreeNodeUtil.setRightSibling(cursor, rightSibling, stableGeneration, unstableGeneration);
        }
        if (TreeNodeUtil.isNode(rightSibling)) {
            TreeNodeUtil.goTo(cursor, "right sibling", rightSibling);
            TreeNodeUtil.setLeftSibling(cursor, leftSibling, stableGeneration, unstableGeneration);
        }
        TreeNodeUtil.goTo(cursor, "back to origin after repointing siblings", currentId);
    }

    private void mergeToRightSiblingLeaf(PageCursor cursor, PageCursor rightSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext, CursorCreator linkedCursorCreator) throws IOException {
        assert (rightSiblingKeyCount > 0) : "trying to read the last key from the empty leaf";
        this.leafNode.keyAt(rightSiblingCursor, structurePropagation.rightKey, rightSiblingKeyCount - 1, cursorContext);
        this.structureWriteLog.merge(unstableGeneration, this.levels[this.currentLevel - 1].treeNodeId, rightSiblingCursor.getCurrentPageId(), cursor.getCurrentPageId());
        this.merge(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount, stableGeneration, unstableGeneration, linkedCursorCreator, cursorContext);
        structurePropagation.hasMidChildUpdate = true;
        structurePropagation.midChild = rightSiblingCursor.getCurrentPageId();
        structurePropagation.hasRightKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void mergeFromLeftSiblingLeaf(PageCursor cursor, PageCursor leftSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int leftSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext, CursorCreator linkedCursorCreator) throws IOException {
        assert (leftSiblingKeyCount > 0) : "trying to read the first key from the empty leaf";
        this.leafNode.keyAt(leftSiblingCursor, structurePropagation.leftKey, 0, cursorContext);
        this.structureWriteLog.merge(unstableGeneration, this.levels[this.currentLevel - 1].treeNodeId, cursor.getCurrentPageId(), leftSiblingCursor.getCurrentPageId());
        this.merge(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, stableGeneration, unstableGeneration, linkedCursorCreator, cursorContext);
        structurePropagation.hasLeftChildUpdate = true;
        structurePropagation.leftChild = cursor.getCurrentPageId();
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void merge(PageCursor leftSiblingCursor, int leftSiblingKeyCount, PageCursor rightSiblingCursor, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorCreator linkedCursorCreator, CursorContext cursorContext) throws IOException {
        this.leafNode.copyKeyValuesFromLeftToRight(leftSiblingCursor, leftSiblingKeyCount, rightSiblingCursor, rightSiblingKeyCount, cursorContext);
        TreeNodeUtil.setSuccessor(leftSiblingCursor, rightSiblingCursor.getCurrentPageId(), stableGeneration, unstableGeneration);
        InternalTreeLogic.connectLeftAndRightSibling(leftSiblingCursor, stableGeneration, unstableGeneration);
        this.structureWriteLog.addToFreelist(unstableGeneration, leftSiblingCursor.getCurrentPageId());
        this.idProvider.releaseId(stableGeneration, unstableGeneration, leftSiblingCursor.getCurrentPageId(), linkedCursorCreator);
    }

    private void rebalanceLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int numberOfKeysToMove, StructurePropagation<KEY> structurePropagation, CursorContext cursorContext) throws IOException {
        this.leafNode.moveKeyValuesFromLeftToRight(leftCursor, leftKeyCount, rightCursor, rightKeyCount, leftKeyCount - numberOfKeysToMove, cursorContext);
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.REPLACE;
        this.leafNode.keyAt(rightCursor, structurePropagation.leftKey, 0, cursorContext);
    }

    private int simplyRemoveFromLeaf(PageCursor cursor, int keyCount, int pos, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyCount = this.leafNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNodeUtil.setKeyCount(cursor, newKeyCount);
        return newKeyCount;
    }

    private void createSuccessorIfNeeded(PageCursor cursor, StructurePropagation<KEY> structurePropagation, StructurePropagation.StructureUpdate structureUpdate, long stableGeneration, long unstableGeneration) throws IOException {
        long oldId = cursor.getCurrentPageId();
        long nodeGeneration = TreeNodeUtil.generation(cursor);
        if (nodeGeneration == unstableGeneration) {
            return;
        }
        long successorId = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        this.structureWriteLog.createSuccessor(unstableGeneration, this.currentLevel > 0 ? this.levels[this.currentLevel - 1].treeNodeId : -1L, cursor.getCurrentPageId(), successorId);
        try (PageCursor successorCursor = cursor.openLinkedCursor(successorId);){
            TreeNodeUtil.goTo(successorCursor, "successor", successorId);
            cursor.copyTo(0, successorCursor, 0, cursor.getPagedFile().payloadSize());
            TreeNodeUtil.setGeneration(successorCursor, unstableGeneration);
            TreeNodeUtil.setSuccessor(successorCursor, 0L, stableGeneration, unstableGeneration);
        }
        TreeNodeUtil.setSuccessor(cursor, successorId, stableGeneration, unstableGeneration);
        long leftSibling = TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNodeUtil.isNode(leftSibling)) {
            TreeNodeUtil.goTo(cursor, "left sibling in split", leftSibling);
            TreeNodeUtil.setRightSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        if (TreeNodeUtil.isNode(rightSibling)) {
            TreeNodeUtil.goTo(cursor, "right sibling in split", rightSibling);
            TreeNodeUtil.setLeftSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        TreeNodeUtil.goTo(cursor, "successor", successorId);
        structureUpdate.update(structurePropagation, successorId);
        this.structureWriteLog.addToFreelist(unstableGeneration, oldId);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, oldId, CursorCreator.bind(cursor));
    }

    OptionalInt aggregate(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY fromInclusive, KEY toExclusive, ValueAggregator<VALUE> aggregator, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        if (!this.moveToCorrectLeaf(cursor, fromInclusive, stableGeneration, unstableGeneration, cursorContext)) {
            return OptionalInt.empty();
        }
        OptionalInt result = this.aggregateInLeaf(cursor, structurePropagation, fromInclusive, toExclusive, aggregator, stableGeneration, unstableGeneration, cursorContext);
        if (result.isPresent()) {
            this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
            if (this.currentLevel <= 0) {
                this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
            }
        }
        return result;
    }

    private OptionalInt aggregateInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY fromInclusive, KEY toExclusive, ValueAggregator<VALUE> aggregator, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int itemsToAggregate;
        int fromPos;
        int pos;
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int search = KeySearch.search(cursor, this.leafNode, fromInclusive, this.readKey, keyCount, cursorContext);
        VALUE aggregatedValue = this.layout.newValue();
        Object key = this.layout.newKey();
        ValueHolder<VALUE> value = new ValueHolder<VALUE>(this.layout.newValue());
        int totalSpaceBefore = 0;
        for (pos = fromPos = KeySearch.positionOf(search); pos < keyCount; ++pos) {
            this.leafNode.keyValueAt(cursor, key, value, pos, cursorContext);
            if (this.layout.compare(key, toExclusive) >= 0) break;
            totalSpaceBefore += this.leafNode.totalSpaceOfKeyValue(key, value.value);
            aggregator.aggregate(value.value, aggregatedValue);
        }
        if ((itemsToAggregate = pos - fromPos) <= 1) {
            return OptionalInt.of(0);
        }
        int totalSpaceAfter = this.leafNode.totalSpaceOfKeyValue(this.leafNode.keyAt(cursor, key, pos - 1, cursorContext), aggregatedValue);
        int shrinkSize = totalSpaceBefore - totalSpaceAfter;
        if (!this.coordination.beforeRemovalFromLeaf(shrinkSize)) {
            return OptionalInt.empty();
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        int newKeyCount = keyCount;
        if (!this.leafNode.setValueAt(cursor, aggregatedValue, pos - 1, cursorContext, stableGeneration, unstableGeneration)) {
            newKeyCount = this.leafNode.removeKeyValues(cursor, fromPos, pos, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
            TreeNodeUtil.setKeyCount(cursor, newKeyCount);
            InsertResult result = this.doInsertInLeaf(cursor, structurePropagation, key, aggregatedValue, fromPos, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
            if (result == InsertResult.SPLIT_FAIL) {
                return OptionalInt.empty();
            }
            ++newKeyCount;
        } else {
            newKeyCount = this.leafNode.removeKeyValues(cursor, fromPos, pos - 1, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNodeUtil.setKeyCount(cursor, newKeyCount);
        if (this.leafNode.underflow(cursor, newKeyCount)) {
            this.underflowInLeaf(cursor, structurePropagation, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.coordination.updateChildInformation(this.leafNode.availableSpace(cursor, newKeyCount), newKeyCount);
        }
        return OptionalInt.of(itemsToAggregate);
    }

    boolean updateCeilingValue(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY searchKey, KEY upperBoundary, Function<VALUE, VALUE> updateFunction, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        if (!this.moveToCorrectLeaf(cursor, searchKey, stableGeneration, unstableGeneration, cursorContext)) {
            return false;
        }
        UpdateCeilingValueResult updateResult = this.updateCeilingValueInLeaf(cursor, structurePropagation, searchKey, upperBoundary, updateFunction, stableGeneration, unstableGeneration, cursorContext);
        if (updateResult == UpdateCeilingValueResult.RETRY_IN_SIBLING) {
            Object firstInRightSibling;
            int rightSiblingKeyCount;
            long rightSibling = TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration);
            if (!TreeNodeUtil.isNode(rightSibling)) {
                return true;
            }
            if (!this.coordination.beforeAccessingRightSiblingLeaf(rightSibling)) {
                return false;
            }
            try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(rightSibling);){
                TreeNodeUtil.goTo(rightSiblingCursor, "right sibling", rightSibling);
                rightSiblingKeyCount = TreeNodeUtil.keyCount(rightSiblingCursor);
                assert (rightSiblingKeyCount > 0);
                firstInRightSibling = this.leafNode.keyAt(rightSiblingCursor, this.layout.newKey(), 0, cursorContext);
            }
            if (this.leafNode.keyComparator().compare(firstInRightSibling, upperBoundary) >= 0) {
                return true;
            }
            if (!this.moveToCorrectLeaf(cursor, firstInRightSibling, stableGeneration, unstableGeneration, cursorContext)) {
                return false;
            }
            if (this.updateValueAt(cursor, 0, firstInRightSibling, updateFunction, rightSiblingKeyCount, structurePropagation, stableGeneration, unstableGeneration, cursorContext)) {
                updateResult = UpdateCeilingValueResult.SUCCESS;
            }
        }
        this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
        return updateResult == UpdateCeilingValueResult.SUCCESS;
    }

    private UpdateCeilingValueResult updateCeilingValueInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY searchKey, KEY upperBoundary, Function<VALUE, VALUE> updateFunction, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int search = KeySearch.search(cursor, this.leafNode, searchKey, this.readKey, keyCount, cursorContext);
        int pos = KeySearch.positionOf(search);
        if (pos < keyCount) {
            Object foundKey = this.leafNode.keyAt(cursor, this.layout.newKey(), pos, cursorContext);
            if (this.leafNode.keyComparator().compare(foundKey, upperBoundary) < 0) {
                return this.updateValueAt(cursor, pos, foundKey, updateFunction, keyCount, structurePropagation, stableGeneration, unstableGeneration, cursorContext) ? UpdateCeilingValueResult.SUCCESS : UpdateCeilingValueResult.FAIL;
            }
            return UpdateCeilingValueResult.SUCCESS;
        }
        return UpdateCeilingValueResult.RETRY_IN_SIBLING;
    }

    private boolean updateValueAt(PageCursor cursor, int pos, KEY key, Function<VALUE, VALUE> updateFunction, int keyCount, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        Object value = this.leafNode.valueAt((PageCursor)cursor, new ValueHolder<VALUE>(this.layout.newValue()), (int)pos, (CursorContext)cursorContext).value;
        VALUE updatedValue = updateFunction.apply(value);
        int valueShrinkSize = this.leafNode.totalSpaceOfKeyValue(key, value) - this.leafNode.totalSpaceOfKeyValue(key, updatedValue);
        if (!this.coordination.beforeRemovalFromLeaf(valueShrinkSize)) {
            return false;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        return this.setValueAtWithFallback(cursor, pos, key, updatedValue, keyCount, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
    }

    private static <KEY> void checkChildPointer(long childPointer, PageCursor cursor, int childPos, InternalNodeBehaviour<KEY> bTreeNode, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(childPointer, false, cursor.getCurrentPageId(), "CHILD", stableGeneration, unstableGeneration, cursor, bTreeNode.childOffset(childPos));
    }

    private static void checkRightSiblingPointer(long siblingPointer, boolean allowNoNode, PageCursor cursor, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(siblingPointer, allowNoNode, cursor.getCurrentPageId(), "RIGHT_SIBLING", stableGeneration, unstableGeneration, cursor, 10);
    }

    private static void checkLeftSiblingPointer(long siblingPointer, boolean allowNoNode, PageCursor cursor, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(siblingPointer, allowNoNode, cursor.getCurrentPageId(), "LEFT_SIBLING", stableGeneration, unstableGeneration, cursor, 34);
    }

    private static class Level<KEY> {
        private final Comparator<KEY> layout;
        private long treeNodeId;
        private int childPos;
        private final KEY lower;
        private boolean lowerIsOpenEnded;
        private final KEY upper;
        private boolean upperIsOpenEnded;

        Level(Layout<KEY, ?> layout) {
            this.layout = layout;
            this.lower = layout.newKey();
            this.upper = layout.newKey();
        }

        boolean covers(KEY key) {
            boolean insideLower = this.lowerIsOpenEnded || this.layout.compare(key, this.lower) >= 0;
            boolean insideHigher = this.upperIsOpenEnded || this.layout.compare(key, this.upper) < 0;
            return insideLower && insideHigher;
        }
    }

    private static enum InsertResult {
        NO_SPLIT,
        SPLIT,
        SPLIT_FAIL;

    }

    static enum RemoveResult {
        NOT_FOUND,
        REMOVED,
        FAIL;

    }

    private static enum UpdateCeilingValueResult {
        SUCCESS,
        FAIL,
        RETRY_IN_SIBLING;

    }
}

