/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.DependencyResolver;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.DataTreeAlreadyExistsException;
import org.neo4j.index.internal.gbptree.DataTreeNotEmptyException;
import org.neo4j.index.internal.gbptree.DataTreeNotFoundException;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.RootMappingLayout;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TrackingValueMerger;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeLatchService;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.Preconditions;

class MultiRootLayer<ROOT_KEY, DATA_KEY, DATA_VALUE>
extends RootLayer<ROOT_KEY, DATA_KEY, DATA_VALUE> {
    private static final int BYTE_SIZE_PER_CACHED_EXTERNAL_ROOT = 48;
    private final RootLayerSupport support;
    private final CursorContextFactory contextFactory;
    private final TreeNodeSelector treeNodeSelector;
    private final Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout;
    private final TreeNode<ROOT_KEY, RootMappingLayout.RootMappingValue> rootTreeNode;
    private final AtomicReferenceArray<DataTreeRoot<ROOT_KEY>> rootMappingCache;
    private final TreeNodeLatchService rootMappingCacheLatches = new TreeNodeLatchService();
    private final ValueMerger<ROOT_KEY, RootMappingLayout.RootMappingValue> DONT_ALLOW_CREATE_EXISTING_ROOT = (existingKey, newKey, existingValue, newValue) -> {
        throw new DataTreeAlreadyExistsException(existingKey);
    };
    private final Layout<DATA_KEY, DATA_VALUE> dataLayout;
    private final TreeNode<DATA_KEY, DATA_VALUE> dataTreeNode;
    private volatile Root root;

    MultiRootLayer(RootLayerSupport support, Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout, Layout<DATA_KEY, DATA_VALUE> dataLayout, int rootCacheSizeInBytes, CursorContextFactory contextFactory, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
        Preconditions.checkState((boolean)this.hashCodeSeemsImplemented(rootLayout), (String)"Root layout doesn't seem to have a hashCode() implementation");
        this.support = support;
        this.rootLayout = rootLayout;
        this.dataLayout = dataLayout;
        this.contextFactory = contextFactory;
        this.treeNodeSelector = treeNodeSelector;
        int numCachedRoots = rootCacheSizeInBytes / 48;
        this.rootMappingCache = new AtomicReferenceArray(Integer.max(numCachedRoots, 10));
        TreeNodeSelector.Factory rootMappingFormat = treeNodeSelector.selectByLayout(this.rootLayout);
        TreeNodeSelector.Factory format = treeNodeSelector.selectByLayout(dataLayout);
        OffloadStoreImpl<ROOT_KEY, RootMappingLayout.RootMappingValue> rootOffloadStore = support.buildOffload(this.rootLayout);
        OffloadStoreImpl<DATA_KEY, DATA_VALUE> dataOffloadStore = support.buildOffload(dataLayout);
        this.rootTreeNode = rootMappingFormat.create(support.payloadSize(), this.rootLayout, rootOffloadStore, dependencyResolver);
        this.dataTreeNode = format.create(support.payloadSize(), dataLayout, dataOffloadStore, dependencyResolver);
    }

    private boolean hashCodeSeemsImplemented(Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout) {
        Object key1 = rootLayout.newKey();
        Object key2 = rootLayout.newKey();
        rootLayout.initializeAsHighest(key1);
        rootLayout.initializeAsHighest(key2);
        return key1.hashCode() == key2.hashCode();
    }

    @Override
    public void setRoot(Root root) throws IOException {
        this.root = root;
    }

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    void initializeAfterCreation(Root firstRoot, CursorContext cursorContext) throws IOException {
        this.setRoot(firstRoot);
        this.support.writeMeta(this.rootLayout, this.dataLayout, cursorContext, this.treeNodeSelector);
        this.support.initializeNewRoot(this.root, this.rootTreeNode, (byte)1, cursorContext);
    }

    @Override
    void initialize(Root root, CursorContext cursorContext) throws IOException {
        this.setRoot(root);
        this.support.readMeta(cursorContext).verify(this.dataLayout, this.rootLayout, this.treeNodeSelector);
    }

    @Override
    void create(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        CursorCreator cursorCreator = CursorCreator.bind(this.support, 2, cursorContext);
        try (Writer<ROOT_KEY, RootMappingLayout.RootMappingValue> rootMappingWriter = this.support.internalParallelWriter(this.rootLayout, this.rootTreeNode, 0.5, cursorContext, this, (byte)1);){
            dataRootKey = this.rootLayout.copyKey(dataRootKey);
            long generation = this.support.generation();
            long stableGeneration = Generation.stableGeneration(generation);
            long unstableGeneration = Generation.unstableGeneration(generation);
            long rootId = this.support.idProvider().acquireNewId(stableGeneration, unstableGeneration, cursorCreator);
            try {
                Root dataRoot = new Root(rootId, unstableGeneration);
                this.support.initializeNewRoot(dataRoot, this.dataTreeNode, (byte)0, cursorContext);
                rootMappingWriter.merge(dataRootKey, new RootMappingLayout.RootMappingValue().initialize(dataRoot), this.DONT_ALLOW_CREATE_EXISTING_ROOT);
                this.cache(new DataTreeRoot<ROOT_KEY>(dataRootKey, dataRoot));
            }
            catch (DataTreeAlreadyExistsException e) {
                this.support.idProvider().releaseId(stableGeneration, unstableGeneration, rootId, cursorCreator);
                throw e;
            }
        }
    }

    @Override
    void delete(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        int cacheIndex = this.cacheIndex(dataRootKey);
        try (Writer<ROOT_KEY, RootMappingLayout.RootMappingValue> rootMappingWriter = this.support.internalParallelWriter(this.rootLayout, this.rootTreeNode, 0.5, cursorContext, this, (byte)1);){
            MutableLong rootIdToRelease;
            do {
                rootIdToRelease = new MutableLong();
                ValueMerger<Object, RootMappingLayout.RootMappingValue> rootMappingMerger = (existingKey, newKey, existingValue, newValue) -> {
                    LongSpinLatch rootLatch = this.support.latchService().tryAcquireWrite(existingValue.rootId);
                    if (rootLatch == null) {
                        rootIdToRelease.setValue(-1L);
                        return ValueMerger.MergeResult.UNCHANGED;
                    }
                    try {
                        ValueMerger.MergeResult mergeResult;
                        block14: {
                            PageCursor cursor = this.support.openRootCursor(existingValue.asRoot(), 2, cursorContext);
                            try {
                                if (TreeNode.keyCount(cursor) != 0) {
                                    throw new DataTreeNotEmptyException(dataRootKey);
                                }
                                rootIdToRelease.setValue(existingValue.rootId);
                                DataTreeRoot<ROOT_KEY> cachedRoot = this.rootMappingCache.get(cacheIndex);
                                if (cachedRoot != null && this.rootLayout.compare(cachedRoot.key, dataRootKey) == 0) {
                                    this.rootMappingCache.compareAndSet(cacheIndex, cachedRoot, null);
                                }
                                mergeResult = ValueMerger.MergeResult.REMOVED;
                                if (cursor == null) break block14;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (cursor != null) {
                                        try {
                                            cursor.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            }
                            cursor.close();
                        }
                        return mergeResult;
                    }
                    finally {
                        rootLatch.releaseWrite();
                    }
                };
                rootMappingWriter.mergeIfExists(dataRootKey, new RootMappingLayout.RootMappingValue().initialize(new Root(-1L, -1L)), rootMappingMerger);
                if (rootIdToRelease.longValue() != 0L) continue;
                throw new DataTreeNotFoundException(dataRootKey);
            } while (rootIdToRelease.longValue() == -1L);
            long generation = this.support.generation();
            this.support.idProvider().releaseId(Generation.stableGeneration(generation), Generation.unstableGeneration(generation), rootIdToRelease.longValue(), CursorCreator.bind(this.support, 2, cursorContext));
        }
    }

    private static long cacheIndexAsTreeNodeId(int cacheIndex) {
        return ((long)cacheIndex & 0xFFFFFFFFL) + 1L;
    }

    @Override
    DataTree<DATA_KEY, DATA_VALUE> access(ROOT_KEY dataRootKey) {
        return new MultiDataTree(dataRootKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void visit(GBPTreeVisitor visitor, CursorContext cursorContext) throws IOException {
        long generation = this.support.generation();
        GBPTreeStructure<ROOT_KEY, DATA_KEY, DATA_VALUE> structure = new GBPTreeStructure<ROOT_KEY, DATA_KEY, DATA_VALUE>(this.rootTreeNode, this.rootLayout, this.dataTreeNode, this.dataLayout, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
        CursorCreator cursorCreator = CursorCreator.bind(this.support, 1, cursorContext);
        try (PageCursor cursor = this.support.openRootCursor(this.root, 1, cursorContext);){
            structure.visitTree(cursor, visitor, cursorContext);
            this.support.idProvider().visitFreelist(visitor, cursorCreator);
        }
        try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> allRootsSeek = this.allRootsSeek(cursorContext);){
            while (allRootsSeek.next()) {
                PageCursor cursor = this.support.openRootCursor(allRootsSeek.value().asRoot(), 1, cursorContext);
                try {
                    structure.visitTree(cursor, visitor, cursorContext);
                    this.support.idProvider().visitFreelist(visitor, cursorCreator);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            return;
        }
    }

    @Override
    void consistencyCheck(GBPTreeConsistencyChecker.ConsistencyCheckState state, GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty, PageCursor cursor, CursorContext cursorContext, Path file) throws IOException {
        long generation = this.support.generation();
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        new GBPTreeConsistencyChecker<ROOT_KEY>(this.rootTreeNode, this.rootLayout, state, stableGeneration, unstableGeneration, reportDirty).check(file, cursor, this.root, visitor, cursorContext);
        try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> seek = this.allRootsSeek(cursorContext);){
            while (seek.next()) {
                Root dataRoot = seek.value().asRoot();
                new GBPTreeConsistencyChecker<DATA_KEY>(this.dataTreeNode, this.dataLayout, state, stableGeneration, unstableGeneration, reportDirty).check(file, cursor, dataRoot, visitor, cursorContext);
            }
        }
    }

    private Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> allRootsSeek(CursorContext cursorContext) throws IOException {
        Object low = this.rootLayout.newKey();
        Object high = this.rootLayout.newKey();
        this.rootLayout.initializeAsLowest(low);
        this.rootLayout.initializeAsHighest(high);
        return this.support.initializeSeeker(this.support.internalAllocateSeeker(this.rootLayout, this.rootTreeNode, cursorContext, SeekCursor.NO_MONITOR), this, low, high, 20, Integer.MAX_VALUE);
    }

    @Override
    int keyValueSizeCap() {
        return this.dataTreeNode.keyValueSizeCap();
    }

    @Override
    int inlineKeyValueSizeCap() {
        return this.dataTreeNode.inlineKeyValueSizeCap();
    }

    @Override
    void unsafe(GBPTreeUnsafe unsafe, boolean dataTree, CursorContext cursorContext) throws IOException {
        if (dataTree) {
            this.support.unsafe(unsafe, this.dataLayout, this.dataTreeNode, cursorContext);
        } else {
            this.support.unsafe(unsafe, this.rootLayout, this.rootTreeNode, cursorContext);
        }
    }

    @Override
    CrashGenerationCleaner createCrashGenerationCleaner(CursorContextFactory contextFactory) {
        return this.support.createCrashGenerationCleaner(this.rootTreeNode, this.dataTreeNode, contextFactory);
    }

    @Override
    void printNode(PageCursor cursor, CursorContext cursorContext) {
        byte layerType = TreeNode.layerType(cursor);
        TreeNode<Object, Object> treeNode = layerType == 0 ? this.dataTreeNode : this.rootTreeNode;
        long generation = this.support.generation();
        treeNode.printNode(cursor, false, true, Generation.stableGeneration(generation), Generation.unstableGeneration(generation), cursorContext);
    }

    private void cache(DataTreeRoot<ROOT_KEY> dataRoot) {
        this.rootMappingCache.set(this.cacheIndex(dataRoot.key), dataRoot);
    }

    private int cacheIndex(ROOT_KEY dataRootKey) {
        return Math.abs(dataRootKey.hashCode()) % this.rootMappingCache.length();
    }

    @Override
    void visitAllDataTreeRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<ROOT_KEY> visitor) throws IOException {
        try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> seek = this.allRootsSeek(cursorContext);){
            while (seek.next() && !visitor.accept(this.rootLayout.copyKey(seek.key()))) {
            }
        }
    }

    private record DataTreeRoot<DATA_ROOT_KEY>(DATA_ROOT_KEY key, Root root) {
    }

    private class MultiDataTree
    implements DataTree<DATA_KEY, DATA_VALUE> {
        private final RootMappingInteraction rootMappingInteraction;

        MultiDataTree(ROOT_KEY dataRootKey) {
            this.rootMappingInteraction = new RootMappingInteraction(dataRootKey);
        }

        @Override
        public Writer<DATA_KEY, DATA_VALUE> writer(int flags, CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalParallelWriter(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataTreeNode, RootLayer.splitRatio(flags), cursorContext, this.rootMappingInteraction, (byte)0);
        }

        @Override
        public Seeker<DATA_KEY, DATA_VALUE> allocateSeeker(CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalAllocateSeeker(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataTreeNode, cursorContext, SeekCursor.NO_MONITOR);
        }

        @Override
        public Seeker<DATA_KEY, DATA_VALUE> seek(Seeker<DATA_KEY, DATA_VALUE> seeker, DATA_KEY fromInclusive, DATA_KEY toExclusive) throws IOException {
            return MultiRootLayer.this.support.initializeSeeker(seeker, this.rootMappingInteraction, fromInclusive, toExclusive, 20, Integer.MAX_VALUE);
        }

        @Override
        public List<DATA_KEY> partitionedSeek(DATA_KEY fromInclusive, DATA_KEY toExclusive, int numberOfPartitions, CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalPartitionedSeek(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataTreeNode, fromInclusive, toExclusive, numberOfPartitions, this.rootMappingInteraction, cursorContext);
        }

        @Override
        public long estimateNumberOfEntriesInTree(CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.estimateNumberOfEntriesInTree(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataTreeNode, this.rootMappingInteraction, cursorContext);
        }
    }

    private class RootMappingInteraction
    implements TreeRootExchange {
        private final ROOT_KEY dataRootKey;
        private final int cacheIndex;

        RootMappingInteraction(ROOT_KEY dataRootKey) {
            this.dataRootKey = dataRootKey;
            this.cacheIndex = MultiRootLayer.this.cacheIndex(dataRootKey);
        }

        /*
         * Loose catch block
         */
        @Override
        public Root getRoot() {
            DataTreeRoot dataRoot = MultiRootLayer.this.rootMappingCache.get(this.cacheIndex);
            if (dataRoot != null && MultiRootLayer.this.rootLayout.compare(dataRoot.key, this.dataRootKey) == 0) {
                return dataRoot.root;
            }
            LongSpinLatch rootMappingLatch = MultiRootLayer.this.rootMappingCacheLatches.acquireRead(MultiRootLayer.cacheIndexAsTreeNodeId(this.cacheIndex));
            try {
                Seeker seek;
                CursorContext cursorContext;
                block19: {
                    Root root;
                    block21: {
                        block20: {
                            cursorContext = MultiRootLayer.this.contextFactory.create("Update root mapping");
                            seek = MultiRootLayer.this.support.initializeSeeker(MultiRootLayer.this.support.internalAllocateSeeker(MultiRootLayer.this.rootLayout, MultiRootLayer.this.rootTreeNode, cursorContext, SeekCursor.NO_MONITOR), () -> MultiRootLayer.this.root, this.dataRootKey, this.dataRootKey, 20, Integer.MAX_VALUE);
                            if (!seek.next()) break block19;
                            Root root2 = seek.value().asRoot();
                            this.cacheReadRoot(root2);
                            root = root2;
                            if (seek == null) break block20;
                            seek.close();
                        }
                        if (cursorContext == null) break block21;
                        cursorContext.close();
                    }
                    return root;
                }
                try {
                    try {
                        throw new DataTreeNotFoundException(this.dataRootKey);
                        {
                            catch (Throwable throwable) {
                                if (seek != null) {
                                    try {
                                        seek.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (cursorContext != null) {
                            try {
                                cursorContext.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                rootMappingLatch.releaseRead();
            }
        }

        private void cacheReadRoot(Root root) {
            DataTreeRoot from;
            DataTreeRoot to = new DataTreeRoot(this.dataRootKey, root);
            while (!((from = MultiRootLayer.this.rootMappingCache.get(this.cacheIndex)) != null && MultiRootLayer.this.rootLayout.compare(from.key, this.dataRootKey) == 0 || MultiRootLayer.this.rootMappingCache.compareAndSet(this.cacheIndex, from, to))) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRoot(Root newRoot) throws IOException {
            LongSpinLatch rootMappingLatch = MultiRootLayer.this.rootMappingCacheLatches.acquireWrite(MultiRootLayer.cacheIndexAsTreeNodeId(this.cacheIndex));
            try (CursorContext cursorContext = MultiRootLayer.this.contextFactory.create("Update root mapping");
                 Writer rootMappingWriter = MultiRootLayer.this.support.internalParallelWriter(MultiRootLayer.this.rootLayout, MultiRootLayer.this.rootTreeNode, 0.5, cursorContext, MultiRootLayer.this, (byte)0);){
                MultiRootLayer.this.cache(new DataTreeRoot(this.dataRootKey, newRoot));
                TrackingValueMerger merger = new TrackingValueMerger(ValueMergers.overwrite());
                rootMappingWriter.mergeIfExists(this.dataRootKey, new RootMappingLayout.RootMappingValue().initialize(newRoot), merger);
                if (!merger.wasMerged()) {
                    throw new DataTreeNotFoundException(this.dataRootKey);
                }
            }
            finally {
                rootMappingLatch.releaseWrite();
            }
        }
    }
}

