/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeWriter;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.Preconditions;

class SingleRootLayer<KEY, VALUE>
extends RootLayer<SingleRoot, KEY, VALUE> {
    private final RootLayerSupport support;
    private final Layout<KEY, VALUE> layout;
    private final TreeNodeSelector treeNodeSelector;
    private final TreeNode<KEY, VALUE> treeNode;
    private final SingleDataTree singleRootAccess;
    private volatile Root root;

    SingleRootLayer(RootLayerSupport support, Layout<KEY, VALUE> layout, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
        this.support = support;
        this.layout = layout;
        this.treeNodeSelector = treeNodeSelector;
        TreeNodeSelector.Factory format = treeNodeSelector.selectByLayout(layout);
        OffloadStoreImpl<KEY, VALUE> offloadStore = support.buildOffload(layout);
        this.treeNode = format.create(support.payloadSize(), layout, offloadStore, dependencyResolver);
        this.singleRootAccess = new SingleDataTree();
    }

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Root root) throws IOException {
        this.root = root;
    }

    @Override
    public void initializeAfterCreation(Root firstRoot, CursorContext cursorContext) throws IOException {
        this.setRoot(firstRoot);
        this.support.writeMeta(null, this.layout, cursorContext, this.treeNodeSelector);
        this.support.initializeNewRoot(this.root, this.treeNode, (byte)0, cursorContext);
    }

    @Override
    void initialize(Root root, CursorContext cursorContext) throws IOException {
        this.setRoot(root);
        this.support.readMeta(cursorContext).verify(this.layout, null, this.treeNodeSelector);
    }

    @Override
    public void create(SingleRoot dataRootKey, CursorContext cursorContext) {
        this.singleRootException();
    }

    @Override
    public void delete(SingleRoot dataRootKey, CursorContext cursorContext) {
        this.singleRootException();
    }

    private void singleRootException() {
        throw new UnsupportedOperationException("This is a single-data-tree GBPTree, which means it always has one data tree which cannot be deleted and no more data trees can be created");
    }

    @Override
    public DataTree<KEY, VALUE> access(SingleRoot dataRootKey) {
        return this.singleRootAccess;
    }

    @Override
    public void visit(GBPTreeVisitor<SingleRoot, KEY, VALUE> visitor, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.support.openRootCursor(this.root, 1, cursorContext);){
            long generation = this.support.generation();
            GBPTreeStructure<SingleRoot, KEY, VALUE> structure = new GBPTreeStructure<SingleRoot, KEY, VALUE>(null, null, this.treeNode, this.layout, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
            structure.visitTree(cursor, visitor, cursorContext);
            this.support.idProvider().visitFreelist(visitor, CursorCreator.bind(this.support, 1, cursorContext));
        }
    }

    @Override
    public void consistencyCheck(GBPTreeConsistencyChecker.ConsistencyCheckState state, GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty, PageCursor cursor, CursorContext cursorContext, Path file) throws IOException {
        long generation = this.support.generation();
        new GBPTreeConsistencyChecker<KEY>(this.treeNode, this.layout, state, Generation.stableGeneration(generation), Generation.unstableGeneration(generation), reportDirty).check(file, cursor, this.root, visitor, cursorContext);
    }

    @Override
    public int keyValueSizeCap() {
        return this.treeNode.keyValueSizeCap();
    }

    @Override
    public int inlineKeyValueSizeCap() {
        return this.treeNode.inlineKeyValueSizeCap();
    }

    @Override
    void visitAllDataTreeRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<SingleRoot> visitor) {
        visitor.accept(SingleRoot.SINGLE_ROOT);
    }

    @Override
    void unsafe(GBPTreeUnsafe unsafe, boolean dataTree, CursorContext cursorContext) throws IOException {
        Preconditions.checkState((boolean)dataTree, (String)"Can only operate on data tree");
        this.support.unsafe(unsafe, this.layout, this.treeNode, cursorContext);
    }

    @Override
    CrashGenerationCleaner createCrashGenerationCleaner(CursorContextFactory contextFactory) {
        return this.support.createCrashGenerationCleaner(null, this.treeNode, contextFactory);
    }

    @Override
    void printNode(PageCursor cursor, CursorContext cursorContext) {
        long generation = this.support.generation();
        this.treeNode.printNode(cursor, false, true, Generation.stableGeneration(generation), Generation.unstableGeneration(generation), cursorContext);
    }

    private class SingleDataTree
    implements DataTree<KEY, VALUE> {
        private final GBPTreeWriter<KEY, VALUE> batchedWriter;

        SingleDataTree() {
            this.batchedWriter = SingleRootLayer.this.support.newWriter(SingleRootLayer.this.layout, SingleRootLayer.this, SingleRootLayer.this.treeNode, TreeWriterCoordination.NO_COORDINATION, false, (byte)0);
        }

        @Override
        public Seeker<KEY, VALUE> allocateSeeker(CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.internalAllocateSeeker(SingleRootLayer.this.layout, SingleRootLayer.this.treeNode, cursorContext, SeekCursor.NO_MONITOR);
        }

        @Override
        public Seeker<KEY, VALUE> seek(Seeker<KEY, VALUE> seeker, KEY fromInclusive, KEY toExclusive) throws IOException {
            return SingleRootLayer.this.support.initializeSeeker(seeker, SingleRootLayer.this, fromInclusive, toExclusive, 20, Integer.MAX_VALUE);
        }

        @Override
        public List<KEY> partitionedSeek(KEY fromInclusive, KEY toExclusive, int numberOfPartitions, CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.internalPartitionedSeek(SingleRootLayer.this.layout, SingleRootLayer.this.treeNode, fromInclusive, toExclusive, numberOfPartitions, SingleRootLayer.this, cursorContext);
        }

        @Override
        public Writer<KEY, VALUE> writer(int flags, CursorContext cursorContext) throws IOException {
            double splitRatio = RootLayer.splitRatio(flags);
            if ((flags & 1) != 0) {
                return SingleRootLayer.this.support.initializeWriter(this.batchedWriter, splitRatio, cursorContext);
            }
            return SingleRootLayer.this.support.internalParallelWriter(SingleRootLayer.this.layout, SingleRootLayer.this.treeNode, splitRatio, cursorContext, SingleRootLayer.this, (byte)0);
        }

        @Override
        public long estimateNumberOfEntriesInTree(CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.estimateNumberOfEntriesInTree(SingleRootLayer.this.layout, SingleRootLayer.this.treeNode, SingleRootLayer.this, cursorContext);
        }
    }
}

