/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class TreeNodeFixedSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    static final byte FORMAT_IDENTIFIER = 2;
    static final byte FORMAT_VERSION = 0;
    private final int internalMaxKeyCount;
    private final int leafMaxKeyCount;
    private final int keySize;
    protected final int valueSize;
    private final int maxKeyCount;
    private final int halfLeafSpace;

    TreeNodeFixedSize(int pageSize, Layout<KEY, VALUE> layout) {
        this(pageSize, layout, 0);
    }

    TreeNodeFixedSize(int pageSize, Layout<KEY, VALUE> layout, int valuePadding) {
        super(pageSize, layout);
        this.keySize = layout.keySize(null);
        this.valueSize = layout.valueSize(null) + valuePadding;
        this.internalMaxKeyCount = Math.floorDiv(pageSize - 106, this.keySize + 24);
        this.leafMaxKeyCount = Math.floorDiv(pageSize - 82, this.keySize + this.valueSize);
        this.maxKeyCount = Math.max(this.internalMaxKeyCount, this.leafMaxKeyCount);
        int halfLeafKeyCount = (this.leafMaxKeyCount + 1) / 2;
        this.halfLeafSpace = halfLeafKeyCount * (this.keySize + this.valueSize);
        if (this.internalMaxKeyCount < 2) {
            throw new MetadataMismatchException(String.format("For layout %s a page size of %d would only fit %d internal keys, minimum is 2", layout, pageSize, this.internalMaxKeyCount));
        }
        if (this.leafMaxKeyCount < 2) {
            throw new MetadataMismatchException(String.format("A page size of %d would only fit %d leaf keys (keySize:%d, valueSize:%d), minimum is 2", pageSize, this.leafMaxKeyCount, this.keySize, this.valueSize));
        }
    }

    @Override
    void writeAdditionalHeader(PageCursor cursor) {
    }

    @Override
    long offloadIdAt(PageCursor cursor, int pos, TreeNode.Type type) {
        return -1L;
    }

    private static int childSize() {
        return 24;
    }

    @Override
    KEY keyAt(PageCursor cursor, KEY into, int pos, TreeNode.Type type, CursorContext cursorContext) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.readKey(cursor, into, -1);
        return into;
    }

    @Override
    void keyValueAt(PageCursor cursor, KEY intoKey, TreeNode.ValueHolder<VALUE> intoValue, int pos, CursorContext cursorContext) throws IOException {
        this.keyAt(cursor, intoKey, pos, TreeNode.Type.LEAF, cursorContext);
        this.valueAt(cursor, intoValue, pos, cursorContext);
    }

    @Override
    void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertChildAt(cursor, child, pos + 1, keyCount, stableGeneration, unstableGeneration);
    }

    @Override
    void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertValueAt(cursor, value, pos, keyCount, cursorContext, stableGeneration, unstableGeneration);
    }

    @Override
    int removeKeyValueAt(PageCursor cursor, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.removeKeyAt(cursor, pos, keyCount);
        this.removeValueAt(cursor, pos, keyCount);
        return keyCount - 1;
    }

    @Override
    void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos, keyCount);
    }

    @Override
    void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos + 1, keyCount);
    }

    @Override
    boolean setKeyAtInternal(PageCursor cursor, KEY key, int pos) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
        return true;
    }

    @Override
    TreeNode.ValueHolder<VALUE> valueAt(PageCursor cursor, TreeNode.ValueHolder<VALUE> value, int pos, CursorContext cursorContext) throws IOException {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.readValue(cursor, value.value, -1);
        value.defined = true;
        return value;
    }

    @Override
    boolean setValueAt(PageCursor cursor, VALUE value, int pos, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.writeValue(cursor, value);
        return true;
    }

    @Override
    void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        int childOffset = this.childOffset(pos);
        cursor.setOffset(childOffset);
        TreeNodeFixedSize.writeChild(cursor, child, stableGeneration, unstableGeneration, pos, childOffset);
    }

    @Override
    int keyValueSizeCap() {
        return -1;
    }

    @Override
    int inlineKeyValueSizeCap() {
        return this.keyValueSizeCap();
    }

    @Override
    void validateKeyValueSize(KEY key, VALUE value) {
    }

    @Override
    boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    @Override
    boolean reasonableChildCount(int childCount) {
        return childCount >= 0 && childCount <= this.internalMaxKeyCount();
    }

    @Override
    int childOffset(int pos) {
        assert (pos >= 0) : pos;
        return 82 + this.internalMaxKeyCount * this.keySize + pos * 24;
    }

    int internalMaxKeyCount() {
        return this.internalMaxKeyCount;
    }

    private void insertKeyAt(PageCursor cursor, KEY key, int pos, int keyCount) {
        this.insertKeySlotsAt(cursor, pos, 1, keyCount);
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    protected int leafMaxKeyCount() {
        return this.leafMaxKeyCount;
    }

    private void removeKeyAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertChildAt(PageCursor cursor, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        this.insertChildSlot(cursor, pos, keyCount);
        this.setChildAt(cursor, child, pos, stableGeneration, unstableGeneration);
    }

    private void removeChildAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount + 1, this.childOffset(0), TreeNodeFixedSize.childSize());
    }

    private void insertKeyValueSlots(PageCursor cursor, int numberOfSlots, int keyCount) {
        this.insertKeySlotsAt(cursor, 0, numberOfSlots, keyCount);
        this.insertValueSlotsAt(cursor, 0, numberOfSlots, keyCount);
    }

    protected void insertValueAt(PageCursor cursor, VALUE value, int pos, int keyCount, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        this.insertValueSlotsAt(cursor, pos, 1, keyCount);
        this.setValueAt(cursor, value, pos, cursorContext, stableGeneration, unstableGeneration);
    }

    private void removeValueAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.removeSlotAt(cursor, pos, keyCount, this.valueOffset(0), this.valueSize);
    }

    private void insertKeySlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.keyOffset(0), this.keySize);
    }

    protected void insertValueSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.valueOffset(0), this.valueSize);
    }

    private void insertChildSlot(PageCursor cursor, int pos, int keyCount) {
        TreeNodeFixedSize.insertSlotsAt(cursor, pos, 1, keyCount + 1, this.childOffset(0), TreeNodeFixedSize.childSize());
    }

    private int keyOffset(int pos) {
        return 82 + pos * this.keySize;
    }

    protected int valueOffset(int pos) {
        return 82 + this.leafMaxKeyCount * this.keySize + pos * this.valueSize;
    }

    private int keySize() {
        return this.keySize;
    }

    private int valueSize() {
        return this.valueSize;
    }

    @Override
    TreeNode.Overflow internalOverflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        return currentKeyCount + 1 > this.internalMaxKeyCount() ? TreeNode.Overflow.YES : TreeNode.Overflow.NO;
    }

    @Override
    TreeNode.Overflow leafOverflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        return currentKeyCount + 1 > this.leafMaxKeyCount() ? TreeNode.Overflow.YES : TreeNode.Overflow.NO;
    }

    @Override
    int availableSpace(PageCursor cursor, int currentKeyCount) {
        boolean isInternal = TreeNodeFixedSize.isInternal(cursor);
        return isInternal ? this.internalMaxKeyCount - currentKeyCount * (this.keySize + TreeNodeFixedSize.childSize()) : this.leafAvailableSpace(currentKeyCount);
    }

    protected int leafAvailableSpace(int currentKeyCount) {
        return (this.leafMaxKeyCount() - currentKeyCount) * (this.keySize + this.valueSize);
    }

    @Override
    int totalSpaceOfKeyValue(KEY key, VALUE value) {
        return this.keySize + this.valueSize;
    }

    @Override
    int totalSpaceOfKeyChild(KEY key) {
        return this.keySize + TreeNodeFixedSize.childSize();
    }

    @Override
    int leafUnderflowThreshold() {
        return this.halfLeafSpace;
    }

    @Override
    void defragmentLeaf(PageCursor cursor) {
    }

    @Override
    void defragmentInternal(PageCursor cursor) {
    }

    @Override
    boolean leafUnderflow(PageCursor cursor, int keyCount) {
        return this.leafAvailableSpace(keyCount) > this.halfLeafSpace;
    }

    @Override
    int canRebalanceLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        if (leftKeyCount + rightKeyCount >= this.leafMaxKeyCount()) {
            int totalKeyCount = rightKeyCount + leftKeyCount;
            int moveFromPosition = totalKeyCount / 2;
            return leftKeyCount - moveFromPosition;
        }
        return -1;
    }

    @Override
    boolean canMergeLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        return leftKeyCount + rightKeyCount <= this.leafMaxKeyCount();
    }

    @Override
    int findSplitter(PageCursor cursor, int keyCount, KEY newKey, VALUE newValue, int insertPos, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        int keyCountAfterInsert = keyCount + 1;
        int splitPos = TreeNodeFixedSize.splitPos(keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(cursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, TreeNode.Type.LEAF, cursorContext);
        }
        return splitPos;
    }

    @Override
    void doSplitLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, int splitPos, double ratioToKeepInLeftOnSplit, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int rightKeyCount = keyCountAfterInsert - splitPos;
        if (insertPos < splitPos) {
            this.copyKeysAndValues(leftCursor, splitPos - 1, rightCursor, 0, rightKeyCount);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else {
            int countBeforePos = insertPos - splitPos;
            if (countBeforePos > 0) {
                this.copyKeysAndValues(leftCursor, splitPos, rightCursor, 0, countBeforePos);
            }
            this.insertKeyValueAt(rightCursor, newKey, newValue, countBeforePos, countBeforePos, stableGeneration, unstableGeneration, cursorContext);
            int countAfterPos = leftKeyCount - insertPos;
            if (countAfterPos > 0) {
                this.copyKeysAndValues(leftCursor, insertPos, rightCursor, countBeforePos + 1, countAfterPos);
            }
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    private static int splitPos(int keyCount, double ratioToKeepInLeftOnSplit) {
        int minSplitPos = 1;
        int maxSplitPos = keyCount - 1;
        return Math.max(minSplitPos, Math.min(maxSplitPos, (int)(ratioToKeepInLeftOnSplit * (double)keyCount)));
    }

    @Override
    void doSplitInternal(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = TreeNodeFixedSize.splitPos(keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, TreeNode.Type.INTERNAL, cursorContext);
        }
        int rightKeyCount = keyCountAfterInsert - splitPos - 1;
        if (insertPos < splitPos) {
            leftCursor.copyTo(this.keyOffset(splitPos), rightCursor, this.keyOffset(0), rightKeyCount * this.keySize());
            leftCursor.copyTo(this.childOffset(splitPos), rightCursor, this.childOffset(0), (rightKeyCount + 1) * TreeNodeFixedSize.childSize());
            this.insertKeyAt(leftCursor, newKey, insertPos, splitPos - 1);
            this.insertChildAt(leftCursor, newRightChild, insertPos + 1, splitPos - 1, stableGeneration, unstableGeneration);
        } else {
            int countAfterPos;
            int countBeforePos = insertPos - (splitPos + 1);
            if (countBeforePos > 0) {
                leftCursor.copyTo(this.keyOffset(splitPos + 1), rightCursor, this.keyOffset(0), countBeforePos * this.keySize());
            }
            if (countBeforePos >= 0) {
                this.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
            }
            if ((countAfterPos = leftKeyCount - insertPos) > 0) {
                leftCursor.copyTo(this.keyOffset(insertPos), rightCursor, this.keyOffset(countBeforePos + 1), countAfterPos * this.keySize());
            }
            if ((countBeforePos = insertPos - splitPos) > 0) {
                leftCursor.copyTo(this.childOffset(splitPos + 1), rightCursor, this.childOffset(0), countBeforePos * TreeNodeFixedSize.childSize());
            }
            this.insertChildAt(rightCursor, newRightChild, countBeforePos, countBeforePos, stableGeneration, unstableGeneration);
            if (countAfterPos > 0) {
                leftCursor.copyTo(this.childOffset(insertPos + 1), rightCursor, this.childOffset(countBeforePos + 1), countAfterPos * TreeNodeFixedSize.childSize());
            }
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        this.insertKeyValueSlots(rightCursor, numberOfKeysToMove, rightKeyCount);
        this.copyKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeFixedSize.setKeyCount(leftCursor, leftKeyCount - numberOfKeysToMove);
        TreeNodeFixedSize.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    @Override
    void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.insertKeyValueSlots(rightCursor, leftKeyCount, rightKeyCount);
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeFixedSize.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    @Override
    void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        try {
            boolean isDataNode;
            boolean bl = isDataNode = TreeNodeFixedSize.layerType(cursor) == 0;
            if (isDataNode) {
                new GBPTreeStructure(null, null, this, this.layout, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            } else {
                new GBPTreeStructure(this, this.layout, null, null, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        fromCursor.copyTo(this.keyOffset(fromPos), toCursor, this.keyOffset(toPos), count * this.keySize());
        int valueLength = count * this.valueSize();
        if (valueLength > 0) {
            fromCursor.copyTo(this.valueOffset(fromPos), toCursor, this.valueOffset(toPos), valueLength);
        }
    }

    @Override
    String checkMetaConsistency(PageCursor cursor, int keyCount, TreeNode.Type type, GBPTreeConsistencyCheckVisitor visitor) {
        return "";
    }

    public String toString() {
        return "TreeNodeFixedSize[pageSize:" + this.pageSize + ", internalMax:" + this.internalMaxKeyCount() + ", leafMax:" + this.leafMaxKeyCount() + ", keySize:" + this.keySize() + ", valueSize:" + this.valueSize + "]";
    }
}

