/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.util.VisibleForTesting;

public class TreeNodeLatchService {
    private final ConcurrentHashMap<Long, LongSpinLatch> latches = new ConcurrentHashMap();

    LongSpinLatch acquireRead(long treeNodeId) {
        LongSpinLatch latch;
        while ((latch = this.latches.computeIfAbsent(treeNodeId, id -> new LongSpinLatch((long)id, this.latches::remove))).acquireRead() <= 0) {
        }
        return latch;
    }

    LongSpinLatch acquireWrite(long treeNodeId) {
        LongSpinLatch latch;
        while (!(latch = this.latches.computeIfAbsent(treeNodeId, id -> new LongSpinLatch((long)id, this.latches::remove))).acquireWrite()) {
        }
        return latch;
    }

    LongSpinLatch tryAcquireWrite(long treeNodeId) {
        LongSpinLatch latch;
        int result;
        while ((result = (latch = this.latches.computeIfAbsent(treeNodeId, id -> new LongSpinLatch((long)id, this.latches::remove))).tryAcquireWrite()) == -1) {
        }
        return result == 1 ? latch : null;
    }

    @VisibleForTesting
    int size() {
        return this.latches.size();
    }
}

