/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.Overflow;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

final class InternalNodeFixedSize<KEY>
implements InternalNodeBehaviour<KEY> {
    private final int maxKeyCount;
    private final int keySize;
    private final Layout<KEY, ?> layout;
    private final int payloadSize;

    InternalNodeFixedSize(int payloadSize, Layout<KEY, ?> layout) {
        this.payloadSize = payloadSize;
        this.layout = layout;
        this.keySize = layout.keySize(null);
        this.maxKeyCount = Math.floorDiv(payloadSize - 106, this.keySize + 24);
        if (this.maxKeyCount < 2) {
            throw new MetadataMismatchException(String.format("For layout %s a page size of %d would only fit %d internal keys, minimum is 2", layout, payloadSize, this.maxKeyCount));
        }
    }

    @Override
    public void initialize(PageCursor cursor, byte layerType, long stableGeneration, long unstableGeneration) {
        TreeNodeUtil.writeBaseHeader(cursor, (byte)0, layerType, stableGeneration, unstableGeneration);
    }

    @Override
    public long offloadIdAt(PageCursor cursor, int pos) {
        return -1L;
    }

    @Override
    public KEY keyAt(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.readKey(cursor, into, -1);
        return into;
    }

    @Override
    public Comparator<KEY> keyComparator() {
        return this.layout;
    }

    @Override
    public void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertChildAt(cursor, child, pos + 1, keyCount, stableGeneration, unstableGeneration);
    }

    @Override
    public void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos, keyCount);
    }

    @Override
    public void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        this.removeKeyAt(cursor, keyPos, keyCount);
        this.removeChildAt(cursor, keyPos + 1, keyCount);
    }

    @Override
    public boolean setKeyAt(PageCursor cursor, KEY key, int pos) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
        return true;
    }

    @Override
    public void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        int childOffset = this.childOffset(pos);
        cursor.setOffset(childOffset);
        TreeNodeUtil.writeChild(cursor, child, stableGeneration, unstableGeneration, pos, childOffset);
    }

    @Override
    public int childOffset(int pos) {
        assert (pos >= 0) : pos;
        return 82 + this.maxKeyCount * this.keySize + pos * 24;
    }

    @Override
    public int maxKeyCount() {
        return this.maxKeyCount;
    }

    private void insertKeyAt(PageCursor cursor, KEY key, int pos, int keyCount) {
        this.insertKeySlotsAt(cursor, pos, 1, keyCount);
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    private void removeKeyAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeUtil.removeSlotAt(cursor, pos, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertChildAt(PageCursor cursor, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        this.insertChildSlot(cursor, pos, keyCount);
        this.setChildAt(cursor, child, pos, stableGeneration, unstableGeneration);
    }

    private void removeChildAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeUtil.removeSlotAt(cursor, pos, keyCount + 1, this.childOffset(0), 24);
    }

    private void insertKeySlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeUtil.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertChildSlot(PageCursor cursor, int pos, int keyCount) {
        TreeNodeUtil.insertSlotsAt(cursor, pos, 1, keyCount + 1, this.childOffset(0), 24);
    }

    private int keyOffset(int pos) {
        return 82 + pos * this.keySize;
    }

    @Override
    public Overflow overflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        return currentKeyCount + 1 > this.maxKeyCount ? Overflow.YES : Overflow.NO;
    }

    @Override
    public int availableSpace(PageCursor cursor, int currentKeyCount) {
        return this.maxKeyCount - currentKeyCount * (this.keySize + 24);
    }

    @Override
    public int totalSpaceOfKeyChild(KEY key) {
        return this.keySize + 24;
    }

    @Override
    public void defragment(PageCursor cursor, int keyCount) {
    }

    @Override
    public void doSplit(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = TreeNodeUtil.splitPos(keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, cursorContext);
        }
        int rightKeyCount = keyCountAfterInsert - splitPos - 1;
        if (insertPos < splitPos) {
            leftCursor.copyTo(this.keyOffset(splitPos), rightCursor, this.keyOffset(0), rightKeyCount * this.keySize);
            leftCursor.copyTo(this.childOffset(splitPos), rightCursor, this.childOffset(0), (rightKeyCount + 1) * 24);
            this.insertKeyAt(leftCursor, newKey, insertPos, splitPos - 1);
            this.insertChildAt(leftCursor, newRightChild, insertPos + 1, splitPos - 1, stableGeneration, unstableGeneration);
        } else {
            int countAfterPos;
            int countBeforePos = insertPos - (splitPos + 1);
            if (countBeforePos > 0) {
                leftCursor.copyTo(this.keyOffset(splitPos + 1), rightCursor, this.keyOffset(0), countBeforePos * this.keySize);
            }
            if (countBeforePos >= 0) {
                this.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
            }
            if ((countAfterPos = leftKeyCount - insertPos) > 0) {
                leftCursor.copyTo(this.keyOffset(insertPos), rightCursor, this.keyOffset(countBeforePos + 1), countAfterPos * this.keySize);
            }
            if ((countBeforePos = insertPos - splitPos) > 0) {
                leftCursor.copyTo(this.childOffset(splitPos + 1), rightCursor, this.childOffset(0), countBeforePos * 24);
            }
            this.insertChildAt(rightCursor, newRightChild, countBeforePos, countBeforePos, stableGeneration, unstableGeneration);
            if (countAfterPos > 0) {
                leftCursor.copyTo(this.childOffset(insertPos + 1), rightCursor, this.childOffset(countBeforePos + 1), countAfterPos * 24);
            }
        }
        TreeNodeUtil.setKeyCount(leftCursor, splitPos);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    public void printNode(PageCursor cursor, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
    }

    @Override
    public String checkMetaConsistency(PageCursor cursor) {
        return "";
    }

    @Override
    public long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        return this.childAt(cursor, pos, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    @Override
    public long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    @Override
    public boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    public String toString() {
        return "InternalNodeFixedSize[payloadSize:" + this.payloadSize + ", maxKeys:" + this.maxKeyCount + ", keySize:" + this.keySize + "]";
    }
}

