/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.GBPPointerType;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class InternalTreeLogic<KEY, VALUE> {
    static final double DEFAULT_SPLIT_RATIO = 0.5;
    private final IdProvider idProvider;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final Layout<KEY, VALUE> layout;
    private final KEY newKeyPlaceHolder;
    private final KEY readKey;
    private final TreeNode.ValueHolder<VALUE> readValue;
    private final MultiRootGBPTree.Monitor monitor;
    private final TreeWriterCoordination coordination;
    final byte layerType;
    private Level<KEY>[] levels;
    private int currentLevel = -1;
    private double ratioToKeepInLeftOnSplit;

    InternalTreeLogic(IdProvider idProvider, TreeNode<KEY, VALUE> bTreeNode, Layout<KEY, VALUE> layout, MultiRootGBPTree.Monitor monitor, TreeWriterCoordination coordination, byte layerType) {
        this.idProvider = idProvider;
        this.bTreeNode = bTreeNode;
        this.layout = layout;
        this.newKeyPlaceHolder = layout.newKey();
        this.readKey = layout.newKey();
        this.readValue = new TreeNode.ValueHolder<VALUE>(layout.newValue());
        this.monitor = monitor;
        this.coordination = coordination;
        this.layerType = layerType;
        this.levels = new Level[10];
        this.levels[0] = new Level<KEY>(layout);
    }

    protected void initialize(PageCursor cursorAtRoot, double ratioToKeepInLeftOnSplit) {
        this.currentLevel = 0;
        Level<KEY> level = this.levels[this.currentLevel];
        level.treeNodeId = cursorAtRoot.getCurrentPageId();
        level.lowerIsOpenEnded = true;
        level.upperIsOpenEnded = true;
        this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
    }

    private Level<KEY> descendToLevel(int currentLevel) {
        Level<KEY> level;
        if (currentLevel >= this.levels.length) {
            this.levels = Arrays.copyOf(this.levels, currentLevel + 1);
        }
        if ((level = this.levels[currentLevel]) == null) {
            level = this.levels[currentLevel] = new Level<KEY>(this.layout);
        }
        return level;
    }

    private boolean popLevel(PageCursor cursor) throws IOException {
        --this.currentLevel;
        if (this.currentLevel >= 0) {
            Level<KEY> level = this.levels[this.currentLevel];
            TreeNode.goTo(cursor, "parent", level.treeNodeId);
            return true;
        }
        return false;
    }

    private boolean moveToCorrectLeaf(PageCursor cursor, KEY key, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int previousLevel = this.currentLevel;
        while (!this.levels[this.currentLevel].covers(key)) {
            --this.currentLevel;
        }
        if (this.currentLevel != previousLevel) {
            TreeNode.goTo(cursor, "parent", this.levels[this.currentLevel].treeNodeId);
        }
        while (TreeNode.isInternal(cursor)) {
            this.ensureNodeIsTreeNode(cursor, key);
            int keyCount = TreeNode.keyCount(cursor);
            int searchResult = this.search(cursor, TreeNode.Type.INTERNAL, key, this.readKey, keyCount, cursorContext);
            int childPos = KeySearch.childPositionOf(searchResult);
            Level<KEY> parentLevel = this.levels[this.currentLevel];
            ++this.currentLevel;
            Level<KEY> level = this.descendToLevel(this.currentLevel);
            level.childPos = childPos;
            boolean bl = level.lowerIsOpenEnded = childPos == 0 && !TreeNode.isNode(TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.lowerIsOpenEnded) {
                if (childPos == 0) {
                    this.layout.copyKey(parentLevel.lower, level.lower);
                    level.lowerIsOpenEnded = parentLevel.lowerIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, level.lower, childPos - 1, TreeNode.Type.INTERNAL, cursorContext);
                }
            }
            boolean bl2 = level.upperIsOpenEnded = childPos >= keyCount && !TreeNode.isNode(TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration));
            if (!level.upperIsOpenEnded) {
                if (childPos == keyCount) {
                    this.layout.copyKey(parentLevel.upper, level.upper);
                    level.upperIsOpenEnded = parentLevel.upperIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, level.upper, childPos, TreeNode.Type.INTERNAL, cursorContext);
                }
            }
            long childId = this.bTreeNode.childAt(cursor, childPos, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(childId, cursor, childPos, this.bTreeNode, stableGeneration, unstableGeneration);
            this.coordination.beforeTraversingToChild(GenerationSafePointerPair.pointer(childId), childPos);
            TreeNode.goTo(cursor, "child", childId);
            level.treeNodeId = cursor.getCurrentPageId();
            int childKeyCount = TreeNode.keyCount(cursor);
            if (!this.coordination.arrivedAtChild(TreeNode.isInternal(cursor), this.bTreeNode.availableSpace(cursor, childKeyCount), TreeNode.generation(cursor) != unstableGeneration, childKeyCount)) {
                return false;
            }
            assert (PointerChecking.assertNoSuccessor(cursor, stableGeneration, unstableGeneration));
        }
        this.ensureNodeIsTreeNode(cursor, key);
        this.ensureTreeNodeIsLeaf(cursor, key);
        return true;
    }

    private void ensureNodeIsTreeNode(PageCursor cursor, KEY key) {
        if (TreeNode.nodeType(cursor) != 1) {
            throw new TreeInconsistencyException("Index update aborted due to finding tree node that doesn't have correct type (pageId: %d, type: %d), when moving cursor towards " + key + ". This is most likely caused by an inconsistency in the index. ", cursor.getCurrentPageId(), TreeNode.nodeType(cursor));
        }
    }

    private void ensureTreeNodeIsLeaf(PageCursor cursor, KEY key) {
        if (!TreeNode.isLeaf(cursor)) {
            throw new TreeInconsistencyException("Index update aborted due to ending up on a tree node which isn't a leaf after moving cursor towards " + key + ", cursor is at pageId " + cursor.getCurrentPageId() + ". This is most likely caused by an inconsistency in the index.", new Object[0]);
        }
    }

    boolean insert(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.bTreeNode.validateKeyValueSize(key, value);
        if (!this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration, cursorContext)) {
            return false;
        }
        boolean insertSuccess = this.insertInLeaf(cursor, structurePropagation, key, value, valueMerger, createIfNotExists, stableGeneration, unstableGeneration, cursorContext);
        this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
        return insertSuccess;
    }

    private int search(PageCursor cursor, TreeNode.Type type, KEY key, KEY readKey, int keyCount, CursorContext cursorContext) {
        int searchResult = KeySearch.search(cursor, this.bTreeNode, type, key, readKey, keyCount, cursorContext);
        KeySearch.assertSuccess(searchResult);
        return searchResult;
    }

    private boolean cursorIsAtExpectedLocation(PageCursor cursor) {
        if (!this.coordination.mustStartFromRoot()) {
            assert (this.currentLevel >= 0) : "Uninitialized tree logic, currentLevel:" + this.currentLevel;
            long currentPageId = cursor.getCurrentPageId();
            long expectedPageId = this.levels[this.currentLevel].treeNodeId;
            assert (currentPageId == expectedPageId) : "Expected cursor to be at page:" + expectedPageId + " at level:" + this.currentLevel + ", but was at page:" + currentPageId;
        }
        return true;
    }

    private void insertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        this.doInsertInInternal(cursor, structurePropagation, keyCount, primKey, rightChild, stableGeneration, unstableGeneration, cursorContext);
    }

    private void doInsertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        TreeNode.Overflow overflow = this.bTreeNode.internalOverflow(cursor, keyCount, primKey);
        if (overflow == TreeNode.Overflow.YES) {
            this.layout.copyKey(primKey, this.newKeyPlaceHolder);
            this.splitInternal(cursor, structurePropagation, this.newKeyPlaceHolder, rightChild, keyCount, stableGeneration, unstableGeneration, cursorContext);
            return;
        }
        if (overflow == TreeNode.Overflow.NO_NEED_DEFRAG) {
            this.bTreeNode.defragmentInternal(cursor);
        }
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.INTERNAL, primKey, this.readKey, keyCount, cursorContext));
        this.bTreeNode.insertKeyAndRightChildAt(cursor, primKey, rightChild, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNode.setKeyCount(cursor, keyCount + 1);
    }

    private void splitInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, long newRightChild, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        long current = cursor.getCurrentPageId();
        this.coordination.beforeSplitInternal(current);
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(oldRight, true, cursor, stableGeneration, unstableGeneration);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.INTERNAL, newKey, this.readKey, keyCount, cursorContext));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeInternal(rightCursor, this.layerType, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.bTreeNode.doSplitInternal(cursor, keyCount, rightCursor, pos, newKey, newRightChild, stableGeneration, unstableGeneration, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit, cursorContext);
        }
        if (TreeNode.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private boolean insertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, boolean createIfNotExists, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, TreeNode.Type.LEAF, key, this.readKey, keyCount, cursorContext);
        int pos = KeySearch.positionOf(search);
        if (KeySearch.isHit(search)) {
            return this.mergeValue(cursor, structurePropagation, key, value, valueMerger, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        if (createIfNotExists) {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            return this.doInsertInLeaf(cursor, structurePropagation, key, value, pos, keyCount, stableGeneration, unstableGeneration, cursorContext) != InsertResult.SPLIT_FAIL;
        }
        return true;
    }

    private boolean mergeValue(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<KEY, VALUE> valueMerger, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.bTreeNode.valueAt(cursor, this.readValue, pos, cursorContext);
        int totalSpaceBefore = this.bTreeNode.totalSpaceOfKeyValue(key, this.readValue.value);
        ValueMerger.MergeResult mergeResult = ValueMerger.MergeResult.REPLACED;
        if (this.readValue.defined && (mergeResult = valueMerger.merge(this.readKey, key, this.readValue.value, value)) == ValueMerger.MergeResult.UNCHANGED) {
            return true;
        }
        int totalSpaceAfter = switch (mergeResult) {
            case ValueMerger.MergeResult.MERGED -> this.bTreeNode.totalSpaceOfKeyValue(key, this.readValue.value);
            case ValueMerger.MergeResult.REPLACED -> this.bTreeNode.totalSpaceOfKeyValue(key, value);
            default -> 0;
        };
        int valueShrinkSize = totalSpaceBefore - totalSpaceAfter;
        if (!this.coordination.beforeRemovalFromLeaf(valueShrinkSize)) {
            return false;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        if (mergeResult == ValueMerger.MergeResult.REPLACED || mergeResult == ValueMerger.MergeResult.MERGED) {
            VALUE mergedValue = mergeResult == ValueMerger.MergeResult.REPLACED ? value : this.readValue.value;
            boolean couldOverwrite = this.bTreeNode.setValueAt(cursor, mergedValue, pos, cursorContext, stableGeneration, unstableGeneration);
            if (!couldOverwrite) {
                int newKeyCount = this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
                TreeNode.setKeyCount(cursor, newKeyCount);
                InsertResult result = this.doInsertInLeaf(cursor, structurePropagation, key, mergedValue, pos, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
                if (result == InsertResult.SPLIT_FAIL) {
                    return false;
                }
                if (result == InsertResult.NO_SPLIT && this.bTreeNode.leafUnderflow(cursor, keyCount)) {
                    this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration, cursorContext);
                }
            }
        } else if (mergeResult == ValueMerger.MergeResult.REMOVED) {
            int newKeyCount = this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
            TreeNode.setKeyCount(cursor, newKeyCount);
            if (this.bTreeNode.leafUnderflow(cursor, newKeyCount)) {
                this.underflowInLeaf(cursor, structurePropagation, newKeyCount, stableGeneration, unstableGeneration, cursorContext);
            }
        } else {
            throw new UnsupportedOperationException("Unexpected merge result " + mergeResult);
        }
        return true;
    }

    private InsertResult doInsertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        TreeNode.Overflow overflow = this.bTreeNode.leafOverflow(cursor, keyCount, key, value);
        if (overflow == TreeNode.Overflow.YES) {
            if (!this.splitLeaf(cursor, structurePropagation, key, value, keyCount, stableGeneration, unstableGeneration, cursorContext)) {
                return InsertResult.SPLIT_FAIL;
            }
            return InsertResult.SPLIT;
        }
        if (overflow == TreeNode.Overflow.NO_NEED_DEFRAG) {
            this.bTreeNode.defragmentLeaf(cursor);
        }
        this.bTreeNode.insertKeyValueAt(cursor, key, value, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNode.setKeyCount(cursor, keyCount + 1);
        return InsertResult.NO_SPLIT;
    }

    private boolean splitLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, VALUE newValue, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int pos = KeySearch.positionOf(this.search(cursor, TreeNode.Type.LEAF, newKey, this.readKey, keyCount, cursorContext));
        int middlePos = this.bTreeNode.findSplitter(cursor, keyCount, newKey, newValue, pos, structurePropagation.rightKey, this.ratioToKeepInLeftOnSplit, cursorContext);
        if (!this.coordination.beforeSplittingLeaf(this.bTreeNode.totalSpaceOfKeyChild(structurePropagation.rightKey))) {
            return false;
        }
        long current = cursor.getCurrentPageId();
        long oldRight = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(oldRight, true, cursor, stableGeneration, unstableGeneration);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        structurePropagation.hasRightKeyInsert = true;
        structurePropagation.midChild = current;
        structurePropagation.rightChild = newRight;
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            TreeNode.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeLeaf(rightCursor, this.layerType, stableGeneration, unstableGeneration);
            TreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            TreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            this.bTreeNode.doSplitLeaf(cursor, keyCount, rightCursor, pos, newKey, newValue, structurePropagation.rightKey, middlePos, this.ratioToKeepInLeftOnSplit, stableGeneration, unstableGeneration, cursorContext);
        }
        if (TreeNode.isNode(oldRight)) {
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                TreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                TreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
        }
        TreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
        return true;
    }

    RemoveResult remove(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, TreeNode.ValueHolder<VALUE> into, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        if (!this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration, cursorContext)) {
            return RemoveResult.FAIL;
        }
        RemoveResult result = this.removeFromLeaf(cursor, structurePropagation, key, into, stableGeneration, unstableGeneration, cursorContext);
        if (result == RemoveResult.REMOVED) {
            this.handleStructureChanges(cursor, structurePropagation, stableGeneration, unstableGeneration, cursorContext);
            if (this.currentLevel <= 0) {
                this.tryShrinkTree(cursor, structurePropagation, stableGeneration, unstableGeneration);
            }
        }
        return result;
    }

    private void handleStructureChanges(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        while (structurePropagation.hasLeftChildUpdate || structurePropagation.hasMidChildUpdate || structurePropagation.hasRightChildUpdate || structurePropagation.hasLeftKeyReplace || structurePropagation.hasRightKeyReplace || structurePropagation.hasRightKeyInsert) {
            int pos = this.levels[this.currentLevel].childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasLeftChildUpdate) {
                structurePropagation.hasLeftChildUpdate = false;
                if (pos == 0) {
                    this.updateRightmostChildInLeftSibling(cursor, structurePropagation.leftChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.leftChild, pos - 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, pos, stableGeneration, unstableGeneration);
            }
            if (structurePropagation.hasRightChildUpdate) {
                structurePropagation.hasRightChildUpdate = false;
                int keyCount = TreeNode.keyCount(cursor);
                if (pos == keyCount) {
                    this.updateLeftmostChildInRightSibling(cursor, structurePropagation.rightChild, stableGeneration, unstableGeneration);
                } else {
                    this.bTreeNode.setChildAt(cursor, structurePropagation.rightChild, pos + 1, stableGeneration, unstableGeneration);
                }
            }
            if (structurePropagation.hasRightKeyInsert) {
                structurePropagation.hasRightKeyInsert = false;
                this.insertInInternal(cursor, structurePropagation, TreeNode.keyCount(cursor), structurePropagation.rightKey, structurePropagation.rightChild, stableGeneration, unstableGeneration, cursorContext);
            }
            if (structurePropagation.hasLeftKeyReplace && this.levels[this.currentLevel].covers(structurePropagation.leftKey)) {
                assert (pos > 0) : "attempt to replace key left to the leftmost key";
                structurePropagation.hasLeftKeyReplace = false;
                switch (structurePropagation.keyReplaceStrategy) {
                    case REPLACE: {
                        this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.leftKey, pos - 1, stableGeneration, unstableGeneration, cursorContext);
                        break;
                    }
                    case BUBBLE: {
                        this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos - 1, stableGeneration, unstableGeneration, cursorContext);
                    }
                }
            }
            if (!structurePropagation.hasRightKeyReplace || !this.levels[this.currentLevel].covers(structurePropagation.rightKey)) continue;
            structurePropagation.hasRightKeyReplace = false;
            switch (structurePropagation.keyReplaceStrategy) {
                case REPLACE: {
                    this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.rightKey, pos, stableGeneration, unstableGeneration, cursorContext);
                    break;
                }
                case BUBBLE: {
                    this.replaceKeyByBubbleRightmostFromSubtree(cursor, structurePropagation, pos, stableGeneration, unstableGeneration, cursorContext);
                }
            }
        }
    }

    private void overwriteKeyInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, int pos, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        int keyCount = TreeNode.keyCount(cursor);
        boolean couldOverwrite = this.bTreeNode.setKeyAtInternal(cursor, newKey, pos);
        if (!couldOverwrite) {
            long rightChild = this.bTreeNode.childAt(cursor, pos + 1, stableGeneration, unstableGeneration);
            this.bTreeNode.removeKeyAndRightChildAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
            TreeNode.setKeyCount(cursor, keyCount - 1);
            this.doInsertInInternal(cursor, structurePropagation, keyCount - 1, newKey, rightChild, stableGeneration, unstableGeneration, cursorContext);
        }
    }

    private void tryShrinkTree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        int rootKeyCount = TreeNode.keyCount(cursor);
        while (rootKeyCount == 0 && TreeNode.isInternal(cursor)) {
            long oldRoot = cursor.getCurrentPageId();
            long onlyChildOfRoot = this.bTreeNode.childAt(cursor, 0, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(onlyChildOfRoot, cursor, 0, this.bTreeNode, stableGeneration, unstableGeneration);
            structurePropagation.hasMidChildUpdate = true;
            structurePropagation.midChild = onlyChildOfRoot;
            this.idProvider.releaseId(stableGeneration, unstableGeneration, oldRoot, CursorCreator.bind(cursor));
            TreeNode.goTo(cursor, "child", onlyChildOfRoot);
            rootKeyCount = TreeNode.keyCount(cursor);
            this.monitor.treeShrink();
        }
    }

    private void updateMidChild(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int childPos, long stableGeneration, long unstableGeneration) {
        structurePropagation.hasMidChildUpdate = false;
        this.bTreeNode.setChildAt(cursor, structurePropagation.midChild, childPos, stableGeneration, unstableGeneration);
    }

    private void replaceKeyByBubbleRightmostFromSubtree(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int subtreePosition, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        long currentPageId = cursor.getCurrentPageId();
        long subtree = this.bTreeNode.childAt(cursor, subtreePosition, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkChildPointer(subtree, cursor, subtreePosition, this.bTreeNode, stableGeneration, unstableGeneration);
        TreeNode.goTo(cursor, "child", subtree);
        boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration, cursorContext);
        if (structurePropagation.hasMidChildUpdate) {
            this.updateMidChild(cursor, structurePropagation, subtreePosition, stableGeneration, unstableGeneration);
        }
        if (foundKeyBelow) {
            this.overwriteKeyInternal(cursor, structurePropagation, structurePropagation.bubbleKey, subtreePosition, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            int keyCount = TreeNode.keyCount(cursor);
            this.simplyRemoveFromInternal(cursor, keyCount, subtreePosition, true, stableGeneration, unstableGeneration, cursorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bubbleRightmostKeyRecursive(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long previousNode, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        try {
            if (TreeNode.isLeaf(cursor)) {
                boolean bl = false;
                return bl;
            }
            long currentPageId = cursor.getCurrentPageId();
            int keyCount = TreeNode.keyCount(cursor);
            long rightmostSubtree = this.bTreeNode.childAt(cursor, keyCount, stableGeneration, unstableGeneration);
            InternalTreeLogic.checkChildPointer(rightmostSubtree, cursor, keyCount, this.bTreeNode, stableGeneration, unstableGeneration);
            TreeNode.goTo(cursor, "child", rightmostSubtree);
            boolean foundKeyBelow = this.bubbleRightmostKeyRecursive(cursor, structurePropagation, currentPageId, stableGeneration, unstableGeneration, cursorContext);
            if (structurePropagation.hasMidChildUpdate) {
                this.updateMidChild(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration);
            }
            if (foundKeyBelow) {
                boolean bl = true;
                return bl;
            }
            if (keyCount == 0) {
                InternalTreeLogic.connectLeftAndRightSibling(cursor, stableGeneration, unstableGeneration);
                this.idProvider.releaseId(stableGeneration, unstableGeneration, currentPageId, CursorCreator.bind(cursor));
                boolean bl = false;
                return bl;
            }
            this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
            this.bTreeNode.keyAt(cursor, structurePropagation.bubbleKey, keyCount - 1, TreeNode.Type.INTERNAL, cursorContext);
            this.simplyRemoveFromInternal(cursor, keyCount, keyCount - 1, false, stableGeneration, unstableGeneration, cursorContext);
            boolean bl = true;
            return bl;
        }
        finally {
            TreeNode.goTo(cursor, "back to previous node", previousNode);
        }
    }

    private void simplyRemoveFromInternal(PageCursor cursor, int keyCount, int keyPos, boolean leftChild, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        if (leftChild) {
            this.bTreeNode.removeKeyAndLeftChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        } else {
            this.bTreeNode.removeKeyAndRightChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNode.setKeyCount(cursor, keyCount - 1);
    }

    private void updateRightmostChildInLeftSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, false, cursor, stableGeneration, unstableGeneration);
        try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(leftSibling);){
            TreeNode.goTo(leftSiblingCursor, "left sibling", leftSibling);
            int keyCount = TreeNode.keyCount(leftSiblingCursor);
            this.bTreeNode.setChildAt(leftSiblingCursor, childPointer, keyCount, stableGeneration, unstableGeneration);
        }
    }

    private void updateLeftmostChildInRightSibling(PageCursor cursor, long childPointer, long stableGeneration, long unstableGeneration) throws IOException {
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, false, cursor, stableGeneration, unstableGeneration);
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(rightSibling);){
            TreeNode.goTo(rightSiblingCursor, "right sibling", rightSibling);
            this.bTreeNode.setChildAt(rightSiblingCursor, childPointer, 0, stableGeneration, unstableGeneration);
        }
    }

    private RemoveResult removeFromLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, TreeNode.ValueHolder<VALUE> into, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCount = TreeNode.keyCount(cursor);
        int search = this.search(cursor, TreeNode.Type.LEAF, key, this.readKey, keyCount, cursorContext);
        int pos = KeySearch.positionOf(search);
        boolean hit = KeySearch.isHit(search);
        if (!hit) {
            return RemoveResult.NOT_FOUND;
        }
        this.bTreeNode.valueAt(cursor, into, pos, cursorContext);
        if (!this.coordination.beforeRemovalFromLeaf(this.bTreeNode.totalSpaceOfKeyValue(key, into.value))) {
            return RemoveResult.FAIL;
        }
        this.createSuccessorIfNeeded(cursor, structurePropagation, StructurePropagation.UPDATE_MID_CHILD, stableGeneration, unstableGeneration);
        keyCount = this.simplyRemoveFromLeaf(cursor, keyCount, pos, stableGeneration, unstableGeneration, cursorContext);
        if (this.bTreeNode.leafUnderflow(cursor, keyCount)) {
            this.underflowInLeaf(cursor, structurePropagation, keyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        return RemoveResult.REMOVED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void underflowInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.coordination.beforeUnderflowInLeaf(cursor.getCurrentPageId());
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNode.isNode(leftSibling)) {
            try (PageCursor leftSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(leftSibling));){
                leftSiblingCursor.next();
                int leftSiblingKeyCount = TreeNode.keyCount(leftSiblingCursor);
                int keysToRebalance = this.bTreeNode.canRebalanceLeaves(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount);
                if (keysToRebalance > 0) {
                    this.createSuccessorIfNeeded(leftSiblingCursor, structurePropagation, StructurePropagation.UPDATE_LEFT_CHILD, stableGeneration, unstableGeneration);
                    this.rebalanceLeaf(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, keysToRebalance, structurePropagation, cursorContext);
                    return;
                }
                if (keysToRebalance != -1) return;
                this.mergeFromLeftSiblingLeaf(cursor, leftSiblingCursor, structurePropagation, keyCount, leftSiblingKeyCount, stableGeneration, unstableGeneration, cursorContext, CursorCreator.bind(leftSiblingCursor));
                return;
            }
        }
        if (!TreeNode.isNode(rightSibling)) return;
        try (PageCursor rightSiblingCursor = cursor.openLinkedCursor(GenerationSafePointerPair.pointer(rightSibling));){
            rightSiblingCursor.next();
            int rightSiblingKeyCount = TreeNode.keyCount(rightSiblingCursor);
            if (!this.bTreeNode.canMergeLeaves(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount)) return;
            this.createSuccessorIfNeeded(rightSiblingCursor, structurePropagation, StructurePropagation.UPDATE_RIGHT_CHILD, stableGeneration, unstableGeneration);
            this.mergeToRightSiblingLeaf(cursor, rightSiblingCursor, structurePropagation, keyCount, rightSiblingKeyCount, stableGeneration, unstableGeneration, cursorContext, CursorCreator.bind(rightSiblingCursor));
            return;
        }
    }

    private static void connectLeftAndRightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) throws IOException {
        long currentId = cursor.getCurrentPageId();
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling", leftSibling);
            TreeNode.setRightSibling(cursor, rightSibling, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling", rightSibling);
            TreeNode.setLeftSibling(cursor, leftSibling, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "back to origin after repointing siblings", currentId);
    }

    private void mergeToRightSiblingLeaf(PageCursor cursor, PageCursor rightSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext, CursorCreator linkedCursorCreator) throws IOException {
        assert (rightSiblingKeyCount > 0) : "trying to read the last key from the empty leaf";
        this.bTreeNode.keyAt(rightSiblingCursor, structurePropagation.rightKey, rightSiblingKeyCount - 1, TreeNode.Type.LEAF, cursorContext);
        this.merge(cursor, keyCount, rightSiblingCursor, rightSiblingKeyCount, stableGeneration, unstableGeneration, linkedCursorCreator);
        structurePropagation.hasMidChildUpdate = true;
        structurePropagation.midChild = rightSiblingCursor.getCurrentPageId();
        structurePropagation.hasRightKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void mergeFromLeftSiblingLeaf(PageCursor cursor, PageCursor leftSiblingCursor, StructurePropagation<KEY> structurePropagation, int keyCount, int leftSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext, CursorCreator linkedCursorCreator) throws IOException {
        assert (leftSiblingKeyCount > 0) : "trying to read the first key from the empty leaf";
        this.bTreeNode.keyAt(leftSiblingCursor, structurePropagation.leftKey, 0, TreeNode.Type.LEAF, cursorContext);
        this.merge(leftSiblingCursor, leftSiblingKeyCount, cursor, keyCount, stableGeneration, unstableGeneration, linkedCursorCreator);
        structurePropagation.hasLeftChildUpdate = true;
        structurePropagation.leftChild = cursor.getCurrentPageId();
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.BUBBLE;
    }

    private void merge(PageCursor leftSiblingCursor, int leftSiblingKeyCount, PageCursor rightSiblingCursor, int rightSiblingKeyCount, long stableGeneration, long unstableGeneration, CursorCreator linkedCursorCreator) throws IOException {
        this.bTreeNode.copyKeyValuesFromLeftToRight(leftSiblingCursor, leftSiblingKeyCount, rightSiblingCursor, rightSiblingKeyCount);
        TreeNode.setSuccessor(leftSiblingCursor, rightSiblingCursor.getCurrentPageId(), stableGeneration, unstableGeneration);
        InternalTreeLogic.connectLeftAndRightSibling(leftSiblingCursor, stableGeneration, unstableGeneration);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, leftSiblingCursor.getCurrentPageId(), linkedCursorCreator);
    }

    private void rebalanceLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int numberOfKeysToMove, StructurePropagation<KEY> structurePropagation, CursorContext cursorContext) {
        this.bTreeNode.moveKeyValuesFromLeftToRight(leftCursor, leftKeyCount, rightCursor, rightKeyCount, leftKeyCount - numberOfKeysToMove);
        structurePropagation.hasLeftKeyReplace = true;
        structurePropagation.keyReplaceStrategy = StructurePropagation.KeyReplaceStrategy.REPLACE;
        this.bTreeNode.keyAt(rightCursor, structurePropagation.leftKey, 0, TreeNode.Type.LEAF, cursorContext);
    }

    private int simplyRemoveFromLeaf(PageCursor cursor, int keyCount, int pos, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyCount = this.bTreeNode.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
        TreeNode.setKeyCount(cursor, newKeyCount);
        return newKeyCount;
    }

    private void createSuccessorIfNeeded(PageCursor cursor, StructurePropagation<KEY> structurePropagation, StructurePropagation.StructureUpdate structureUpdate, long stableGeneration, long unstableGeneration) throws IOException {
        long oldId = cursor.getCurrentPageId();
        long nodeGeneration = TreeNode.generation(cursor);
        if (nodeGeneration == unstableGeneration) {
            return;
        }
        long successorId = this.idProvider.acquireNewId(stableGeneration, unstableGeneration, CursorCreator.bind(cursor));
        try (PageCursor successorCursor = cursor.openLinkedCursor(successorId);){
            TreeNode.goTo(successorCursor, "successor", successorId);
            cursor.copyTo(0, successorCursor, 0, cursor.getPagedFile().payloadSize());
            TreeNode.setGeneration(successorCursor, unstableGeneration);
            TreeNode.setSuccessor(successorCursor, 0L, stableGeneration, unstableGeneration);
        }
        TreeNode.setSuccessor(cursor, successorId, stableGeneration, unstableGeneration);
        long leftSibling = TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkLeftSiblingPointer(leftSibling, true, cursor, stableGeneration, unstableGeneration);
        long rightSibling = TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        InternalTreeLogic.checkRightSiblingPointer(rightSibling, true, cursor, stableGeneration, unstableGeneration);
        if (TreeNode.isNode(leftSibling)) {
            TreeNode.goTo(cursor, "left sibling in split", leftSibling);
            TreeNode.setRightSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            TreeNode.goTo(cursor, "right sibling in split", rightSibling);
            TreeNode.setLeftSibling(cursor, successorId, stableGeneration, unstableGeneration);
        }
        TreeNode.goTo(cursor, "successor", successorId);
        structureUpdate.update(structurePropagation, successorId);
        this.idProvider.releaseId(stableGeneration, unstableGeneration, oldId, CursorCreator.bind(cursor));
    }

    private static <KEY, VALUE> void checkChildPointer(long childPointer, PageCursor cursor, int childPos, TreeNode<KEY, VALUE> bTreeNode, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(childPointer, false, cursor.getCurrentPageId(), GBPPointerType.child(childPos), stableGeneration, unstableGeneration, cursor, bTreeNode.childOffset(childPos));
    }

    private static void checkRightSiblingPointer(long siblingPointer, boolean allowNoNode, PageCursor cursor, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(siblingPointer, allowNoNode, cursor.getCurrentPageId(), "RIGHT_SIBLING", stableGeneration, unstableGeneration, cursor, 10);
    }

    private static void checkLeftSiblingPointer(long siblingPointer, boolean allowNoNode, PageCursor cursor, long stableGeneration, long unstableGeneration) {
        PointerChecking.checkPointer(siblingPointer, allowNoNode, cursor.getCurrentPageId(), "LEFT_SIBLING", stableGeneration, unstableGeneration, cursor, 34);
    }

    private static class Level<KEY> {
        private final Comparator<KEY> layout;
        private long treeNodeId;
        private int childPos;
        private final KEY lower;
        private boolean lowerIsOpenEnded;
        private final KEY upper;
        private boolean upperIsOpenEnded;

        Level(Layout<KEY, ?> layout) {
            this.layout = layout;
            this.lower = layout.newKey();
            this.upper = layout.newKey();
        }

        boolean covers(KEY key) {
            boolean insideLower = this.lowerIsOpenEnded || this.layout.compare(key, this.lower) >= 0;
            boolean insideHigher = this.upperIsOpenEnded || this.layout.compare(key, this.upper) < 0;
            return insideLower && insideHigher;
        }
    }

    private static enum InsertResult {
        NO_SPLIT,
        SPLIT,
        SPLIT_FAIL;

    }

    static enum RemoveResult {
        NOT_FOUND,
        REMOVED,
        FAIL;

    }
}

