/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Arrays;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.index.internal.gbptree.TreeNodeLatchService;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.io.pagecache.PageCursor;

class LatchCrabbingCoordination
implements TreeWriterCoordination {
    static final int DEFAULT_RESET_FREQUENCY = 20;
    private final TreeNodeLatchService latchService;
    private final int leafUnderflowThreshold;
    private final int resetFrequency;
    private DepthData[] dataByDepth = new DepthData[10];
    private int depth = -1;
    private boolean pessimistic;
    private int operationCounter;
    private PageCursor cursor;
    private static final boolean KEEP_STATS = false;

    LatchCrabbingCoordination(TreeNodeLatchService latchService, int leafUnderflowThreshold, int resetFrequency) {
        this.latchService = latchService;
        this.leafUnderflowThreshold = leafUnderflowThreshold;
        this.resetFrequency = resetFrequency;
    }

    @Override
    public void initialize(PageCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public boolean checkForceReset() {
        boolean result;
        boolean bl = result = this.pessimistic || this.operationCounter >= this.resetFrequency;
        if (result) {
            this.operationCounter = 0;
        }
        return result;
    }

    @Override
    public void beginOperation() {
        LatchCrabbingCoordination.inc(Stat.TOTAL_OPERATIONS);
        this.pessimistic = false;
        ++this.operationCounter;
    }

    @Override
    public void beforeTraversingToChild(long childTreeNodeId, int childPos) {
        DepthData depthData;
        ++this.depth;
        if (this.depth >= this.dataByDepth.length) {
            this.dataByDepth = Arrays.copyOf(this.dataByDepth, this.dataByDepth.length * 2);
        }
        if ((depthData = this.dataByDepth[this.depth]) == null) {
            depthData = this.dataByDepth[this.depth] = new DepthData();
        }
        LongSpinLatch latch = this.getLatch(childTreeNodeId, depthData);
        if (this.pessimistic) {
            latch.acquireWrite();
        } else {
            latch.acquireRead();
        }
        depthData.latchTypeIsWrite = this.pessimistic;
        depthData.childPos = childPos;
    }

    private LongSpinLatch getLatch(long childTreeNodeId, DepthData data) {
        LongSpinLatch latch = data.latch;
        if (latch != null) {
            if (latch.treeNodeId() == childTreeNodeId) {
                return latch;
            }
            data.derefLatch();
        }
        data.latch = this.latchService.latch(childTreeNodeId);
        return data.latch;
    }

    @Override
    public boolean arrivedAtChild(boolean isInternal, int availableSpace, boolean isStable, int keyCount) {
        DepthData depthData = this.dataByDepth[this.depth];
        depthData.availableSpace = availableSpace;
        depthData.isStable = isStable;
        depthData.keyCount = keyCount;
        if (isInternal || this.pessimistic) {
            return true;
        }
        boolean upgraded = this.tryUpgradeReadLatchToWrite(this.depth);
        if (!upgraded) {
            LatchCrabbingCoordination.inc(Stat.FAIL_LEAF_UPGRADE);
            return false;
        }
        if (isStable) {
            if (depthData.positionedAtTheEdge()) {
                LatchCrabbingCoordination.inc(Stat.FAIL_SUCCESSOR_SIBLING);
                return false;
            }
            return this.tryUpgradeUnstableParentReadLatchToWrite();
        }
        return true;
    }

    @Override
    public void updateChildInformation(int availableSpace, int keyCount) {
        DepthData depthData = this.dataByDepth[this.depth];
        depthData.availableSpace = availableSpace;
        depthData.keyCount = keyCount;
    }

    @Override
    public boolean beforeSplittingLeaf(int bubbleEntrySize) {
        boolean parentSafe;
        LatchCrabbingCoordination.inc(Stat.LEAF_SPLITS);
        if (this.pessimistic) {
            return true;
        }
        DepthData parent = this.depth > 0 ? this.dataByDepth[this.depth - 1] : null;
        boolean bl = parentSafe = parent != null && parent.availableSpace - bubbleEntrySize >= 0;
        if (!parentSafe) {
            LatchCrabbingCoordination.inc(Stat.FAIL_LEAF_SPLIT_PARENT_UNSAFE);
            return false;
        }
        return this.tryUpgradeUnstableParentReadLatchToWrite();
    }

    @Override
    public boolean beforeRemovalFromLeaf(int sizeOfLeafEntryToRemove) {
        boolean leafWillUnderflow;
        if (this.pessimistic) {
            return true;
        }
        int availableSpaceAfterRemoval = this.dataByDepth[this.depth].availableSpace + sizeOfLeafEntryToRemove;
        boolean bl = leafWillUnderflow = availableSpaceAfterRemoval > this.leafUnderflowThreshold;
        if (leafWillUnderflow) {
            LatchCrabbingCoordination.inc(Stat.FAIL_LEAF_UNDERFLOW);
            return false;
        }
        return true;
    }

    @Override
    public void beforeSplitInternal(long treeNodeId) {
        if (!this.pessimistic) {
            throw new IllegalStateException(String.format("Unexpected split of internal node [%d] in optimistic mode", treeNodeId));
        }
    }

    @Override
    public void beforeUnderflowInLeaf(long treeNodeId) {
        if (!this.pessimistic) {
            throw new IllegalStateException(String.format("Unexpected underflow of leaf node [%d] in optimistic mode", treeNodeId));
        }
    }

    @Override
    public void up() {
        this.releaseLatchAtDepth(this.depth--);
    }

    @Override
    public void reset() {
        while (this.depth >= 0) {
            this.up();
        }
        if (this.cursor != null) {
            this.cursor.unpin();
        }
    }

    @Override
    public void flipToPessimisticMode() {
        this.reset();
        this.pessimistic = true;
        LatchCrabbingCoordination.inc(Stat.PESSIMISTIC);
    }

    @Override
    public void close() {
        this.reset();
        for (DepthData depthData : this.dataByDepth) {
            if (depthData == null) break;
            depthData.derefLatch();
        }
    }

    private boolean tryUpgradeUnstableParentReadLatchToWrite() {
        if (this.depth == 0 || this.dataByDepth[this.depth - 1].isStable) {
            LatchCrabbingCoordination.inc(Stat.FAIL_PARENT_NEEDS_SUCCESSOR);
            return false;
        }
        boolean upgraded = this.tryUpgradeReadLatchToWrite(this.depth - 1);
        if (!upgraded) {
            LatchCrabbingCoordination.inc(Stat.FAIL_PARENT_UPGRADE);
        }
        return upgraded;
    }

    private boolean tryUpgradeReadLatchToWrite(int depth) {
        if (depth < 0) {
            return false;
        }
        DepthData depthData = this.dataByDepth[depth];
        if (!depthData.latchTypeIsWrite) {
            if (!depthData.latch.tryUpgradeToWrite()) {
                return false;
            }
            depthData.latchTypeIsWrite = true;
        }
        return true;
    }

    private void releaseLatchAtDepth(int depth) {
        DepthData depthData = this.dataByDepth[depth];
        if (depthData.latchTypeIsWrite) {
            depthData.latch.releaseWrite();
        } else {
            depthData.latch.releaseRead();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.format("LATCHES %s depth:%d%n", this.pessimistic ? "PESSIMISTIC" : "OPTIMISTIC", this.depth));
        for (int i = 0; i <= this.depth; ++i) {
            LongSpinLatch latch = this.dataByDepth[i].latch;
            builder.append(this.dataByDepth[i].latchTypeIsWrite ? "W" : "R").append(latch.toString()).append(String.format("%n", new Object[0]));
        }
        return builder.toString();
    }

    private static void inc(Stat stat) {
    }

    static void dumpStats() {
        System.out.println("Stats for GBPTree parallel writes locking:");
        Stat[] stats = Stat.values();
        Arrays.sort(stats, (s1, s2) -> Long.compare(s2.count.sum(), s1.count.sum()));
        for (Stat stat : stats) {
            long sum = stat.count.sum();
            System.out.printf("  %s: %d", stat.name(), sum);
            if (stat.comparedTo != null) {
                long comparedToSum = stat.comparedTo.count.sum();
                double percentage = 100.0 * (double)sum / (double)comparedToSum;
                System.out.printf(" (%.4f%% of %s)", percentage, stat.comparedTo.name());
            }
            System.out.println();
        }
    }

    private static class DepthData {
        private LongSpinLatch latch;
        private boolean latchTypeIsWrite;
        private int availableSpace;
        private int keyCount;
        private int childPos;
        private boolean isStable;

        private DepthData() {
        }

        boolean positionedAtTheEdge() {
            return this.childPos == 0 || this.childPos == this.keyCount;
        }

        void derefLatch() {
            if (this.latch != null) {
                this.latch.deref();
                this.latch = null;
            }
        }
    }

    private static enum Stat {
        TOTAL_OPERATIONS,
        PESSIMISTIC(TOTAL_OPERATIONS),
        LEAF_SPLITS(TOTAL_OPERATIONS),
        FAIL_LEAF_UPGRADE(PESSIMISTIC),
        FAIL_LEAF_SPLIT_PARENT_UNSAFE(PESSIMISTIC),
        FAIL_LEAF_UNDERFLOW(PESSIMISTIC),
        FAIL_SUCCESSOR_SIBLING(PESSIMISTIC),
        FAIL_PARENT_NEEDS_SUCCESSOR(PESSIMISTIC),
        FAIL_PARENT_UPGRADE(PESSIMISTIC);

        private final Stat comparedTo;
        private final LongAdder count = new LongAdder();

        private Stat() {
            this(null);
        }

        private Stat(Stat comparedTo) {
            this.comparedTo = comparedTo;
        }
    }
}

