/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;

class LongSpinLatch {
    private static final long MAX_SPIN_NANOS = TimeUnit.MICROSECONDS.toNanos(500L);
    private static final long PARK_NANOS = TimeUnit.MICROSECONDS.toNanos(100L);
    private static final long TEST_FAILED = -1L;
    private static final long DEAD = -2L;
    private static final long WRITE_LOCK_MASK = 32768L;
    private static final long READ_LOCK_MASK = 32767L;
    private static final long LOCK_MASK = 65535L;
    private static final long REF_COUNT_MASK = 0x7FFF0000L;
    private static final int REF_COUNT_SHIFT = 16;
    private static final long DEAD_MASK = 0x80000000L;
    private static final LongPredicate ALWAYS_TRUE = bits -> true;
    private static final LongPredicate NO_WRITE_LOCK = bits -> (bits & 0x8000L) == 0L;
    private static final LongPredicate NO_WRITE_ONLY_MY_READ_LOCK = bits -> (bits & 0xFFFFL) == 1L;
    private static final LongPredicate NO_READ_LOCK = bits -> (bits & 0x7FFFL) == 0L;
    private static final LongToLongFunction ACQUIRE_READ_LOCK = (LongToLongFunction & Serializable)bits -> bits + 1L;
    private static final LongToLongFunction RELEASE_READ_LOCK = (LongToLongFunction & Serializable)bits -> bits - 1L;
    private static final LongToLongFunction ACQUIRE_WRITE_LOCK = (LongToLongFunction & Serializable)bits -> bits | 0x8000L;
    private static final LongToLongFunction ACQUIRE_WRITE_LOCK_CLEAR_READ_LOCKS = (LongToLongFunction & Serializable)bits -> bits & 0xFFFFFFFFFFFF0000L | 0x8000L;
    private static final LongToLongFunction RELEASE_WRITE_LOCK = (LongToLongFunction & Serializable)bits -> bits & 0xFFFFFFFFFFFF7FFFL;
    private static final LongToLongFunction NO_TRANSFORM = (LongToLongFunction & Serializable)bits -> bits;
    private final long initialTreeNodeId;
    private final LongConsumer removeAction;
    private volatile long lockBits;
    private static final VarHandle LOCK_BITS;

    LongSpinLatch(long initialTreeNodeId, LongConsumer removeAction) {
        this.initialTreeNodeId = initialTreeNodeId;
        this.removeAction = removeAction;
    }

    boolean ref() {
        long result = this.spinTransform(ALWAYS_TRUE, (LongToLongFunction & Serializable)bits -> {
            long refCount = (bits & 0x7FFF0000L) >>> 16;
            assert ((++refCount << 16 & 0x7FFF0000L) == refCount << 16);
            return bits & 0xFFFFFFFF8000FFFFL | refCount << 16;
        }, false, true);
        return result != -2L;
    }

    void deref() {
        boolean lastRef;
        long result = this.spinTransform(ALWAYS_TRUE, (LongToLongFunction & Serializable)bits -> {
            long refCount = (bits & 0x7FFF0000L) >>> 16;
            assert (--refCount >= 0L);
            if (refCount == 0L) {
                assert ((bits & 0xFFFFL) == 0L);
                bits |= 0x80000000L;
            }
            return bits & 0xFFFFFFFF8000FFFFL | refCount << 16;
        }, false, false);
        boolean bl = lastRef = (result & 0x80000000L) != 0L;
        if (lastRef) {
            this.removeAction.accept(this.initialTreeNodeId);
        }
    }

    int acquireRead() {
        long transformed = this.spinTransform(NO_WRITE_LOCK, ACQUIRE_READ_LOCK, false, false);
        return Math.toIntExact(transformed & 0x7FFFL);
    }

    int releaseRead() {
        long transformed = this.spinTransform(ALWAYS_TRUE, RELEASE_READ_LOCK, false, false);
        return Math.toIntExact(transformed & 0x7FFFL);
    }

    boolean tryUpgradeToWrite() {
        return this.spinTransform(NO_WRITE_ONLY_MY_READ_LOCK, ACQUIRE_WRITE_LOCK_CLEAR_READ_LOCKS, true, false) != -1L;
    }

    boolean acquireWrite() {
        this.spinTransform(NO_WRITE_LOCK, ACQUIRE_WRITE_LOCK, false, false);
        this.spinTransform(NO_READ_LOCK, NO_TRANSFORM, false, false);
        return true;
    }

    boolean tryAcquireWrite() {
        return this.spinTransform(NO_WRITE_LOCK, ACQUIRE_WRITE_LOCK, true, false) != -1L;
    }

    void releaseWrite() {
        this.spinTransform(ALWAYS_TRUE, RELEASE_WRITE_LOCK, false, false);
    }

    long treeNodeId() {
        return this.initialTreeNodeId;
    }

    private long spinTransform(LongPredicate tester, LongToLongFunction transformer, boolean breakOnTestFail, boolean allowOnDead) {
        long transformedBits;
        long timedWaitStartTime = 0L;
        while (true) {
            long bits;
            if (((bits = this.volatileGetBits()) & 0x80000000L) != 0L) {
                if (!allowOnDead) {
                    throw new IllegalStateException("Tried to transform a dead latch");
                }
                return -2L;
            }
            if (!tester.test(bits)) {
                if (breakOnTestFail) {
                    return -1L;
                }
                if (timedWaitStartTime == 0L) {
                    timedWaitStartTime = System.nanoTime() + MAX_SPIN_NANOS;
                } else if (System.nanoTime() > timedWaitStartTime) {
                    LockSupport.parkNanos(PARK_NANOS);
                }
                Thread.onSpinWait();
                continue;
            }
            transformedBits = transformer.applyAsLong(bits);
            if (LOCK_BITS.compareAndSet(this, bits, transformedBits)) break;
        }
        return transformedBits;
    }

    private long volatileGetBits() {
        return LOCK_BITS.getVolatile(this);
    }

    public String toString() {
        long bits = this.volatileGetBits();
        return String.format("Lock[%d,w:%b,r:%d]", this.initialTreeNodeId, (bits & 0x8000L) != 0L, bits & 0x7FFFL);
    }

    static {
        try {
            LOCK_BITS = MethodHandles.lookup().findVarHandle(LongSpinLatch.class, "lockBits", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

