/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;

abstract class RootLayer<ROOT_KEY, DATA_KEY, DATA_VALUE>
implements TreeRootExchange {
    protected final RootLayerSupport support;
    protected final TreeNodeSelector treeNodeSelector;
    protected volatile Root root;
    private volatile LongSpinLatch rootLatch;

    RootLayer(RootLayerSupport support, TreeNodeSelector treeNodeSelector) {
        this.support = support;
        this.treeNodeSelector = treeNodeSelector;
    }

    abstract void initializeAfterCreation(Root var1, CursorContext var2) throws IOException;

    abstract void initialize(Root var1, CursorContext var2) throws IOException;

    abstract void create(ROOT_KEY var1, CursorContext var2) throws IOException;

    abstract void delete(ROOT_KEY var1, CursorContext var2) throws IOException;

    abstract DataTree<DATA_KEY, DATA_VALUE> access(ROOT_KEY var1);

    @Override
    public Root getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Root root) {
        if (this.rootLatch != null) {
            this.rootLatch.deref();
        }
        this.root = root;
        this.rootLatch = this.support.latchService().latch(root.id());
    }

    abstract void visit(GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> var1, CursorContext var2) throws IOException;

    abstract void consistencyCheck(GBPTreeConsistencyChecker.ConsistencyCheckState var1, GBPTreeConsistencyCheckVisitor var2, boolean var3, CursorContextFactory var4, int var5) throws IOException;

    abstract int keyValueSizeCap();

    abstract int inlineKeyValueSizeCap();

    abstract void visitAllDataTreeRoots(CursorContext var1, TreeRootsVisitor<ROOT_KEY> var2) throws IOException;

    abstract <K, V> void unsafe(GBPTreeUnsafe<K, V> var1, boolean var2, CursorContext var3) throws IOException;

    abstract CrashGenerationCleaner createCrashGenerationCleaner(CursorContextFactory var1);

    abstract void printNode(PageCursor var1, CursorContext var2);

    static double splitRatio(int flags) {
        if ((flags & 2) != 0) {
            return 1.0;
        }
        if ((flags & 4) != 0) {
            return 0.0;
        }
        return 0.5;
    }

    @FunctionalInterface
    public static interface TreeRootsVisitor<ROOT_KEY> {
        public boolean accept(ROOT_KEY var1);
    }
}

