/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.StringJoiner;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.util.VisibleForTesting;

public class TreeNodeDynamicSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    public static final int OFFSET_SIZE = 2;
    public static final int KEY_OFFSET_AND_CHILD_SIZE = 26;
    public static final int BYTE_POS_ALLOC_OFFSET = 82;
    public static final int BYTE_POS_DEAD_SPACE = 84;
    public static final int HEADER_LENGTH_DYNAMIC = 86;
    static final byte FORMAT_IDENTIFIER = 3;
    static final byte FORMAT_VERSION = 0;
    private static final int FIXED_MAX_KEY_VALUE_SIZE_CAP = 8175;
    @VisibleForTesting
    static final int SUPPORTED_PAGE_SIZE_LIMIT = (int)ByteUnit.kibiBytes((long)64L);
    private static final int LEAST_NUMBER_OF_ENTRIES_PER_PAGE = 2;
    private static final int MINIMUM_ENTRY_SIZE_CAP = 64;
    private final int inlineKeyValueSizeCap;
    private final int keyValueSizeCap;
    private final int totalSpace;
    private final int halfSpace;
    final OffloadStore<KEY, VALUE> offloadStore;
    private final int maxKeyCount;

    TreeNodeDynamicSize(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore) {
        super(payloadSize, layout);
        assert (payloadSize < SUPPORTED_PAGE_SIZE_LIMIT) : "Only payload size less then " + SUPPORTED_PAGE_SIZE_LIMIT + " bytes supported";
        this.totalSpace = payloadSize - 86;
        this.maxKeyCount = this.totalSpace / 3;
        this.offloadStore = offloadStore;
        this.halfSpace = this.totalSpace >> 1;
        this.inlineKeyValueSizeCap = TreeNodeDynamicSize.inlineKeyValueSizeCap(payloadSize);
        this.keyValueSizeCap = TreeNodeDynamicSize.keyValueSizeCapFromPageSize(payloadSize);
        if (this.inlineKeyValueSizeCap < 64) {
            throw new MetadataMismatchException(String.format("We need to fit at least %d key-value entries per page in leaves. To do that a key-value entry can be at most %dB with current page size of %dB. We require this cap to be at least %dB.", 2, this.inlineKeyValueSizeCap, payloadSize, 8));
        }
    }

    @VisibleForTesting
    public static int keyValueSizeCapFromPageSize(int pageSize) {
        return Math.min(8175, OffloadStoreImpl.keyValueSizeCapFromPageSize(pageSize));
    }

    private static int inlineKeyValueSizeCap(int payloadSize) {
        int totalOverhead = 6;
        int capToFitNumberOfEntriesPerPage = (payloadSize - 86) / 2 - totalOverhead;
        return Math.min(4095, capToFitNumberOfEntriesPerPage);
    }

    @Override
    void writeAdditionalHeader(PageCursor cursor) {
        this.setAllocOffset(cursor, this.payloadSize);
        this.setDeadSpace(cursor, 0);
    }

    @Override
    long offloadIdAt(PageCursor cursor, int pos, TreeNode.Type type) {
        this.placeCursorAtActualKey(cursor, pos, type);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            return DynamicSizeUtil.readOffloadId(cursor);
        }
        return -1L;
    }

    @Override
    KEY keyAt(PageCursor cursor, KEY into, int pos, TreeNode.Type type, CursorContext cursorContext) {
        this.placeCursorAtActualKey(cursor, pos, type);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                this.offloadStore.readKey(offloadId, into, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read key from offload, cause: " + e.getMessage());
            }
        } else {
            int valueSize;
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            if (this.keyValueSizeTooLarge(keySize, valueSize = DynamicSizeUtil.extractValueSize(keyValueSize)) || keySize < 0 || valueSize < 0) {
                this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
                return into;
            }
            this.layout.readKey(cursor, into, keySize);
        }
        return into;
    }

    @Override
    void keyValueAt(PageCursor cursor, KEY intoKey, TreeNode.ValueHolder<VALUE> intoValue, int pos, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        intoValue.defined = true;
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                this.offloadStore.readKeyValue(offloadId, intoKey, intoValue.value, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read keyValue from offload, cause: " + e.getMessage());
            }
        } else {
            if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0 || valueSize < 0) {
                this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
                return;
            }
            this.layout.readKey(cursor, intoKey, keySize);
            this.layout.readValue(cursor, intoValue.value, valueSize);
        }
    }

    @Override
    void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyOffset;
        int currentKeyOffset = this.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        if (this.canInline(keySize)) {
            newKeyOffset = currentKeyOffset - keySize - DynamicSizeUtil.getOverhead(keySize, 0, false);
            cursor.setOffset(newKeyOffset);
            DynamicSizeUtil.putKeyValueSize(cursor, keySize, 0);
            this.layout.writeKey(cursor, key);
        } else {
            newKeyOffset = currentKeyOffset - DynamicSizeUtil.getOverhead(keySize, 0, true);
            cursor.setOffset(newKeyOffset);
            DynamicSizeUtil.putOffloadMarker(cursor);
            long offloadId = this.offloadStore.writeKey(key, stableGeneration, unstableGeneration, cursorContext);
            DynamicSizeUtil.putOffloadId(cursor, offloadId);
        }
        this.setAllocOffset(cursor, newKeyOffset);
        int childPos = pos + 1;
        int childOffset = this.childOffset(childPos);
        TreeNodeDynamicSize.insertSlotsAt(cursor, pos, 1, keyCount, TreeNodeDynamicSize.keyPosOffsetInternal(0), 26);
        cursor.setOffset(TreeNodeDynamicSize.keyPosOffsetInternal(pos));
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)newKeyOffset);
        TreeNodeDynamicSize.writeChild(cursor, child, stableGeneration, unstableGeneration, childPos, childOffset);
    }

    @Override
    void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyValueOffset;
        int valueSize;
        int currentKeyValueOffset = this.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        if (this.canInline(keySize + (valueSize = this.layout.valueSize(value)))) {
            newKeyValueOffset = currentKeyValueOffset - keySize - valueSize - DynamicSizeUtil.getOverhead(keySize, valueSize, false);
            cursor.setOffset(newKeyValueOffset);
            DynamicSizeUtil.putKeyValueSize(cursor, keySize, valueSize);
            this.layout.writeKey(cursor, key);
            this.layout.writeValue(cursor, value);
        } else {
            newKeyValueOffset = currentKeyValueOffset - DynamicSizeUtil.getOverhead(keySize, valueSize, true);
            cursor.setOffset(newKeyValueOffset);
            DynamicSizeUtil.putOffloadMarker(cursor);
            long offloadId = this.offloadStore.writeKeyValue(key, value, stableGeneration, unstableGeneration, cursorContext);
            DynamicSizeUtil.putOffloadId(cursor, offloadId);
        }
        this.setAllocOffset(cursor, newKeyValueOffset);
        TreeNodeDynamicSize.insertSlotsAt(cursor, pos, 1, keyCount, TreeNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        cursor.setOffset(TreeNodeDynamicSize.keyPosOffsetLeaf(pos));
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)newKeyValueOffset);
    }

    @Override
    int removeKeyValueAt(PageCursor cursor, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize, offload));
        TreeNodeDynamicSize.removeSlotAt(cursor, pos, keyCount, TreeNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        return keyCount - 1;
    }

    @Override
    void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, keyPos, TreeNode.Type.INTERNAL);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0, offload));
        TreeNodeDynamicSize.removeSlotAt(cursor, keyPos, keyCount, TreeNodeDynamicSize.keyPosOffsetInternal(0), 26);
        TreeNodeDynamicSize.zeroPad(cursor, TreeNodeDynamicSize.keyPosOffsetInternal(keyCount - 1), 26);
    }

    @Override
    void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, keyPos, TreeNode.Type.INTERNAL);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0, offload));
        TreeNodeDynamicSize.removeSlotAt(cursor, keyPos, keyCount, TreeNodeDynamicSize.keyPosOffsetInternal(0) - 24, 26);
        cursor.copyTo(this.childOffset(keyCount), cursor, this.childOffset(keyCount - 1), 24);
        TreeNodeDynamicSize.zeroPad(cursor, TreeNodeDynamicSize.keyPosOffsetInternal(keyCount - 1), 26);
    }

    @Override
    boolean setKeyAtInternal(PageCursor cursor, KEY key, int pos) {
        int newKeySize;
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.INTERNAL);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int oldKeySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(oldKeySize, oldValueSize)) {
            this.readUnreliableKeyValueSize(cursor, oldKeySize, oldValueSize, keyValueSize, pos);
        }
        if ((newKeySize = this.layout.keySize(key)) == oldKeySize) {
            this.layout.writeKey(cursor, key);
            return true;
        }
        return false;
    }

    @Override
    TreeNode.ValueHolder<VALUE> valueAt(PageCursor cursor, TreeNode.ValueHolder<VALUE> into, int pos, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        into.defined = true;
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                this.offloadStore.readValue(offloadId, into.value, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read value from offload, cause: " + e.getMessage());
            }
        } else {
            if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0 || valueSize < 0) {
                this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
                return into;
            }
            TreeNodeDynamicSize.progressCursor(cursor, keySize);
            this.layout.readValue(cursor, into.value, valueSize);
        }
        return into;
    }

    @Override
    boolean setValueAt(PageCursor cursor, VALUE value, int pos, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        int newValueSize = this.layout.valueSize(value);
        if (oldValueSize == newValueSize) {
            TreeNodeDynamicSize.progressCursor(cursor, keySize);
            this.layout.writeValue(cursor, value);
            return true;
        }
        return false;
    }

    static void progressCursor(PageCursor cursor, int delta) {
        cursor.setOffset(cursor.getOffset() + delta);
    }

    @Override
    void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        int childOffset = this.childOffset(pos);
        cursor.setOffset(childOffset);
        TreeNodeDynamicSize.writeChild(cursor, child, stableGeneration, unstableGeneration, pos, childOffset);
    }

    @Override
    public int keyValueSizeCap() {
        return this.keyValueSizeCap;
    }

    @Override
    public int inlineKeyValueSizeCap() {
        return this.inlineKeyValueSizeCap;
    }

    @Override
    void validateKeyValueSize(KEY key, VALUE value) {
        int valueSize;
        int keySize = this.layout.keySize(key);
        if (this.keyValueSizeTooLarge(keySize, valueSize = this.layout.valueSize(value))) {
            throw new IllegalArgumentException("Index key-value size it too large. Please see index documentation for limitations.");
        }
    }

    @Override
    boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    @Override
    boolean reasonableChildCount(int childCount) {
        return this.reasonableKeyCount(childCount);
    }

    @Override
    int childOffset(int pos) {
        return TreeNodeDynamicSize.keyPosOffsetInternal(pos) - 24;
    }

    @Override
    TreeNode.Overflow internalOverflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        int allocSpace = this.getAllocSpace(cursor, currentKeyCount, TreeNode.Type.INTERNAL);
        int deadSpace = this.getDeadSpace(cursor);
        int neededSpace = this.totalSpaceOfKeyChild(newKey);
        return neededSpace <= allocSpace ? TreeNode.Overflow.NO : (neededSpace <= allocSpace + deadSpace ? TreeNode.Overflow.NO_NEED_DEFRAG : TreeNode.Overflow.YES);
    }

    @Override
    TreeNode.Overflow leafOverflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        int deadSpace = this.getDeadSpace(cursor);
        int allocSpace = this.getAllocSpace(cursor, currentKeyCount, TreeNode.Type.LEAF);
        int neededSpace = this.totalSpaceOfKeyValue(newKey, newValue);
        return neededSpace <= allocSpace ? TreeNode.Overflow.NO : (neededSpace <= allocSpace + deadSpace ? TreeNode.Overflow.NO_NEED_DEFRAG : TreeNode.Overflow.YES);
    }

    @Override
    int availableSpace(PageCursor cursor, int currentKeyCount, boolean isInternal) {
        int deadSpace = this.getDeadSpace(cursor);
        int allocSpace = this.getAllocSpace(cursor, currentKeyCount, isInternal ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF);
        return allocSpace + deadSpace;
    }

    @Override
    int leafUnderflowThreshold() {
        return this.halfSpace;
    }

    @Override
    void defragmentLeaf(PageCursor cursor) {
        this.doDefragment(cursor, TreeNode.Type.LEAF, TreeNodeDynamicSize.keyCount(cursor));
    }

    @Override
    void defragmentInternal(PageCursor cursor) {
        this.doDefragment(cursor, TreeNode.Type.INTERNAL, TreeNodeDynamicSize.keyCount(cursor));
    }

    private void doDefragment(PageCursor cursor, TreeNode.Type type, int keyCount) {
        int[] offsets = new int[keyCount];
        int[] sizes = new int[keyCount];
        this.recordAliveBlocks(cursor, keyCount, offsets, sizes);
        IntIntHashMap remappedOffsets = this.compactRight(cursor, keyCount, offsets, sizes);
        this.remapOffsets(cursor, keyCount, remappedOffsets, type);
        this.setDeadSpace(cursor, 0);
    }

    protected void recordAliveBlocks(PageCursor cursor, int keyCount, int[] offsets, int[] sizes) {
        int entrySize;
        int index = 0;
        for (int currentOffset = this.getAllocOffset(cursor); currentOffset < this.payloadSize && index < keyCount; currentOffset += entrySize) {
            cursor.setOffset(currentOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            boolean dead = DynamicSizeUtil.extractTombstone(keyValueSize);
            entrySize = keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize, offload);
            if (dead) continue;
            offsets[index] = currentOffset;
            sizes[index] = entrySize;
            ++index;
        }
        assert (index == keyCount) : "expected " + keyCount + " alive blocks, found only " + index;
    }

    private void remapOffsets(PageCursor cursor, int keyCount, IntIntHashMap remappedOffsets, TreeNode.Type type) {
        for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = TreeNodeDynamicSize.keyPosOffset(pos, type);
            cursor.setOffset(keyPosOffset);
            int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            cursor.setOffset(keyPosOffset);
            assert (remappedOffsets.containsKey(keyOffset)) : "missing mapping for offset " + keyOffset + " at pos " + pos + " key count " + keyCount + " all mappings " + remappedOffsets;
            PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)remappedOffsets.get(keyOffset));
        }
    }

    private IntIntHashMap compactRight(PageCursor cursor, int keyCount, int[] offsets, int[] sizes) {
        int targetOffset = this.payloadSize;
        IntIntHashMap remappedOffsets = new IntIntHashMap();
        for (int index = keyCount - 1; index >= 0; --index) {
            int sourceOffset = offsets[index];
            int entrySize = sizes[index];
            if (sourceOffset != (targetOffset -= entrySize)) {
                cursor.copyTo(sourceOffset, cursor, targetOffset, entrySize);
            }
            remappedOffsets.put(sourceOffset, targetOffset);
        }
        int prevAllocOffset = this.getAllocOffset(cursor);
        this.setAllocOffset(cursor, targetOffset);
        TreeNodeDynamicSize.zeroPad(cursor, prevAllocOffset, targetOffset - prevAllocOffset);
        return remappedOffsets;
    }

    @Override
    boolean leafUnderflow(PageCursor cursor, int keyCount) {
        int deadSpace;
        int allocSpace = this.getAllocSpace(cursor, keyCount, TreeNode.Type.LEAF);
        int availableSpace = allocSpace + (deadSpace = this.getDeadSpace(cursor));
        return availableSpace > this.halfSpace;
    }

    @Override
    int canRebalanceLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int prevDelta;
        int lastChunkSize;
        int rightActiveSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount, TreeNode.Type.LEAF);
        if (leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount, TreeNode.Type.LEAF)) <= this.totalSpace) {
            return -1;
        }
        if (leftActiveSpace < rightActiveSpace) {
            return 0;
        }
        int currentDelta = Math.abs(leftActiveSpace - rightActiveSpace);
        int keysToMove = 0;
        do {
            lastChunkSize = this.totalSpaceOfKeyValue(leftCursor, leftKeyCount - ++keysToMove);
            prevDelta = currentDelta;
        } while ((currentDelta = Math.abs((leftActiveSpace -= lastChunkSize) - (rightActiveSpace += lastChunkSize))) < prevDelta);
        boolean canRebalance = (leftActiveSpace += lastChunkSize) > this.halfSpace && (rightActiveSpace -= lastChunkSize) > this.halfSpace;
        return canRebalance ? --keysToMove : 0;
    }

    @Override
    boolean canMergeLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int rightActiveSpace;
        int totalSpace = this.totalSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount, TreeNode.Type.LEAF);
        return totalSpace >= leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount, TreeNode.Type.LEAF));
    }

    @Override
    int findSplitter(PageCursor cursor, int keyCount, KEY newKey, VALUE newValue, int insertPos, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        KEY rightInSplit;
        Object leftInSplit;
        int keyCountAfterInsert = keyCount + 1;
        int splitPos = this.splitPosInLeaf(cursor, insertPos, newKey, newValue, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            leftInSplit = this.keyAt(cursor, this.layout.newKey(), splitPos - 1, TreeNode.Type.LEAF, cursorContext);
            rightInSplit = newKey;
        } else {
            int rightPos = insertPos < splitPos ? splitPos - 1 : splitPos;
            rightInSplit = this.keyAt(cursor, this.layout.newKey(), rightPos, TreeNode.Type.LEAF, cursorContext);
            if (rightPos == insertPos) {
                leftInSplit = newKey;
            } else {
                int leftPos = rightPos - 1;
                leftInSplit = this.keyAt(cursor, this.layout.newKey(), leftPos, TreeNode.Type.LEAF, cursorContext);
            }
        }
        this.layout.minimalSplitter(leftInSplit, rightInSplit, newSplitter);
        return splitPos;
    }

    @Override
    void doSplitLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, int splitPos, double ratioToKeepInLeftOnSplit, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int rightKeyCount = keyCountAfterInsert - splitPos;
        if (insertPos < splitPos) {
            this.moveKeysAndValues(leftCursor, splitPos - 1, rightCursor, 0, rightKeyCount);
            this.defragmentLeaf(leftCursor);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else {
            int newInsertPos = insertPos - splitPos;
            int keysToMove = leftKeyCount - splitPos;
            this.moveKeysAndValues(leftCursor, splitPos, rightCursor, 0, keysToMove);
            this.defragmentLeaf(leftCursor);
            this.insertKeyValueAt(rightCursor, newKey, newValue, newInsertPos, keysToMove, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void doSplitInternal(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = this.splitPosInternal(leftCursor, insertPos, newKey, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, TreeNode.Type.INTERNAL, cursorContext);
        }
        int rightKeyCount = keyCountAfterInsert - splitPos - 1;
        if (insertPos < splitPos) {
            this.moveKeysAndChildren(leftCursor, splitPos, rightCursor, 0, rightKeyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos - 1, splitPos, stableGeneration, unstableGeneration, cursorContext);
            this.doDefragment(leftCursor, TreeNode.Type.INTERNAL, splitPos - 1);
            this.insertKeyAndRightChildAt(leftCursor, newKey, newRightChild, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else if (insertPos == splitPos) {
            int copyFrom = splitPos;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, false);
            this.doDefragment(leftCursor, TreeNode.Type.INTERNAL, splitPos);
            this.setChildAt(rightCursor, newRightChild, 0, stableGeneration, unstableGeneration);
        } else {
            int copyFrom = splitPos + 1;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos, splitPos + 1, stableGeneration, unstableGeneration, cursorContext);
            this.doDefragment(leftCursor, TreeNode.Type.INTERNAL, splitPos);
            this.insertKeyAndRightChildAt(rightCursor, newKey, newRightChild, insertPos - copyFrom, copyCount, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        this.defragmentLeaf(rightCursor);
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        TreeNodeDynamicSize.insertSlotsAt(rightCursor, 0, numberOfKeysToMove, rightKeyCount, TreeNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        this.moveKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeDynamicSize.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    private void moveKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int firstAllocOffset;
        int toAllocOffset = firstAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.copyRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset, true);
            toCursor.setOffset(TreeNodeDynamicSize.keyPosOffsetLeaf(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = this.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        this.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        TreeNodeDynamicSize.setKeyCount(fromCursor, fromPos);
    }

    protected int copyRawKeyValue(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset, boolean markDead) {
        this.placeCursorAtActualKey(fromCursor, fromPos, TreeNode.Type.LEAF);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
        int newRightAllocSpace = toAllocOffset - toCopy;
        fromCursor.copyTo(fromKeyOffset, toCursor, newRightAllocSpace, toCopy);
        if (markDead) {
            fromCursor.setOffset(fromKeyOffset);
            DynamicSizeUtil.putTombstone(fromCursor);
        }
        return newRightAllocSpace;
    }

    @Override
    void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.defragmentLeaf(rightCursor);
        TreeNodeDynamicSize.insertSlotsAt(rightCursor, 0, leftKeyCount, rightKeyCount, TreeNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeDynamicSize.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int toAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.copyRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset, false);
            toCursor.setOffset(TreeNodeDynamicSize.keyPosOffsetLeaf(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
    }

    private int getAllocSpace(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int allocOffset = this.getAllocOffset(cursor);
        int endOfOffsetArray = type == TreeNode.Type.LEAF ? TreeNodeDynamicSize.keyPosOffsetLeaf(keyCount) : TreeNodeDynamicSize.keyPosOffsetInternal(keyCount);
        return allocOffset - endOfOffsetArray;
    }

    private void moveKeysAndChildren(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count, boolean includeLeftMostChild) {
        int toAllocOffset;
        if (count == 0 && !includeLeftMostChild) {
            return;
        }
        int childFromOffset = includeLeftMostChild ? this.childOffset(fromPos) : this.childOffset(fromPos + 1);
        int childToOffset = this.childOffset(fromPos + count) + 24;
        int lengthInBytes = childToOffset - childFromOffset;
        int targetOffset = includeLeftMostChild ? this.childOffset(0) : this.childOffset(1);
        fromCursor.copyTo(childFromOffset, toCursor, targetOffset, lengthInBytes);
        int firstAllocOffset = toAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.transferRawKey(fromCursor, fromPos + i, toCursor, toAllocOffset);
            toCursor.setOffset(TreeNodeDynamicSize.keyPosOffsetInternal(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = this.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        this.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        TreeNodeDynamicSize.zeroPad(fromCursor, childFromOffset, lengthInBytes);
    }

    private static void zeroPad(PageCursor fromCursor, int fromOffset, int lengthInBytes) {
        fromCursor.setOffset(fromOffset);
        fromCursor.putBytes(lengthInBytes, (byte)0);
    }

    private int transferRawKey(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset) {
        this.placeCursorAtActualKey(fromCursor, fromPos, TreeNode.Type.INTERNAL);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, 0, offload) + keySize;
        fromCursor.copyTo(fromKeyOffset, toCursor, toAllocOffset -= toCopy, toCopy);
        fromCursor.setOffset(fromKeyOffset);
        DynamicSizeUtil.putTombstone(fromCursor);
        return toAllocOffset;
    }

    private int splitPosInternal(PageCursor cursor, int insertPos, KEY newKey, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = 24;
        int currentDelta = Math.abs(accumulatedLeftSpace - targetLeftSpace);
        int spaceOfNewKeyAndChild = this.totalSpaceOfKeyChild(newKey);
        int totalSpaceIncludingNewKeyAndChild = this.totalActiveSpace(cursor, keyCountAfterInsert - 1, TreeNode.Type.INTERNAL) + spaceOfNewKeyAndChild;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        do {
            int space;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos && !includedNew) {
                space = this.totalSpaceOfKeyChild(newKey);
                includedNew = true;
                --currentPos;
            } else {
                space = this.totalSpaceOfKeyChild(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += space) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKeyAndChild - accumulatedLeftSpace < this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace < this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int splitPosInLeaf(PageCursor cursor, int insertPos, KEY newKey, VALUE newValue, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = 0;
        int currentDelta = targetLeftSpace;
        int spaceOfNewKey = this.totalSpaceOfKeyValue(newKey, newValue);
        int totalSpaceIncludingNewKey = this.totalActiveSpace(cursor, keyCountAfterInsert - 1, TreeNode.Type.LEAF) + spaceOfNewKey;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        if (totalSpaceIncludingNewKey > this.totalSpace * 2) {
            throw new IllegalStateException(String.format("There's not enough space to insert new key, even when splitting the leaf. Space needed:%d, max space allowed:%d", totalSpaceIncludingNewKey, this.totalSpace * 2));
        }
        do {
            int currentSpace;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos && !includedNew) {
                currentSpace = spaceOfNewKey;
                includedNew = true;
                --currentPos;
            } else {
                currentSpace = this.totalSpaceOfKeyValue(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += currentSpace) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKey - accumulatedLeftSpace <= this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace <= this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int totalActiveSpace(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int deadSpace = this.getDeadSpace(cursor);
        int allocSpace = this.getAllocSpace(cursor, keyCount, type);
        return this.totalSpace - deadSpace - allocSpace;
    }

    @Override
    int totalSpaceOfKeyValue(KEY key, VALUE value) {
        int valueSize;
        int keySize = this.layout.keySize(key);
        boolean canInline = this.canInline(keySize + (valueSize = this.layout.valueSize(value)));
        if (canInline) {
            return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, false) + keySize + valueSize;
        }
        return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, true);
    }

    @Override
    int totalSpaceOfKeyChild(KEY key) {
        int keySize = this.layout.keySize(key);
        boolean canInline = this.canInline(keySize);
        if (canInline) {
            return 2 + DynamicSizeUtil.getOverhead(keySize, 0, false) + 24 + keySize;
        }
        return 2 + DynamicSizeUtil.getOverhead(keySize, 0, true) + 24;
    }

    @Override
    protected int totalSpaceOfKeyValue(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
    }

    private int totalSpaceOfKeyChild(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.INTERNAL);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        return 2 + DynamicSizeUtil.getOverhead(keySize, 0, offload) + 24 + keySize;
    }

    @VisibleForTesting
    void setAllocOffset(PageCursor cursor, int allocOffset) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)82, (int)allocOffset);
    }

    int getAllocOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)82);
    }

    @VisibleForTesting
    void setDeadSpace(PageCursor cursor, int deadSpace) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)84, (int)deadSpace);
    }

    @VisibleForTesting
    int getDeadSpace(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)84);
    }

    void placeCursorAtActualKey(PageCursor cursor, int pos, TreeNode.Type type) {
        int keyPosOffset = TreeNodeDynamicSize.keyPosOffset(pos, type);
        cursor.setOffset(keyPosOffset);
        int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
        if (keyOffset >= this.payloadSize || keyOffset < 86) {
            cursor.setCursorException(String.format("Tried to read key on offset=%d, headerLength=%d, pageSize=%d, pos=%d", keyOffset, 86, this.payloadSize, pos));
            return;
        }
        cursor.setOffset(keyOffset);
    }

    void readUnreliableKeyValueSize(PageCursor cursor, int keySize, int valueSize, long keyValueSize, int pos) {
        cursor.setCursorException(String.format("Read unreliable key, id=%d, keySize=%d, valueSize=%d, keyValueSizeCap=%d, keyHasTombstone=%b, pos=%d", cursor.getCurrentPageId(), keySize, valueSize, this.keyValueSizeCap(), DynamicSizeUtil.extractTombstone(keyValueSize), pos));
    }

    boolean keyValueSizeTooLarge(int keySize, int valueSize) {
        return keySize + valueSize > this.keyValueSizeCap();
    }

    private static int keyPosOffset(int pos, TreeNode.Type type) {
        if (type == TreeNode.Type.LEAF) {
            return TreeNodeDynamicSize.keyPosOffsetLeaf(pos);
        }
        return TreeNodeDynamicSize.keyPosOffsetInternal(pos);
    }

    protected static int keyPosOffsetLeaf(int pos) {
        return 86 + pos * 2;
    }

    private static int keyPosOffsetInternal(int pos) {
        return 110 + pos * 26;
    }

    public String toString() {
        return "TreeNodeDynamicSize[pageSize:" + this.payloadSize + ", keyValueSizeCap:" + this.keyValueSizeCap() + ", inlineKeyValueSizeCap:" + this.inlineKeyValueSizeCap + "]";
    }

    private String asString(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration) {
        int currentOffset = cursor.getOffset();
        TreeNode.Type type = TreeNodeDynamicSize.isInternal(cursor) ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF;
        int allocOffset = this.getAllocOffset(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        String additionalHeader = "{" + cursor.getCurrentPageId() + "} [allocOffset=" + allocOffset + " deadSpace=" + deadSpace + "] ";
        String offsetArray = this.readOffsetArray(cursor, stableGeneration, unstableGeneration, type);
        String allocSpace = "";
        if (includeAllocSpace) {
            allocSpace = this.readAllocSpace(cursor, allocOffset, type);
        }
        Object readKey = this.layout.newKey();
        Object readValue = this.layout.newValue();
        StringJoiner keys = new StringJoiner(" ");
        cursor.setOffset(allocOffset);
        while (cursor.getOffset() < cursor.getPagedFile().payloadSize()) {
            StringJoiner singleKey = new StringJoiner("|");
            singleKey.add(Integer.toString(cursor.getOffset()));
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            int valueSize = 0;
            if (type == TreeNode.Type.LEAF) {
                valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            }
            if (DynamicSizeUtil.extractTombstone(keyValueSize)) {
                singleKey.add("T");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                singleKey.add("O");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                long offloadId = DynamicSizeUtil.readOffloadId(cursor);
                singleKey.add(Long.toString(offloadId));
            } else {
                this.layout.readKey(cursor, readKey, keySize);
                if (type == TreeNode.Type.LEAF) {
                    this.layout.readValue(cursor, readValue, valueSize);
                }
                singleKey.add(Integer.toString(keySize));
                if (type == TreeNode.Type.LEAF && includeValue) {
                    singleKey.add(Integer.toString(valueSize));
                }
                singleKey.add(readKey.toString());
                if (type == TreeNode.Type.LEAF && includeValue) {
                    singleKey.add(readValue.toString());
                }
            }
            keys.add(singleKey.toString());
        }
        cursor.setOffset(currentOffset);
        return additionalHeader + offsetArray + " " + allocSpace + " " + keys;
    }

    @Override
    void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        System.out.println(this.asString(cursor, includeValue, includeAllocSpace, stableGeneration, unstableGeneration));
    }

    @Override
    String checkMetaConsistency(PageCursor cursor, int keyCount, TreeNode.Type type, GBPTreeConsistencyCheckVisitor visitor) {
        int offsetArray;
        long nodeId = cursor.getCurrentPageId();
        StringJoiner joiner = new StringJoiner(", ", "Meta data for tree node is inconsistent, id=" + nodeId + ": ", "");
        boolean hasInconsistency = false;
        int allocOffset = this.getAllocOffset(cursor);
        if (allocOffset < (offsetArray = TreeNodeDynamicSize.keyPosOffset(keyCount, type))) {
            joiner.add(String.format("Overlap between offsetArray and allocSpace, offsetArray=%d, allocOffset=%d", offsetArray, allocOffset));
            return joiner.toString();
        }
        if (this.reasonableKeyCount(keyCount)) {
            int lowestActiveKeyOffset;
            int allocSpace;
            int deadSpace;
            int activeSpace = this.totalActiveSpaceRaw(cursor, keyCount, type);
            if (activeSpace + (deadSpace = this.getDeadSpace(cursor)) + (allocSpace = this.getAllocSpace(cursor, keyCount, type)) != this.totalSpace) {
                hasInconsistency = true;
                joiner.add(String.format("Space areas did not sum to total space; activeSpace=%d, deadSpace=%d, allocSpace=%d, totalSpace=%d", activeSpace, deadSpace, allocSpace, this.totalSpace));
            }
            if ((lowestActiveKeyOffset = this.lowestActiveKeyOffset(cursor, keyCount, type)) < allocOffset) {
                hasInconsistency = true;
                joiner.add(String.format("Overlap between allocSpace and active keys, allocOffset=%d, lowestActiveKeyOffset=%d", allocOffset, lowestActiveKeyOffset));
            }
        }
        if (allocOffset < this.payloadSize && allocOffset >= 0) {
            cursor.setOffset(allocOffset);
            long keyValueAtAllocOffset = DynamicSizeUtil.readKeyValueSize(cursor);
            if (keyValueAtAllocOffset == 0L) {
                hasInconsistency = true;
                joiner.add(String.format("Pointer to allocSpace is misplaced, it should point to start of key, allocOffset=%d", allocOffset));
            }
        }
        if (hasInconsistency) {
            return joiner.toString();
        }
        return "";
    }

    private int lowestActiveKeyOffset(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int lowestOffsetSoFar = this.payloadSize;
        for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = TreeNodeDynamicSize.keyPosOffset(pos, type);
            cursor.setOffset(keyPosOffset);
            int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            lowestOffsetSoFar = Math.min(lowestOffsetSoFar, keyOffset);
        }
        return lowestOffsetSoFar;
    }

    private int totalActiveSpaceRaw(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int offsetArrayStart = 86;
        int offsetArrayEnd = TreeNodeDynamicSize.keyPosOffset(keyCount, type);
        int offsetArraySize = offsetArrayEnd - offsetArrayStart;
        int aliveKeySize = 0;
        int nextKeyOffset = this.getAllocOffset(cursor);
        while (nextKeyOffset < this.payloadSize) {
            cursor.setOffset(nextKeyOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            boolean tombstone = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (!tombstone) {
                aliveKeySize += DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
            }
            nextKeyOffset = cursor.getOffset() + (offload ? 8 : keySize + valueSize);
        }
        return offsetArraySize + aliveKeySize;
    }

    private String readAllocSpace(PageCursor cursor, int allocOffset, TreeNode.Type type) {
        int keyCount = TreeNodeDynamicSize.keyCount(cursor);
        int endOfOffsetArray = type == TreeNode.Type.INTERNAL ? TreeNodeDynamicSize.keyPosOffsetInternal(keyCount) : TreeNodeDynamicSize.keyPosOffsetLeaf(keyCount);
        cursor.setOffset(endOfOffsetArray);
        int bytesToRead = allocOffset - endOfOffsetArray;
        byte[] allocSpace = new byte[bytesToRead];
        cursor.getBytes(allocSpace);
        for (byte b : allocSpace) {
            if (b == 0) continue;
            return "v" + endOfOffsetArray + ">" + bytesToRead + "|" + Arrays.toString(allocSpace);
        }
        return "v" + endOfOffsetArray + ">" + bytesToRead + "|[0...]";
    }

    private String readOffsetArray(PageCursor cursor, long stableGeneration, long unstableGeneration, TreeNode.Type type) {
        int keyCount = TreeNodeDynamicSize.keyCount(cursor);
        StringJoiner offsetArray = new StringJoiner(" ");
        for (int i = 0; i < keyCount; ++i) {
            if (type == TreeNode.Type.INTERNAL) {
                long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, i, stableGeneration, unstableGeneration));
                offsetArray.add("/" + childPointer + "\\");
            }
            cursor.setOffset(TreeNodeDynamicSize.keyPosOffset(i, type));
            offsetArray.add(Integer.toString(PageCursorUtil.getUnsignedShort((PageCursor)cursor)));
        }
        if (type == TreeNode.Type.INTERNAL) {
            long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, keyCount, stableGeneration, unstableGeneration));
            offsetArray.add("/" + childPointer + "\\");
        }
        return offsetArray.toString();
    }

    private boolean canInline(int entrySize) {
        return entrySize <= this.inlineKeyValueSizeCap;
    }

    @VisibleForTesting
    public int getHeaderLength() {
        return 86;
    }
}

