/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.function.ThrowingAction;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeWriter;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.InternalTreeLogic;
import org.neo4j.index.internal.gbptree.KeyPartitioning;
import org.neo4j.index.internal.gbptree.LatchCrabbingCoordination;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.OffloadIdValidator;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootSupplier;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.SeekDepthMonitor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SizeEstimationMonitor;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeLatchService;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.TripCountingRootCatchup;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.Preconditions;

class RootLayerSupport {
    private final PagedFile pagedFile;
    private final LongSupplier generationSupplier;
    private final Consumer<Throwable> exceptionDecorator;
    private final TreeNodeLatchService latchService;
    private final FreeListIdProvider freeList;
    private final MultiRootGBPTree.Monitor monitor;
    private final ThrowingAction<IOException> cleanCheck;
    private final ReadWriteLock checkpointLock;
    private final ReadWriteLock writerLock;
    private final AtomicBoolean changesSinceLastCheckpoint;
    private final int payloadSize;
    private final String treeName;
    private final boolean readOnly;
    private final BooleanSupplier writersMustEagerlyFlushSupplier;

    RootLayerSupport(PagedFile pagedFile, LongSupplier generationSupplier, Consumer<Throwable> exceptionDecorator, TreeNodeLatchService latchService, FreeListIdProvider freeList, MultiRootGBPTree.Monitor monitor, ThrowingAction<IOException> cleanCheck, ReadWriteLock checkpointLock, ReadWriteLock writerLock, AtomicBoolean changesSinceLastCheckpoint, String treeName, boolean readOnly, BooleanSupplier writersMustEagerlyFlushSupplier) {
        this.pagedFile = pagedFile;
        this.generationSupplier = generationSupplier;
        this.exceptionDecorator = exceptionDecorator;
        this.latchService = latchService;
        this.freeList = freeList;
        this.monitor = monitor;
        this.cleanCheck = cleanCheck;
        this.checkpointLock = checkpointLock;
        this.writerLock = writerLock;
        this.changesSinceLastCheckpoint = changesSinceLastCheckpoint;
        this.payloadSize = pagedFile.payloadSize();
        this.treeName = treeName;
        this.readOnly = readOnly;
        this.writersMustEagerlyFlushSupplier = writersMustEagerlyFlushSupplier;
    }

    <K, V> SeekCursor<K, V> internalAllocateSeeker(Layout<K, V> layout, TreeNode<K, V> bTreeNode, CursorContext cursorContext, SeekCursor.Monitor monitor) throws IOException {
        PageCursor cursor = this.pagedFile.io(0L, 1, cursorContext);
        return new SeekCursor<K, V>(cursor, bTreeNode, layout, this.generationSupplier, this.exceptionDecorator, monitor, cursorContext);
    }

    <K, V> Seeker<K, V> initializeSeeker(Seeker<K, V> seeker, RootSupplier rootSupplier, K fromInclusive, K toExclusive, int readAheadLength, int searchLevel) throws IOException {
        return ((SeekCursor)seeker).initialize(c -> rootSupplier.getRoot().goTo(c), new TripCountingRootCatchup(rootSupplier), fromInclusive, toExclusive, readAheadLength, searchLevel);
    }

    <K, V> List<K> internalPartitionedSeek(Layout<K, V> layout, TreeNode<K, V> bTreeNode, K fromInclusive, K toExclusive, int desiredNumberOfPartitions, RootSupplier rootSupplier, CursorContext cursorContext) throws IOException {
        int numberOfSubtrees;
        Preconditions.checkArgument((layout.compare(fromInclusive, toExclusive) <= 0 ? 1 : 0) != 0, (String)"Partitioned seek only supports forward seeking for the time being");
        TreeSet<K> splitterKeysInRange = new TreeSet<K>(layout);
        int searchLevel = 0;
        do {
            SeekDepthMonitor depthMonitor = new SeekDepthMonitor();
            K localFrom = layout.copyKey(fromInclusive, layout.newKey());
            K localTo = layout.copyKey(toExclusive, layout.newKey());
            try (Seeker<K, V> seek = this.initializeSeeker(this.internalAllocateSeeker(layout, bTreeNode, cursorContext, depthMonitor), rootSupplier, localFrom, localTo, 20, searchLevel);){
                if (depthMonitor.reachedLeafLevel) break;
                while (seek.next()) {
                    splitterKeysInRange.add(layout.copyKey(seek.key(), layout.newKey()));
                }
            }
            ++searchLevel;
        } while ((numberOfSubtrees = splitterKeysInRange.size() + 1) < desiredNumberOfPartitions);
        return new KeyPartitioning<K>(layout).partition(splitterKeysInRange, fromInclusive, toExclusive, desiredNumberOfPartitions);
    }

    <K, V> Writer<K, V> internalParallelWriter(Layout<K, V> layout, TreeNode<K, V> treeNode, double ratioToKeepInLeftOnSplit, CursorContext cursorContext, TreeRootExchange rootChangeMonitor, byte layerType) throws IOException {
        LatchCrabbingCoordination traversalMonitor = new LatchCrabbingCoordination(this.latchService, treeNode.leafUnderflowThreshold(), 20);
        GBPTreeWriter<K, V> writer = this.newWriter(layout, rootChangeMonitor, treeNode, traversalMonitor, true, layerType);
        return this.initializeWriter(writer, ratioToKeepInLeftOnSplit, cursorContext);
    }

    <K, V> GBPTreeWriter<K, V> newWriter(Layout<K, V> layout, TreeRootExchange rootChangeMonitor, TreeNode<K, V> treeNode, TreeWriterCoordination traversalMonitor, boolean parallel, byte layerType) {
        return new GBPTreeWriter<K, V>(layout, this.pagedFile, traversalMonitor, new InternalTreeLogic<K, V>(this.freeList, treeNode, layout, this.monitor, traversalMonitor, layerType), treeNode, parallel, rootChangeMonitor, this.checkpointLock, this.writerLock, this.freeList, this.monitor, this.exceptionDecorator, this.generationSupplier, this.writersMustEagerlyFlushSupplier);
    }

    <K, V> GBPTreeWriter<K, V> initializeWriter(GBPTreeWriter<K, V> writer, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        if (this.readOnly) {
            throw new IllegalStateException(String.format("'%s' is read-only", this.pagedFile.path()));
        }
        this.cleanCheck.apply();
        writer.initialize(ratioToKeepInLeftOnSplit, cursorContext);
        this.changesSinceLastCheckpoint.set(true);
        return writer;
    }

    <K, V> OffloadStoreImpl<K, V> buildOffload(Layout<K, V> layout) {
        OffloadIdValidator idValidator = id -> id >= 3L && id <= this.pagedFile.getLastPageId();
        return new OffloadStoreImpl<K, V>(layout, this.freeList, (arg_0, arg_1, arg_2) -> ((PagedFile)this.pagedFile).io(arg_0, arg_1, arg_2), idValidator, this.payloadSize);
    }

    private static PageCursor openMetaPageCursor(PagedFile pagedFile, int pfFlags, CursorContext cursorContext) throws IOException {
        PageCursor metaCursor = pagedFile.io(0L, pfFlags, cursorContext);
        PageCursorUtil.goTo((PageCursor)metaCursor, (String)"meta page", (long)0L);
        return metaCursor;
    }

    Meta readMeta(CursorContext cursorContext) throws IOException {
        try (PageCursor metaCursor = RootLayerSupport.openMetaPageCursor(this.pagedFile, 1, cursorContext);){
            Meta meta = Meta.read(metaCursor);
            return meta;
        }
    }

    static Meta readMeta(PagedFile pagedFile, CursorContext cursorContext) throws IOException {
        try (PageCursor metaCursor = RootLayerSupport.openMetaPageCursor(pagedFile, 1, cursorContext);){
            Meta meta = Meta.read(metaCursor);
            return meta;
        }
    }

    void writeMeta(Layout<?, ?> rootLayout, Layout<?, ?> dataLayout, CursorContext cursorContext, TreeNodeSelector treeNodeSelector) throws IOException {
        Meta meta = Meta.from(this.payloadSize, dataLayout, rootLayout, treeNodeSelector);
        try (PageCursor metaCursor = RootLayerSupport.openMetaPageCursor(this.pagedFile, 2, cursorContext);){
            meta.write(metaCursor);
        }
    }

    int payloadSize() {
        return this.payloadSize;
    }

    PageCursor openRootCursor(Root root, int pfFlags, CursorContext cursorContext) throws IOException {
        PageCursor cursor = this.pagedFile.io(0L, pfFlags, cursorContext);
        root.goTo(cursor);
        return cursor;
    }

    PageCursor openCursor(int pfFlags, CursorContext cursorContext) throws IOException {
        return this.pagedFile.io(0L, pfFlags, cursorContext);
    }

    long generation() {
        return this.generationSupplier.getAsLong();
    }

    <K, V> void initializeNewRoot(Root root, TreeNode<K, V> treeNode, byte layerType, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.openRootCursor(root, 2, cursorContext);){
            long generation = this.generationSupplier.getAsLong();
            long stableGeneration = Generation.stableGeneration(generation);
            long unstableGeneration = Generation.unstableGeneration(generation);
            treeNode.initializeLeaf(cursor, layerType, stableGeneration, unstableGeneration);
            this.changesSinceLastCheckpoint.set(true);
            PointerChecking.checkOutOfBounds(cursor);
        }
    }

    IdProvider idProvider() {
        return this.freeList;
    }

    <K, V> void unsafe(GBPTreeUnsafe<K, V> unsafe, Layout<K, V> layout, TreeNode<K, V> treeNode, CursorContext cursorContext) throws IOException {
        TreeState state;
        try (PageCursor cursor = this.pagedFile.io(0L, 2, cursorContext);){
            Pair<TreeState, TreeState> states = TreeStatePair.readStatePages(cursor, 1L, 2L);
            state = TreeStatePair.selectNewestValidOrFirst(states);
        }
        unsafe.access(this.pagedFile, layout, treeNode, state);
    }

    CrashGenerationCleaner createCrashGenerationCleaner(TreeNode<?, ?> rootTreeNode, TreeNode<?, ?> dataTreeNode, CursorContextFactory contextFactory) {
        long generation = this.generation();
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        long highTreeNodeId = this.freeList.lastId() + 1L;
        return new CrashGenerationCleaner(this.pagedFile, rootTreeNode, dataTreeNode, 3L, highTreeNodeId, stableGeneration, unstableGeneration, this.monitor, contextFactory, this.treeName);
    }

    TreeNodeLatchService latchService() {
        return this.latchService;
    }

    <K, V> long estimateNumberOfEntriesInTree(final Layout<K, V> layout, final TreeNode<K, V> treeNode, final RootSupplier rootSupplier, CursorContext cursorContext) throws IOException {
        Object low = layout.newKey();
        layout.initializeAsLowest(low);
        Object high = layout.newKey();
        layout.initializeAsHighest(high);
        int sampleSize = 100;
        final SizeEstimationMonitor monitor = new SizeEstimationMonitor();
        do {
            monitor.clear();
            Seeker.Factory monitoredSeeks = new Seeker.Factory<K, V>(){

                @Override
                public Seeker<K, V> allocateSeeker(CursorContext cursorContext) throws IOException {
                    return RootLayerSupport.this.internalAllocateSeeker(layout, treeNode, cursorContext, monitor);
                }

                @Override
                public Seeker<K, V> seek(Seeker<K, V> seeker, K fromInclusive, K toExclusive) throws IOException {
                    return RootLayerSupport.this.initializeSeeker(seeker, rootSupplier, fromInclusive, toExclusive, 1, Integer.MAX_VALUE);
                }

                @Override
                public List<K> partitionedSeek(K fromInclusive, K toExclusive, int numberOfPartitions, CursorContext cursorContext) throws IOException {
                    return RootLayerSupport.this.internalPartitionedSeek(layout, treeNode, fromInclusive, toExclusive, numberOfPartitions, rootSupplier, cursorContext);
                }
            };
            List<K> partitionEdges = this.internalPartitionedSeek(layout, treeNode, low, high, sampleSize, rootSupplier, cursorContext);
            for (int i = 0; i < partitionEdges.size() - 1; ++i) {
                try (Seeker partition = monitoredSeeks.seek(partitionEdges.get(i), partitionEdges.get(i + 1), cursorContext);){
                    partition.next();
                    continue;
                }
            }
        } while (!monitor.isConsistent());
        return monitor.estimateNumberOfKeys();
    }

    PagedFile pagedFile() {
        return this.pagedFile;
    }
}

