/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.RootInitializer;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.util.Preconditions;

class SeekCursor<KEY, VALUE>
implements Seeker<KEY, VALUE> {
    static final Monitor NO_MONITOR = new MonitorAdaptor();
    static final int DEFAULT_MAX_READ_AHEAD = 20;
    static final int LEAF_LEVEL = Integer.MAX_VALUE;
    private final PageCursor cursor;
    private final CursorContext cursorContext;
    private KEY[] mutableKeys;
    private TreeNode.ValueHolder<VALUE>[] mutableValues;
    private int cachedIndex;
    private int cachedLength;
    private boolean resultOnTrack;
    private KEY fromInclusive;
    private KEY toExclusive;
    private boolean exactMatch;
    private final Layout<KEY, VALUE> layout;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final KEY prevKey;
    private final LongSupplier generationSupplier;
    private RootCatchup rootCatchup;
    private int searchLevel;
    private boolean first = true;
    private long stableGeneration;
    private long unstableGeneration;
    private int pos;
    private int keyCount;
    private boolean concurrentWriteHappened;
    private long currentNodeGeneration;
    private long lastFollowedPointerGeneration;
    private long expectedCurrentNodeGeneration;
    private boolean seekForward;
    private int stride;
    private byte nodeType;
    private long successor;
    private long successorGeneration;
    private boolean isInternal;
    private long pointerId;
    private long pointerGeneration;
    private long prevSiblingId;
    private long prevSiblingGeneration;
    private final KEY expectedFirstAfterGoToNext;
    private final KEY firstKeyInNode;
    private boolean verifyExpectedFirstAfterGoToNext;
    private boolean ended;
    private boolean closed;
    private final Consumer<Throwable> exceptionDecorator;
    private final Monitor monitor;
    private boolean forceReadHeader;
    private final GenerationKeeper generationKeeper = new GenerationKeeper();

    SeekCursor(PageCursor cursor, TreeNode<KEY, VALUE> bTreeNode, Layout<KEY, VALUE> layout, LongSupplier generationSupplier, Consumer<Throwable> exceptionDecorator, Monitor monitor, CursorContext cursorContext) {
        this.cursor = cursor;
        this.cursorContext = cursorContext;
        this.layout = layout;
        this.exceptionDecorator = exceptionDecorator;
        this.monitor = monitor;
        this.generationSupplier = generationSupplier;
        this.bTreeNode = bTreeNode;
        this.prevKey = layout.newKey();
        this.expectedFirstAfterGoToNext = layout.newKey();
        this.firstKeyInNode = layout.newKey();
    }

    SeekCursor<KEY, VALUE> initialize(RootInitializer rootInitializer, RootCatchup rootCatchup, KEY fromInclusive, KEY toExclusive, int maxReadAhead, int searchLevel) throws IOException {
        int batchSize;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Seeker already closed");
        this.rootCatchup = rootCatchup;
        this.lastFollowedPointerGeneration = rootInitializer.goToRoot(this.cursor);
        long generation = this.generationSupplier.getAsLong();
        this.stableGeneration = Generation.stableGeneration(generation);
        this.unstableGeneration = Generation.unstableGeneration(generation);
        this.cachedIndex = 0;
        this.cachedLength = 0;
        this.resultOnTrack = false;
        this.expectedCurrentNodeGeneration = 0L;
        this.verifyExpectedFirstAfterGoToNext = false;
        this.forceReadHeader = false;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.exactMatch = this.layout.compare(fromInclusive, toExclusive) == 0;
        this.first = true;
        this.seekForward = this.layout.compare(fromInclusive, toExclusive) <= 0;
        this.stride = this.seekForward ? 1 : -1;
        this.searchLevel = searchLevel;
        int n = batchSize = this.exactMatch ? 1 : maxReadAhead;
        if (this.mutableKeys == null || batchSize > this.mutableKeys.length) {
            this.mutableKeys = new Object[batchSize];
            this.mutableValues = new TreeNode.ValueHolder[batchSize];
            this.mutableKeys[0] = this.layout.newKey();
            this.mutableValues[0] = new TreeNode.ValueHolder<VALUE>(this.layout.newValue());
        }
        this.ended = false;
        this.pos = 0;
        this.keyCount = 0;
        this.concurrentWriteHappened = false;
        this.currentNodeGeneration = 0L;
        this.nodeType = 0;
        this.successor = 0L;
        this.successorGeneration = 0L;
        this.isInternal = false;
        this.pointerId = 0L;
        this.pointerGeneration = 0L;
        this.prevSiblingId = 0L;
        this.prevSiblingGeneration = 0L;
        try {
            this.traverseDownToCorrectLevel();
        }
        catch (Throwable e) {
            this.exceptionDecorator.accept(e);
            IOUtils.closeAllSilently((AutoCloseable[])new SeekCursor[]{this});
            throw e;
        }
        return this;
    }

    private void traverseDownToCorrectLevel() throws IOException {
        int currentReadLevel = 0;
        int completedReadLevel = -1;
        do {
            int searchResult = Integer.MIN_VALUE;
            boolean lookingForChild = true;
            do {
                try {
                    if (!this.readHeader()) continue;
                    searchResult = this.isInternal ? KeySearch.searchInternal(this.cursor, this.bTreeNode, this.fromInclusive, this.mutableKeys[0], this.keyCount, this.cursorContext) : KeySearch.searchLeaf(this.cursor, this.bTreeNode, this.fromInclusive, this.mutableKeys[0], this.keyCount, this.cursorContext);
                    lookingForChild = this.isInternal && currentReadLevel < this.searchLevel;
                    this.pos = SeekCursor.positionOf(searchResult, lookingForChild);
                    if (!lookingForChild) continue;
                    this.pointerId = this.bTreeNode.childAt(this.cursor, this.pos, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
                    this.pointerGeneration = this.generationKeeper.generation;
                }
                catch (Exception e) {
                    this.cursor.setCursorException(e.getMessage());
                }
            } while (this.cursor.shouldRetry());
            PointerChecking.checkOutOfBounds(this.cursor);
            this.cursor.checkAndClearCursorException();
            if (!this.endedUpOnExpectedNode()) {
                this.prepareToStartFromRoot();
                this.isInternal = true;
                currentReadLevel = 0;
                completedReadLevel = -1;
                continue;
            }
            if (!this.saneRead()) {
                throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGeneration:%d%n  successor:%d%n  successorGeneration:%d%n  isInternal:%b%n  keyCount:%d%n  searchResult:%d%n  pos:%d%n  childId:%d%n  childIdGeneration:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGeneration, this.successor, this.successorGeneration, this.isInternal, this.keyCount, searchResult, this.pos, this.pointerId, this.pointerGeneration);
            }
            if (this.goToSuccessor()) continue;
            completedReadLevel = currentReadLevel++;
            if (!lookingForChild) continue;
            this.monitor.internalNode(completedReadLevel, this.keyCount);
            this.goTo(this.pointerId, this.pointerGeneration, "CHILD", false);
        } while (completedReadLevel < currentReadLevel && completedReadLevel < this.searchLevel);
        if (this.isInternal) {
            this.monitor.internalNode(completedReadLevel, this.keyCount);
        } else {
            this.monitor.leafNode(completedReadLevel, this.keyCount);
        }
        this.pos -= this.stride;
        if (!this.seekForward) {
            this.concurrentWriteHappened = true;
        }
        this.cachedLength = 0;
    }

    @Override
    public boolean next() throws IOException {
        try {
            while (!this.ended) {
                this.pos += this.stride;
                if (this.cachedIndex + 1 < this.cachedLength && !(this.concurrentWriteHappened = this.cursor.shouldRetry())) {
                    ++this.cachedIndex;
                    if (this.resultOnTrack && this.isValueDefined()) {
                        return true;
                    }
                    if (!this.isResultKey()) continue;
                    this.resultOnTrack = true;
                    return true;
                }
                if (this.resultOnTrack) {
                    this.layout.copyKey(this.mutableKeys[this.cachedIndex], this.prevKey);
                }
                if (!this.readAndValidateNextKeyValueBatch()) {
                    this.cachedLength = 0;
                    continue;
                }
                if (!this.seekForward && this.pos >= this.keyCount) {
                    this.goTo(this.prevSiblingId, this.prevSiblingGeneration, "RIGHT_SIBLING", true);
                    continue;
                }
                if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0 && !this.insidePrevKey(this.cachedIndex)) {
                    if (this.goToNextSibling()) {
                        continue;
                    }
                } else if (0 <= this.pos && this.pos < this.keyCount && this.insideEndRange(this.exactMatch, 0)) {
                    if (!this.isResultKey()) continue;
                    this.resultOnTrack = true;
                    return true;
                }
                this.ended = true;
                return false;
            }
        }
        catch (Throwable e) {
            this.exceptionDecorator.accept(e);
            throw e;
        }
        return false;
    }

    private boolean readAndValidateNextKeyValueBatch() throws IOException {
        int searchResult = Integer.MIN_VALUE;
        block2: do {
            try {
                this.cachedIndex = 0;
                this.cachedLength = 0;
                this.resultOnTrack = false;
                if ((this.concurrentWriteHappened || this.forceReadHeader || !this.seekForward) && (!this.readHeader() || this.isInternal && this.searchLevel == Integer.MAX_VALUE)) continue;
                if (this.verifyExpectedFirstAfterGoToNext) {
                    this.pos = this.seekForward ? 0 : this.keyCount - 1;
                    this.bTreeNode.keyAt(this.cursor, this.firstKeyInNode, this.pos, this.isInternal ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF, this.cursorContext);
                }
                if (this.concurrentWriteHappened) {
                    KEY key = this.first ? this.fromInclusive : this.prevKey;
                    searchResult = this.isInternal ? KeySearch.searchInternal(this.cursor, this.bTreeNode, key, this.mutableKeys[0], this.keyCount, this.cursorContext) : KeySearch.searchLeaf(this.cursor, this.bTreeNode, key, this.mutableKeys[0], this.keyCount, this.cursorContext);
                    this.pos = SeekCursor.positionOf(searchResult, false);
                    if (!this.seekForward && this.pos >= this.keyCount) {
                        this.prevSiblingId = this.readPrevSibling();
                        this.prevSiblingGeneration = this.generationKeeper.generation;
                    }
                }
                if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0) {
                    this.pointerId = this.readNextSibling();
                    this.pointerGeneration = this.generationKeeper.generation;
                }
                for (int readPos = this.pos; this.cachedLength < this.mutableKeys.length && 0 <= readPos && readPos < this.keyCount; readPos += this.stride) {
                    if (this.mutableKeys[this.cachedLength] == null) {
                        this.mutableKeys[this.cachedLength] = this.layout.newKey();
                        this.mutableValues[this.cachedLength] = new TreeNode.ValueHolder<VALUE>(this.layout.newValue());
                    }
                    if (!this.isInternal) {
                        this.bTreeNode.keyValueAt(this.cursor, this.mutableKeys[this.cachedLength], this.mutableValues[this.cachedLength], readPos, this.cursorContext);
                    } else {
                        this.bTreeNode.keyAtInternal(this.cursor, this.mutableKeys[this.cachedLength], readPos, this.cursorContext);
                    }
                    if (!this.insideEndRange(this.exactMatch, this.cachedLength)) continue block2;
                    if (this.cachedLength <= 0 && !this.insidePrevKey(this.cachedLength)) continue;
                    ++this.cachedLength;
                }
            }
            catch (Exception e) {
                this.cursor.setCursorException(e.getMessage());
            }
        } while (this.concurrentWriteHappened = this.cursor.shouldRetry());
        this.checkOutOfBoundsAndClosed();
        this.cursor.checkAndClearCursorException();
        if (!this.endedUpOnExpectedNode() || this.isInternal && this.searchLevel == Integer.MAX_VALUE) {
            this.prepareToStartFromRoot();
            this.traverseDownToCorrectLevel();
            return false;
        }
        if (!this.saneRead()) {
            throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGeneration:%d%n  successor:%d%n  successorGeneration:%d%n  keyCount:%d%n  searchResult:%d%n  pos:%d%n  rightSibling:%d%n  rightSiblingGeneration:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGeneration, this.successor, this.successorGeneration, this.keyCount, searchResult, this.pos, this.pointerId, this.pointerGeneration);
        }
        if (!this.verifyFirstKeyInNodeIsExpectedAfterGoTo()) {
            return false;
        }
        return !this.goToSuccessor();
    }

    private void checkOutOfBoundsAndClosed() {
        try {
            PointerChecking.checkOutOfBounds(this.cursor);
        }
        catch (TreeInconsistencyException e) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Tried to use seeker after it was closed");
            throw e;
        }
    }

    private boolean insideEndRange(boolean exactMatch, int cachedIndex) {
        if (exactMatch) {
            return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) <= 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) >= 0;
        }
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) < 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.toExclusive) > 0;
    }

    private boolean insideStartRange(int cachedIndex) {
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.fromInclusive) >= 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.fromInclusive) <= 0;
    }

    private boolean insidePrevKey(int cachedIndex) {
        if (this.first) {
            return this.insideStartRange(cachedIndex);
        }
        return this.seekForward ? this.layout.compare(this.mutableKeys[cachedIndex], this.prevKey) > 0 : this.layout.compare(this.mutableKeys[cachedIndex], this.prevKey) < 0;
    }

    private boolean goTo(long pointerId, long pointerGeneration, String type, boolean allowNoNode) throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(pointerId, allowNoNode, type)) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (!allowNoNode || TreeNodeUtil.isNode(pointerId)) {
            TreeNodeUtil.goTo(this.cursor, type, pointerId);
            this.lastFollowedPointerGeneration = pointerGeneration;
            this.concurrentWriteHappened = true;
            return true;
        }
        return false;
    }

    private boolean goToSuccessor() throws IOException {
        return this.goTo(this.successor, this.successorGeneration, "SUCCESSOR", true);
    }

    private boolean verifyFirstKeyInNodeIsExpectedAfterGoTo() {
        boolean result = true;
        if (this.verifyExpectedFirstAfterGoToNext && this.layout.compare(this.firstKeyInNode, this.expectedFirstAfterGoToNext) != 0) {
            this.concurrentWriteHappened = true;
            result = false;
        }
        this.verifyExpectedFirstAfterGoToNext = false;
        return result;
    }

    private long readPrevSibling() {
        return this.seekForward ? TreeNodeUtil.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper) : TreeNodeUtil.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
    }

    private long readNextSibling() {
        return this.seekForward ? TreeNodeUtil.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper) : TreeNodeUtil.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
    }

    private static int positionOf(int searchResult, boolean lookingForChildPosition) {
        if (lookingForChildPosition) {
            return KeySearch.childPositionOf(searchResult);
        }
        return KeySearch.positionOf(searchResult);
    }

    private boolean readHeader() {
        this.nodeType = TreeNodeUtil.nodeType(this.cursor);
        if (this.nodeType != 1) {
            return false;
        }
        this.isInternal = TreeNodeUtil.isInternal(this.cursor);
        this.keyCount = TreeNodeUtil.keyCount(this.cursor);
        this.currentNodeGeneration = TreeNodeUtil.generation(this.cursor);
        this.successor = TreeNodeUtil.successor(this.cursor, this.stableGeneration, this.unstableGeneration, this.generationKeeper);
        this.successorGeneration = this.generationKeeper.generation;
        this.forceReadHeader = false;
        return this.keyCountIsSane(this.keyCount);
    }

    private boolean endedUpOnExpectedNode() {
        return this.nodeType == 1 && this.verifyNodeGenerationInvariants();
    }

    private boolean goToNextSibling() throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(this.pointerId, true, this.seekForward ? "RIGHT_SIBLING" : "LEFT_SIBLING")) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (TreeNodeUtil.isNode(this.pointerId)) {
            if (this.seekForward) {
                TreeNodeUtil.goTo(this.cursor, "sibling", this.pointerId);
                this.lastFollowedPointerGeneration = this.pointerGeneration;
                if (this.first) {
                    this.concurrentWriteHappened = true;
                } else {
                    this.forceReadHeader = true;
                    this.pos = -1;
                }
                return true;
            }
            if (this.scoutNextSibling()) {
                TreeNodeUtil.goTo(this.cursor, "sibling", this.pointerId);
                this.verifyExpectedFirstAfterGoToNext = true;
                this.lastFollowedPointerGeneration = this.pointerGeneration;
            } else {
                this.concurrentWriteHappened = true;
            }
            return true;
        }
        return false;
    }

    private boolean scoutNextSibling() throws IOException {
        byte nodeType;
        assert (!this.seekForward);
        assert (!this.isInternal);
        int keyCount = -1;
        try (PageCursor scout = this.cursor.openLinkedCursor(GenerationSafePointerPair.pointer(this.pointerId));){
            scout.next();
            nodeType = TreeNodeUtil.nodeType(scout);
            if (nodeType == 1 && this.keyCountIsSane(keyCount = TreeNodeUtil.keyCount(scout)) && keyCount > 0) {
                int firstPos = keyCount - 1;
                this.bTreeNode.keyAtLeaf(scout, this.expectedFirstAfterGoToNext, firstPos, this.cursorContext);
            }
            if (this.cursor.shouldRetry()) {
                boolean bl = false;
                return bl;
            }
            PointerChecking.checkOutOfBounds(this.cursor);
        }
        return nodeType == 1 && this.keyCountIsSane(keyCount) && keyCount > 0;
    }

    private boolean isResultKey() {
        if (!this.insideStartRange(this.cachedIndex)) {
            this.concurrentWriteHappened = true;
            return false;
        }
        if (!this.first && !this.insidePrevKey(this.cachedIndex)) {
            return false;
        }
        if (!this.isValueDefined()) {
            return false;
        }
        if (this.first) {
            this.first = false;
        }
        return true;
    }

    private boolean isValueDefined() {
        return this.isInternal || this.mutableValues[this.cachedIndex].defined;
    }

    private boolean keyCountIsSane(int keyCount) {
        return this.bTreeNode.reasonableKeyCount(keyCount);
    }

    private boolean saneRead() {
        return this.keyCountIsSane(this.keyCount);
    }

    private void prepareToStartFromRoot() throws IOException {
        this.generationCatchup();
        Root root = this.rootCatchup.catchupFrom(this.cursor.getCurrentPageId());
        this.lastFollowedPointerGeneration = root.goTo(this.cursor);
        if (!this.first) {
            this.layout.copyKey(this.prevKey, this.fromInclusive);
        }
        this.cachedIndex = 0;
        this.cachedLength = 0;
        this.resultOnTrack = false;
        this.pos = 0;
        this.keyCount = 0;
        this.concurrentWriteHappened = false;
        this.verifyExpectedFirstAfterGoToNext = false;
        this.currentNodeGeneration = 0L;
        this.expectedCurrentNodeGeneration = 0L;
        this.nodeType = 0;
        this.successor = 0L;
        this.successorGeneration = 0L;
        this.isInternal = false;
        this.pointerId = 0L;
        this.pointerGeneration = 0L;
        this.prevSiblingId = 0L;
        this.prevSiblingGeneration = 0L;
        this.forceReadHeader = false;
    }

    private boolean verifyNodeGenerationInvariants() {
        if (this.lastFollowedPointerGeneration != 0L) {
            if (this.currentNodeGeneration > this.lastFollowedPointerGeneration) {
                return false;
            }
            this.lastFollowedPointerGeneration = 0L;
            this.expectedCurrentNodeGeneration = this.currentNodeGeneration;
        } else if (this.currentNodeGeneration != this.expectedCurrentNodeGeneration) {
            return false;
        }
        return true;
    }

    private boolean pointerCheckingWithGenerationCatchup(long pointer, boolean allowNoNode, String pointerType) {
        if (!GenerationSafePointerPair.isSuccess(pointer)) {
            if (this.generationCatchup()) {
                return true;
            }
            PointerChecking.checkPointer(pointer, allowNoNode, this.cursor.getCurrentPageId(), pointerType, this.stableGeneration, this.unstableGeneration);
        }
        return false;
    }

    private boolean generationCatchup() {
        long newGeneration = this.generationSupplier.getAsLong();
        long newStableGeneration = Generation.stableGeneration(newGeneration);
        long newUnstableGeneration = Generation.unstableGeneration(newGeneration);
        if (newStableGeneration != this.stableGeneration || newUnstableGeneration != this.unstableGeneration) {
            this.stableGeneration = newStableGeneration;
            this.unstableGeneration = newUnstableGeneration;
            return true;
        }
        return false;
    }

    @Override
    public KEY key() {
        this.assertHasResult();
        return this.mutableKeys[this.cachedIndex];
    }

    @Override
    public VALUE value() {
        this.assertHasResult();
        assert (this.mutableValues[this.cachedIndex].defined);
        return this.mutableValues[this.cachedIndex].value;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.cursor.close();
            this.closed = true;
            this.ended = true;
        }
    }

    private void assertHasResult() {
        if (this.first) {
            throw new IllegalStateException("There has been no successful call to next() yet");
        }
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
    }

    static interface Monitor {
        public void internalNode(int var1, int var2);

        public void leafNode(int var1, int var2);
    }

    static class MonitorAdaptor
    implements Monitor {
        MonitorAdaptor() {
        }

        @Override
        public void internalNode(int depth, int keyCount) {
        }

        @Override
        public void leafNode(int depth, int keyCount) {
        }
    }
}

