/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.util.Arrays;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.string.Mask;

public final class TokenIndexUpdateCommand
extends IndexUpdateCommand<int[]> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TokenIndexUpdateCommand.class);
    private final int[] before;
    private final int[] values;

    public TokenIndexUpdateCommand(IndexCommandSerialization serialization, long indexId, long entityId, int[] before, int[] values) {
        super(serialization, UpdateMode.CHANGED, indexId, entityId);
        this.before = before;
        this.values = values;
    }

    @Override
    public int[] getBefore() {
        return this.before;
    }

    @Override
    public int[] getAfter() {
        return this.values;
    }

    @Override
    public String toString(Mask mask) {
        return String.format("TokenIndexUpdateCommand[mode:%s, indexId:%d, entityId:%d, before:%s, after:%s]", this.updateMode, this.indexId, this.entityId, Arrays.toString(this.before), Arrays.toString(this.values));
    }

    public boolean equals(Object o) {
        if (!(o instanceof TokenIndexUpdateCommand)) {
            return false;
        }
        TokenIndexUpdateCommand that = (TokenIndexUpdateCommand)o;
        return Arrays.equals(this.before, that.before) && Arrays.equals(this.values, that.values);
    }
}

