/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.indexcommand.IndexUpdatesState;
import org.neo4j.internal.indexcommand.NodeBasedTransactionToIndexUpdateVisitor;
import org.neo4j.internal.indexcommand.RelationshipBasedTransactionToIndexUpdateVisitor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.EntityChange;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public abstract sealed class TransactionToIndexUpdateVisitor
extends TxStateVisitor.Delegator
permits NodeBasedTransactionToIndexUpdateVisitor, RelationshipBasedTransactionToIndexUpdateVisitor {
    protected static final int[] NO_TOKENS = ArrayUtils.EMPTY_INT_ARRAY;
    protected final IndexUpdatesState indexUpdatesState;
    protected final StorageNodeCursor nodeCursor;
    private final IndexDescriptor labelIndex;

    public TransactionToIndexUpdateVisitor(TxStateVisitor next, IndexUpdatesState indexUpdatesState, StorageReader storageReader, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(next);
        this.indexUpdatesState = indexUpdatesState;
        this.nodeCursor = storageReader.allocateNodeCursor(cursorContext, storeCursors, memoryTracker);
        this.labelIndex = TransactionToIndexUpdateVisitor.getTokenIndex(storageReader, EntityType.NODE);
    }

    protected static IndexDescriptor getTokenIndex(StorageReader storageReader, EntityType entityType) {
        return (IndexDescriptor)Iterators.firstOrNull((Iterator)storageReader.indexGetForSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType)));
    }

    public void visitDeletedNode(long id) {
        super.visitDeletedNode(id);
        if (this.labelIndex == null) {
            return;
        }
        this.nodeCursor.single(id);
        if (!this.nodeCursor.next()) {
            return;
        }
        int[] labelsBefore = this.nodeCursor.labels();
        if (labelsBefore.length == 0) {
            return;
        }
        if (labelsBefore.length > 1) {
            Arrays.sort(labelsBefore);
        }
        this.indexUpdatesState.addTokenUpdate(TokenIndexEntryUpdate.tokenChange((long)id, (IndexDescriptor)this.labelIndex, (int[])labelsBefore, (int[])NO_TOKENS));
    }

    public void visitNodeLabelChanges(long id, IntSet added, IntSet removed) throws ConstraintValidationException {
        super.visitNodeLabelChanges(id, added, removed);
        if (this.labelIndex == null) {
            return;
        }
        this.indexUpdatesState.addTokenUpdate(TokenIndexEntryUpdate.tokenChange((long)id, (IndexDescriptor)this.labelIndex, (int[])removed.toSortedArray(), (int[])added.toSortedArray()));
    }

    public void visitValueIndexUpdate(IndexDescriptor descriptor, long entityId, ValueTuple values, EntityChange entityChange) {
        super.visitValueIndexUpdate(descriptor, entityId, values, entityChange);
        IndexUpdatesState.IndexEntityPair key = new IndexUpdatesState.IndexEntityPair(descriptor.getId(), entityId);
        ValueIndexEntryUpdate existingUpdate = this.indexUpdatesState.getValueUpdate(key);
        ValueIndexEntryUpdate update = this.getValueUpdate(descriptor, entityId, values, entityChange, existingUpdate);
        this.indexUpdatesState.putValueUpdate(key, update);
    }

    private ValueIndexEntryUpdate getValueUpdate(IndexDescriptor descriptor, long entityId, ValueTuple values, EntityChange entityChange, ValueIndexEntryUpdate existingUpdate) {
        if (entityChange == EntityChange.ADDED) {
            return existingUpdate == null ? ValueIndexEntryUpdate.add((long)entityId, (IndexDescriptor)descriptor, (Value[])values.getValues()) : ValueIndexEntryUpdate.change((long)entityId, (IndexDescriptor)descriptor, (Value[])existingUpdate.values(), (Value[])values.getValues());
        }
        return existingUpdate == null ? ValueIndexEntryUpdate.remove((long)entityId, (IndexDescriptor)descriptor, (Value[])values.getValues()) : ValueIndexEntryUpdate.change((long)entityId, (IndexDescriptor)descriptor, (Value[])values.getValues(), (Value[])existingUpdate.values());
    }

    public void close() throws KernelException {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{() -> super.close(), this.indexUpdatesState, this.nodeCursor});
    }
}

