/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.indexcommand;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongFunction;
import org.neo4j.internal.indexcommand.IndexCommandSelector;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class IndexCommandConversion {
    public static Optional<IndexEntryUpdate> convertCommandToIndexEntryUpdate(IndexUpdateCommand<?> command, LongFunction<IndexDescriptor> indexSupplier, IndexCommandSelector commandSelector) {
        IndexDescriptor index = indexSupplier.apply(command.getIndexId());
        if (index == null) {
            return Optional.empty();
        }
        IndexUpdateCommand<?> indexUpdateCommand = command;
        Objects.requireNonNull(indexUpdateCommand);
        IndexUpdateCommand<?> indexUpdateCommand2 = indexUpdateCommand;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TokenIndexUpdateCommand.class, ValueIndexUpdateCommand.class}, indexUpdateCommand2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                TokenIndexUpdateCommand token = (TokenIndexUpdateCommand)indexUpdateCommand2;
                yield Optional.of(IndexCommandConversion.convertTokenCommand(token, index, commandSelector));
            }
            case 1 -> {
                ValueIndexUpdateCommand value = (ValueIndexUpdateCommand)indexUpdateCommand2;
                yield Optional.of(IndexCommandConversion.convertValueCommand(value, index, commandSelector));
            }
        };
    }

    private static TokenIndexEntryUpdate convertTokenCommand(TokenIndexUpdateCommand tokenCommand, IndexDescriptor index, IndexCommandSelector commandSelector) {
        return TokenIndexEntryUpdate.tokenChange((long)tokenCommand.getEntityId(), (IndexDescriptor)index, (int[])commandSelector.getBefore(tokenCommand), (int[])commandSelector.getAfter(tokenCommand));
    }

    private static IndexEntryUpdate convertValueCommand(ValueIndexUpdateCommand valueCommand, IndexDescriptor index, IndexCommandSelector commandSelector) {
        return switch (commandSelector.mode(valueCommand)) {
            default -> throw new MatchException(null, null);
            case UpdateMode.ADDED -> ValueIndexEntryUpdate.add((long)valueCommand.getEntityId(), (IndexDescriptor)index, (Value[])valueCommand.getAfter());
            case UpdateMode.CHANGED -> ValueIndexEntryUpdate.change((long)valueCommand.getEntityId(), (IndexDescriptor)index, (Value[])commandSelector.getBefore(valueCommand), (Value[])commandSelector.getAfter(valueCommand));
            case UpdateMode.REMOVED -> ValueIndexEntryUpdate.remove((long)valueCommand.getEntityId(), (IndexDescriptor)index, (Value[])valueCommand.getAfter());
        };
    }
}

