/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.ByteBufferPage;
import org.neo4j.test.TargetDirectory;

public abstract class PageSwapperTest {
    public static final PageEvictionCallback NO_CALLBACK = new PageEvictionCallback(){

        public void onEvict(long pageId, Page page) {
        }
    };
    public static final long X = -3819410105021120785L;
    public static final long Y = 6846544296635974449L;
    public static final int Z = -16843010;
    protected static final int cachePageSize = 32;
    @Rule
    public final TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    private final ConcurrentLinkedQueue<PageSwapper> openedSwappers = new ConcurrentLinkedQueue();

    protected abstract PageSwapperFactory swapperFactory() throws Exception;

    protected abstract void mkdirs(File var1) throws IOException;

    protected int cachePageSize() {
        return 32;
    }

    protected ByteBufferPage createPage(int cachePageSize) {
        return new ByteBufferPage(ByteBuffer.allocateDirect(cachePageSize));
    }

    protected ByteBufferPage createPage() {
        return this.createPage(this.cachePageSize());
    }

    protected void clear(ByteBufferPage page) {
        byte b = 0;
        for (int i = 0; i < this.cachePageSize(); ++i) {
            page.putByte(b, i);
        }
    }

    protected PageSwapper createSwapper(PageSwapperFactory swapperFactory, File file, int filePageSize, PageEvictionCallback callback, boolean createIfNotExist) throws IOException {
        PageSwapper swapper = swapperFactory.createPageSwapper(file, filePageSize, callback, createIfNotExist);
        this.openedSwappers.add(swapper);
        return swapper;
    }

    private File file(String filename) throws IOException {
        File file = this.testDir.file(filename);
        this.mkdirs(file.getParentFile());
        return file;
    }

    @Before
    @After
    public void clearStrayInterrupts() {
        Thread.interrupted();
    }

    @After
    public void closeOpenedPageSwappers() throws IOException {
        PageSwapper swapper;
        IOException exception = null;
        while ((swapper = this.openedSwappers.poll()) != null) {
            try {
                swapper.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void readMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        page.putInt(1, 0);
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Assert.assertThat((Object)swapper.write(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        page.putInt(0, 0);
        Thread.currentThread().interrupt();
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
    }

    private long sizeOf(ByteBufferPage page) {
        return page.size();
    }

    @Test
    public void vectoredReadMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        page.putInt(1, 0);
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Assert.assertThat((Object)swapper.write(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        page.putInt(0, 0);
        Thread.currentThread().interrupt();
        Assert.assertThat((Object)swapper.read(0L, new Page[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)swapper.read(0L, new Page[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void writeMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        page.putInt(1, 0);
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Thread.currentThread().interrupt();
        Assert.assertThat((Object)swapper.write(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        page.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)swapper.write(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        page.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void vectoredWriteMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        page.putInt(1, 0);
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Thread.currentThread().interrupt();
        Assert.assertThat((Object)swapper.write(0L, new Page[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        page.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)swapper.write(0L, new Page[]{page}, 0, 1), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
        page.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(0L, (Page)page), (Matcher)Matchers.is((Object)this.sizeOf(page)));
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void forcingMustNotSwallowInterrupts() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Thread.currentThread().interrupt();
        swapper.force();
        Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
    }

    @Test
    public void mustReopenChannelWhenReadFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        page.putLong(6846544296635974449L, 8);
        page.putInt(-16843010, 16);
        swapper.write(0L, (Page)page);
        Thread.currentThread().interrupt();
        swapper.read(0L, (Page)page);
        Assert.assertTrue((boolean)Thread.interrupted());
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)page.getLong(8), (Matcher)Matchers.is((Object)6846544296635974449L));
        Assert.assertThat((Object)page.getInt(16), (Matcher)Matchers.is((Object)-16843010));
        swapper.force();
    }

    @Test
    public void mustReopenChannelWhenVectoredReadFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        page.putLong(6846544296635974449L, 8);
        page.putInt(-16843010, 16);
        swapper.write(0L, (Page)page);
        Thread.currentThread().interrupt();
        swapper.read(0L, new Page[]{page}, 0, 1);
        Assert.assertTrue((boolean)Thread.interrupted());
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)page.getLong(8), (Matcher)Matchers.is((Object)6846544296635974449L));
        Assert.assertThat((Object)page.getInt(16), (Matcher)Matchers.is((Object)-16843010));
        swapper.force();
    }

    @Test
    public void mustReopenChannelWhenWriteFailsWithAsynchronousCloseException() throws Exception {
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        page.putLong(6846544296635974449L, 8);
        page.putInt(-16843010, 16);
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Thread.currentThread().interrupt();
        swapper.write(0L, (Page)page);
        Assert.assertTrue((boolean)Thread.interrupted());
        swapper.force();
        this.clear(page);
        swapper.read(0L, (Page)page);
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)page.getLong(8), (Matcher)Matchers.is((Object)6846544296635974449L));
        Assert.assertThat((Object)page.getInt(16), (Matcher)Matchers.is((Object)-16843010));
    }

    @Test
    public void mustReopenChannelWhenVectoredWriteFailsWithAsynchronousCloseException() throws Exception {
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        page.putLong(6846544296635974449L, 8);
        page.putInt(-16843010, 16);
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        Thread.currentThread().interrupt();
        swapper.write(0L, new Page[]{page}, 0, 1);
        Assert.assertTrue((boolean)Thread.interrupted());
        swapper.force();
        this.clear(page);
        swapper.read(0L, (Page)page);
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)page.getLong(8), (Matcher)Matchers.is((Object)6846544296635974449L));
        Assert.assertThat((Object)page.getInt(16), (Matcher)Matchers.is((Object)-16843010));
    }

    @Test
    public void mustReopenChannelWhenForceFailsWithAsynchronousCloseException() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        for (int i = 0; i < 10; ++i) {
            Thread.currentThread().interrupt();
            swapper.force();
            Assert.assertTrue((boolean)Thread.interrupted());
        }
    }

    @Test
    public void readMustNotReopenExplicitlyClosedChannel() throws Exception {
        String filename = "a";
        File file = this.file(filename);
        ByteBufferPage page = this.createPage();
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        swapper.write(0L, (Page)page);
        swapper.close();
        try {
            swapper.read(0L, (Page)page);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Test
    public void vectoredReadMustNotReopenExplicitlyClosedChannel() throws Exception {
        String filename = "a";
        File file = this.file(filename);
        ByteBufferPage page = this.createPage();
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        swapper.write(0L, (Page)page);
        swapper.close();
        try {
            swapper.read(0L, new Page[]{page}, 0, 1);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Test
    public void writeMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        swapper.close();
        try {
            swapper.write(0L, (Page)page);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Test
    public void vectoredWriteMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        ByteBufferPage page = this.createPage();
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        swapper.close();
        try {
            swapper.write(0L, new Page[]{page}, 0, 1);
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Test
    public void forceMustNotReopenExplicitlyClosedChannel() throws Exception {
        File file = this.file("a");
        PageSwapperFactory swapperFactory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(swapperFactory, file, this.cachePageSize(), NO_CALLBACK, true);
        swapper.close();
        try {
            swapper.force();
            Assert.fail((String)"Should have thrown because the channel should be closed");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    @Test
    public void mustNotOverwriteDataInOtherFiles() throws Exception {
        File fileA = this.file("a");
        File fileB = this.file("b");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapperA = this.createSwapper(factory, fileA, this.cachePageSize(), NO_CALLBACK, true);
        PageSwapper swapperB = this.createSwapper(factory, fileB, this.cachePageSize(), NO_CALLBACK, true);
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        swapperA.write(0L, (Page)page);
        page.putLong(6846544296635974449L, 8);
        swapperB.write(0L, (Page)page);
        this.clear(page);
        swapperA.read(0L, (Page)page);
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)page.getLong(8), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void mustRunEvictionCallbackOnEviction() throws Exception {
        final AtomicLong callbackFilePageId = new AtomicLong();
        final AtomicReference callbackPage = new AtomicReference();
        PageEvictionCallback callback = new PageEvictionCallback(){

            public void onEvict(long filePageId, Page page) {
                callbackFilePageId.set(filePageId);
                callbackPage.set(page);
            }
        };
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, this.cachePageSize(), callback, true);
        ByteBufferPage page = this.createPage();
        swapper.evicted(42L, (Page)page);
        Assert.assertThat((Object)callbackFilePageId.get(), (Matcher)Matchers.is((Object)42L));
        Assert.assertThat(callbackPage.get(), (Matcher)Matchers.sameInstance((Object)page));
    }

    @Test
    public void mustNotIssueEvictionCallbacksAfterSwapperHasBeenClosed() throws Exception {
        final AtomicBoolean gotCallback = new AtomicBoolean();
        PageEvictionCallback callback = new PageEvictionCallback(){

            public void onEvict(long filePageId, Page page) {
                gotCallback.set(true);
            }
        };
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, this.cachePageSize(), callback, true);
        ByteBufferPage page = this.createPage();
        swapper.close();
        swapper.evicted(42L, (Page)page);
        Assert.assertFalse((boolean)gotCallback.get());
    }

    @Test(expected=NoSuchFileException.class)
    public void mustThrowExceptionIfFileDoesNotExist() throws Exception {
        PageSwapperFactory factory = this.swapperFactory();
        this.createSwapper(factory, this.file("does not exist"), this.cachePageSize(), NO_CALLBACK, false);
    }

    @Test
    public void mustCreateNonExistingFileWithCreateFlag() throws Exception {
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper pageSwapper = this.createSwapper(factory, this.file("does not exist"), this.cachePageSize(), NO_CALLBACK, true);
        ByteBufferPage page = this.createPage();
        page.putLong(-3819410105021120785L, 0);
        pageSwapper.write(0L, (Page)page);
        this.clear(page);
        pageSwapper.read(0L, (Page)page);
        Assert.assertThat((Object)page.getLong(0), (Matcher)Matchers.is((Object)-3819410105021120785L));
    }

    @Test
    public void truncatedFilesMustBeEmpty() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, true);
        Assert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        ByteBufferPage page = this.createPage();
        page.putInt(-889275714, 0);
        swapper.write(10L, (Page)page);
        this.clear(page);
        swapper.read(10L, (Page)page);
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)-889275714));
        Assert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)10L));
        swapper.close();
        swapper = this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, false);
        this.clear(page);
        swapper.read(10L, (Page)page);
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)-889275714));
        Assert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)10L));
        swapper.truncate();
        this.clear(page);
        swapper.read(10L, (Page)page);
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        swapper.close();
        swapper = this.createSwapper(factory, file, this.cachePageSize(), NO_CALLBACK, false);
        this.clear(page);
        swapper.read(10L, (Page)page);
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)swapper.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        swapper.close();
    }

    @Test
    public void positionedVectoredWriteMustFlushAllBuffersInOrder() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        ByteBufferPage pageC = this.createPage(4);
        ByteBufferPage pageD = this.createPage(4);
        pageA.putInt(2, 0);
        pageB.putInt(3, 0);
        pageC.putInt(4, 0);
        pageD.putInt(5, 0);
        swapper.write(1L, new Page[]{pageA, pageB, pageC, pageD}, 0, 4);
        ByteBufferPage result = this.createPage(4);
        swapper.read(0L, (Page)result);
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)0));
        result.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(1L, (Page)result), (Matcher)Matchers.is((Object)4L));
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)2));
        result.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(2L, (Page)result), (Matcher)Matchers.is((Object)4L));
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)3));
        result.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(3L, (Page)result), (Matcher)Matchers.is((Object)4L));
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)4));
        result.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(4L, (Page)result), (Matcher)Matchers.is((Object)4L));
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)5));
        result.putInt(0, 0);
        Assert.assertThat((Object)swapper.read(5L, (Page)result), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)result.getInt(0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void positionedVectoredReadMustFillAllBuffersInOrder() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage output = this.createPage();
        output.putInt(2, 0);
        swapper.write(1L, (Page)output);
        output.putInt(3, 0);
        swapper.write(2L, (Page)output);
        output.putInt(4, 0);
        swapper.write(3L, (Page)output);
        output.putInt(5, 0);
        swapper.write(4L, (Page)output);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        ByteBufferPage pageC = this.createPage(4);
        ByteBufferPage pageD = this.createPage(4);
        Assert.assertThat((Object)swapper.read(1L, new Page[]{pageA, pageB, pageC, pageD}, 0, 4), (Matcher)Matchers.is((Object)16L));
        Assert.assertThat((Object)pageA.getInt(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)pageB.getInt(0), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)pageC.getInt(0), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)pageD.getInt(0), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void positionedVectoredReadFromEmptyFileMustFillPagesWithZeros() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage page = this.createPage(4);
        page.putInt(1, 0);
        Assert.assertThat((Object)swapper.read(0L, new Page[]{page}, 0, 1), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)page.getInt(0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void positionedVectoredReadBeyondEndOfFileMustFillPagesWithZeros() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage output = this.createPage(4);
        output.putInt(-1, 0);
        swapper.write(0L, new Page[]{output, output, output}, 0, 3);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        pageA.putInt(-1, 0);
        pageB.putInt(-1, 0);
        Assert.assertThat((Object)swapper.read(3L, new Page[]{pageA, pageB}, 0, 2), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)pageA.getInt(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)pageB.getInt(0), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void positionedVectoredReadWhereLastPageExtendBeyondEndOfFileMustHaveRemainderZeroFilled() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage output = this.createPage(4);
        output.putInt(-1, 0);
        swapper.write(0L, new Page[]{output, output, output, output, output}, 0, 5);
        swapper.close();
        swapper = this.createSwapper(factory, file, 8, NO_CALLBACK, false);
        ByteBufferPage pageA = this.createPage(8);
        ByteBufferPage pageB = this.createPage(8);
        pageA.putLong(-3819410105021120785L, 0);
        pageB.putLong(6846544296635974449L, 0);
        Assert.assertThat((Object)swapper.read(1L, new Page[]{pageA, pageB}, 0, 2), (Matcher)Matchers.isOneOf((Object[])new Long[]{12L, 16L}));
        Assert.assertThat((Object)pageA.getLong(0), (Matcher)Matchers.is((Object)-1L));
        Assert.assertThat((Object)pageB.getLong(0), (Matcher)Matchers.is((Object)-4294967296L));
    }

    @Test
    public void positionedVectoredReadWhereSecondLastPageExtendBeyondEndOfFileMustHaveRestZeroFilled() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage output = this.createPage(4);
        output.putInt(1, 0);
        swapper.write(0L, (Page)output);
        output.putInt(2, 0);
        swapper.write(1L, (Page)output);
        output.putInt(3, 0);
        swapper.write(2L, (Page)output);
        swapper.close();
        swapper = this.createSwapper(factory, file, 8, NO_CALLBACK, false);
        ByteBufferPage pageA = this.createPage(8);
        ByteBufferPage pageB = this.createPage(8);
        ByteBufferPage pageC = this.createPage(8);
        pageA.putInt(-1, 0);
        pageB.putInt(-1, 0);
        pageC.putInt(-1, 0);
        Assert.assertThat((Object)swapper.read(0L, new Page[]{pageA, pageB, pageC}, 0, 3), (Matcher)Matchers.isOneOf((Object[])new Long[]{12L, 16L}));
        Assert.assertThat((Object)pageA.getInt(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)pageA.getInt(4), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)pageB.getInt(0), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)pageB.getInt(4), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)pageC.getLong(0), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void concurrentPositionedVectoredReadsAndWritesMustNotInterfere() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        final PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        int pageCount = 100;
        int iterations = 20000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        ByteBufferPage output = this.createPage(4);
        for (int i = 0; i < 100; ++i) {
            output.putInt(i + 1, 0);
            swapper.write((long)i, (Page)output);
        }
        Callable<Void> work = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int i;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                Page[] pages = new ByteBufferPage[10];
                for (i = 0; i < pages.length; ++i) {
                    pages[i] = PageSwapperTest.this.createPage(4);
                }
                startLatch.await();
                for (i = 0; i < 20000; ++i) {
                    long startFilePageId = rng.nextLong(0L, 100 - pages.length);
                    if (rng.nextBoolean()) {
                        long bytesRead = swapper.read(startFilePageId, pages, 0, pages.length);
                        Assert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)((long)pages.length * 4L)));
                        for (int j = 0; j < pages.length; ++j) {
                            int expectedValue = (int)((long)(1 + j) + startFilePageId);
                            int actualValue = pages[j].getInt(0);
                            Assert.assertThat((Object)actualValue, (Matcher)Matchers.is((Object)expectedValue));
                        }
                        continue;
                    }
                    for (int j = 0; j < pages.length; ++j) {
                        int value = (int)((long)(1 + j) + startFilePageId);
                        pages[j].putInt(value, 0);
                    }
                    Assert.assertThat((Object)swapper.write(startFilePageId, pages, 0, pages.length), (Matcher)Matchers.is((Object)((long)pages.length * 4L)));
                }
                return null;
            }
        };
        int threads = 8;
        ExecutorService executor = Executors.newFixedThreadPool(threads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(threads);
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(work));
        }
        startLatch.countDown();
        for (Future future : futures) {
            future.get();
        }
    }

    @Test
    public void positionedVectoredReadMustWorkOnSubsequenceOfGivenArray() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        ByteBufferPage pageC = this.createPage(4);
        ByteBufferPage pageD = this.createPage(4);
        pageA.putInt(1, 0);
        pageB.putInt(2, 0);
        pageC.putInt(3, 0);
        pageD.putInt(4, 0);
        Page[] pages = new Page[]{pageA, pageB, pageC, pageD};
        long bytesWritten = swapper.write(0L, pages, 0, 4);
        Assert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)16L));
        pageA.putInt(5, 0);
        pageB.putInt(6, 0);
        pageC.putInt(7, 0);
        pageD.putInt(8, 0);
        long bytesRead = swapper.read(1L, pages, 1, 2);
        Assert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)8L));
        int[] actualValues = new int[]{pageA.getInt(0), pageB.getInt(0), pageC.getInt(0), pageD.getInt(0)};
        int[] expectedValues = new int[]{5, 2, 3, 8};
        Assert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    public void positionedVectoredWriteMustWorkOnSubsequenceOfGivenArray() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        ByteBufferPage pageC = this.createPage(4);
        ByteBufferPage pageD = this.createPage(4);
        pageA.putInt(1, 0);
        pageB.putInt(2, 0);
        pageC.putInt(3, 0);
        pageD.putInt(4, 0);
        Page[] pages = new Page[]{pageA, pageB, pageC, pageD};
        long bytesWritten = swapper.write(0L, pages, 0, 4);
        Assert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)16L));
        pageB.putInt(6, 0);
        pageC.putInt(7, 0);
        bytesWritten = swapper.write(1L, pages, 1, 2);
        Assert.assertThat((Object)bytesWritten, (Matcher)Matchers.is((Object)8L));
        pageA.putInt(0, 0);
        pageB.putInt(0, 0);
        pageC.putInt(0, 0);
        pageD.putInt(0, 0);
        long bytesRead = swapper.read(0L, pages, 0, 4);
        Assert.assertThat((Object)bytesRead, (Matcher)Matchers.is((Object)16L));
        int[] actualValues = new int[]{pageA.getInt(0), pageB.getInt(0), pageC.getInt(0), pageD.getInt(0)};
        int[] expectedValues = new int[]{1, 6, 7, 4};
        Assert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    public void mustThrowNullPointerExceptionFromReadWhenPageArrayElementsAreNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage page = this.createPage(4);
        swapper.write(0L, new Page[]{page, page, page, page}, 0, 4);
        try {
            swapper.read(0L, new Page[]{page, page, null, page}, 0, 4);
            Assert.fail((String)"vectored read with nulls in array should have thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void mustThrowNullPointerExceptionFromWriteWhenPageArrayElementsAreNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage page = this.createPage(4);
        try {
            swapper.write(0L, new Page[]{page, page, null, page}, 0, 4);
            Assert.fail((String)"vectored read with nulls in array should have thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void mustThrowNullPointerExceptionFromReadWhenPageArrayIsNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage page = this.createPage(4);
        swapper.write(0L, new Page[]{page, page, page, page}, 0, 4);
        try {
            swapper.read(0L, null, 0, 4);
            Assert.fail((String)"vectored read with null array should have thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void mustThrowNullPointerExceptionFromWriteWhenPageArrayIsNull() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        try {
            swapper.write(0L, null, 0, 4);
            Assert.fail((String)"vectored write with null array should have thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test(expected=IOException.class)
    public void readMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        swapper.read(-1L, (Page)this.createPage(4));
    }

    @Test(expected=IOException.class)
    public void writeMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        swapper.write(-1L, (Page)this.createPage(4));
    }

    @Test(expected=IOException.class)
    public void vectoredReadMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        swapper.read(-1L, new Page[]{this.createPage(4), this.createPage(4)}, 0, 2);
    }

    @Test(expected=IOException.class)
    public void vectoredWriteMustThrowForNegativeFilePageIds() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        swapper.write(-1L, new Page[]{this.createPage(4), this.createPage(4)}, 0, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredReadMustThrowForNegativeArrayOffsets() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 0, 2);
        swapper.read(0L, pages, -1, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredWriteMustThrowForNegativeArrayOffsets() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, -1, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredReadMustThrowWhenLengthGoesBeyondArraySize() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 0, 2);
        swapper.read(0L, pages, 1, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredWriteMustThrowWhenLengthGoesBeyondArraySize() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 1, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredReadMustThrowWhenArrayOffsetIsEqualToArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 0, 2);
        swapper.read(0L, pages, 2, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredWriteMustThrowWhenArrayOffsetIsEqualToArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 2, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredReadMustThrowWhenArrayOffsetIsGreaterThanArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 0, 2);
        swapper.read(0L, pages, 3, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void vectoredWriteMustThrowWhenArrayOffsetIsGreaterThanArrayLength() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        Page[] pages = new Page[]{this.createPage(4), this.createPage(4)};
        swapper.write(0L, pages, 3, 1);
    }

    @Test
    public void vectoredReadMustReadNothingWhenLengthIsZero() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        pageA.putInt(1, 0);
        pageB.putInt(2, 0);
        Page[] pages = new Page[]{pageA, pageB};
        swapper.write(0L, pages, 0, 2);
        pageA.putInt(3, 0);
        pageB.putInt(4, 0);
        swapper.read(0L, pages, 0, 0);
        int[] expectedValues = new int[]{3, 4};
        int[] actualValues = new int[]{pageA.getInt(0), pageB.getInt(0)};
        Assert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }

    @Test
    public void vectoredWriteMustReadNothingWhenLengthIsZero() throws Exception {
        File file = this.file("file");
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        ByteBufferPage pageA = this.createPage(4);
        ByteBufferPage pageB = this.createPage(4);
        pageA.putInt(1, 0);
        pageB.putInt(2, 0);
        Page[] pages = new Page[]{pageA, pageB};
        swapper.write(0L, pages, 0, 2);
        pageA.putInt(3, 0);
        pageB.putInt(4, 0);
        swapper.write(0L, pages, 0, 0);
        swapper.read(0L, pages, 0, 2);
        int[] expectedValues = new int[]{1, 2};
        int[] actualValues = new int[]{pageA.getInt(0), pageB.getInt(0)};
        Assert.assertThat((Object)actualValues, (Matcher)Matchers.is((Object)expectedValues));
    }
}

