/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.stress.StressTestRecord;

public class CountKeeper {
    private final PagedFile pagedFile;
    private final int countersPerRecord;

    public CountKeeper(PagedFile pagedFile, int countersPerRecord) {
        this.pagedFile = pagedFile;
        this.countersPerRecord = countersPerRecord;
    }

    public void onCounterUpdated(int pageNumber, int recordNumber, int counterNumber) throws IOException {
        try (PageCursor cursor = this.pagedFile.io((long)pageNumber, 2);){
            Assert.assertThat((String)"i must be able to access pages", (Object)cursor.next(), (Matcher)CoreMatchers.is((Object)true));
            this.setOffset(cursor, recordNumber, counterNumber);
            long count = cursor.getLong();
            this.setOffset(cursor, recordNumber, counterNumber);
            cursor.putLong(count + 1L);
        }
    }

    private void setOffset(PageCursor cursor, int recordNumber, int counterNumber) {
        cursor.setOffset((recordNumber * this.countersPerRecord + counterNumber) * StressTestRecord.SizeOfCounter);
    }
}

