/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.stress.StressTestRecord;

public class CountVerifier {
    private final PagedFile pagedFile;
    private final int recordsPerPage;
    private final int countersPerRecord;

    public CountVerifier(PagedFile pagedFile, int recordsPerPage, int countersPerRecord) {
        this.pagedFile = pagedFile;
        this.recordsPerPage = recordsPerPage;
        this.countersPerRecord = countersPerRecord;
    }

    public void verifyCounts(PagedFile pagedFile) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            int pageNumber = 0;
            while (cursor.next()) {
                this.verifyPage(cursor, pageNumber);
                ++pageNumber;
            }
        }
    }

    private void verifyPage(PageCursor cursor, int pageNumber) throws IOException {
        int counterNumber;
        int recordNumber;
        long[][] countsForPage;
        do {
            countsForPage = new long[this.recordsPerPage][this.countersPerRecord];
            for (recordNumber = 0; recordNumber < this.recordsPerPage; ++recordNumber) {
                cursor.setOffset(recordNumber * (this.countersPerRecord + 1) * StressTestRecord.SizeOfCounter);
                for (counterNumber = 0; counterNumber < this.countersPerRecord; ++counterNumber) {
                    countsForPage[recordNumber][counterNumber] = cursor.getLong();
                }
            }
        } while (cursor.shouldRetry());
        for (recordNumber = 0; recordNumber < this.recordsPerPage; ++recordNumber) {
            for (counterNumber = 0; counterNumber < this.countersPerRecord; ++counterNumber) {
                Assert.assertThat((Object)countsForPage[recordNumber][counterNumber], (Matcher)CoreMatchers.is((Object)this.getExpectedCount(pageNumber, recordNumber, counterNumber)));
            }
        }
    }

    private long getExpectedCount(int pageNumber, int recordNumber, int counterNumber) throws IOException {
        try (PageCursor cursor = this.pagedFile.io((long)pageNumber, 1);){
            long count;
            Assert.assertThat((String)"i must be able to access pages", (Object)cursor.next(), (Matcher)CoreMatchers.is((Object)true));
            do {
                cursor.setOffset((recordNumber * this.countersPerRecord + counterNumber) * StressTestRecord.SizeOfCounter);
                count = cursor.getLong();
            } while (cursor.shouldRetry());
            long l = count;
            return l;
        }
    }
}

