/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.util.Random;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.stress.ChecksumVerifier;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.CountKeeper;
import org.neo4j.io.pagecache.stress.CountUpdater;

public class RecordStresser
implements Callable<Void> {
    private static final Random Random = new Random();
    private final PagedFile pagedFile;
    private final Condition condition;
    private final ChecksumVerifier checksumVerifier;
    private final CountUpdater countUpdater;
    private final CountKeeper countKeeper;
    private final int maxPages;
    private final int recordsPerPage;
    private final int counterNumber;

    public RecordStresser(PagedFile pagedFile, Condition condition, ChecksumVerifier checksumVerifier, CountUpdater countUpdater, CountKeeper countKeeper, int maxPages, int recordsPerPage, int counterNumber) {
        this.pagedFile = pagedFile;
        this.condition = condition;
        this.checksumVerifier = checksumVerifier;
        this.countUpdater = countUpdater;
        this.countKeeper = countKeeper;
        this.maxPages = maxPages;
        this.recordsPerPage = recordsPerPage;
        this.counterNumber = counterNumber;
    }

    @Override
    public Void call() throws Exception {
        try (PageCursor cursor = this.pagedFile.io(0L, 2);){
            while (!this.condition.fulfilled()) {
                int pageNumber = Random.nextInt(this.maxPages);
                Assert.assertTrue((String)"I must be able to access pages", (boolean)cursor.next((long)pageNumber));
                int recordNumber = Random.nextInt(this.recordsPerPage);
                this.checksumVerifier.verifyChecksum(cursor, recordNumber);
                this.countUpdater.updateCount(cursor, recordNumber, this.counterNumber);
                this.countKeeper.onCounterUpdated(pageNumber, recordNumber, this.counterNumber);
                Assert.assertFalse((String)"Exclusive lock, so never a need to retry", (boolean)cursor.shouldRetry());
            }
        }
        return null;
    }
}

