/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;

public abstract class PageCacheTracerTest {
    private PageCacheTracer tracer;
    private PageSwapper swapper;

    @Before
    public void setUp() {
        this.tracer = this.createTracer();
        this.swapper = new DummyPageSwapper("filename");
    }

    protected abstract PageCacheTracer createTracer();

    @Test
    public void mustCountPinsAndUnpins() {
        PinEvent pinEvent = this.tracer.beginPin(true, 0L, this.swapper);
        pinEvent.done();
        this.assertCounts(1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    private void assertCounts(long pins, long unpins, long faults, long evictions, long evictionExceptions, long flushes, long bytesRead, long bytesWritten, long filesMapped, long filesUnmapped) {
        Assert.assertThat((String)"countPins", (Object)this.tracer.countPins(), (Matcher)Matchers.is((Object)pins));
        Assert.assertThat((String)"countUnpins", (Object)this.tracer.countUnpins(), (Matcher)Matchers.is((Object)unpins));
        Assert.assertThat((String)"countFaults", (Object)this.tracer.countFaults(), (Matcher)Matchers.is((Object)faults));
        Assert.assertThat((String)"countEvictions", (Object)this.tracer.countEvictions(), (Matcher)Matchers.is((Object)evictions));
        Assert.assertThat((String)"countEvictionExceptions", (Object)this.tracer.countEvictionExceptions(), (Matcher)Matchers.is((Object)evictionExceptions));
        Assert.assertThat((String)"countFlushes", (Object)this.tracer.countFlushes(), (Matcher)Matchers.is((Object)flushes));
        Assert.assertThat((String)"countBytesRead", (Object)this.tracer.countBytesRead(), (Matcher)Matchers.is((Object)bytesRead));
        Assert.assertThat((String)"countBytesWritten", (Object)this.tracer.countBytesWritten(), (Matcher)Matchers.is((Object)bytesWritten));
        Assert.assertThat((String)"countFilesMapped", (Object)this.tracer.countFilesMapped(), (Matcher)Matchers.is((Object)filesMapped));
        Assert.assertThat((String)"countFilesUnmapped", (Object)this.tracer.countFilesUnmapped(), (Matcher)Matchers.is((Object)filesUnmapped));
    }

    @Test
    public void mustCountPageFaults() {
        PinEvent pinEvent = this.tracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pinEvent.done();
        this.assertCounts(1L, 1L, 2L, 0L, 0L, 0L, 84L, 0L, 0L, 0L);
    }

    @Test
    public void mustCountEvictions() {
        try (EvictionRunEvent evictionRunEvent = this.tracer.beginPageEvictions(2);){
            FlushEvent flushEvent;
            try (EvictionEvent evictionEvent = evictionRunEvent.beginEviction();){
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
            }
            evictionEvent = evictionRunEvent.beginEviction();
            var4_6 = null;
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (evictionEvent != null) {
                    if (var4_6 != null) {
                        try {
                            evictionEvent.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        evictionEvent.close();
                    }
                }
            }
            evictionEvent = evictionRunEvent.beginEviction();
            var4_6 = null;
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (evictionEvent != null) {
                    if (var4_6 != null) {
                        try {
                            evictionEvent.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        evictionEvent.close();
                    }
                }
            }
            evictionRunEvent.beginEviction().close();
        }
        this.assertCounts(0L, 0L, 0L, 4L, 2L, 3L, 0L, 36L, 0L, 0L);
    }

    @Test
    public void mustCountFileMappingAndUnmapping() {
        this.tracer.mappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L);
        this.tracer.unmappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L);
    }

    @Test
    public void mustCountFlushes() {
        try (MajorFlushEvent cacheFlush = this.tracer.beginCacheFlush();){
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 3L, 0L, 0L, 0L, 0L);
        var2_2 = null;
        try (MajorFlushEvent fileFlush = this.tracer.beginFileFlush(this.swapper);){
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 6L, 0L, 0L, 0L, 0L);
    }
}

