/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.Digests;

public class TargetDirectory {
    private final FileSystemAbstraction fileSystem;
    private final File base;

    public static TestDirectory testDirForTest(Class<?> owningTest) {
        return new TargetDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest).testDirectory();
    }

    public static TestDirectory testDirForTestWithEphemeralFS(EphemeralFileSystemAbstraction fileSystem, Class<?> owningTest) {
        return new TargetDirectory(fileSystem, owningTest).testDirectory();
    }

    TargetDirectory(FileSystemAbstraction fileSystem, Class<?> owningTest) {
        this.fileSystem = fileSystem;
        this.base = new File(new File(TargetDirectory.locateTarget(owningTest), "test-data"), owningTest.getName()).getAbsoluteFile();
    }

    public File cacheDirectory(String name) {
        File dir = new File(this.ensureBase(), name);
        if (!this.fileSystem.fileExists(dir)) {
            this.fileSystem.mkdir(dir);
        }
        return dir;
    }

    public File existingDirectory(String name) {
        return new File(this.base, name);
    }

    public File cleanDirectory(String name) {
        File dir = new File(this.ensureBase(), name);
        if (this.fileSystem.fileExists(dir)) {
            this.recursiveDelete(dir);
        }
        this.fileSystem.mkdir(dir);
        return dir;
    }

    public File directoryForDescription(Description description) {
        String test = description.getMethodName();
        if (test == null) {
            test = "static";
        }
        String dir = Digests.md5Hex(test);
        this.register(test, dir);
        return this.cleanDirectory(dir);
    }

    public File file(String name) {
        return new File(this.ensureBase(), name);
    }

    public TestDirectory testDirectory() {
        return new TestDirectory();
    }

    public File makeGraphDbDir() {
        return this.cleanDirectory("graph-db");
    }

    public void cleanup() throws IOException {
        this.fileSystem.deleteRecursively(this.base);
        this.fileSystem.mkdirs(this.base);
    }

    private void recursiveDelete(File file) {
        try {
            this.fileSystem.deleteRecursively(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void register(String test, String dir) {
        try {
            FileUtils.writeToFile((File)new File(this.ensureBase(), ".register"), (String)String.format("%s=%s\n", dir, test), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File ensureBase() {
        if (this.fileSystem.fileExists(this.base) && !this.fileSystem.isDirectory(this.base)) {
            throw new IllegalStateException(this.base + " exists and is not a directory!");
        }
        try {
            this.fileSystem.mkdirs(this.base);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.base;
    }

    private static File locateTarget(Class<?> owningTest) {
        try {
            File codeSource = new File(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (codeSource.isDirectory()) {
                return codeSource.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new File("target");
    }

    public class TestDirectory
    implements TestRule {
        private File subdir = null;
        private boolean keepDirectoryAfterSuccefulTest;

        private TestDirectory() {
        }

        public TestDirectory keepDirectoryAfterSuccefulTest() {
            this.keepDirectoryAfterSuccefulTest = true;
            return this;
        }

        public String absolutePath() {
            return this.directory().getAbsolutePath();
        }

        public File directory() {
            if (this.subdir == null) {
                throw new IllegalStateException("Not initialized");
            }
            return this.subdir;
        }

        public File file(String name) {
            return new File(this.directory(), name);
        }

        public File directory(String name) {
            File dir = new File(this.directory(), name);
            if (!TargetDirectory.this.fileSystem.fileExists(dir)) {
                TargetDirectory.this.fileSystem.mkdir(dir);
            }
            return dir;
        }

        public File cleanDirectory(String name) throws IOException {
            File directory = this.directory(name);
            for (File file : TargetDirectory.this.fileSystem.listFiles(directory)) {
                TargetDirectory.this.fileSystem.deleteRecursively(file);
            }
            return directory;
        }

        public File graphDbDir() {
            return this.directory("graph-db");
        }

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    TestDirectory.this.subdir = TargetDirectory.this.directoryForDescription(description);
                    boolean success = false;
                    try {
                        base.evaluate();
                        success = true;
                    }
                    finally {
                        TestDirectory.this.complete(success);
                    }
                }
            };
        }

        public String toString() {
            String subdirName = this.subdir == null ? "<uninitialized>" : this.subdir.toString();
            return String.format("%s[%s]", this.getClass().getSimpleName(), subdirName);
        }

        private void complete(boolean success) {
            if (success && this.subdir != null && !this.keepDirectoryAfterSuccefulTest) {
                try {
                    TargetDirectory.this.recursiveDelete(this.subdir);
                }
                catch (RuntimeException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileUtils.MaybeWindowsMemoryMappedFileReleaseProblem) {
                        System.err.println("Failed to delete test directory, maybe due to Windows memory-mapped file problem");
                    }
                    throw e;
                }
            }
            this.subdir = null;
        }
    }
}

