/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageEvictionCallback;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPagedFile
implements PagedFile {
    private static final int translationTableChunkSizePower = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile.translationTableChunkSizePower", 12);
    private static final int translationTableChunkSize = 1 << translationTableChunkSizePower;
    private static final int translationTableChunkSizeMask = translationTableChunkSize - 1;
    private static final int translationTableChunkArrayBase = UnsafeUtil.arrayBaseOffset(MuninnPage[].class);
    private static final int translationTableChunkArrayScale = UnsafeUtil.arrayIndexScale(MuninnPage[].class);
    private static final long referenceCounterOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"referenceCounter");
    private static final long lastPageIdOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"lastPageId");
    final MuninnPageCache pageCache;
    final int filePageSize;
    final PageCacheTracer tracer;
    volatile Object[][] translationTable;
    final PageSwapper swapper;
    private final CursorPool cursorPool;
    private volatile int referenceCounter;
    private volatile long lastPageId;

    MuninnPagedFile(File file, MuninnPageCache pageCache, int filePageSize, PageSwapperFactory swapperFactory, CursorPool cursorPool, PageCacheTracer tracer, boolean createIfNotExists, boolean truncateExisting) throws IOException {
        this.pageCache = pageCache;
        this.filePageSize = filePageSize;
        this.cursorPool = cursorPool;
        this.tracer = tracer;
        MuninnPageEvictionCallback onEviction = new MuninnPageEvictionCallback(this);
        this.swapper = swapperFactory.createPageSwapper(file, filePageSize, onEviction, createIfNotExists);
        if (truncateExisting) {
            this.swapper.truncate();
        }
        long lastPageId = this.swapper.getLastPageId();
        int initialChunks = 1 + this.computeChunkId(lastPageId);
        Object[][] tt = new Object[initialChunks][];
        for (int i = 0; i < initialChunks; ++i) {
            tt[i] = new Object[translationTableChunkSize];
        }
        this.translationTable = tt;
        this.initialiseLastPageId(lastPageId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.file().getName() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags) {
        this.assertStillMapped();
        int lockMask = 3;
        if ((pf_flags & lockMask) == 0) {
            throw new IllegalArgumentException("Must specify either PF_EXCLUSIVE_LOCK or PF_SHARED_LOCK");
        }
        if ((pf_flags & lockMask) == lockMask) {
            throw new IllegalArgumentException("Cannot specify both PF_EXCLUSIVE_LOCK and PF_SHARED_LOCK");
        }
        MuninnPageCursor cursor = (pf_flags & 1) == 0 ? this.cursorPool.takeWriteCursor() : this.cursorPool.takeReadCursor();
        cursor.initialise(this, pageId, pf_flags);
        cursor.rewind();
        return cursor;
    }

    void assertStillMapped() {
        if (this.getRefCount() == 0) {
            throw new IllegalStateException("File has been unmapped: " + this.file().getPath());
        }
    }

    @Override
    public int pageSize() {
        return this.filePageSize;
    }

    File file() {
        return this.swapper.file();
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this);
    }

    void closeSwapper() throws IOException {
        this.swapper.close();
    }

    @Override
    public void flushAndForce() throws IOException {
        try (MajorFlushEvent flushEvent = this.tracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity());
            this.syncDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAndForceInternal(FlushEventOpportunity flushOpportunity) throws IOException {
        this.pageCache.pauseBackgroundFlushTask();
        long[] stamps = new long[translationTableChunkSize];
        MuninnPage[] pages = new MuninnPage[translationTableChunkSize];
        long filePageId = -1L;
        try {
            for (Object[] chunk : this.translationTable) {
                int pagesGrabbed = 0;
                for (Object element : chunk) {
                    ++filePageId;
                    if (element instanceof MuninnPage) {
                        MuninnPage page = (MuninnPage)element;
                        stamps[pagesGrabbed] = page.readLock();
                        if (page.isBoundTo(this.swapper, filePageId) && page.isDirty()) {
                            pages[pagesGrabbed] = page;
                            ++pagesGrabbed;
                            continue;
                        }
                        page.unlockRead(stamps[pagesGrabbed]);
                    }
                    if (pagesGrabbed <= 0) continue;
                    pagesGrabbed = this.vectoredFlush(stamps, pages, pagesGrabbed, flushOpportunity);
                }
                if (pagesGrabbed <= 0) continue;
                this.vectoredFlush(stamps, pages, pagesGrabbed, flushOpportunity);
            }
            this.swapper.force();
        }
        finally {
            this.pageCache.unpauseBackgroundFlushTask();
        }
    }

    private int vectoredFlush(long[] stamps, MuninnPage[] pages, int pagesGrabbed, FlushEventOpportunity flushOpportunity) throws IOException {
        FlushEvent flush = null;
        try {
            MuninnPage firstPage = pages[0];
            long startFilePageId = firstPage.getFilePageId();
            flush = flushOpportunity.beginFlush(startFilePageId, firstPage.getCachePageId(), this.swapper);
            long bytesWritten = this.swapper.write(startFilePageId, pages, 0, pagesGrabbed);
            flush.addBytesWritten(bytesWritten);
            flush.addPagesFlushed(pagesGrabbed);
            flush.done();
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].markAsClean();
            }
            int n = 0;
            return n;
        }
        catch (IOException ioe) {
            if (flush != null) {
                flush.done(ioe);
            }
            throw ioe;
        }
        finally {
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].unlockRead(stamps[j]);
            }
        }
    }

    private void syncDevice() throws IOException {
        this.pageCache.syncDevice();
    }

    @Override
    public long getLastPageId() {
        return this.lastPageId;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        UnsafeUtil.putLong((Object)this, (long)lastPageIdOffset, (long)lastPageIdFromFile);
    }

    long increaseLastPageIdTo(long newLastPageId) {
        long current;
        while ((current = this.lastPageId) < newLastPageId && !UnsafeUtil.compareAndSwapLong((Object)this, (long)lastPageIdOffset, (long)current, (long)newLastPageId)) {
        }
        return this.lastPageId;
    }

    void incrementRefCount() {
        UnsafeUtil.getAndAddInt((Object)this, (long)referenceCounterOffset, (int)1);
    }

    boolean decrementRefCount() {
        return UnsafeUtil.getAndAddInt((Object)this, (long)referenceCounterOffset, (int)-1) <= 1;
    }

    int getRefCount() {
        return UnsafeUtil.getIntVolatile((Object)this, (long)referenceCounterOffset);
    }

    MuninnPage grabFreePage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreePage(faultEvent);
    }

    MuninnPage evictPage(long filePageId) {
        int chunkId = this.computeChunkId(filePageId);
        long chunkOffset = this.computeChunkOffset(filePageId);
        Object[] chunk = this.translationTable[chunkId];
        Object element = UnsafeUtil.getAndSetObject((Object)chunk, (long)chunkOffset, null);
        assert (element instanceof MuninnPage) : "Expected to evict a MuninnPage but found " + element;
        return (MuninnPage)element;
    }

    synchronized Object[][] expandCapacity(int maxChunkId) {
        Object[][] tt = this.translationTable;
        if (tt.length <= maxChunkId) {
            int newLength = this.computeNewRootTableLength(maxChunkId);
            Object[][] ntt = new Object[newLength][];
            System.arraycopy(tt, 0, ntt, 0, tt.length);
            for (int i = tt.length; i < ntt.length; ++i) {
                ntt[i] = new Object[translationTableChunkSize];
            }
            tt = ntt;
            this.translationTable = tt;
        }
        return tt;
    }

    private int computeNewRootTableLength(int maxChunkId) {
        return 1 + (int)((double)maxChunkId * 1.1);
    }

    int computeChunkId(long filePageId) {
        return (int)(filePageId >>> translationTableChunkSizePower);
    }

    long computeChunkOffset(long filePageId) {
        int index = (int)(filePageId & (long)translationTableChunkSizeMask);
        return UnsafeUtil.arrayOffset((int)index, (int)translationTableChunkArrayBase, (int)translationTableChunkArrayScale);
    }
}

